<?php
checkSuperAdmin();
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
?>
<title><?php echo SITE_NAME; ?> - Templates</title>
</head>
<body id="page-top">

<!-- Page Wrapper -->
<div id="wrapper">

    <?php include_once("nav_wrapper_admin.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar -->
        <nav class="navbar navbar-expand navbar-light topbar mb-4 static-top shadow">

          <!-- Sidebar Toggle (Topbar) -->
          <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
            <i class="fa fa-bars"></i>
          </button>

          

          <!-- Topbar Navbar -->
          <ul class="navbar-nav ml-auto">

            

            <div class="topbar-divider d-none d-sm-block"></div>

            <!-- Nav Item - User Information -->
            <li class="nav-item dropdown no-arrow">
              <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <span class="mr-2 d-none d-lg-inline text-white small"><?php echo $member['firstname'].' '.$member['lastname']; ?></span>
              </a>
              <!-- Dropdown - User Information -->
              <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in" aria-labelledby="userDropdown">
                <a class="dropdown-item" href="<?php echo $root; ?>/settings">
                  <i class="fas fa-cogs fa-sm fa-fw mr-2 text-gray-400"></i>
                  Settings
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item" href="<?php echo $root; ?>/?logout=1">
                  <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                  Logout
                </a>
              </div>
            </li>

          </ul>

        </nav>
        <!-- End of Topbar -->

        <!-- Begin Page Content -->
        <div class="container-fluid">

          <!-- Page Heading -->
          <div class="float-left">
            <h1 class="h3 mb-4 text-gray-800">Templates</h1>
          </div>
          <div class="float-right" style="margin-right: 10vw;">

          </div>
          <div class="clearfix"></div>
          <div class="row">
            <div class="col-sm-12">
              <div class="card shadow mb-4">
                <div class="card-header bg-dark py-3">
                  <div class="float-left">
                    <h6 class="m-0 font-weight-bold text-white">Templates</h6>
                  </div>
                  <div class="clearfix"></div>
                </div>
                <?php 

                  if(isset($_POST['action'])){
                    if($_POST['action']=='template_save'){
                      $template_data = array(
                        $_POST['template_name'],
                        $_POST['template_subject'],
                        $_POST['template_category_id'],
                        $_POST['template_content'],
                        time(),
                        0
                      );
                      $q = $pdo->prepare('INSERT INTO `templates` (name,subject_line,template_category_id,template,last_update,member_id) VALUES (?,?,?,?,?,?)');
                      $q->execute($template_data);

                      echo '
                      <div class="alert alert-success alert-dismissible fade show" role="alert">
                        New template was successfully added!
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      ';
                                }elseif($_POST['action']=='template_update'){
                                    $template_data = array(
                                        $_POST['template_name'],
                                        $_POST['template_subject'],
                                        $_POST['template_category_id'],
                                        $_POST['template_content'],
                                        $_POST['edit_tid']
                                    );
                                    $q = $pdo->prepare('UPDATE `templates` SET `name`=?, `subject_line`=?, `template_category_id`=?, `template`=? WHERE `id`=?');
                                    $q->execute($template_data);
                                    echo '
                      <div class="alert alert-success alert-dismissible fade show" role="alert">
                        Template was successfully updated!
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      ';
                    }elseif($_POST['action']=='template_delete'){
                      $q = $pdo->prepare('DELETE FROM `templates` WHERE `id`=?');
                      $q->execute(array($_POST['dtid']));
                      echo '<div style="margin-bottom:2rem;">';
                      echo '
                      <div class="alert alert-success alert-dismissible fade show" role="alert">
                        Template was successfully deleted!
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      ';
                    }
                  }

                ?>
                <div class="card-body">
                  <button class="btn btn-primary" style="margin-top: 15px;" data-toggle="modal" data-target="#addTemplate">Add New</button>
                  <?php
                  $categories = $pdo->prepare('SELECT id, category_name FROM `template_category` ORDER by id DESC');
                  $categories->execute();

                  $q = $pdo->prepare('SELECT td.id,td.name,tc.category_name AS category_name FROM `templates` td LEFT JOIN `template_category` tc ON td.template_category_id = tc.id WHERE td.member_id=? ORDER by td.id DESC');
                  $q->execute(array(0));
                  ?>
                  <?php if($q->rowcount()>0){ ?>
                  <br/><br/>
                  <table class="table admin-templates-datatable datatable">
                    <thead class="bg-default text-dark">
                      <tr>
                        <th scope="col" style="width: 70%;">TEMPLATE NAME</th>
                        <th scope="col" style="width: 70%;">TEMPLATE CATEGORY</th>
                        <th scope="col">ACTION</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach ($q as $row) { ?>
                        <tr>
                          <td scope="col"><?php echo $row['name']; ?></td>
                          <td scope="col"><?php echo $row['category_name']; ?></td>
                          <td scope="col">
                            <div class="dropdown">
                            <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown">Action
                            <span class="caret"></span></button>
                            <ul class="dropdown-menu">
                              <li>
                                <a href="javascript:void(0)" class="btn btn-danger btn-sm btn-template-delete dropdown-item" data-key="<?php echo $row['id']; ?>" title="Delete"><i class="fas fa-trash-alt"></i> Delete</a>
                              </li>                              
                              <li>
                                <a href="javascript:void(0);" class="btn btn-info btn-sm dropdown-item btn-edit-template" data-key="<?php echo $row['id']; ?>" data-name="<?php echo $row['category_name']; ?>" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>     
                            </ul>
                          </div>
                        </tr>
                      <?php } ?>
                    </tbody>
                  </table>
                </div>
              </div>
              <?php } ?>

              <!-- Modal Add -->
              <div class="modal fade" id="addTemplate" tabindex="-1" role="dialog" aria-labelledby="addTemplateLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="addHelpLabel">Add Template</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span> 
                      </button>
                    </div>
                    <form action="" method="post">
                    <div class="modal-body">                                              
                        <div class="row">
                          <div class="col-md-12">
                            <label style="display: block; margin-top: 10px;">Template Name: *</label>
                            <input type="text" name="template_name" required="" class="form-control">
                          </div>
                        </div>
                        <div class="row">
                          <div class="col-md-12">
                            <label style="display: block; margin-top: 10px;">Template Subject: *</label>
                            <input type="text" name="template_subject" required="" class="form-control">
                          </div>
                        </div>
                        <div class="row">
                          <div class="col-md-12">
                            <label style="display: block; margin-top: 10px;">Category Name: *</label>
                            <select name="template_category_id" class="form-control">
                            <?php foreach($categories as $c){ ?>
                              <option value="<?php echo $c['id']; ?>"><?php echo $c['category_name']; ?></option>
                            <?php } ?>
                            </select>
                          </div>
                        </div>
                        <br />
                        <div class="row">
                          <div class="col-md-12">
                            <label style="display: block; margin-top: 10px;">Content: *</label>
                            <textarea class="form-control ckeditor" id="ckeditor-template" name="template_content" style="height: 400px;"></textarea>
                          </div>
                        </div>                 
                    </div>
                    <div class="modal-footer">
                      <button type="submit" class="btn btn-primary" name="action" value="template_save">Save</button>
                      <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    </div>
                    </form>
                  </div>
                </div>
              </div>

              <!-- Modal Edit -->
              <div class="modal fade" id="editTemplate" tabindex="-1" role="dialog" aria-labelledby="editTemplateLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="addHelpLabel">Edit Template</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span> 
                      </button>
                    </div>
                    <form action="" method="post">
                    <input type="hidden" value="" name="edit_tid" id="edit_tid">
                    <div class="modal-body modal-edit-template-body">                                              
                                 
                    </div>
                    <div class="modal-footer">
                      <button type="submit" class="btn btn-primary" name="action" value="template_update">Update</button>
                      <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    </div>
                    </form>
                  </div>
                </div>
              </div>

              <!-- Modal Delete Confirmation -->
              <div class="modal fade modal-enhanced modal-danger" id="modalDeleteConfirmation" tabindex="-1" role="dialog" aria-labelledby="modalDeleteConfirmationlabel" aria-hidden="true">
                <div class="modal-dialog modal-md" role="document">
                  <form action="#" method="post">
                    <input type="hidden" value="" name="dtid" class="dtid">
                    <div class="modal-content">                      
                      <div class="modal-header">
                        <h5 class="modal-title"><i class="far fa-trash-alt"></i> Delete</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      <div class="modal-body">
                        <div class="autoreply-selected-msg">Delete selected template?</div>
                        <div class="modal-footer">
                          <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                          <button type="submit" class="btn btn-danger" name="action" value="template_delete">Yes</button>
                        </div>
                      </div>
                    </div>
                  </form>
                </div>
              </div>

            </div>

          </div>

        </div>
        <!-- /.container-fluid -->

      </div>
      <!-- End of Main Content -->

   

        <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Copyright &copy; <?php echo date('Y'); ?></span>
                </div>
            </div>
        </footer>
        <!-- End of Footer -->
    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>

  <script>
    $(function(){
      $(".btn-template-delete").click(function(){
        var dtid = $(this).attr("data-key");
        $(".dtid").val(dtid);
        $("#modalDeleteConfirmation").modal('show');
      });

      $('table.admin-templates-datatable').DataTable({"pageLength": 20, filter: true});

      $(document).on('click', '.btn-edit-template', function(){
        var template_id = $(this).attr("data-key");
        var url     = root_dir + "/admin-get-edit-template";

        $("#edit_tid").val(template_id);

        $.ajax({
            type: "POST",
            url: url,
            data:{template_id:template_id}, 
            success: function(o)
            {

                $('.modal-edit-template-body').html(o);
                CKEDITOR.replace( 'ckeditor-edit', {
                    //width: '800'
                });            
            }
        });

        $("#editTemplate").modal('show');
      })

      $(document).on('click', '.btn-edit-category', function(){
        var data_id   = $(this).attr("data-key");
        var data_name = $(this).attr("data-name");

        $("#edit_tcid").val(data_id);
        $("#edit_category_name").val(data_name);

        $("#editCategory").modal("show");

      })
    });
</script>