<?php
ini_set('display_errors', 0);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
?>

<title><?php echo SITE_NAME; ?> - Sub Account Management</title>
<style>
/* width */
::-webkit-scrollbar {
  width: 10px;
}

/* Track */
::-webkit-scrollbar-track {
  background: #f1f1f1; 
}
 
/* Handle */
::-webkit-scrollbar-thumb {
  background: #888; 
}

/* Handle on hover */
::-webkit-scrollbar-thumb:hover {
  background: #555; 
}
.body-container{
    max-height: 500px;
    overflow-y: scroll;
    overflow-x: hidden;
    padding: 20px;
}
</style>
</head>
<body id="page-top">

<!-- Page Wrapper -->
<div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>

            <!-- Begin Page Content -->
            <div class="container-fluid">

                <!-- Page Heading -->
                <div class="panel-header">
                    <div class="float-left">
                        <h1 class="panel-title">Sub Account Management</h1>
                        <!-- <h4>User Management</h4> -->
                        <p class="panel-subtitle">Add Sub Account (This will manage the member sub account).</p>
                        <button class="btn btn-success" data-toggle="modal" data-target="#addSubAccount">Add Sub Account</button>
                    </div>
                    <div class="clearfix"></div>
                </div>

                <div class="row">

                    <div class="col-sm-12">
                        <?php
                        $plan = $pdo->prepare("SELECT* FROM `plans` WHERE `id`=? LIMIT 1");
                        $plan->execute(array($member['plan']));
                        $planData = $plan->fetch(PDO::FETCH_ASSOC);

                        $total_sub_accounts =  $planData['total_sub_accounts']* $member['plan_quantity'];
                        $total_admin_sub_accounts = $planData['total_admin_sub_accounts']* $member['plan_quantity'];

                        if( isset($_GET['deleteSubAccount']) && $_GET['deleteSubAccount'] > 0 ){
                            //Delete from members
                            $q = $pdo->prepare('DELETE FROM `members` WHERE `id`=? LIMIT 1');
                            $q->execute(array($_GET['deleteSubAccount']));

                            //Delete roles
                            $q = $pdo->prepare('DELETE FROM `user_roles` WHERE `member_id`=?');
                            $q->execute(array($_GET['deleteSubAccount']));

                            //Delete assigned emails
                            $q = $pdo->prepare('DELETE FROM `sub_account_emails` WHERE `member_id`=?');
                            $q->execute(array($_GET['deleteSubAccount']));

                            echo '
                  <div class="alert alert-danger" role="alert">
                    Sub Account was successfully deleted!
                  </div>
                  ';
                        }

                        if( isset($_POST['action']) && $_POST['action'] == 'add-sub-account' ){
                            $subAccounts = $pdo->prepare('SELECT* FROM `members` WHERE `parent_id`=?');
                            $subAccounts->execute(array($_SESSION['id']));

                            $subAccountAdmin = $pdo->prepare("SELECT* FROM `members` WHERE `parent_id`=? AND `account_type`=?");
                            $subAccountAdmin->execute(array($member['id'], 0));
                            //Check if max sub account
                            if( $subAccounts->rowcount() < $total_sub_accounts ){
                                $valid = true;
                                if( $_POST['sub_account_type'] == 0 ){
                                    //Check if max can create admin
                                    $msg   = '';
                                    if( $subAccountAdmin->rowcount() >= $total_admin_sub_accounts ){
                                        $valid = false;
                                        $msg   = "You have reached maximum admin sub accounts you can create. Please upgrade plan to increase limit.";
                                    }
                                }

                                if( $valid ){
                                    //Check if username exists
                                    $isUsernameExists = $pdo->prepare('SELECT* FROM `members` WHERE `username`=?');
                                    $isUsernameExists->execute(array($_POST['username']));

                                    // Check if email exists for forgot password....
                                    $isEmailExists = $pdo->prepare('SELECT* FROM `members` WHERE `email`=?');
                                    $isEmailExists->execute(array($_POST['email']));

                                    if( $isUsernameExists->rowcount() <= 0 && $isEmailExists->rowcount()  <= 0){
                                        $q = $pdo->prepare('SELECT* FROM `members` WHERE `id`=? LIMIT 1');
                                        $q->execute(array($_POST['username']));



                                        $data_sub_account = array(
                                            $_POST['firstname'],
                                            $_POST['lastname'],
                                            $_POST['email'],
                                            $_POST['username'],
                                            password_hash($_POST['password'], PASSWORD_BCRYPT),
                                            $member['plan'],
                                            $member['stripe'],
                                            $member['timezone'],
                                            NULL,
                                            strtotime(date("Y-m-d")),
                                            1,
                                            $member['id'],
                                            $_POST['sub_account_type'],
                                            $member['plan_quantity'],
                                            $member['cleaning_credits'],
                                            1,
                                            $member['selected_state'],
                                            $member['selected_city'],
                                            $member['selected_postal_code'],
                                            $member['super_admin'],
                                            $member['cc_4digits'],
                                            $member['cc_month'],
                                            $member['cc_year'],
                                            '',
                                            time()
                                        );
                                        //Create Sub Account
                                        //$q = $pdo->prepare('INSERT INTO `members` VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)');
                                        $q = $pdo->prepare('INSERT INTO `members` (fname,lname,email,username,password,plan,stripe,timezone,id,date_created,status,parent_id,account_type,plan_quantity,cleaning_credits,is_startup,selected_state,selected_city,selected_postal_code,super_admin,cc_4digits,cc_month,cc_year,ipaddress,date_lastlogin) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
                                        $q->execute($data_sub_account);
                                        $new_member_id = $pdo->lastInsertId();

                                        if( $_POST['sub_account_type'] == 0 ){
                                            $json_roles_data = json_encode(array('all_access'));
                                            $data_roles = array(
                                                $new_member_id,
                                                'all_modules',
                                                $json_roles_data,
                                                strtotime(date("Y-m-d"))
                                            );
                                            //Create Roles
                                            $q = $pdo->prepare('INSERT INTO `user_roles` (member_id,module,action,created) VALUES (?,?,?,?)');
                                            $q->execute($data_roles);

                                        }else{
                                            foreach( $_POST['roles'] as $key => $values ){
                                                $roles = array();
                                                foreach($values as $subKey => $subValue){
                                                    $roles[] = $subKey;
                                                }

                                                $json_roles_data = json_encode($roles);
                                                $data_roles = array(
                                                    $new_member_id,
                                                    $key,
                                                    $json_roles_data,
                                                    strtotime(date("Y-m-d"))
                                                );
                                                //Create Roles
                                                $q = $pdo->prepare('INSERT INTO `user_roles` (member_id,module,action,created) VALUES (?,?,?,?)');
                                                $q->execute($data_roles);
                                            }
                                        }

                                        echo '
                        <div class="alert alert-success" role="alert">
                          User '.$_POST['firstname'].' '. $_POST['lastname'] .' sub account successfully added!
                        </div>
                        ';
                                    }else{

                                        if ($isEmailExists->rowcount() > 0 )
                                            echo '
                                   <div class="alert alert-danger" role="alert">
                                      Email Address is already used!
                                    </div>
                                                    ';
                                        else
                                            echo '
                        <div class="alert alert-danger" role="alert">
                          Username already taken!
                        </div>
                        ';
                                    }
                                }else{
                                    echo '
                        <div class="alert alert-danger" role="alert">
                          '. $msg .'
                        </div>
                        ';
                                }
                            }else{
                                echo '
                      <div class="alert alert-danger" role="alert">
                        You have reached maximum sub accounts you can create. Please upgrade plan to increase limit.
                      </div>
                      ';
                            }


                        }elseif( isset($_POST['action']) && $_POST['action'] == 'change-password' ){
                            if($_POST['password'] == $_POST['rpassword']){
                                $q = $pdo->prepare('UPDATE `members` SET `password`=? WHERE `id`=? AND `parent_id` =?');
                                $q->execute(array(password_hash($_POST['password'], PASSWORD_BCRYPT), $_POST['editUserPass_id'],$_SESSION['id']));
                                echo '<div class="alert alert-success">
                     Password successfully updated.
                    </div>';

                            }else{
                                echo '<div class="alert alert-warning">
                     Error: Password does not match.
                    </div>';
                            }
                        }elseif( isset($_POST['action']) && $_POST['action'] == 'assign-email-account' ){

                            $q = $pdo->prepare('DELETE FROM `sub_account_emails` WHERE `member_id`=?');
                            $q->execute(array($_POST['member_id']));
                            foreach( $_POST['email'] as $type => $subemial ){
                                foreach( $subemial as $key => $email_id ){
                                    $data_assigned_email = array(
                                        $_POST['member_id'],
                                        $email_id,
                                        $type,
                                        strtotime(date("Y-m-d"))
                                    );

                                    $q = $pdo->prepare('INSERT INTO `sub_account_emails` (member_id,email_id,type,created) VALUES (?,?,?,?)');
                                    $q->execute($data_assigned_email);
                                }
                            }

                            echo '
                  <div class="alert alert-success" role="alert">
                    Record saved!
                  </div>
                  ';
                        }elseif( isset($_POST['action']) && $_POST['action'] == 'update-sub-account' ){

                            $valid = true;
                            $msg   = '';

                            if( $_POST['sub_account_type'] == 0 ){
                                //Check if max can create admin
                                $subAccountAdmin = $pdo->prepare("SELECT* FROM `members` WHERE `parent_id`=? AND `account_type`=?");
                                $subAccountAdmin->execute(array($member['id'], 0));
                                if( $subAccountAdmin->rowcount() >= $total_admin_sub_accounts ){
                                    $valid = false;
                                    $msg   = "You have reached maximum admin sub accounts you can create. Please upgrade plan to increase limit.";
                                }
                            }

                            if( $valid ){
                                $q = $pdo->prepare('UPDATE `members` SET `fname` =?, `lname`=?, `email`=?, `account_type`=? WHERE `id`=?');
                                $q->execute(array(
                                    $_POST['edit_firstname'],
                                    $_POST['edit_lastname'],
                                    $_POST['edit_email'],
                                    $_POST['sub_account_type'],
                                    $_POST['editUser_id']
                                ));

                                //Delete roles
                                $q = $pdo->prepare('DELETE FROM `user_roles` WHERE `member_id`=?');
                                $q->execute(array($_POST['editUser_id']));

                                if( $_POST['sub_account_type'] == 0 ){
                                    $json_roles_data = json_encode(array('all_access'));
                                    $data_roles = array(
                                        $_POST['editUser_id'],
                                        'all_modules',
                                        $json_roles_data,
                                        strtotime(date("Y-m-d"))
                                    );
                                    //Create Roles
                                    $q = $pdo->prepare('INSERT INTO `user_roles` (member_id,module,action,created) VALUES (?,?,?,?)');
                                    $q->execute($data_roles);

                                }else{
                                    foreach( $_POST['roles'] as $key => $values ){
                                        $roles = array();
                                        foreach($values as $subKey => $subValue){
                                            $roles[] = $subKey;
                                        }

                                        $json_roles_data = json_encode($roles);
                                        $data_roles = array(
                                            $_POST['editUser_id'],
                                            $key,
                                            $json_roles_data,
                                            strtotime(date("Y-m-d"))
                                        );
                                        //Create Roles
                                        $q = $pdo->prepare('INSERT INTO `user_roles` (member_id,module,action,created) VALUES (?,?,?,?)');
                                        $q->execute($data_roles);
                                    }
                                }

                                echo '
                    <div class="alert alert-success" role="alert">
                      User '.$_POST['edit_firstname'].' '. $_POST['edit_lastname'] .' account has been successfully updated!
                    </div>
                    ';
                            }else{
                                echo '
                      <div class="alert alert-danger" role="alert">
                        '. $msg .'
                      </div>
                      ';
                            }

                        }
                        ?>
                        <?php
                        $subAccounts = $pdo->prepare('SELECT* FROM `members` WHERE `parent_id`=?');
                        $subAccounts->execute(array($_SESSION['id']));

                        $subAccountAdmin = $pdo->prepare("SELECT* FROM `members` WHERE `parent_id`=? AND `account_type`=?");
                        $subAccountAdmin->execute(array($member['id'], 0));
                        ?>
                        <?php if($subAccounts->rowcount()>0) { ?>
                            <br/><br/>
                            <h6>Total Sub accounts: <strong class="blue"><?php echo $subAccounts->rowcount(); ?>/<?php echo $total_sub_accounts; ?></strong></h6>
                            <h6>Total Admin accounts: <strong class="blue"><?php echo $subAccountAdmin->rowcount(); ?>/<?php echo $total_admin_sub_accounts; ?></strong></h6>
                            <br/>
                            <div class="dataTables_wrapper">
                                <table class="table datatable table-shrink">
                                    <thead class="bg-default text-dark">
                                    <tr>
                                        <th scope="col">First name</th>
                                        <th scope="col">Last name</th>
                                        <th scope="col">Email address</th>
                                        <th scope="col">Username</th>
                                        <th scope="col">Date created</th>
                                        <th scope="col">Actions</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($subAccounts as $row) {

                                        //Roles
                                        $roles = $pdo->prepare('SELECT* FROM `user_roles` WHERE `member_id`=?');
                                        $roles->execute(array($row['id']));
                                        $list_roles = array();
                                        foreach( $roles as $role ){
                                            $list_roles[$role['module']] = $role['action'];
                                        }

                                        echo '
                      <tr>
                        <td class="firstname" scope="col">'.$row['fname'] .'</td>
                        <td class="lastname" scope="col">'.$row['lname'].'</td>
                        <td class="email" scope="col">'.$row['email'].'</td>
                        <td class="username" scope="col">'.$row['username'].'</td>
                        <td class="datecreated" scope="col">'.date("m/d/Y", $row['date_created']).'</td>
                        <td class="action" scope="col">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default btn-sm dropdown-toggle no-caret" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
                            <div class="dropdown-menu dropdown-menu-right">
                              <a href="javascript:void(0);" class="dropdown-item" data-toggle="modal" data-target="#editSubAccount'.$row['id'].'" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>
                              <a href="javascript:void(0);" class="dropdown-item btn-assign-emails-accounts" data-type="member" data-key='.$row['id'].' title="Assign Email"><i class="fas fa-envelope-open"></i> Assign email</a>
                              <a href="javascript:void(0);" class="dropdown-item" data-toggle="modal" data-target="#editUserPass'.$row['id'].'" title="Change password"><i class="fas fa-user-lock"></i> Change password</a>
                              <div class="dropdown-divider"></div>
                              <a href="'.$root.'/sub-accounts/?deleteSubAccount='.$row['id'].'" class="dropdown-item text-danger" onclick="return confirm(\'Confirm deletion of '.$row['fname'].' '.$row['lname'].'?\')"><i class="fas fa-trash-alt"></i> Delete</a>
                            </div>
                          </div>                      
                        
                        
                        
                        ' ; ?>

                                        <!-- Modal for EdituserPassword -->
                                        <div class="modal fade" id="editUserPass<?php echo $row['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="editUserPassLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document" style="margin-top: 10vw;">
                                                <div class="modal-content">
                                                    <form action="" method="post">
                                                        <div class="row" style="margin-top:37px;">
                                                            <div class="col-12" style="text-align: center;">
                                                                <i class="fas fa-user-lock" style="font-size:50px;"></i>
                                                                <p style="margin-top: 20px; font-size: 30px;margin-bottom: 3px;">Change Password</p>
                                                                <p style="margin-top: 5px; font-size: 20px;margin-bottom: 13px;">Update your user password account.</p>
                                                            </div>
                                                        </div>
                                                        <div class="modal-body">
                                                            <input type="hidden" name="editUserPass_id" value="<?php echo $row['id']; ?>">
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <input type="password" required="" name="password" class="form-control">
                                                                        <label>Password:*</label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <input type="password" readonly="" name="rpassword" class="form-control" >
                                                                        <label>Repeat new password:*</label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer" style="display: block;text-align: center;">
                                                          <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                                                          <button type="submit" class="btn btn-success" style="width:200px;font-size: 21px;" name="action" value="change-password">Save</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Modal for Edituser -->
                                        <div class="modal fade" id="editSubAccount<?php echo $row['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="editSubAccountLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <div class="modal-content">
                                                    <form action="" method="post">
                                                        <div class="modal-body">
                                                            <h4 class="modal-heading">Edit User</h4>
                                                            <p>Edit your user account details.</p>

                                                            <input type="hidden" name="editUser_id" value="<?php echo $row['id']; ?>">
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <input type="text" name="edit_firstname" required="" class="form-control" value="<?php echo $row['fname']; ?>">
                                                                        <label>First Name:*</label>
                                                                    </div>
                                                                </div>

                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <input type="text" name="edit_lastname" required="" class="form-control" value="<?php echo $row['lname']; ?>">
                                                                        <label>Last Name:*</label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <input type="email" name="edit_email" required="" class="form-control" value="<?php echo $row['email']; ?>">
                                                                        <label>Email:*</label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h4 style="margin-bottom:20px;">Roles</h4>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <select class="form-control edit-sub-account-type" data-key="<?php echo $row['id']; ?>" name="sub_account_type">
                                                                            <option value="1" <?php echo( $row['account_type'] == 1 ? 'selected="selected"' : '' ); ?>>User</option>
                                                                            <!--<option value="0" <?php //echo( $row['account_type'] == 0 ? 'selected="selected"' : '' ); ?>>Admin</option>-->
                                                                        </select>
                                                                        <label>Sub Account Type:*</label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <?php
                                                            $css_roles = '';
                                                            if( $row['account_type'] == 0 ){
                                                                $css_roles = "display:none;";
                                                            }
                                                            ?>

                                                            <div class="user-roles user-roles-<?php echo $row['id']; ?>" style="<?php echo $css_roles; ?>">
                                                                <div class="row">
                                                                    <div class="col-md-12">
                                                                        <div class="custom-control custom-checkbox">
                                                                            <input type="checkbox" class="custom-control-input" id="edit-chk-all-roles">
                                                                            <label class="custom-control-label" for="edit-chk-all-roles">Check All Roles</label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <br />
                                                                <div class="row">
                                                                    <div class="col-md-4">
                                                                        <h3>LIST</h3>
                                                                        <?php
                                                                        $roles_list     = json_decode($list_roles['list']);
                                                                        $roles_template = json_decode($list_roles['template']);
                                                                        $roles_campaign = json_decode($list_roles['campaign']);
                                                                        $roles_leads    = json_decode($list_roles['leads']);
                                                                        $roles_settings = json_decode($list_roles['settings']);
                                                                        $roles_exclusions = json_decode($list_roles['exclusions']);
                                                                        ?>
                                                                        <ul class="roles-list">
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('view', $roles_list) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="listView-<?php echo $row['id']; ?>" name="roles[list][view]">
                                                                                    <label class="custom-control-label" for="listView-<?php echo $row['id']; ?>">Can View</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('add', $roles_list) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="listAdd-<?php echo $row['id']; ?>" name="roles[list][add]">
                                                                                    <label class="custom-control-label" for="listAdd-<?php echo $row['id']; ?>">Can Add</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('edit', $roles_list) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="listEdit-<?php echo $row['id']; ?>" name="roles[list][edit]">
                                                                                    <label class="custom-control-label" for="listEdit-<?php echo $row['id']; ?>">Can Edit</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('delete', $roles_list) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="listDelete-<?php echo $row['id']; ?>" name="roles[list][delete]">
                                                                                    <label class="custom-control-label" for="listDelete-<?php echo $row['id']; ?>">Can Delete</label>
                                                                                </div>
                                                                            </li>
                                                                        </ul>
                                                                    </div>

                                                                    <div class="col-md-4">
                                                                        <h3>TEMPLATE</h3>
                                                                        <ul class="roles-list">
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('view', $roles_template) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="templateView-<?php echo $row['id']; ?>" name="roles[template][view]">
                                                                                    <label class="custom-control-label" for="templateView-<?php echo $row['id']; ?>">Can View</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('add', $roles_template) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="templateAdd-<?php echo $row['id']; ?>" name="roles[template][add]">
                                                                                    <label class="custom-control-label" for="templateAdd-<?php echo $row['id']; ?>">Can Add</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('edit', $roles_template) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="templateEdit-<?php echo $row['id']; ?>" name="roles[template][edit]">
                                                                                    <label class="custom-control-label" for="templateEdit-<?php echo $row['id']; ?>">Can Edit</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('delete', $roles_template) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="templateDelete-<?php echo $row['id']; ?>" name="roles[template][delete]">
                                                                                    <label class="custom-control-label" for="templateDelete-<?php echo $row['id']; ?>">Can Delete</label>
                                                                                </div>
                                                                            </li>
                                                                        </ul>
                                                                    </div>

                                                                    <div class="col-md-4">
                                                                        <h3>CAMPAIGN</h3>
                                                                        <ul class="roles-list">
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('view', $roles_campaign) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="campaignView-<?php echo $row['id']; ?>" name="roles[campaign][view]">
                                                                                    <label class="custom-control-label" for="campaignView-<?php echo $row['id']; ?>">Can View</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('start', $roles_campaign) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="campaignStart-<?php echo $row['id']; ?>" name="roles[campaign][start]">
                                                                                    <label class="custom-control-label" for="campaignStart-<?php echo $row['id']; ?>">Can Start Campaign</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('edit', $roles_campaign) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="campaignEdit-<?php echo $row['id']; ?>" name="roles[campaign][edit]">
                                                                                    <label class="custom-control-label" for="campaignEdit-<?php echo $row['id']; ?>">Can Edit Existing Campaign</label>
                                                                                </div>
                                                                            </li>
                                                                        </ul>
                                                                    </div>

                                                                    <div class="col-md-4">
                                                                        <h3>LEADS</h3>
                                                                        <ul class="roles-list">
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('view', $roles_leads) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="leadsView-<?php echo $row['id']; ?>" name="roles[leads][view]">
                                                                                    <label class="custom-control-label" for="leadsView-<?php echo $row['id']; ?>">Can View</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('change_status', $roles_leads) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="leadsChangeStatus-<?php echo $row['id']; ?>" name="roles[leads][change_status]">
                                                                                    <label class="custom-control-label" for="leadsChangeStatus-<?php echo $row['id']; ?>">Can Change status</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('reply', $roles_leads) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="leadsReply-<?php echo $row['id']; ?>" name="roles[leads][reply]">
                                                                                    <label class="custom-control-label" for="leadsReply-<?php echo $row['id']; ?>">Can Reply</label>
                                                                                </div>
                                                                            </li>
                                                                        </ul>
                                                                    </div>

                                                                    <div class="col-md-4">
                                                                        <h3>SETTINGS</h3>
                                                                        <ul class="roles-list settings-role">
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('update_name', $roles_settings) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="settingsUpdateName-<?php echo $row['id']; ?>" name="roles[settings][update_name]">
                                                                                    <label class="custom-control-label" for="settingsUpdateName-<?php echo $row['id']; ?>">Can Update Name</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('update_password', $roles_settings) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="settingsChangePassword-<?php echo $row['id']; ?>" name="roles[settings][update_password]">
                                                                                    <label class="custom-control-label" for="settingsChangePassword-<?php echo $row['id']; ?>">Can Update Password</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('update_signature', $roles_settings) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="settingsChangeSignature-<?php echo $row['id']; ?>" name="roles[settings][update_signature]">
                                                                                    <label class="custom-control-label" for="settingsChangeSignature-<?php echo $row['id']; ?>">Can Update Signature</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('update_timezone', $roles_settings) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="settingsUpdateTimezoe-<?php echo $row['id']; ?>" name="roles[settings][update_timezone]">
                                                                                    <label class="custom-control-label" for="settingsUpdateTimezoe-<?php echo $row['id']; ?>">Can Update Timezone</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('change_sending_speed', $roles_settings) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="settingsChangeSendingSpeed-<?php echo $row['id']; ?>" name="roles[settings][change_sending_speed]">
                                                                                    <label class="custom-control-label" for="settingsChangeSendingSpeed-<?php echo $row['id']; ?>">Can Change Sending Speed</label>
                                                                                </div>
                                                                            </li>
                                                                        </ul>
                                                                    </div>

                                                                    <div class="col-md-4">
                                                                        <h3>EXCLUSIONS</h3>
                                                                        <ul class="roles-list">
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('view', $roles_exclusions) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="exclusionsView-<?php echo $row['id']; ?>" name="roles[exclusions][view]">
                                                                                    <label class="custom-control-label" for="exclusionsView-<?php echo $row['id']; ?>">Can View</label>
                                                                                </div>
                                                                            </li>
                                                                            <li>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input <?php echo( in_array('manage', $roles_exclusions) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input edit-chk-role" id="exclusionsManage-<?php echo $row['id']; ?>" name="roles[exclusions][manage]">
                                                                                    <label class="custom-control-label" for="exclusionsManage-<?php echo $row['id']; ?>">Can Manage Exclusions</label>
                                                                                </div>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="submit" class="btn btn-success" name="action" value="update-sub-account">Save</button>
                                                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                            </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>


                                        <?php  echo ' </td>
                      </tr>
                      ';
                                    } ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php
                        }
                        ?>

                        <!-- Modal Assign Email -->
                        <div class="modal fade" id="modal-assign-email-accounts" tabindex="-1" role="dialog" aria-labelledby="assignEmailAccountsLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg" role="document" style="margin-top: 10vw;">
                                <div class="modal-content">
                                    <form action="" method="post">
                                        <div class="row" style="margin-top:37px;">
                                            <div class="col-12" style="text-align: center;">
                                                <i class="fas fa-envelope-open" style="font-size:50px;"></i>
                                                <p style="margin-top: 20px; font-size: 30px;margin-bottom: 13px;">Assign Email Accounts</p>
                                            </div>
                                        </div>
                                        <div class="modal-body ">
                                            <div class="assign-account-container"></div>
                                        </div>
                                        <div class="modal-footer" style="display: block;text-align: center;">
                                          <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                                          <button type="submit" class="btn btn-success" style="width:200px;font-size: 21px;" name="action" value="assign-email-account">Save</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- Modal Add Sub Account -->
                        <div class="modal fade" id="addSubAccount" tabindex="-1" role="dialog" aria-labelledby="addSubAccountLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <form action="" method="post">
                                        <div class="row" style="margin-top:37px;">
                                            <div class="col-12" style="text-align: center;">
                                                <i class="fa fa-users" style="font-size:50px;"></i>
                                                <p style="margin-top: 20px; font-size: 30px;margin-bottom: 13px;">Add Sub Account</p>
                                            </div>
                                        </div>  
                                        <div class="modal-body">     
                                            <div class="body-container">                                                                              
                                            <?php if( $subAccounts->rowcount() < $total_sub_accounts){ ?>
                                                <p>Add sub account that will manage your data.</p>
                                                <input type="hidden" name="user" value="1" />
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <input type="text" name="firstname" required="" class="form-control">
                                                            <label>First Name:*</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <input type="text" name="lastname" required="" class="form-control">
                                                            <label>Last Name:*</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <input type="email" name="email" required="" class="form-control">
                                                            <label>Email:*</label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <h4 style="margin-bottom:20px;">Login account</h4>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <input type="text" name="username" required="" class="form-control">
                                                            <label>Username:*</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <input type="password" name="password" required="" class="form-control">
                                                            <label>Password:*</label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <h4 style="margin-bottom:20px;">Roles</h4>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <select class="form-control sub-account-type" name="sub_account_type">
                                                                <option value="1">User</option>
                                                                <?php if( $subAccountAdmin->rowcount() < $total_admin_sub_accounts ){ ?>

<!--                                                                    <option value="0">Admin</option>-->
                                                                <?php } ?>
                                                            </select>
                                                            <label>Sub Account Type:*</label>
                                                        </div>
                                                    </div>
                                                    <?php if( $subAccountAdmin->rowcount() >= $total_admin_sub_accounts ){ ?>
                                                        <div class="col-md-12">
                                                            <label style="display: block; margin-top: 23px;color: red;">Cannot add more Admin Sub Account - already reached maximum you can create.</label>
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                                <div class="user-roles">
                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <div class="custom-control custom-checkbox">
                                                                <input type="checkbox" class="custom-control-input" id="add-chk-all-roles">
                                                                <label class="custom-control-label" for="add-chk-all-roles">Check All Roles</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <br />
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <h3>LIST</h3>
                                                            <ul class="roles-list">
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addlistView" name="roles[list][view]">
                                                                        <label class="custom-control-label" for="addlistView">Can View</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addlistAdd" name="roles[list][add]">
                                                                        <label class="custom-control-label" for="addlistAdd">Can Add</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addlistEdit" name="roles[list][edit]">
                                                                        <label class="custom-control-label" for="addlistEdit">Can Edit</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addlistDelete" name="roles[list][delete]">
                                                                        <label class="custom-control-label" for="addlistDelete">Can Delete</label>
                                                                    </div>
                                                                </li>
                                                            </ul>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <h3>TEMPLATE</h3>
                                                            <ul class="roles-list">
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addtemplateView" name="roles[template][view]">
                                                                        <label class="custom-control-label" for="addtemplateView">Can View</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addtemplateAdd" name="roles[template][add]">
                                                                        <label class="custom-control-label" for="addtemplateAdd">Can Add</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addtemplateEdit" name="roles[template][edit]">
                                                                        <label class="custom-control-label" for="addtemplateEdit">Can Edit</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addtemplateDelete" name="roles[template][delete]">
                                                                        <label class="custom-control-label" for="addtemplateDelete">Can Delete</label>
                                                                    </div>
                                                                </li>
                                                            </ul>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <h3>CAMPAIGN</h3>
                                                            <ul class="roles-list">
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addcampaignView" name="roles[campaign][view]">
                                                                        <label class="custom-control-label" for="addcampaignView">Can View</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addcampaignStart" name="roles[campaign][start]">
                                                                        <label class="custom-control-label" for="addcampaignStart">Can Start Campaign</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addcampaignEdit" name="roles[campaign][edit]">
                                                                        <label class="custom-control-label" for="addcampaignEdit">Can Edit Existing Campaign</label>
                                                                    </div>
                                                                </li>
                                                            </ul>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <h3>LEADS</h3>
                                                            <ul class="roles-list">
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addleadsView" name="roles[leads][view]">
                                                                        <label class="custom-control-label" for="addleadsView">Can View</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addleadsChangeStatus" name="roles[leads][change_status]">
                                                                        <label class="custom-control-label" for="addleadsChangeStatus">Can Change status</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addleadsReply" name="roles[leads][reply]">
                                                                        <label class="custom-control-label" for="addleadsReply">Can Reply</label>
                                                                    </div>
                                                                </li>
                                                            </ul>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <h3>SETTINGS</h3>
                                                            <ul class="roles-list settings-role">
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addsettingsUpdateName" name="roles[settings][update_name]">
                                                                        <label class="custom-control-label" for="addsettingsUpdateName">Can Update Name</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addsettingsChangePassword" name="roles[settings][update_password]">
                                                                        <label class="custom-control-label" for="addsettingsChangePassword">Can Update Password</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addsettingsChangeSignature" name="roles[settings][update_signature]">
                                                                        <label class="custom-control-label" for="addsettingsChangeSignature">Can Update Signature</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addsettingsUpdateTimezoe" name="roles[settings][update_timezone]">
                                                                        <label class="custom-control-label" for="addsettingsUpdateTimezoe">Can Update Timezone</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addsettingsChangeSendingSpeed" name="roles[settings][change_sending_speed]">
                                                                        <label class="custom-control-label" for="addsettingsChangeSendingSpeed">Can Change Sending Speed</label>
                                                                    </div>
                                                                </li>
                                                            </ul>
                                                        </div>

                                                        <div class="col-md-4">
                                                            <h3>EXCLUSIONS</h3>
                                                            <ul class="roles-list">
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addexclusionsView" name="roles[exclusions][view]">
                                                                        <label class="custom-control-label" for="addexclusionsView">Can View</label>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="custom-control custom-checkbox">
                                                                        <input type="checkbox" class="custom-control-input add-chk-role" id="addexclusionsManage" name="roles[settings][manage]">
                                                                        <label class="custom-control-label" for="addexclusionsManage">Can Manage Exclusions</label>
                                                                    </div>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php }else{ ?>
                                                <div class="alert alert-danger" role="alert">You have reached maximum sub accounts you can create. Please upgrade plan to increase limit.</div>
                                            <?php } ?>
                                            </div>
                                            <div class="modal-footer" style="display: block;text-align: center;">
                                                <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                                              <?php if( $subAccounts->rowcount() < $total_sub_accounts){ ?>
                                                <button type="submit" class="btn btn-success" style="width:200px;font-size: 21px;" value="add-sub-account" name="action">Save</button>
                                              <?php } ?>
                                            </div>   
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>

            </div>
            <!-- /.container-fluid -->

        </div>
        <!-- End of Main Content -->



        <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Copyright &copy; <?php echo date('Y'); ?></span>
                </div>
            </div>
        </footer>
        <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>
<script>
    $(function(){
        $("#add-chk-all-roles").change(function(){
            if( $(this).is(':checked') ){
                $('.add-chk-role').prop('checked',true);
            }else{
                $('.add-chk-role').prop('checked', false);
            }
        });

        $("#edit-chk-all-roles").change(function(){
            if( $(this).is(':checked') ){
                $('.edit-chk-role').prop('checked',true);
            }else{
                $('.edit-chk-role').prop('checked', false);
            }
        });
    });
</script>