<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PhpImap\Mailbox;
use PhpImap\Exceptions\ConnectionException;
define("IN_CRONTAB",1);
require_once dirname(__FILE__) . '/config.php';
require_once dirname(__FILE__) . '/functions.php';
require_once dirname(__FILE__) . '/PHPMailer/autoload.php';
require_once dirname(__FILE__) . '/Google/autoload.php';
require_once dirname(__FILE__) . '/swiftmailer/autoload.php';
require_once dirname(__FILE__) . '/php-imap/autoload.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(900);

echo 'Running Cron Read Lead Replies';
flush();
$script_time_start = microtime(true);

/*Lead Replies*/
$data = $pdo->prepare('SELECT `id`, `cron_module`,`last_id_checked`,`last_activity` FROM `cron_last_activities` WHERE `cron_module`="lead_replies"');
$data->execute();
$cron = $data->fetch(PDO::FETCH_ASSOC);
$last_id_checked = $cron['last_id_checked'];

$leadReplies = $pdo->prepare('SELECT id,lead_id FROM `lead_replies` WHERE `is_sent`=? AND `is_with_reply`=? AND `id` >= ? LIMIT 10');
$leadReplies->execute(array(1,0,$last_id_checked));
foreach($leadReplies as $lr){
	$is_checked = false;

	$data = $pdo->prepare('SELECT `sent_mail_id` FROM `leads` WHERE `id`=?');
	$data->execute(array($lr['lead_id']));
	$lead = $data->fetch(PDO::FETCH_ASSOC);

	if($lead){
		$data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `id`=?');
		$data->execute(array($lead['sent_mail_id']));
		$sent_mail = $data->fetch(PDO::FETCH_ASSOC);
		$identifier = $sent_mail['identifier'];

		$data = $pdo->prepare('SELECT * FROM `campaigns` WHERE `id`=?');
		$data->execute(array($sent_mail['campaign_id']));
		$campaign = $data->fetch(PDO::FETCH_ASSOC);

		$nextCheckTime = time() - (10 * 60);
		// IMAP non ssl
		$imap = $pdo->prepare('SELECT * FROM `imap` WHERE active = 1 AND `user`=? AND lastdate_leadreplies <= ?');
		$imap->execute(array($sent_mail['from_email'],$nextCheckTime));

		if($imap->rowcount()>0) {
			$imap = $imap->fetch(PDO::FETCH_ASSOC);

			$updateActive = $pdo->prepare('UPDATE `imap` SET lastdate_leadreplies  =? WHERE `id`=?');
			$updateActive->execute(array(time(),$imap['id']));

			if( $imap['is_ssl'] == 1 ){
				$mailbox_server = '{'.$imap['server'].':'.$imap['port'].'/imap/ssl}INBOX';
			}else{
				$mailbox_server = '{'.$imap['server'].':'.$imap['port'].'/imap}INBOX';
			}
	        try {
			$mailbox = new Mailbox(
			    $mailbox_server,
			    $imap['user'],
			    crypt_jm($imap['password'],'d'),
			    __DIR__,
			    'US-ASCII'
			);


			$subject = str_replace("@", "", $sent_mail['subject']);
			$mail_ids = $mailbox->searchMailbox('SUBJECT "'.$subject.'" FROM "' . $sent_mail['to_email'] . '"');	
			
			} catch(ConnectionException $ex) {

	            // Account no longer active...
	            $updateActive = $pdo->prepare('UPDATE `imap` SET active = 0,inactive_reason =? WHERE `id`=?');
	            $updateActive->execute(array($ex->getMessage(),$imap['id']));
			    error_log("IMAP Check Lead Relies failed: " . $imap['id'] . " Reason: " . $ex->getMessage());
			    AddNotification("imap", "IMAP Account " . $imap['user']. " inactive - " . $e->getMessage(),$campaign['member_id']);
			    continue;
			}
			foreach ($mail_ids as $mail_id) {
			    $email = $mailbox->getMail(
			        $mail_id,
			        false
			    );

			    if(!empty($email->fromAddress)){

			    	$email_content_raw = htmlentities($email->textHtml);
				    $strpos = strpos($email_content_raw, $identifier);
				    if($strpos !== false){

				    	$count_replies = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `mail_id`=?');
						$count_replies->execute(array($mail_id));
						$count_replies = $count_replies->fetch(PDO::FETCH_ASSOC);

						if( !$count_replies ){
							if( strtotime($email->date) >= $campaign['trigger_date'] ){ //To prevent fetching old msg with same subject
								//Insert lead reply
						    	$data = array(
						    		$lr['lead_id'],
						    		$sent_mail['campaign_id'],
						    		$email->textHtml,
						    		strtotime($email->date),
						    		1,
						    		1,
						    		$mail_id
						    	);
						    	$q = $pdo->prepare('INSERT INTO `lead_replies` (lead_id,campaign_id,msg,replied_date,is_with_reply,is_sent,mail_id)  VALUES (?,?,?,?,?,?,?)');
								$result = $q->execute($data);

								$q = $pdo->prepare('UPDATE `lead_replies` SET `is_with_reply`=? WHERE `id`=?');
								$result = $q->execute(array(1,$lr['id']));

								AddNotification("leads", "New Lead Reply",$campaign['member_id']);
							}
						}
			    		$is_checked = true;
			    	}
			    }
			}

			$mailbox->disconnect();
		}

		$last_id_checked = $lr['id'];
	}
}

if($last_id_checked == $cron['last_id_checked']){
	$q = $pdo->prepare('UPDATE `cron_last_activities` SET `last_id_checked`=?, `last_activity`=? WHERE `cron_module`="lead_replies"');
	$result = $q->execute(array(0,time()));
}else{
	if($last_id_checked > 0){
		$q = $pdo->prepare('UPDATE `cron_last_activities` SET `last_id_checked`=?, `last_activity`=? WHERE `cron_module`="lead_replies"');
		$result = $q->execute(array($last_id_checked,time()));
	}	
}


$time_end = microtime(true);
$time = $time_end - $script_time_start;

echo ' End Cron Read Lead Replies - Time Taken: ' . $time . '<br>';

//Reactivate imap
$current_timestamp = time();
$imap = $pdo->prepare('SELECT * FROM `imap` WHERE active = 0');
$imap->execute();

$error_string = 'Connection timed out';

foreach( $imap as $i ){
	if( strpos($i['inactive_reason'], $error_string) !== false ){
		$lastdate_check = date("Y-m-d H:i:s",$i['lastdate_leadreplies']);
		$timestap_10mins   = strtotime($lastdate_check . ' +10 minute');
		if( $timestap_10mins <= $current_timestamp ){			
			$updateActive = $pdo->prepare('UPDATE `imap` SET active = 1,inactive_reason ="" WHERE `id`=?');
		    $updateActive->execute(array($i['id']));
		}
	} 	
}

