<title><?php echo SITE_NAME; ?> - Prospect</title>
<script type="text/javascript" src='https://cdnjs.cloudflare.com/ajax/libs/jquery/1.12.3/jquery.min.js'></script>
<script type="text/javascript" src='https://cdnjs.cloudflare.com/ajax/libs/rangeslider.js/2.3.0/rangeslider.min.js'></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/rangeslider.js/2.3.0/rangeslider.min.css" />
<link rel="stylesheet" href="<?php echo $root . '/css/prospect/'; ?>chosen.min.css">
<link rel="stylesheet" href="<?php echo $root . '/css/prospect/'; ?>main.css" />
<link rel="stylesheet" href="<?php echo $root . '/css/prospect/'; ?>slider.css" />
<!--<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootswatch/4.3.1/flatly/bootstrap.min.css">-->
</head>
<body id="page-top">
<?php
$authentication = true;
// api to check prospect key is expired or not

$curl = curl_init();

curl_setopt_array($curl, array(
    CURLOPT_URL => GETPROSPECT_URL."/user/account/workspace-limits",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => array(
        "Content-Type: application/json",
        "Authorization: Bearer ". GETPROSPECT_API_KEY
    ),
));

$response = curl_exec($curl);
$decode_res = json_decode($response, true);
if(isset($decode_res['statusCode'])){
    if($decode_res['statusCode']==401)
    {
        $authentication = false;
        $error_prospect = "Some thing went wrong please try again later";
        //include 'get_prospect_email.php';
        PhpMailerSendEmail('support@automailer.io','Prospect Key Expiration','Your Given Key for Get Prospect Has Been Expired','Automailer.io',true);
    }
}
?>
<style>
    /*
* bootstrap-tagsinput v0.8.0
*
*/

    .bootstrap-tagsinput {
        background-color: #fff;
        border: 1px solid #ccc;
        box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
        display: inline-block;
        padding: 4px 6px;
        color: #555;
        vertical-align: middle;
        border-radius: 4px;
        width: 100%;
        line-height: 22px;
        cursor: text;
    }
    .bootstrap-tagsinput input {
        border: none;
        box-shadow: none;
        outline: none;
        background-color: transparent;
        padding: 0 6px;
        margin: 0;
        width: auto;
        max-width: inherit;
    }
    .sr-only {
        position: absolute !important;
        width: 1px !important;
        height: 1px !important;
        padding: 0 !important;
        overflow: hidden !important;
        clip: rect(0, 0, 0, 0) !important;
        white-space: nowrap !important;
        border: 0px !important;
    }
    .bootstrap-tagsinput.form-control input::-moz-placeholder {
        color: #777;
        opacity: 1;
    }
    .bootstrap-tagsinput.form-control input:-ms-input-placeholder {
        color: #777;
    }
    .bootstrap-tagsinput.form-control input::-webkit-input-placeholder {
        color: #777;
    }
    .bootstrap-tagsinput input:focus {
        border: none;
        box-shadow: none;
    }
    .bootstrap-tagsinput .badge {
        margin: 2px 3px;
        padding:5px 8px;
    }
    .bootstrap-tagsinput .badge [data-role="remove"] {
        margin-left: 8px;
        cursor: pointer;
    }
    .bootstrap-tagsinput .badge [data-role="remove"]:after {
        content: "×";
        padding: 0px 4px;
        background-color:rgba(0, 0, 0, 0.1);
        border-radius:50%;
        font-size:13px
    }
    .bootstrap-tagsinput .badge [data-role="remove"]:hover:after {

        background-color:rgba(0, 0, 0, 0.62);}
    .bootstrap-tagsinput .badge [data-role="remove"]:hover:active {
        box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125);
    }

    .bootstrap-tagsinput  input{
        width: 100%;
        border: none !important;
    }

    .tt-menu {
        position: absolute;
        top: 100%;
        left: 0;
        z-index: 1000;
        display: none;
        float: left;
        min-width: 160px;
        padding: 5px 0;
        margin: 2px 0 0;
        list-style: none;
        font-size: 14px;
        background-color: #ffffff;
        border: 1px solid #cccccc;
        border: 1px solid rgba(0, 0, 0, 0.15);
        border-radius: 4px;
        -webkit-box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);
        box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);
        background-clip: padding-box;
        cursor: pointer;
    }

    .tt-suggestion {
        display: block;
        padding: 3px 20px;
        clear: both;
        font-weight: normal;
        line-height: 1.428571429;
        color: #333333;
        white-space: nowrap;
    }

    .tt-suggestion:hover,
    .tt-suggestion:focus {
        color: #ffffff;
        text-decoration: none;
        outline: 0;
        background-color: #428bca;
    }

    .new-badge{
        background-color:#0d9bf8;
    }

</style>
<!-- Page Wrapper -->
<div id="wrapper">
    <?php include_once("nav_wrapper.php"); ?>
    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column no-scroll">

        <!-- Main Content -->
        <div id="content">
            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>
            <!-- Begin Page Content -->

            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-8 col-sm-8 col-12 m-bt">

                        <?php

                        if (!empty($_POST)) {
                            //echo '<pre>';print_r($_POST);exit;

                            $inSummary = false;
                            if (isset($_POST['inSummary']) && $_POST['inSummary'] == 'on') {
                                $inSummary = true;
                            }


                            // print_r(implode(', ', $_POST['locations']));die;
                            $dest_list = isset($_POST['dest_list']) ? $_POST['dest_list'] : '';
                            $list_name = isset($_POST['list_name']) ? $_POST['list_name'] : '';
                            $positions = isset($_POST['positions']) ?  implode(', ', $_POST['positions']) : '';
                            $lead_country = isset($_POST['locations']) ?  implode(', ', $_POST['locations']) : '';
                            // $lead_cities = isset($_POST['lead_city']) ? implode(', ', $_POST['lead_city']) : '';
                            $industries = isset($_POST['industries']) ?  implode(', ', $_POST['industries']) : '';
                            $company_min = $_POST['emp_min_count'];
                            $company_max = $_POST['emp_max_count'];
                            $HQcountry = isset($_POST['HQcountry'])  ? implode(', ', $_POST['HQcountry']) : '';
                            $HQcity = isset($_POST['HQcity']) ?  implode(', ', $_POST['HQcity']) : '';
                            $domain = $_POST['domain'];
                            $company_name = $_POST['company_name'];
                            $limit_amount = $_POST['limit_amount'];
                            // print_r($lead_country);die;

                            $post_lists = [
                                'name' => $list_name,
                            ];

                            $validForm = true;

                            if($list_name == '' || empty($list_name)){
                                echo '<p class="text-danger mb-4">Error: List Name required.</p>';
                                $validForm = false;
                            }

                            if(empty($positions) || $positions == "")
                            {
                                echo '<p class="text-danger mb-4">Error: Select atleast One Position.</p>';
                                $validForm = false;
                            }

                            if(empty($lead_country) || $lead_country == "")
                            {
                                echo '<p class="text-danger mb-4">Error: Select atleast One Lead Country.</p>';
                                $validForm = false;
                            }
                            $isListNameExists = $pdo->prepare('SELECT id, member_id FROM `lists` WHERE `member_id`=? AND `name`=? LIMIT 1');
                            $isListNameExists->execute(array($_SESSION['id'], $list_name));

                            if ($validForm && $isListNameExists->rowcount() > 0) {
                                echo '<p class="text-danger mb-4">Error: List Name already exists.</p>';
                                $validForm = false;
                            }

                            if ($validForm) {

                                //insert all postions in prospect_positions table
                                $filtered_positions = array();
                                if(isset($_POST['positions'])){
                                    foreach($_POST['positions'] as $key=>$filter_position)
                                    {

                                        $check_position_record = $pdo->prepare('SELECT * FROM `prospect_positions` WHERE `position`=? LIMIT 1');
                                        $check_position_record->execute(array($filter_position));
                                        $position_record = $check_position_record->fetch(PDO::FETCH_ASSOC);

                                        if($check_position_record->rowcount()>0){
                                            $filtered_positions[$key] = $position_record['id'];
                                        }

                                    }
                                }
                                $q = $pdo->prepare('INSERT INTO `lists` (name,fields,member_id,date_created) VALUES (?,?,?,?)');
                                $q->execute(array($list_name, '', $_SESSION['id'],date("Y-m-d H:i:s")));
                                $dest_list = $pdo->lastInsertId();
                                //insert all countries in prospect_countries table
                                $filtered_countries = array();

                                //insert all industries in prospect_industries table
                                $filtered_industries = array();
                                // print_R($_POST['industries']);
                                if(isset($_POST['industries'])){
                                    foreach($_POST['industries'] as $key=>$filter_industry)
                                    {

                                        $check_industry_record = $pdo->prepare('SELECT * FROM `prospect_industries` WHERE `industry`=? LIMIT 1');
                                        $check_industry_record->execute(array($filter_industry));
                                        $industry_record = $check_industry_record->fetch(PDO::FETCH_ASSOC);

                                        if($check_industry_record->rowcount()>0) {
                                            $filtered_industries[$key] = $industry_record['id'];
                                        }
                                    }
                                }


                                $filtered_countries = implode(",",$filtered_countries);
                                // $filtered_cities = implode(",",$filtered_cities);
                                $filtered_industries = implode(",",$filtered_industries);
                                $filtered_positions = implode(",",$filtered_positions);
                                // $filtered_industries="2,1";
                                $member_id = $member['id'];


                                $query_parts = array();
                                foreach ($_POST['locations'] as $val) {
                                    $query_parts[] = "'%".$val."%'";
                                }
                                $string = implode(' OR country_code LIKE ', $query_parts);


                                $sql = "SELECT * FROM `contacts` WHERE NOT EXISTS  (SELECT * FROM member_has_contacts WHERE contacts.email = member_has_contacts.email AND member_has_contacts.member_id = $member_id)  AND (contacts.country_code LIKE {$string}) AND contacts.position IN($filtered_positions)";
                                if(!empty($filtered_industries))
                                {
                                    $sql .= "AND contacts.industry IN($filtered_industries)";
                                }

                                $sql .= " LIMIT $limit_amount";
                                $stm = $pdo->prepare($sql);
                                $stm->execute();
                                $contacts = $stm->fetchAll();

                                $fetch_contacts = count($contacts);
                                $added_accounts = 0;
                                foreach($contacts as $contact)
                                {
                                    // print_r($contact);die;

                                    $q = $pdo->prepare('INSERT INTO `contacts`  (list_id,firstName,lastName,email,data,all_data,status, country,city,position,industry,hq_location)  VALUES (?,?,?,?,?,?,?,?,?,?,?,?)');
                                    $q->execute(array($dest_list, $contact['firstName'], $contact['lastName'], $contact['email'], $contact['data'], $contact['all_data'], 0, $contact['country'], $contact['city'], $contact['position'], $contact['industry'], $contact['hq_location']));

                                    $q = $pdo->prepare('INSERT INTO `member_has_contacts`  (contact_id,email,member_id)  VALUES (?,?,?)');
                                    $q->execute(array($contact['id'],$contact['email'],$member['id']));
                                    $added_accounts++;
                                }

                                $q = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=?');
                                $q->execute(array($dest_list));
                                $contacts = $q->fetchAll();

                                $q = $pdo->prepare('UPDATE `lists` SET `total_contacts`=? , `verification` = ?  WHERE `id`=?');
                                $q->execute(array(count($contacts), 0 ,$dest_list));
                                if($limit_amount>count($contacts)){

                                    //if($dest_list == ''){

                                    //}
                                    $limit_amount = $limit_amount - count($contacts);
                                    $curl = curl_init();

                                    curl_setopt_array($curl, array(
                                        CURLOPT_URL => GETPROSPECT_URL."/contacts/lists",
                                        CURLOPT_RETURNTRANSFER => true,
                                        CURLOPT_ENCODING => "",
                                        CURLOPT_MAXREDIRS => 10,
                                        CURLOPT_TIMEOUT => 0,
                                        CURLOPT_FOLLOWLOCATION => true,
                                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                        CURLOPT_CUSTOMREQUEST => "POST",
                                        //CURLOPT_POSTFIELDS => "{\n    \"positions\" : \"$positions\",\n    \"inSummary\": \"true\",\n    \"countryCodes\": \"US\",\n    \"leadCities\": \"$lead_cities\",\n \"companyIndustries\": \"$industries\",\n \"companySizeMin\": \"$company_min\",\n \"companySizeMax\": \"$company_max\" \n}",
                                        CURLOPT_POSTFIELDS => json_encode($post_lists),
                                        CURLOPT_HTTPHEADER => array(
                                            "Content-Type: application/json",
                                            "Authorization: Bearer ". GETPROSPECT_API_KEY
                                        ),
                                    ));

                                    $response = curl_exec($curl);
                                    $decode_res = json_decode($response, true);
                                    // print_r($decode_res);
                                    //echo '<pre>';print_r($decode_res);exit;
                                    //$prospect_list_id = $decode_res['data']['id'];
                                    $prospect_list_id = isset($decode_res['_id'])? $decode_res['_id'] :'';

//                              $post = [
//                                  'positions' => $positions,
//                                  'inSummary' => $inSummary,
//                                  'countryCodes' => $lead_country,
//                                  'leadCities' => $lead_cities,
//                                  'companyIndustries' => $industries,
//                                  'companySizeMin' => $company_min,
//                                  'companySizeMax' => $company_max,
//                                  'companyCountryCodes' => $HQcountry,
//                                  'companyCities' => $HQcity,
//                                  'companyWebsites' => $domain,
//                                  'companyNames' => $company_name,
//                                  'limit' => $limit_amount,
//                                  'listId' => $prospect_list_id,
//                              ];

                                    $post = array();
                                    $post['filters'] = array();

                                    if ($positions) {
                                        //echo "positions";
                                        //$post['filters'] = array();
                                        $newdata = array();
                                        $newdata['property'] = 'company.position';
                                        $newdata['included'] = array();
                                        $newdata['included']['operator'] = 'CONTAINS';
                                        $newdata['included']['value'] = explode(',', $positions);
                                        array_push($post['filters'],$newdata);
                                    }
                                    if ($lead_country) {
                                        //echo "country";
                                        //$post['filters'] = array();
                                        $newdata1 = array();
                                        $newdata1['property'] = 'contact.location';
                                        $newdata1['included'] = array();
                                        $newdata1['included']['operator'] = 'LOCATION';
                                        $newdata1['included']['value'] = $_POST['locations'];
                                        array_push($post['filters'],$newdata1);
                                    }
                                    // print_r($post['filters']);die;
                                    if ($industries) {
                                        //echo "industrt";
                                        //$post['filters'] = array();
                                        $newdata2 = array();
                                        $newdata2['property'] = 'company.industry';
                                        $newdata2['included'] = array();
                                        $newdata2['included']['operator'] = 'EQ';
                                        $newdata2['included']['value'] = explode(',',$industries);
                                        array_push($post['filters'],$newdata2);
                                    }

                                    if ($company_min != '' && $company_max != '') {
                                        //$post['filters'] = array();
                                        $newdata3 = array();
                                        $newdata3['property'] = 'company.size';
                                        $newdata3['included'] = array();
                                        $newdata3['included']['operator'] = 'RANGE';
                                        $newdata3['included']['value'][] = intval($company_min) .'-'. intval($company_max);
                                        array_push($post['filters'],$newdata3);
                                    }
                                    $newdata = array();
                                    $newdata['property'] = 'email';
                                    $newdata['included'] = array("operator"=>"EMAIL_STATUS","value"=>["exist"]);
                                    array_push($post['filters'],$newdata);

                                    $post['limits']['perCompany'] = 1;
                                    $post['limits']['total'] = intval($limit_amount);
                                    $post['selected'] = intval($limit_amount);
                                    $post['source'] = 'contact';
                                    $post['listIds'][] = $prospect_list_id;

                                    $post['saveAdded'] = false;
                                    //echo '<pre>';print_r($post);exit;

//                              $post = array (
//                                  'filters' =>
//                                      array (
//                                          0 =>
//                                              array (
//                                                  'property' => 'email',
//                                                  'included' =>
//                                                      array (
//                                                          'operator' => 'EMAIL_STATUS',
//                                                          'value' =>
//                                                              array (
//                                                              ),
//                                                      ),
//                                              ),
//                                          1 =>
//                                              array (
//                                                  'property' => 'company.position',
//                                                  'included' =>
//                                                      array (
//                                                          'operator' => 'CONTAINS',
//                                                          'value' =>
//                                                              explode(',',$positions)
//                                                      ),
//                                                  'excluded' =>
//                                                      array (
//                                                          'value' =>
//                                                              array (
//                                                              ),
//                                                      ),
//                                              ),
//                                          2 =>
//                                              array (
//                                                  'property' => 'contact.location',
//                                                  'included' =>
//                                                      array (
//                                                          'operator' => 'LOCATION',
//                                                          'value' =>
//                                                              explode(',',$lead_country)
//                                                      ),
//                                                  'excluded' =>
//                                                      array (
//                                                          'value' =>
//                                                              array (
//                                                              ),
//                                                      ),
//                                              ),
//                                          3 =>
//                                              array (
//                                                  'property' => 'company.industry',
//                                                  'included' =>
//                                                      array (
//                                                          'operator' => 'EQ',
//                                                          'value' =>
//                                                              explode(',',$industries)
//                                                      ),
//                                                  'excluded' =>
//                                                      array (
//                                                          'value' =>
//                                                              array (
//                                                              ),
//                                                      ),
//                                              ),
//                                          4 =>
//                                              array (
//                                                  'property' => 'company.size',
//                                                  'included' =>
//                                                      array (
//                                                          'operator' => 'RANGE',
//                                                          'value' =>
//                                                              array (
//                                                                  0 => $company_min .'-'. $company_max,
//                                                                  //0 => '51 - 100'
//                                                              ),
//                                                      ),
//                                                  'excluded' =>
//                                                      array (
//                                                          'value' =>
//                                                              array (
//                                                              ),
//                                                      ),
//                                              ),
//                                          5 =>
//                                              array (
//                                                  'property' => 'company.location',
//                                                  'included' =>
//                                                      array (
//                                                          'operator' => 'LOCATION',
//                                                          'value' =>
//                                                              explode(',',$lead_country)
//                                                      ),
//                                                  'excluded' =>
//                                                      array (
//                                                          'value' =>
//                                                              array (
//                                                              ),
//                                                      ),
//                                              ),
//                                          6 =>
//                                              array (
//                                                  'property' => 'company.domain',
//                                                  'included' =>
//                                                      array (
//                                                          'operator' => 'EQ',
//                                                          'value' =>
//                                                              array (
//                                                                  0 => $domain,
//                                                                  //1 => 'localwisdom.com',
//                                                              ),
//                                                      ),
//                                                  'excluded' =>
//                                                      array (
//                                                          'value' =>
//                                                              array (
//                                                              ),
//                                                      ),
//                                              ),
//                                      ),
//                                  'limits' =>
//                                      array (
//                                          'perCompany' => 1,
//                                          'total' => intval($limit_amount),
//                                      ),
//                                  'selected' => intval($limit_amount),
//                                  'source' => 'contact',
//                                  'listIds' =>
//                                      array (
//                                          0 => $prospect_list_id,
//                                      ),
//                                  'saveAdded' => false,
//                              );

                                    //echo '<pre>';print_r($post);exit;

                                    $curl = curl_init();

                                    curl_setopt_array($curl, array(
                                        CURLOPT_URL => GETPROSPECT_URL."/insights/search",
                                        CURLOPT_RETURNTRANSFER => true,
                                        CURLOPT_ENCODING => "",
                                        CURLOPT_MAXREDIRS => 10,
                                        CURLOPT_TIMEOUT => 0,
                                        CURLOPT_FOLLOWLOCATION => true,
                                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                        CURLOPT_CUSTOMREQUEST => "POST",
                                        //CURLOPT_POSTFIELDS => "{\n    \"positions\" : \"$positions\",\n    \"inSummary\": \"true\",\n    \"countryCodes\": \"US\",\n    \"leadCities\": \"$lead_cities\",\n \"companyIndustries\": \"$industries\",\n \"companySizeMin\": \"$company_min\",\n \"companySizeMax\": \"$company_max\" \n}",
                                        CURLOPT_POSTFIELDS => json_encode($post),
                                        CURLOPT_HTTPHEADER => array(
                                            "Content-Type: application/json",
                                            "Authorization: Bearer ". GETPROSPECT_API_KEY
                                        ),
                                    ));

                                    $response_ls = curl_exec($curl);
                                    $decode_response = json_decode($response_ls, true);
                                    // print_r($decode_response);
                                    if(isset($decode_res['statusCode'])){
                                        if($decode_res['statusCode']==401)
                                        {
                                            //include 'get_prospect_email.php';
                                            PhpMailerSendEmail('support@automailer.io','Prospect Key Expiration','Your Given Key for Get Prospect Has Been Expired','Automailer.io',true);
                                        }
                                    }
                                    $lead_cities = "";
                                    // echo '<pre>';print_r($decode_response);

                                    $data = array(
                                        json_encode($post),
                                        $dest_list,
                                        $_SESSION['id'],
                                        $positions,
                                        $lead_country,
                                        $lead_cities,
                                        $industries,
                                        $company_min,
                                        $company_max,
                                        $HQcountry,
                                        $HQcity,
                                        $domain,
                                        $company_name,
                                        $limit_amount,
                                        $response,
                                        isset($decode_response['search']['id']) ? $decode_response['search']['id'] :'',
                                        $prospect_list_id,
                                        time()
                                    );
                                    if(!isset($error_prospect)){
                                        $q = $pdo->prepare('INSERT INTO `prospect` (insight_search,list_id,user_id,positions,lead_country,lead_cities,industries,company_min,company_max,HQcountry,HQcity,domain_name,company_name,limit_amount,response,getprospect_id,getprospect_list_id,date_created) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
                                        $result = $q->execute($data);
                                        //print_r($q->errorInfo());
                                        $lead_id = $pdo->lastInsertId();
                                    }

                                    if (curl_errno($curl)) {
                                        $error_msg = curl_error($curl);
                                    }
                                    //echo '<pre>';print_r($error_msg);

                                    //$info = curl_getinfo($curl);
                                    //var_dump($info);
                                    //exit;

                                    curl_close($curl);

                                    $res = json_decode($response);
                                }else{
                                    $q = $pdo->prepare('UPDATE `prospect` SET `status`=? WHERE `list_id`=?');
                                    $q->execute(array('completed',  $dest_list));
                                }
                                //echo "<meta http-equiv='refresh' content='0'>";
                                //$_SESSION['success_msg'] =  "Lead request successfully added, once we find it we will send you notification";
                                if(!isset($error_prospect)){
                                    echo '<div class="alert alert-success" role="alert">
                                Lead finder is currently building your list, you will be notified upon completion.
                              </div>';
                                }else {
                                    echo '<div class="alert alert-danger" role="alert">'.
                                        $error_prospect .
                                        '</div>';
                                }
                                // echo "<meta http-equiv='refresh' content='0'>";

                                //echo '<pre>';print_r($res);exit;
                            }
                        }

                        if($authentication==false)
                        {
                            echo '<div class="alert alert-danger" role="alert">This service is not available. Please come back afetr some time</div>';
                        }
                        ?>

                        <h1 class="btn5">Search Leads By filter </h1>
                        <p style='font-size:14px; margin-top: 0px!important;'>You can find leads for your compaign according to your
                            search filters and keywordsearch
                        </p>
                    </div>
                    <div class="col-md-4 col-sm-4 col-12 mar-bt">
                        <div class="text-right">
                            <a class="gradient-button gradient-button-2">
                                <img class="iconset" src="img/prospect/searcss.png" alt="icon"><span><b><?php echo $member['search_credit']; ?></b></span><span class="searchcredit"><br>Search Credit</span></a>
                        </div>
                    </div>
                </div>
                <input type="hidden" id="search_credit" value="<?= $member['search_credit']; ?>">

                <div class="row">
                    <div class="col-sm-12 col-md-3 col-12">
                    </div>
                    <div class="col-sm-12 col-md-6 col-12 ">
                        <!--                    <form class="user center2" action="" method="post" id="register_form">-->
                        <form class="lead_finder" action="" method="post" id="lead_finder">

                            <!--<div class="form-group">
                        <label for="dest-list">Destination List</label>
                        <select class="form-control destination_list" name="dest_list" placeholder="Create new List">
                            <?php
                            //$q = $pdo->prepare('SELECT * FROM `lists` WHERE `member_id`=? ORDER BY `name`');
                            //$q->execute(array($member['id']));
                            //$lists = $q->fetchAll();
                            ?>

                            <option value="">Create new list</option>
                            <?php //foreach($lists as $value){ ?>
                                <option value="<?php //echo $value['id']; ?>"><?php //echo $value['name']; ?></option>
                            <?php //} ?>

                        </select>
                      </div>-->

                            <div class="form-group div_list_name">
                                <label for="list-name">New List Name <span style="color: red;">*</span></label>
                                <input type="text" class="form-control test" id="list_name" required placeholder="USA Marketing Directors" name="list_name">
                            </div>

                            <div class="form-group">
                                <label for="position">Positions <span style="color: red;">*</span></label>
                                <!-- <input list="hosting-plan" type="text" class="form-control test" placeholder="Add Positions"
                                  name="position">
                                <datalist id="hosting-plan">
                                  <option value="small">$15 USD</option>
                                </datalist> -->
                                <?php
                                $all_positions = $pdo->prepare('SELECT * FROM `prospect_positions`');
                                $all_positions->execute();
                                $all_positions = $all_positions->fetchAll();
                                ?>
                                <select class="form-control mselect" name="positions[]" id="position" placeholder="Add Positions" multiple="" required>
                                    <?php
                                    foreach ($all_positions as $key => $value) { ?>
                                        <option value="<?php echo $value['position'] ?>"><?php echo $value['position'] ?></option>
                                    <?php  }
                                    ?>
                                </select>

                                <input type="checkbox" name="inSummary">
                                <span class="checkmark" style='font-size:10px'>Extend Search result with keywordsearch in profile
                          summary</span>
                                </label>

                            </div>
                            <div class="form-group">
                                <label for="list-name">Location <span style="color: red;">*</span></label>

                                <input type="text" class="form-control" id="search_location"  required placeholder="Enter Location" data-role="tagsinput">
                            </div>
                            <!-- <div class="form-group div_location">
                                <label for="list-name">Location <span style="color: red;">*</span></label>

                                <input type="text" class="form-control test" required placeholder="Enter Location" data-role="tagsinput">
                                <input type="hidden" id="location_hidden">
                            </div> -->
                            <!-- <div class="form-group">
                                <label for="country">Lead Country <span style="color: red;">*</span></label>
                                <?php
                            $all_countries = $pdo->prepare('SELECT * FROM `countries`');
                            $all_countries->execute();
                            $all_countries = $all_countries->fetchAll();
                            ?>
                                <select class="form-control mselect" name="lead_country[]" id="country" placeholder="Select Countries" multiple="">
                                    <?php
                            foreach ($all_countries as $key => $value) { ?>
                                        <option value="<?php echo $value['name'] ?>"><?php echo $value['name'] ?></option>
                                    <?php  }
                            ?>
                                </select>
                            </div> -->

                            <!-- <div class="form-group">
                                <label for="city">Lead City</label>
                                <?php
                            $all_cities = $pdo->prepare('SELECT * FROM `prospect_cities`');
                            $all_cities->execute();
                            $all_cities = $all_cities->fetchAll();
                            ?>
                                <select class="form-control mselect" name="lead_city[]" id="city" placeholder="Select City" multiple="">
                                    <?php
                            foreach ($all_cities as $key => $value) { ?>
                                        <option value="<?php echo $value['city'] ?>"><?php echo $value['city'] ?></option>
                                    <?php  }
                            ?>
                                </select>
                            </div> -->

                            <!-- <div class="form-group">
                              <label for="email">Employee count</label>
                              <div class="slide">
                                <input type="range" min="5" max="100" value="90" class="slider form-control" id="myRange">
                              </div>
                            </div> -->
                            <div class="form-group">

                                <div class="slider-0">
                                    <label>Employee count</label>
                                    <div class="range-slider">
                                        <input type="text" class="js-range-slider" value="" />
                                    </div>
                                    <div class="extra-controls">
                                        <div class="form-group range-value-row">
                                            <div class="range-value">
                                                <span>Min:</span>
                                                <input type="text" name="emp_min_count" class="js-input-from" value="0" />
                                            </div>
                                            <div class="range-value">
                                                <span>Max:</span>
                                                <input type="text" name="emp_max_count" class="js-input-to" value="0" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="industries">Industries</label>
                                <!-- <input list="hosting-plan" type="text" class="form-control test" placeholder="Add Industries"
                                  name="industries">
                                <datalist id="hosting-plan">
                                  <option value="small">$15 USD</option>
                                </datalist> -->
                                <?php
                                $all_industries = $pdo->prepare('SELECT * FROM `prospect_industries`');
                                $all_industries->execute();
                                $all_industries = $all_industries->fetchAll();
                                ?>
                                <select class="form-control mselect" name="industries[]" id="industries" placeholder="Add Industries" multiple="">
                                    <?php
                                    foreach ($all_industries as $key => $value) { ?>
                                        <option value="<?php echo $value['industry'] ?>"><?php echo $value['industry'] ?></option>
                                    <?php  }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="HQcountry">Company HQ Country</label>
                                <!-- <input list="hosting-plan" type="text" class="form-control test" placeholder="Select country"
                                  name="HQcountry">
                                <datalist id="hosting-plan">
                                  <option value="small">$15 USD</option>
                                </datalist> -->
                                <?php
                                $all_hq_countries = $pdo->prepare('SELECT * FROM `prospect_hq_countries`');
                                $all_hq_countries->execute();
                                $all_hq_countries = $all_hq_countries->fetchAll();
                                ?>
                                <select class="form-control mselect" name="HQcountry[]" id="HQcountry" placeholder="Select country" multiple="">
                                    <?php
                                    foreach ($all_hq_countries as $key => $value) { ?>
                                        <option value="<?php echo $key ?>"><?php echo $value['hq_country'] ?></option>
                                    <?php  }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="HQcity">Company HQ Cities</label>
                                <!-- <input list="hosting-plan" type="text" class="form-control test" placeholder="Add city" name="email">
                                <datalist id="hosting-plan">
                                  <option value="small">$15 USD</option>
                                </datalist> -->
                                <?php
                                $all_hq_cities = $pdo->prepare('SELECT * FROM `prospect_hq_cities`');
                                $all_hq_cities->execute();
                                $all_hq_cities = $all_hq_cities->fetchAll();
                                ?>
                                <select class="form-control mselect" name="HQcity[]" id="HQcity" placeholder="Add city" multiple="">
                                    <?php
                                    foreach ($all_hq_cities as $key => $value) { ?>
                                        <option value="<?php echo $value['hq_city'] ?>"><?php echo $value['hq_city'] ?></option>
                                    <?php  }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group domain">
                                <label for="domain">Company Domain</label>
                                <!-- <input type="text" class="form-control test" placeholder="Name1" name="domain"> -->
                                <textarea class="form-control test" placeholder="salesforce.com &#10;ibm.com &#10;tesla.com &#10;..." name="domain" id="domain"  rows="3" cols="50"></textarea>

                            </div>

                            <div class="form-group company-name">
                                <label for="company-name">Company Name</label>
                                <!-- <input class="form-control test" placeholder="Name1" name="company-name"> -->
                                <textarea class="form-control test" placeholder="Apple &#10;Google &#10;Google Inc. &#10;..." name="company_name" id="company-name" rows="3" cols="50"></textarea>

                            </div>
                            <div class="form-group">
                                <div class="middle1">
                                    <label>Limit Amount</label>

                                    <input type="range" id="js-amount-range" value="10" min="10" max="<?php echo $member['search_credit']; ?>">
                                    <br>
                                    <div class="range-value"><span>Max Lead:</span> <input type="text" name="limit_amount" id="js-amount-input" value="10" min="10" max="<?php echo $member['search_credit']; ?>"></input></div>


                                </div>
                            </div>

                            <br>

                        </form>

                        <div class="center">
                            <center>     <button <?php $authentication = true; if($authentication==false){echo 'disabled';} ?> style="<?php if($authentication==false){echo 'background-color:#6bbbf0 !important';} ?>" id="myBtn1" class="btn-1">Find and save to List</button>
                                <p class="text-muted but_txt">Tip: With fewer search criteria, you'll get more leads </p>
                            </center>
                            <!-- The Modal -->
                        </div>

                        <div class="modal fade modal-enhanced" id="myModal1" tabindex="-1" role="dialog" aria-labelledby="myModal1" aria-hidden="true">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <div class="row" style="text-align: center;">
                                            <div class="col-md-12">
                                                <h3 style="font-size: 34px;margin-bottom: 22px;letter-spacing: -1.2px;">Do you want to start search?</h3>
                                                <p style="font-size: 20px;color: #828181;"><b>Filters are:</b> <span class="filter-notes"></span></p>
                                                <p style="font-size: 20px;color: #828181;">Max Leads: <b><span class="filter-notes-limit" style="color: #0d9bf8;"></span></b></p>
                                                <p style="font-size:20px;color: #828181;"><b>Note:</b> You'll be charged 1 credit for each email found in this search.</p>
                                            </div>
                                        </div>
                                        <div class="modal-footer" style="display: block;text-align: center;">
                                            <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;height: 44px;">Cancel</button>
                                            <button class="btn btn-success find_list_submit" style="width:200px;font-size: 21px;height: 44px;">Find List</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div id="myModal2" class="modal1">
                            <!-- Modal content -->
                            <div class="modal-content1">
                                <div class="modal-header">
                                    <h4 class="modal-title">Do you want to start search?</h4>
                                    <!-- <span class="close1">&times;</span> -->
                                </div>
                                <div class="modal-body" id="error_body">
                                </div>

                            </div>
                        </div>


                        <div class="col-md-4">
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-3 col-12">
                    </div>
                </div>

            </div>


        </div>
        <div class="clear"></div>
        <!-- End of Main Content -->

        <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Copyright &copy; <?php echo date('Y'); ?></span>
                </div>
            </div>
        </footer>
        <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>
<script
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCUX8e2-IyJqS0Jbs59L8zauqH4NP7OPow&libraries=places&v=weekly"
        defer
></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/typeahead.js/0.11.1/typeahead.bundle.min.js"></script>
<script src="<?php echo $root; ?>/js/tagsinput.js"></script>

<script>


    $(document).ready(function () {
        // $(document).find('.bootstrap-tagsinput').find('input').attr('id','location');
        $(document).find('.bootstrap-tagsinput').find('input').attr('id','search_location');
        $("#search_location").keypress(function(){
            var search_for = $(this).val();
            if(search_for != "")
            {
                locations = "";
                $.ajax({
                    type : 'POST',
                    url : root_dir+'/search_location',
                    data :  {search_for: search_for},
                    success: function(locations)
                    {
                        locations = jQuery.parseJSON(locations);
                        //    alert(locations);
                        //    alert(availableTags);
                        $( "#search_location" ).autocomplete({
                            source: locations,
                            select: function (event, ui) {

                            }
                        });
                        //    if(locations.length > 0){

                        //     // $(locations).each(function(index, value){

                        //     // });
                        //     }
                        //    alert(response[0].city);
                    }
                });
            }
        });

        $('.find_list_submit').click(function(e) {
            e.preventDefault();

            // const list_name = $("#list_name").val();
            // alert(list_name);
            // return false;
            $("#lead_finder").submit();
        });

        //$('.div_list_name').hide();

        /*$('.destination_list').on('change', function () {

            if($('.destination_list').val() == ''){
                $('.div_list_name').show();
            }else{
                $('.div_list_name').hide();
            }
        });*/

        $('.mselect').chosen();


        $("#domain").keyup(function(){
            var domain_val = $(this).val();
            //alert(domain_val);
            if(domain_val != null){
                $('.company-name').hide();
            }

            if(domain_val == ""){
                $('.company-name').show();
            }

        });

        $("#company-name").keyup(function(){
            var domain_val = $(this).val();
            //alert(domain_val);
            if(domain_val != null){
                $('.domain').hide();
            }

            if(domain_val == ""){
                $('.domain').show();
            }

        });

    });


    var $rangeslider = $('#js-amount-range');
    var $amount = $('#js-amount-input');

    $rangeslider
        .rangeslider({
            polyfill: false
        })
        .on('input', function() {
            $amount[0].value = this.value;
        });

    $amount.on('input', function() {
        $rangeslider.val(this.value).change();
    });
</script>