  <?php
    checkSuperAdmin();
    // ini_set('display_errors', 1);
    // ini_set('display_startup_errors', 1);
    // error_reporting(E_ALL);
  ?>

  <title><?php echo SITE_NAME; ?> - Plan Management</title>
  <style>
  .dataTables_length, .dataTables_wrapper .dataTables_filter{
    display: block !important;
  }
  </style>
</head>

<body id="page-top">

  <!-- Page Wrapper -->
  <div id="wrapper">

    <?php include_once("nav_wrapper_admin.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar Navbar -->
        <?php include_once("nav/right_nav.php"); ?>

        <!-- Begin Page Content -->
        <div class="container-fluid">

          <!-- Page Heading -->
          <div class="float-left">
            <h1 class="h3 mb-4 text-gray-800">Plan Management</h1>
          </div>
          <div class="float-right" style="margin-right: 10vw;">

          </div>
          <div class="clearfix"></div>
          

          <div class="row">

            <div class="col-sm-12">
              <?php
               if(isset($_POST['deletePlanid']))
              {
                $q = $pdo->prepare('DELETE FROM `plans` WHERE `id`=? LIMIT 1');
                $q->execute(array($_POST['deletePlanid']));
                 echo '
                <div class="alert alert-danger" role="alert">
                  Plan successfully deleted!
                </div>
                ';
              }

              

              if(isset($_POST['editPlan_id']))
              {    
                $q = $pdo->prepare('UPDATE `plans` SET `plan_name` =?, `price_per_month` =?, `total_list_cleaning_credits` =?, `total_sub_accounts` =?, `total_admin_sub_accounts` =?, `feature_breakdown` =?, `trial_period_day` =?, `discount_percent` =?, `plan_type` =? WHERE `id`=?');
                $q->execute(array(
                  $_POST['edit_plan_name'],
                  $_POST['edit_price_per_month'],
                  $_POST['edit_total_list_cleaning_credits'],
                  $_POST['edit_total_sub_accounts'],
                  $_POST['edit_total_admin_sub_accounts'],
                  $_POST['edit_feature_breakdown'],
                  $_POST['edit_trial_period_day'],
                  $_POST['edit_discount_percent'],
                  $_POST['edit_plan_type'],
                  $_POST['editPlan_id']
                  ));
                echo '
                <div class="alert alert-success" role="alert">
                  User '.$_POST['firstname'].' '. $_POST['lastname'] .' account has been successfully updated!
                </div>
                ';
              }



              if(isset($_POST['plan_name']))
              {           
             
        				$q = $pdo->prepare('INSERT INTO `plans` VALUES (?,?,?,?,?,?,?,?,?,?)');
                $q->execute(array(
                  NULL,
                  $_POST['plan_name'],
                  $_POST['price_per_month'],
                  $_POST['total_list_cleaning_credits'],
                  $_POST['total_sub_accounts'],
                  $_POST['total_admin_sub_accounts'],
                  $_POST['feature_breakdown'],
                  $_POST['trial_period_day'],
                  $_POST['discount_percent'],
                  $_POST['plan_type']
                ));
                echo '
                <div class="alert alert-success" role="alert">
                  Plan: '.$_POST['plan_name'].' account successfully added!
                </div>
                ';
              }

              ?>

              <div class="card shadow mb-4">
                <div class="card-header bg-dark py-3">
                  <div class="float-left">
                    <h6 class="m-0 font-weight-bold text-white">Plan Management</h6>
                  </div>
                  <div class="float-right">
                     
                  </div>
                  <div class="clearfix"></div>
                </div>
                <div class="card-body">
                  Add Plan (This will manage the plan on member account).<br/>
                  <button class="btn btn-primary" style="margin-top: 15px;" data-toggle="modal" data-target="#addPlan">Add Plan</button>                  
                  <br/><br/>
                  <table class="table table-striped table-hover table-bordered" id="plan-datatable">
                    <thead class="bg-default text-dark">
                      <tr>
                        <th scope="col">PLAN NAME</th>
                        <th scope="col">PRICE</th>
                        <th scope="col">CLEANING CREDITS</th>
                        <th scope="col">TRIAL PERIOD</th>
                        <th scope="col">PLAN TYPE</th>
                        <th scope="col">DISCOUNT</th>
                        <th scope="col">ACTION</th>
                      </tr>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>
              </div>

              <!-- Modal Edit Plan -->
              <div class="modal fade modal-enhanced modal-info" id="modalEditPlan" tabindex="-1" role="dialog" aria-labelledby="modalEditPlanConfirmationlabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                  <form action="#" method="post">
                    <input type="hidden" name="editPlan_id" id="editPlan_id" value=""> 
                    <div class="modal-content">                      
                      <div class="modal-header">
                        <h5 class="modal-title"><i class="far fa-pencil"></i> Edit</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      <div class="modal-body edit-plan-container"></div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger" name="action" value="delete">Update</button>
                      </div>
                    </div>
                  </form>
                </div>
              </div>

              <!-- Modal Delete Confirmation -->
              <div class="modal fade modal-enhanced modal-danger" id="modalPlanDeleteConfirmation" tabindex="-1" role="dialog" aria-labelledby="modalPlanDeleteConfirmationlabel" aria-hidden="true">
                <div class="modal-dialog modal-md" role="document">
                  <form action="#" method="post">
                    <input type="hidden" name="deletePlanid" id="deletePlanid" class="form-control" value="">
                    <div class="modal-content">                      
                      <div class="modal-header">
                        <h5 class="modal-title"><i class="far fa-trash-alt"></i> Delete</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      <div class="modal-body delete-plan-body"></div>                        
                      <div class="modal-footer">
                          <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                          <button type="submit" class="btn btn-danger" name="action" value="delete">Yes</button>
                        </div>                        
                      </div>
                    </div>
                  </form>
                </div>
              </div>

              <!-- Modal Add Plan -->
              <div class="modal fade" id="addPlan" tabindex="-1" role="dialog" aria-labelledby="addPlanLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="addIMAPLabel">Add plan<br/>
                        <small><p>Add the backend staff that will manage the members.</p></small></h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
                    <div class="modal-body">
                      <form action="" method="post">
                        <input type="hidden" name="user" value="1" />
                        <div class="row">
                          <div class="col-md-12">
                            <br />
                            <span style="font-size:20px;font-weight: 800;margin-top: 10px;" data-toggle="tooltip" title="Plan details" >Plan Details</span>
                          </div>
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">Plan Name: *</label>
                            <input type="text" name="plan_name" class="form-control" value="">
                          </div>
                          
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">Amount: *</label>
                            <input type="text" name="price_per_month" class="form-control" value="">
                          </div>
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">Trial Period Day: *</label>
                            <input type="text" name="trial_period_day" class="form-control" value="">
                          </div>
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">Cleaning Credits: *</label>
                            <input type="text" name="total_list_cleaning_credits" class="form-control" value="">
                          </div>

                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">Discount: *</label>
                            <input type="text" name="discount_percent" class="form-control" value="">
                          </div>
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">Number of User sub-accounts: *</label>
                            <input type="text" name="total_sub_accounts" class="form-control" value="">
                          </div>
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">Number of admin sub-accounts: *</label>
                            <input type="text" name="total_admin_sub_accounts" class="form-control" value="">
                          </div>
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">Plan Type: </label>
                            <select name="plan_type" id="plan_type" class="form-control">
                              <option value="1" >Annual</option>
                              <option value="2" >Monthly</option>
                            </select> 
                          </div>

                          <div class="col-md-12">
                            <label style="display: block; margin-top: 10px;">Feature Breakdown: *</label>
                             <textarea class="form-control" rows="7" name="feature_breakdown"></textarea>
                          </div>
                          <div class="col-sm-12">
                            <br/>
                            <button type="submit" class="btn btn-primary">Save</button>
                          </div>
                        </div>
                      </form>
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>

          </div>

        </div>
        <!-- /.container-fluid -->

      </div>
      <!-- End of Main Content -->

      <script>
      $(function(){
        
      });
      </script>

      <!-- Footer -->
      <footer class="sticky-footer bg-white">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; <?php echo date('Y'); ?></span>
          </div>
        </div>
      </footer>
      <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>