<?php
class LeadsHelper
{
	const STATUS_ENGAGING = 0;
	const STATUS_WON      = 1;
	const STATUS_LOST     = 2;
	const STATUS_BOUNCE_SOFT = 3;
	const STATUS_BOUNCE_HARD = 4;
	const STATUS_NOT_INTERESTED = 5;
	const STATUS_ENGAGED = 6;
    const STATUS_DELETE = 7;
    const STATUS_UNSUBSCRIBE = 8;

	const STOP_AUTOMATION = 0;
	const CONTINUE_AUTOMATION = 1;

	//Set status base on content (if autoreply)
	public function cronSetLeadStatus( $content ){		
	    $bounceDelete = bounceDeleteChecker($content);
	    if( $bounceDelete['is_with_delete'] == 1 ){
	    	$bounceSoft = bounceSoftChecker($content);
	    	if( $bounceSoft['status'] == 0 ){
	    		$bounceHard = bounceHardChecker($content);
	    		if( $bounceHard['status'] == 0 ){
	    			$status = 0;
	    		}else{
	    			$status = $bounceHard['status'];
	    		}
	    	}else{
	    		$status = $bounceSoft['status'];
	    	}

            if($status == 0){
                $status = self::STATUS_BOUNCE_SOFT;
            }
	    }else{
	    	$status = 0;
	    }

	    return $status;
	}

	public static function optionLeadStatus(){
		$options = array(
			self::STATUS_ENGAGING => 'Engaging',
			self::STATUS_WON => 'Won',
			self::STATUS_LOST => 'Lost',
			self::STATUS_NOT_INTERESTED => 'Not Interested',
			//self::STATUS_ENGAGED => 'Engaged',
			self::STATUS_BOUNCE_SOFT => 'Auto-reply',
            self::STATUS_DELETE => 'Delete',
            self::STATUS_UNSUBSCRIBE => 'Unsubscribe'
		);

		return $options;
	}

	public static function isBounceSoft(){
		return self::STATUS_BOUNCE_SOFT;
	}

	public static function optionAutomation(){
		$options = array(
			self::CONTINUE_AUTOMATION => 'Select Resume Date',
			self::STOP_AUTOMATION => 'Paused'
		);

		return $options;
	}

	public static function continueAutomation(){
		return self::CONTINUE_AUTOMATION;
	}

	public static function stopAutomation(){
		return self::STOP_AUTOMATION;
	}
}