<title><?php echo SITE_NAME; ?> - Email accounts</title>
</head>
<body id="page-top">

<style>
    body #wrapper #content-wrapper #content>.container-fluid.email-accounts .select-mail-account a.btn{
        width: 245px;
    }
    .img-duplicate, .img-delete{
        margin: 0 auto;
        display: block;
        height: 127px;
    }
    .hdr-duplicate, .hdr-delete{
        width: 100%;
        text-align: center;
        font-size: 25px;
        margin: 29px 0px;
    }
    div.ui-tooltip {
        max-width: 450px;
    }
    .icon-green {
        color: green;
    }
    a.btn-gmail-gsuite-disabled:hover{opacity: 0.3 !important;}
    a.btn-gmail-gsuite-disabled:not( :hover ){opacity: 0.3 !important;}
</style>
<script>
    $(document).ready(function(){
        $('[data-toggle="tooltip"]').tooltip({position: { my: "center bottom", at: "center top" }});
    });
</script>
<!-- Page Wrapper -->
<div id="wrapper">
    <?php include_once("nav_wrapper.php"); ?>
    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>

            <!-- Begin Page Content -->
            <div class="container-fluid email-accounts dashboard">

                <!-- Page Heading -->
                <h1 class="panel-title">Connect an Email account </h1>
                <p class="panel-subtitle">Connect your email account to Automailer. You have two ways to achieve that. <br/>From this page you can add a maximum of <span class="blue"><?php echo $member['plan_quantity']; ?> email account(s)</span>.</p>

                <div class="select-mail-account">

                    <?php

                    if( $success_msg != '' ){
                        echo '
                <div class="alert alert-success" role="alert">
                  '.$success_msg.'
                </div>
                ';
                        $success_msg = '';
                        header('Location: '.$root.'/email-accounts');
                        exit();
                    }

                    if( $error_msg != '' ){
                        echo '
                <div class="alert alert-danger" role="alert">
                  '.$error_msg.'
                </div>
                ';
                        $error_msg = '';

                        header('Location: '.$root.'/email-accounts');
                        exit();
                    }

                    if( isset($_POST['edit_smtp_speed_id']) ){

                        if (checkPermissionByTable("smtp",$member['id'],$_POST['edit_smtp_speed_id']) == false)
                            die("No permission");

                        $q = $pdo->prepare('UPDATE `smtp` SET `sending_limit_per_day`=?, `allowed_time_send_from`=?, `allowed_time_send_to`=?, `time_between_email_send`=?, `max_email_per_time`=? WHERE `id`=? LIMIT 1');
                        $smtp_speed_data = array(
                            $_POST['edit_sending_limit_per_day'],
                            strtotime($_POST['edit_time_send_email_from']),
                            strtotime($_POST['edit_time_send_email_to']),
                            $_POST['edit_time_between_email_send'],
                            $_POST['edit_max_emails_per_time'],
                            $_POST['edit_smtp_speed_id']
                        );
                        $sql =  $q->execute($smtp_speed_data);

                        echo '
                <div class="alert alert-success" role="alert">
                  SMTP account details successfully updated updated!
                </div>
                ';

                        header('Location: '.$root.'/email-accounts');
                        exit();
                    }

                    if( isset($_POST['action']) && $_POST['action'] == 'gmail_edit' ){
                        if (checkPermissionByTable("nylas_smtp",$member['id'],$_POST['edit_id']) == false)
                            die("No permission");

                        $q = $pdo->prepare('UPDATE `nylas_smtp` SET `name`=?, `digital_sign`=?, `updated`=?, active = 1 WHERE `id`=? LIMIT 1');
                        $gmail_data = array(
                            $_POST['edit_gmail_name'],
                            $_POST['sign'],
                            date('Y-m-d H:i:s'),
                            $_POST['edit_id']
                        );
                        $sql =  $q->execute($gmail_data);
                        //$databaseErrors = $q->errorInfo();
                        //echo '<pre>';print_r($databaseErrors);exit;

                        echo '
                <div class="alert alert-success" role="alert">
                  SMTP account details successfully updated!
                </div>
                ';

                        header('Location: '.$root.'/email-accounts');
                        exit();

                        ?>

                        <?php
                    }

                    if( isset($_POST['edit_id']) && $_POST['edit_from_name'] != '' ){

                        if (checkPermissionByTable("nylas_smtp",$member['id'],$_POST['edit_id']) == false)
                            die("No permission");

                        if(isset($_POST['edit_usessltls'])){
                            $usessltls = 1;
                        }else{
                            $usessltls = 0;
                        }

                        if(isset($_POST['edit_imap_usessltls'])){
                            $imap_usessltls = 1;
                        }else{
                            $imap_usessltls = 0;
                        }



                        $passwordD = crypt_jm($_POST['edit_password']);
                        $passwordIMAP = crypt_jm($_POST['edit_imap_password']);
                        $nylas_account_id = crypt_jm($_POST['nylas_account_id'],'d');
                        $nylas_access_token = crypt_jm($_POST['nylas_access_token'],'d');

                        $q = $pdo->prepare('UPDATE `nylas_smtp` SET `name`=?, `email`=?, `username`=?, `password`=?, `server`=?, `port`=?, `imap_username`=?, `imap_password`=?, `imap_usessltls`=?, `imap_server`=?, `imap_port`=?,  `digital_sign`=?, `usessltls`=?, `nylas_account_id`=?, `nylas_access_token`=?, `updated`=?, active = 1 WHERE `id`=? LIMIT 1');
                        $smtp_data = array(
                            $_POST['edit_from_name'],
                            $_POST['edit_from_email'],
                            $_POST['edit_user'],
                            $passwordD,
                            $_POST['edit_server'],
                            $_POST['edit_port'],

                            $_POST['edit_imap_user'],
                            $passwordIMAP,
                            $imap_usessltls,

                            $_POST['edit_imap_server'],
                            $_POST['edit_imap_port'],
                            $_POST['sign'],
                            $usessltls,
                            $nylas_account_id,
                            $nylas_access_token,
                            date('Y-m-d H:i:s'),
                            $_POST['edit_id']

                        );
                        $sql =  $q->execute($smtp_data);
                        //$databaseErrors = $q->errorInfo();
                        //echo '<pre>';print_r($databaseErrors);exit;

                        echo '
                <div class="alert alert-success" role="alert">
                  SMTP account details successfully updated!
                </div>
                ';

                        header('Location: '.$root.'/email-accounts');
                        exit();

                        ?>

                        <?php
                    }elseif(isset($_POST['edit_id'])){
                        if (checkPermissionByTable("nylas_smtp",$member['id'],$_POST['edit_id']) == false)
                            die("No permission");


                        $passwordD = crypt_jm($_POST['password']);
                        $q = $pdo->prepare('UPDATE `nylas_smtp` SET `smtp_type`=?, `name`=?, `email`=?, `password`=?, `digital_sign`=?, `updated`=?, active = 1 WHERE `id`=? LIMIT 1');
                        $smtp_data = array(
                            $_POST['smtp_type'],
                            $_POST['nylas_known_from_name'],
                            $_POST['from_email'],
                            $passwordD,
                            $_POST['sign'],
                            date('Y-m-d H:i:s'),
                            $_POST['edit_id']

                        );
                        $sql =  $q->execute($smtp_data);
                        //$databaseErrors = $q->errorInfo();
                        //echo '<pre>';print_r($databaseErrors);exit;

                        echo '
                <div class="alert alert-success" role="alert">
                  SMTP account details successfully updated!
                </div>
                ';
              
                        header('Location: '.$root.'/email-accounts');
                        exit();
                        ?>

                        <?php
                    }
                    if( isset($_POST['action']) ){
                        if( $_POST['action'] == 'reactivate' ){
                            $q = $pdo->prepare('UPDATE `nylas_smtp` SET `active`=?, `inactive_reason`=? WHERE `id`=? AND `member_id`=? LIMIT 1');
                            $imap_data = array(
                                1,
                                '',
                                $_POST['imap_id'],
                                $member['id']
                            );
                            $sql =  $q->execute($imap_data);

                            echo '
                  <div class="alert alert-success" role="alert">
                    Account was successfully updated!
                  </div>
                  ';

                            header('Location: '.$root.'/email-accounts');
                            exit();
                        }

                    }

                    if(isset($_POST['smtp_from_name']) && $_POST['edit_id'] == '')
                    {
                        /*print "<pre>";
                        print_r($_POST);
                        echo $member['id'].'---';
                        echo crypt_jm($_POST['password']);
                        print "</pre>";
                        exit;*/
                        date_default_timezone_set($member['timezone']);
                        //Default Settings
                        $limit_per_day = 25;
                        $allowed_time_from = strtotime("7:00 AM");
                        $allowed_time_to   = strtotime("5:00 PM");
                        $time_between_email_sent = 20;
                        $max_email_per_time      = 1;

                        if(isset($_POST['usessltls'])){
                            $usessltls = 1;
                        }else{
                            $usessltls = 0;
                        }

                        if(isset($_POST['imap_usessltls'])){
                            $imap_usessltls = 1;
                        }else{
                            $imap_usessltls = 0;
                        }

                        $passwordD = crypt_jm($_POST['password']);
                        $passwordDimap = crypt_jm($_POST['imap_password']);
                        $nylas_account_id = crypt_jm($_POST['nylas_account_id'],'d');
                        $nylas_access_token = crypt_jm($_POST['nylas_access_token'],'d');

                        $q = $pdo->prepare('INSERT INTO `nylas_smtp` (smtp_type,name,
                                                        email,
                                                        username,
                                                        password,
                                                        server,
                                                        port,
                                                        imap_username,
                                                        imap_password,
                                                        imap_server,
                                                        imap_port,
                                                        imap_usessltls,
                                                        created,
                                                        send_limit,
                                                        member_id,
                                                        digital_sign,
                                                        sending_limit_per_day,
                                                        allowed_time_send_from,
                                                        allowed_time_send_to,
                                                        time_between_email_send,
                                                        max_email_per_time,
                                                        nylas_account_id,nylas_access_token,usessltls,active) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
                        $q->execute(
                            array(
                                'smtp',
                                $_POST['smtp_from_name'],
                                $_POST['from_email'],
                                $_POST['user'],
                                $passwordD,
                                $_POST['server'],
                                $_POST['port'],
                                $_POST['imap_username'],
                                $passwordDimap,
                                $_POST['imap_server'],
                                $_POST['imap_port'],
                                $imap_usessltls,
                                date('Y-m-d H:i:s'),
                                200,
                                $member['id'],
                                NULL,
                                $limit_per_day,
                                $allowed_time_from,
                                $allowed_time_to,
                                $time_between_email_sent,
                                $max_email_per_time,
                                $nylas_account_id,
                                $nylas_access_token,
                                $usessltls,
                                1
                            )
                        );
                       // echo "test 1 " ;
                       //  $databaseErrors = $q->errorInfo();
                       //  echo '<pre>';print_r($databaseErrors);exit;

                        //$smtpID =  $pdo->lastInsertId();

                        echo '
                <div class="alert alert-success" role="alert">
                  SMTP account successfully added!
                </div>
                ';

                        header('Location: '.$root.'/email-accounts');
                        exit();
                    }


                    if(isset($_POST['gmail_email']) && isset($_POST['google_fname']))
                    {
                        /*print "<pre>";
                        print_r($_POST);
                        echo $member['id'].'---';
                        echo crypt_jm($_POST['password']);
                        print "</pre>";
                        exit;*/
                        date_default_timezone_set($member['timezone']);
                        //Default Settings
                        $limit_per_day = 25;
                        $allowed_time_from = strtotime("7:00 AM");
                        $allowed_time_to   = strtotime("5:00 PM");
                        $time_between_email_sent = 20;
                        $max_email_per_time      = 1;
                        $usessltls = 1;
                        $imap_usessltls = 1;


                        $smtp_from_name = $_POST['google_fname'] . ' ' . $_POST['google_lname'];
                        $from_email = $_POST['gmail_email'];
                        $user = $_POST['gmail_email'];
                        $server = "smtp.gmail.com";
                        $port = 465;
                        $imap_username = $_POST['gmail_email'];
                        $imap_password =  crypt_jm($_POST['app_password']);
                        $imap_server = "imap.gmail.com";
                        $imap_port = 993;

                        $passwordD = crypt_jm($_POST['app_password']);
                        $nylas_account_id = crypt_jm($_POST['nylas_account_id'],'d');
                        $nylas_access_token = crypt_jm($_POST['nylas_access_token'],'d');

                        $q = $pdo->prepare('INSERT INTO `nylas_smtp` (smtp_type,name,
                                                        email,
                                                        username,
                                                        password,
                                                        server,
                                                        port,
                                                        imap_username,
                                                        imap_password,
                                                        imap_server,
                                                        imap_port,
                                                        imap_usessltls,
                                                        created,
                                                        send_limit,
                                                        member_id,
                                                        digital_sign,
                                                        sending_limit_per_day,
                                                        allowed_time_send_from,
                                                        allowed_time_send_to,
                                                        time_between_email_send,
                                                        max_email_per_time,
                                                        nylas_account_id,nylas_access_token,usessltls,active) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
                        $q->execute(
                            array(
                                'gmail',
                                $smtp_from_name,
                                $from_email,
                                $user,
                                $passwordD,
                                $server,
                                $port,
                                $imap_username,
                                $imap_password,
                                $imap_server,
                                $imap_port,
                                $imap_usessltls,
                                date('Y-m-d H:i:s'),
                                200,
                                $member['id'],
                                NULL,
                                $limit_per_day,
                                $allowed_time_from,
                                $allowed_time_to,
                                $time_between_email_sent,
                                $max_email_per_time,
                                $nylas_account_id,
                                $nylas_access_token,
                                $usessltls,
                                1
                            )
                        );
                        // $databaseErrors = $q->errorInfo();
                        // echo '<pre>';print_r($databaseErrors);exit;

                        //$smtpID =  $pdo->lastInsertId();

                        echo '
                <div class="alert alert-success" role="alert">
                  SMTP account successfully added!
                </div>
                ';

                        header('Location: '.$root.'/email-accounts');
                        exit();
                    }

                    if(isset($_POST['nylas_known_from_name']) && $_POST['edit_id'] == '')
                    {
                        /*print "<pre>";
                        print_r($_POST);
                        echo $member['id'].'---';
                        echo crypt_jm($_POST['password']);
                        print "</pre>";
                        exit;*/

                        //Default Settings
                        $limit_per_day = 25;
                        $allowed_time_from = strtotime("7:00 AM");
                        $allowed_time_to   = strtotime("5:00 PM");
                        $time_between_email_sent = 20;
                        $max_email_per_time      = 1;

                        $passwordD = crypt_jm($_POST['password']);
                        $nylas_account_id = crypt_jm($_POST['nylas_account_id'],'d');
                        $nylas_access_token = crypt_jm($_POST['nylas_access_token'],'d');

                        $q = $pdo->prepare('INSERT INTO `nylas_smtp` (smtp_type,name,
                                                        email,
                                                        password,
                                                        created,
                                                        send_limit,
                                                        member_id,
                                                        digital_sign,
                                                        sending_limit_per_day,
                                                        allowed_time_send_from,
                                                        allowed_time_send_to,
                                                        time_between_email_send,
                                                        max_email_per_time,
                                                        nylas_account_id,nylas_access_token,usessltls,active) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
                        $q->execute(
                            array(
                                $_POST['smtp_type'],
                                $_POST['nylas_known_from_name'],
                                $_POST['from_email'],
                                $passwordD,
                                date('Y-m-d H:i:s'),
                                200,
                                $member['id'],
                                NULL,
                                $limit_per_day,
                                $allowed_time_from,
                                $allowed_time_to,
                                $time_between_email_sent,
                                $max_email_per_time,
                                $nylas_account_id,
                                $nylas_access_token,
                                1,
                                1
                            )
                        );
                        // echo "Test 2";
                        // $databaseErrors = $q->errorInfo();
                        // echo '<pre>';print_r($databaseErrors);exit;

                        //$smtpID =  $pdo->lastInsertId();

                        echo '
                <div class="alert alert-success" role="alert">
                  SMTP account successfully added!
                </div>
                ';

                        header('Location: '.$root.'/email-accounts');
                        exit();
                    }

                    if(isset($_POST['eid']))
                    {

                        if($_POST['account_id']){

                            $curl_remove_access = curl_init();
                            $encode_auth = base64_encode(NYLAS_CLIENT_SECRET.':');

                            curl_setopt_array($curl_remove_access, array(
                                CURLOPT_URL => "https://api.nylas.com/a/".NYLAS_CLIENT_ID."/accounts/".$_POST['account_id']."/revoke-all",
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_FOLLOWLOCATION => true,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_CUSTOMREQUEST => "POST",
                                CURLOPT_HTTPHEADER => array(
                                    "Content-Type: application/json",
                                    "Authorization: Basic ".$encode_auth
                                ),
                            ));

                            $response_remove = curl_exec($curl_remove_access);

                            curl_close($curl_remove_access);

                            $res_remove = json_decode($response_remove);

                            //if($res_remove->success == 'true'){

                            $curl = curl_init();

                            curl_setopt_array($curl, array(
                                CURLOPT_URL => "https://api.nylas.com/a/".NYLAS_CLIENT_ID."/accounts/".$_POST['account_id']."/downgrade",
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => "",
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_FOLLOWLOCATION => true,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_CUSTOMREQUEST => "POST",
                                CURLOPT_HTTPHEADER => array(
                                    "Content-Type: application/json",
                                    "Authorization: Basic ".$encode_auth
                                ),
                            ));

                            $response = curl_exec($curl);

                            curl_close($curl);

                            $res = json_decode($response);

                            if($res->success == 'true'){

                                $q = $pdo->prepare('DELETE FROM `nylas_smtp` WHERE `id`=? AND `member_id`=? LIMIT 1');
                                $q->execute(array($_POST['eid'], $_SESSION['id']));

                                echo '
                                <div class="alert alert-success" role="alert">
                                  SMTP account successfully deleted!
                                </div>
                                ';
                            }else{
                                echo '
                                <div class="alert alert-danger" role="alert">
                                  Something wrong!
                                </div>
                                ';
                            }

                            header('Location: '.$root.'/email-accounts');
                            exit();
                            /*}else{
                                echo '
                              <div class="alert alert-danger" role="alert">
                                Something wrong!
                              </div>
                              ';
                            }*/


                        }else{
                            $q = $pdo->prepare('DELETE FROM `nylas_smtp` WHERE `id`=? AND `member_id`=? LIMIT 1');
                            $q->execute(array($_POST['eid'], $_SESSION['id']));

                            echo '
                                <div class="alert alert-success" role="alert">
                                  SMTP account successfully deleted!
                                </div>
                                ';

                            header('Location: '.$root.'/email-accounts');
                            exit();
                        }


                    }


                    if(isset($_POST['update_limit']))
                    {
                        //if($_POST['type'] == 'SMTP')
                        //{
                        if (checkPermissionByTable("nylas_smtp",$member['id'],$_POST['update_limit']) == false)
                            die("No permission");

                        //$q = $pdo->prepare('UPDATE `smtp` SET `send_limit`=? WHERE `id`=? LIMIT 1');
                        $q = $pdo->prepare('UPDATE `nylas_smtp` SET `sending_limit_per_day`=? WHERE `id`=? LIMIT 1');
                        $q->execute(array($_POST['limit'], $_POST['update_limit']));
                        //}

                    }

                    if(isset($_POST['update_warmup']))
                    {
                        if($_POST['type'] == 'smtp')
                        {
                            if (checkPermissionByTable("nylas_smtp",$member['id'],$_POST['update_warmup']) == false)
                                die("No permission");

                            $q = $pdo->prepare('UPDATE `nylas_smtp` SET `warmup`=? , `warmup_date`=? ,`warmup_sent`=?  WHERE `id`=? LIMIT 1');
                            $q->execute(array($_POST['update_warmup_stat'],date('Y-m-d H:i:s'),0, $_POST['update_warmup']));

                            $email_info = $pdo->prepare('SELECT * FROM `nylas_smtp` WHERE `id`=?');
                            $email_info->execute(array($_POST['update_warmup']));
                            $email = $email_info->fetch(PDO::FETCH_ASSOC);

                            if($_POST['update_warmup_stat']==1){
                                echo '
                                    <div class="alert alert-success" role="alert">
                                      Email account set to Warmup!
                                    </div>
                                    ';
                            }else{
                                echo '
                                    <div class="alert alert-danger" role="alert">
                                       Email account removed to Warmup!
                                    </div>';
                            }
                        }
                    }

                    $nylas_accounts = $pdo->prepare('SELECT * FROM `nylas_smtp` WHERE `member_id`=?');
                    $nylas_accounts->execute(array($member['id']));
                    $amount = $nylas_accounts->rowcount();

                    ?>

                    <?php

                    $limit = false;

                    switch ($member['plan']) {
                        case '1':
                            $max = 1;
                            if($amount == $max)
                            {
                                $limit = true;
                            }

                            break;
                        case '2':
                            $max = 3;
                            if($amount == $max)
                            {
                                $limit = true;
                            }
                            break;
                        case '3':
                            $max = 6;
                            if($amount == $max)
                            {
                                $limit = true;
                            }
                            break;
                    }

                    $member_accounts = $pdo->prepare('SELECT * FROM `members` WHERE `id`=?');
                    $member_accounts->execute(array($member['id']));
                    foreach ($member_accounts as $member_account) {
                        $total_allowed_emails = $member_account['plan_quantity'];
                    }

                    $total_email_set = $amount;

                    if($total_email_set < $total_allowed_emails){
                        $limit = false;
                        $max = $total_allowed_emails;
                    }else{
                        $limit = true;
                    }


                    if($limit === false)
                    {
                        ?>
                        <?php if( $member['account_type'] != 1 ){ ?>
                        <!--  <a href="javascript:void(0);" onclick="javascript:checkAuth()" id="gp_login" class="gp_login btn btn-outline-secondary">
                            <small class="plan">Connect Gmail</small>
                            <i class="fab fa-google"></i>
                            <big>Gmail / G Suite</big>
                            <span class="gmail-type">Connect Gmail</span>
                          </a> -->
                    <?php } ?>
                        <?php
                    }
                    else
                    {
                        ?>
                            <!--  <?php if( $member['account_type'] != 1 ){ ?>
                <a href="javascript:void(0);" class="btn gp_login btn-outline-secondary">
                  <small class="plan">Connect Gmail</small>
                  <i class="fab fa-google"></i>
                  <big>Gmail / G Suite</big>
                  <span class="type">Limit reached</span>
                </a> -->
                    <?php } ?>
                        <?php
                    }

                    ?>

                    <?php
                    if($member['plan']>0)
                    {
                    ?>
                    <?php if( $member['account_type'] != 1 ){ ?>
                    <?php if($limit == false){ ?>
                        <!--                    <a href="javascript:void(0);" class="btn smtp_link-add-smtp-startup btn btn-outline-secondary"  data-toggle="modal" data-target="#add">-->
                        <!--                      <small class="plan">Connect SMTP</small>-->
                        <!--                      <i class="fas fa-envelope"></i>-->
                        <!--                      <big>SMTP</big>-->
                        <!--                      <span class="type">Connect email addresses</span>-->
                        <!--                    </a>-->

                        <a href="javascript:void(0);" class="btn smtp_link-add-smtp-startup btn btn-outline-secondary"  data-toggle="modal" data-target="#add-smtp">
                            <small class="plan">Connect SMTP</small>
                            <i class="fas fa-envelope"></i>
                            <big>SMTP</big>
                            <span class="type">Connect your SMTP email with your server settings</span>
                        </a>

                        <a href="javascript:void(0);" class="btn smtp_link-add-known-smtp-startup btn btn-outline-secondary"  data-toggle="modal" data-target="#add-known-smtp">
                            <small class="plan">Connect Email Accounts</small>
                            <img src="img/yahoo+outlook.png">
                            <big>Yahoo + Outlook</big>
                            <span class="type">Connect your yahoomail, outlook.com emails and more...</span>
                        </a>

                        <?php if( ENABLE_GSUITE_SMTP ){?>

                            <a href="javascript:void(0);" onclick="javascript:checkAuth()" id="gp_login" class="gp_login btn btn-outline-secondary">
                                <small class="plan">Connect Gmail</small>
                                <i class="fab fa-google"></i>
                                <big>Gmail / G Suite</big>
                                <span class="gmail-type">Connect your Gmail or Gsuite account</span>
                            </a>

                        <?php }else{ ?>

                            <a href="javascript:void(0);" onclick="gmail_step1();" class="btn gp_login btn-outline-secondary btn-gmail-gsuite-disabled1" data-toggle="modal" data-target="#add-gmail-smtp" title="Gmail/Gsuite is temporarily unavailable. Please use the alternate email connection options like SMTP or Yahoo/Outlook" data-placement="top">

                                <!-- <a href="javascript:void(0);" class="btn gp_login btn-outline-secondary btn-gmail-gsuite-disabled" data-toggle="tooltip" title="Gmail/Gsuite is temporarily unavailable. Please use the alternate email connection options like SMTP or Yahoo/Outlook" data-placement="top"> -->

                                <small class="plan">Connect Gmail</small>
                                <i class="fab fa-google"></i>
                                <big>Gmail / G Suite</big>
                                <span class="gmail-type">Connect your Gmail or Gsuite account</span>
                            </a>

                        <?php } ?>

                        <a href="<?php echo $root."/msexchange"; ?>"  id="gp_login" class="gp_login btn btn-outline-secondary">
                            <small class="plan">Connect Microsoft</small>
                            <i class="fab fa-microsoft"></i>
                            <big>Microsoft</big>
                            <span class="gmail-type">Outlook / Exchange /</span><br>
                            <span class="gmail-type">Office365 accounts</span>
                        </a>
                        <!--  <a href="javascript:void(0);" class="btn smtp_link-add-smtp-startup btn btn-outline-secondary"  data-toggle="modal" data-target="#add-outlook">
                          <small class="plan">Connect Outlook</small>
                          <img src="<?php echo $root; ?>/img/outlook-dark.svg" alt="Outlook" />
                          <big>Outlook</big>
                          <span class="type">Connect email addresses</span>
                        </a> -->

                    <?php }else{ ?>
                    <!--                    <a href="javascript:void(0);" class="btn smtp_link btn-outline-secondary" disabled>-->
                    <!--                      <small class="plan">Connect SMTP</small>-->
                    <!--                      <i class="fas fa-envelope"></i>-->
                    <!--                      <big>SMTP</big>-->
                    <!--                      <span class="type">Limit reached</span>-->
                    <!--                    </a>-->
                    <a href="javascript:void(0);" class="btn smtp_link-add-smtp-startup btn btn-outline-secondary"  disabled>
                        <small class="plan">Connect SMTP</small>
                        <i class="fas fa-envelope"></i>
                        <big>SMTP</big>
                        <span class="type">Limit reached</span>
                    </a>

                    <a href="javascript:void(0);" class="btn smtp_link-add-known-smtp-startup btn btn-outline-secondary"  disabled>
                        <small class="plan">Connect Email Accounts</small>
                        <img src="img/yahoo+outlook.png">
                        <big>Yahoo + Outlook</big>
                        <span class="type">Limit reached.</span>
                    </a>

                    <?php if( ENABLE_GSUITE_SMTP ){?>
                    <a href="javascript:void(0);" class="btn gp_login btn-outline-secondary">
                        <?php }else{ ?>
                        <a href="javascript:void(0);" class="btn gp_login btn-outline-secondary btn-gmail-gsuite-disabled" data-toggle="tooltip" title="Gmail/Gsuite is temporarily unavailable. Please use the alternate email connection options like SMTP or Yahoo/Outlook" data-placement="top">
                            <?php } ?>

                            <small class="plan">Connect Gmail</small>
                            <i class="fab fa-google"></i>
                            <big>Gmail / G Suite</big>
                            <span class="type">Limit reached</span>
                        </a>

                        <a href="javascript:void(0);" class="btn gp_login btn-outline-secondary">
                            <small class="plan">Connect Microsoft</small>
                            <i class="fab fa-microsoft"></i>
                            <big>Microsoft</big>
                            <span class="type">Limit reached</span>
                        </a>

                        <!-- <a href="javascript:void(0);" class="btn outlook_link btn-outline-secondary" disabled>
                      <small class="plan">Connect Outlook</small>
                      <img src="<?php echo $root; ?>/img/outlook-dark.svg" alt="Outlook" />
                      <big>Outlook</big>
                      <span class="type">Limit reached</span>
                    </a> -->

                        <?php } ?>

                        <?php } ?>
                        <?php
                        }
                        else
                        {
                            ?>
                            <p>SMTP and IMAP integration not available on this plan.</p>
                            <a class="btn btn-primary" style="margin-top: 15px;" href="<?php echo $root; ?>/settings/upgrade" data-toggle="tooltip" data-placement="right" title="To enable SMTP email, please upgrade your plan. This will allow you to send email from any email address you own.">Upgrade</a>

                            <?php
                        }
                        ?>

                        <!-- <a href="javascript:void(0);" class="btn-add-smtp-startup btn btn-outline-secondary">
                            <small class="plan">Connect Outlook</small>
                            <svg height="56.6934px" id="Layer_1" style="enable-background:new 0 0 56.6934 56.6934;" version="1.1" viewBox="0 0 56.6934 56.6934" width="56.6934px" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><g><path d="M38.9577,26.3841l14.6256-9.8605c0-1.1669-1.0887-2.0036-1.7031-2.0036H35.1861v9.7243l3.3984,2.1398   C38.6739,26.41,38.8682,26.4122,38.9577,26.3841z"/><path d="M39.2509,30.0032c0,0-0.5265,0.321-0.9632,0l-3.1016-2.1304h-0.0018v13.2156h15.7551c1.4002,0,2.6458-0.8157,2.6458-2.7616   V20.4542C53.5852,20.4542,38.7262,30.3242,39.2509,30.0032z"/><path d="M18.6389,34.1928c1.04,0,1.8651-0.4688,2.4738-1.4056c0.6087-0.9377,0.9149-2.2394,0.9149-3.9033   c0-1.7345-0.2949-3.0847-0.8871-4.0496c-0.5917-0.9635-1.3999-1.4453-2.4269-1.4453c-1.0569,0-1.899,0.4969-2.521,1.4878   c-0.6217,0.9925-0.9333,2.3051-0.9333,3.9386c0,1.6581,0.3116,2.9686,0.9333,3.9321   C16.8145,33.7132,17.6306,34.1928,18.6389,34.1928z"/><path d="M4.0003,47.6256l28.9409,6.0676V3.9801L4.0003,9.5818V47.6256z M13.9221,22.5941   c1.2267-1.6343,2.8514-2.4515,4.8736-2.4515c1.9098,0,3.4561,0.7804,4.6342,2.3454c1.1799,1.5643,1.7699,3.6248,1.7699,6.1852   c0.0018,2.631-0.6104,4.7521-1.8333,6.3619c-1.2232,1.609-2.8178,2.4161-4.7857,2.4161c-1.9177,0-3.4784-0.7804-4.6865-2.3397   c-1.2063-1.5608-1.8113-3.5924-1.8113-6.0986C12.083,26.3675,12.6957,24.2276,13.9221,22.5941z"/></g></svg>
                            <big>Outlook</big>
                            <span class="type">Connect using your outlook</span>
                          </a> -->

                        <?php
                        $emails = array();
                        $q = $pdo->prepare('SELECT * FROM `nylas_smtp` WHERE `member_id`=?');
                        $q->execute(array($member['id']));
                        foreach ($q as $row) {

                            $pass = crypt_jm($row['password'],'d');
                            if($row['imap_username']=="" && $row['imap_password']=""){
                                $imap_user = $row['username'];
                                $imap_pass = crypt_jm($row['password'],'d');
                                $imap_ssltls = $row['usessltls'];
                            }else{
                                $imap_user = $row['imap_username'];
                                $imap_pass = crypt_jm($row['imap_password'],'d');
                                $imap_ssltls = $row['imap_usessltls'];
                            }

                            $emails[] = array(
                                'name' => '<span style="display: inline-block; margin-left: 45px;"></span>'.$row['name'],
                                'from_name' => $row['name'],
                                'from_email' => $row['email'],
                                'email' => $row['username'],
                                'password' => $pass,
                                'type' => $row['smtp_type'],
                                'send_limit' => $row['send_limit'],
                                'id' => $row['id'],
                                'member_id' => $row['member_id'],
                                'server' => $row['server'],
                                'port' => $row['port'],
                                'imap_usessltls' => $imap_ssltls,

                                'imap_username' => $imap_user,
                                'imap_password' => $imap_pass,
                                'usessltls' => $row['usessltls'],

                                'imap_server' => $row['imap_server'],
                                'imap_port' => $row['imap_port'],
                                'digital_sign' => $row['digital_sign'],
                                'sending_limit_per_day' => $row['sending_limit_per_day'],
                                'allowed_time_send_from' => $row['allowed_time_send_from'],
                                'allowed_time_send_to' => $row['allowed_time_send_to'],
                                'time_between_email_send' => $row['time_between_email_send'],
                                'max_email_per_time' => $row['max_email_per_time'],
                                'active' => $row['active'],
                                'usessltls' => $row['usessltls'],
                                'nylas_account_id' => $row['nylas_account_id'],
                                'warmup' => $row['warmup'],
                                'warmup_date' => $row['warmup_date'],
                            );
                        }

                        ?>


                </div>
                <div class="email-msg"></div>
                <div class="row widgets-row">

                    <div class="col-lg-12 col-md-12">



                        <h6>Email Accounts</h6>


                        <div class="dataTables_wrapper">

                            <table class="table datatable">
                                <thead>
                                <tr>
                                    <th scope="col">Name</th>
                                    <th scope="col">Email</th>
                                    <th scope="col">Email Type</th>
                                    <th scope="col">Enabled</th>
                                    <th scope="col">Daily Send Limit</th>
                                    <th scope="col">Actions</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php

                                foreach ($emails as $email) {

                                    if($email['type'] == 'smtp'){

                                        $sending_account = "";
                                        $with_campaign = 0;
                                        $campaigns_count = 0;
                                        $sending_account = $email['type'].":".$email['id'];
                                        $campaigns  = $pdo->prepare('SELECT c.id, c.sending_account FROM (`campaigns` as c) WHERE c.sending_account =?');
                                        $campaigns->execute(array($sending_account));
                                        $campaigns_count = $campaigns->rowcount();
                                        if($campaigns_count == 0){
                                            $with_campaign = 0;
                                        }else{
                                            $with_campaign = 1;
                                        }

                                        $row_actions = '<div class="dropdown">
                          <button type="button" class="btn btn-default btn-sm dropdown-toggle no-caret" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
                          <div class="dropdown-menu dropdown-menu-right">';

//                      if($email['type'] != 'gmail'){
//                          $row_actions .= '<a href="javascript:void(0);" class="dropdown-item btn-edit-smtp-integration" data-toggle="tooltip" data-key="' .$email['id']. '" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>';
//                      }
                                        $email_type = "";
                                        if($email['type'] == 'smtp'){
                                            $email_type = "SMTP";
                                            $row_actions .= '<a href="javascript:void(0);" class="dropdown-item btn-edit-smtp-integration" data-key="' .$email['id']. '" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>';
                                            $row_actions .= '<a href="javascript:void(0)" class="dropdown-item btn-email-smtp-refresh" data-key="'.$email['id'].'" data-type="smtp"><i class="fas fa-sync"></i> Refresh</a>';
                                        }elseif($email['type'] != 'gmail'){
                                            $row_actions .= '<a href="javascript:void(0);" class="dropdown-item btn-edit-other-integration" data-key="' .$email['id']. '" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>';
                                        }elseif($email['type'] == 'gmail'){
                                            $row_actions .= '<a href="javascript:void(0);" class="dropdown-item btn-edit-gmail-integration" data-key="' .$email['id']. '" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>';
                                        }



                                        if($email['type']=="yahoo")
                                        {
                                            $email_type = 'Yahoo Mail';
                                        }
                                        if($email_type=="")
                                        {
                                            $email_type = ucwords($email['type']);
                                        }
                                        $row_actions .= '<!-- <a class="dropdown-item btn-list-smtp-verify" href="javascript:void(0);" title="" data-key=' .$email['id']. '><i class="fas fa-cog"></i> Check if your smtp setting are working</a>-->
                              <a href="javascript:void(0)" class="dropdown-item text-danger btn-email-delete" data-key-account-id="'.trim(strip_tags($email['nylas_account_id'])).'"  data-key-email="'.trim(strip_tags($email['name'])).'"  data-key-db="'.$email['type'] .'" attr-with-campaign="'.$with_campaign.'" data-key="'.$email['id'].'"><i class="fas fa-trash-alt"></i> Delete</a>
                          </div>
                      </div>';

                                        $warmup = "0";
                                        $warm_days_diff = 0;
                                        if($email['warmup']==1){
                                            $warmup = $email['warmup'];
                                            $warm_date = date('Y-m-d',  strtotime($email['warmup_date']));
                                            $datetime1 = date_create_from_format('Y-m-d', $warm_date);
                                            $datetime2 = date_create(date('Y-m-d'));
                                            $warm_diff = date_diff($datetime1, $datetime2);
                                            $warm_days_diff = $warm_diff->format("%a");
                                        }

                                        echo '
                      <tr>
                          <td class="name" scope="col">'.$email['from_name'].'</td>
                          <td class="email" scope="col">'.$email['from_email'].'</td>
                          <td scope="col">'.$email_type.'</td>
                          <td scope="col">'. ($email['active'] ? 'Yes': 'No') . '</td>
                          <td class="limit" scope="col">'.$email['sending_limit_per_day'].' <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="#edit" attr-edit-type="'.$email['type'].'" attr-edit-limit="'.$email['id'].'" attr-email-type="'.$email['type'].'" attr-current-val="'.$email['sending_limit_per_day'].'"><i class="far fa-edit"></i></button></td>
                          <td class="action" scope="col">'.$row_actions.'</div>
                ';

                                        ?>
                                        <!-- </td>
                                           </tr> -->

                                        <div class="modal fade" id="edit_warmup<?php echo $email['id']; ?>" tabindex="1" role="dialog" aria-labelledby="editLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document" style="margin-top: 10vw;">
                                                <form action="" method="post">
                                                    <div class="modal-content">
                                                        <div class="modal-body">
                                                            <div class="row">
                                                                <div class="col-12" style="text-align: center;">
                                                                    <!-- <i class="fas fa-envelope" style="font-size:50px;"></i> -->
                                                                    <img src="img/warm.png" style="width:120px;">
                                                                    <strong><p style="margin-top: 20px; font-size: 30px;margin-bottom: 25px;">Warmup Email</p></strong>
                                                                </div>
                                                            </div>
                                                            <input type="hidden" name="update_warmup" value="">
                                                            <input type="hidden" name="type" value="">
                                                            <input type="hidden" name="update_warmup_stat" value="">

                                                            <div class="row">
                                                                <label> Automailer will send everyday realistic emails from your inbox,<br /> remove these emails from the spam folder, open & bookmark <br /> these emails, reply to a part of these emails and generate <br /> positive interactions with your inbox to raise your email sending <br /> reputation.</label>
                                                            </div>

                                                            <div class="modal-footer" style="display: block;text-align: center;">
                                                                <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;height:45.5px ;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                                                                <button type="submit" class="btn btn-success" style="width:200px;font-size: 21px;">Proceed</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>

                                        <div class="modal fade" id="modal-smtp-edit-<?php echo $email['id']; ?>" data-focus="false" tabindex="1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <div class="modal-content">
                                                    <form action="" method="post" class="frm-edit-smtp-<?php echo $email['id']; ?>">
                                                        <div class="modal-body">
                                                            <div class="form">
                                                                <input type="hidden" name="edit_id" value="<?php echo $email['id']; ?>">
                                                                <input type="hidden" name="action" value="edit">
                                                                <input type="hidden" name="nylas_account_id" class="nylas_account_id">
                                                                <input type="hidden" name="nylas_access_token" class="nylas_access_token">
                                                                <div class="row">
                                                                    <div class="col-12" style="text-align: center;">
                                                                        <i class="fas fa-envelope" style="font-size:50px;"></i>
                                                                        <p style="margin-top: 20px; font-size: 30px;margin-bottom: 13px;">SMTP Settings (sending emails)</p>
                                                                    </div>
                                                                </div>
                                                                <div class="form-input-container" style="max-height: 600px; overflow-x: hidden;overflow-y:auto;">
                                                                    <div style="margin-bottom:30px;" class="modal-edit-smtp-msg"></div>
                                                                    <div class="row">
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_from_name" required="" value="<?php echo $email['from_name']; ?>" placeholder="Sender Name" class="form-control">
                                                                                <label  data-toggle="tooltip" title="Name that will show on the sender name">From Name: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_from_email" required="" value="<?php echo $email['from_email'];  ?>" placeholder="sender@automailer.io" class="form-control">
                                                                                <label data-toggle="tooltip" title="Email that will show on the sender" >From Email: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="email" id="edit_user" name="edit_user" required="" value="<?php echo $email['email'];  ?>" placeholder="youremail@domain.com" class="form-control imap_user_pass_edit edit_user_smtp<?php echo $email['id']; ?>" data-id="<?php echo $email['id']; ?>">
                                                                                <label data-toggle="tooltip" title="SMTP email that the system will use for sending email" >User (usually your email): *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="password" id="edit_password" name="edit_password" required="" value="<?php echo $email['password'];  ?>" placeholder="Password" class="form-control imap_user_pass_edit edit_pass_smtp<?php echo $email['id']; ?>" data-id="<?php echo $email['id']; ?>">
                                                                                <label data-toggle="tooltip" title="Your SMTP email password">Password: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_server" required="" value="<?php echo $email['server'];  ?>" placeholder="mail.automailer.io" class="form-control">
                                                                                <label data-toggle="tooltip" title="SMTP server details can be found on you hosting email setting">SMTP Server: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_port" required="" value="<?php echo $email['port'];  ?>" placeholder="25" class="form-control">
                                                                                <label data-toggle="tooltip" title="SMTP server port can be found on email settings on the cpanel">Port *:</label>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <div class="form-group">
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input type="checkbox" class="custom-control-input" id="edit_usessltls_<?php echo $email['id']; ?>" name="edit_usessltls" value="1" <?php if($email['usessltls']==1){ ?> checked="checked" <?php } ?> >
                                                                                    <label class="custom-control-label" for="edit_usessltls_<?php echo $email['id']; ?>">Use SSL/TLS</label>
                                                                                </div>
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input type="checkbox" class="custom-control-input imap_user_pass_edit " id="same_as_smtp_edit" name="same_as_smtp_edit" value="1" >
                                                                                    <label class="custom-control-label" for="same_as_smtp_edit">Use the same Username/Password for SMTP & IMAP</label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <!-- <div class="row">
                                                                         <div class="col-md-12">
                                                                             <div class="custom-control custom-checkbox">
                                                                                 <input type="checkbox" class="custom-control-input imap_user_pass_edit " id="same_as_smtp_edit" name="same_as_smtp_edit" value="1" >
                                                                                 <label class="custom-control-label" for="same_as_smtp_edit">Use the same Username/Password for SMTP & IMAP</label>
                                                                             </div>
                                                                         </div>
                                                                     </div> <br /> -->
                                                                    <div class="row">
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_imap_user" id="edit_imap_user" value="<?php echo $email['imap_username']; ?>" required="" placeholder="mail.sampledomain.com" class="form-control edit_imap_user<?php echo $email['id']; ?>">
                                                                                <label  data-toggle="tooltip" title="IMAP server details can be found on you hosting email setting" >IMAP Username: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="password" id="edit_imap_password" name="edit_imap_password" required="" value="<?php echo $email['imap_password'];  ?>" placeholder="Password" class="form-control edit_imap_password<?php echo $email['id']; ?>">
                                                                                <label data-toggle="tooltip" title="Your SMTP email password">Password: *</label>
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_imap_server" id="edit_imap_server" value="<?php echo $email['imap_server']; ?>" required="" placeholder="mail.sampledomain.com" class="form-control">
                                                                                <label  data-toggle="tooltip" title="IMAP server details can be found on you hosting email setting" >IMAP Server: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_imap_port" required="" placeholder="993" value="<?php echo $email['imap_port']; ?>" class="form-control">
                                                                                <label data-toggle="tooltip" title="IMAP server port can be found on email settings on the cpanel">IMAP Port *:</label>
                                                                            </div>
                                                                        </div>
                                                                    </div>`

                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <div class="form-group">
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input type="checkbox" class="custom-control-input" id="edit_imap_usessltls_<?php echo $email['id']; ?>" name="edit_imap_usessltls" value="1" <?php if($email['imap_usessltls']==1){ ?> checked="checked" <?php } ?> >
                                                                                    <label class="custom-control-label" for="edit_imap_usessltls_<?php echo $email['id']; ?>">Use SSL/TLS</label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <div class="form-group">

                                                                                <label> Tip: if this is a new email, please use the getting started send speed to warm up your email</label>

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <h4 style="margin-bottom:20px;">Signature</h4>
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <label data-toggle="tooltip" title="Input / Copy paste your signature below">Enter your email signature below (manually or by copy-pasting it from your email).</label>
                                                                            <textarea id="sign" name="sign" class="form-control ckeditor" data-gramm="false" rows="3"><?php echo $email['digital_sign'];  ?></textarea>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer" style="display: block;text-align: center;">

                                                                    <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;height: 49px;">Cancel</button>
                                                                    <button type="submit" class="btn btn-success btn-update-nylas-smtp" style="width:200px;font-size: 21px;" data-key="<?php echo $email['id']; ?>">Save changes</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>





                                        



                                        </td>



                                    <?php }else{

                                        $sending_account = "";
                                        $email_type ="";
                                        $with_campaign = 0;
                                        $campaigns_count = 0;
                                        $sending_account = $email['type'].":".$email['id'];
                                        $campaigns  = $pdo->prepare('SELECT c.id, c.sending_account FROM (`campaigns` as c) WHERE c.sending_account =?');
                                        $campaigns->execute(array($sending_account));
                                        $campaigns_count = $campaigns->rowcount();
                                        if($campaigns_count == 0){
                                            $with_campaign = 0;
                                        }else{
                                            $with_campaign = 1;
                                        }

                                        /*$row_actions = '<div class="dropdown">
                                            <button type="button" class="btn btn-default btn-sm dropdown-toggle no-caret" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a href="javascript:void(0);" class="dropdown-item btn-edit-smtp-integration" data-toggle="tooltip" data-key="' .$email['id']. '" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>
                                                <!-- <a class="dropdown-item btn-list-smtp-verify" href="javascript:void(0);" title="" data-key=' .$email['id']. '><i class="fas fa-cog"></i> Check if your smtp setting are working</a>-->
                                                <a href="javascript:void(0)" class="dropdown-item text-danger btn-email-delete" data-key-account-id="'.trim(strip_tags($email['nylas_account_id'])).'"  data-key-email="'.trim(strip_tags($email['name'])).'"  data-key-db="'.$email['type'] .'" attr-with-campaign="'.$with_campaign.'" data-key="'.$email['id'].'"><i class="fas fa-trash-alt"></i> Delete</a>
                                            </div>
                                        </div>';*/

                                        $row_actions = '<div class="dropdown">
                    <button type="button" class="btn btn-default btn-sm dropdown-toggle no-caret" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
                    <div class="dropdown-menu dropdown-menu-right">';
                                        ?>
                                        <?php
                                        if($email['type'] == 'smtp'){
                                            $email_type = "SMTP";
                                            $row_actions .= '<a href="javascript:void(0);" class="dropdown-item btn-edit-smtp-integration" data-key="' .$email['id']. '" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>';
                                        }elseif($email['type'] != 'gmail'){
                                            if($email['type'] == 'microsoft')
                                            {
                                                $email_type = "Microsoft Exchange";
                                                $row_actions .= '<a href="javascript:void(0);" class="dropdown-item btn-edit-microsoft-integration" data-key="' .$email['id']. '" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>';
                                            } else {
                                                $row_actions .= '<a href="javascript:void(0);" class="dropdown-item btn-edit-other-integration" data-key="' .$email['id']. '" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>';
                                                $row_actions .= '<a href="javascript:void(0)" class="dropdown-item btn-email-smtp-refresh" data-key="'.$email['id'].'" data-type="known"><i class="fas fa-sync"></i> Refresh</a>';
                                            }

                                        }elseif($email['type'] == 'gmail'){
                                            $row_actions .= '<a href="javascript:void(0);" class="dropdown-item btn-edit-gmail-integration" data-key="' .$email['id']. '" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>';
                                        }

                                        if($email['type'] == 'gmail'){
                                            $email_type = "Gmail";
                                            $row_actions = "";
                                            $row_actions = '<div class="dropdown">
                    <button type="button" class="btn btn-default btn-sm dropdown-toggle no-caret" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
                    <div class="dropdown-menu dropdown-menu-right">';
                                            $row_actions .= '<a href="javascript:void(0);" class="dropdown-item btn-edit-smtp-gmail-integration" data-key="' .$email['id']. '" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>';
                                            $row_actions .= '<a href="javascript:void(0)" class="dropdown-item btn-email-smtp-refresh" data-key="'.$email['id'].'" data-type="smtp"><i class="fas fa-sync"></i> Refresh</a>';
                                        }

                                        if($email['type']=="yahoo")
                                        {
                                            $email_type = 'Yahoo Mail';
                                        }
                                        if($email_type=="")
                                        {
                                            $email_type = ucwords($email['type']);
                                        }
                                        ?>
                                        <?php
                                        $row_actions .= '<a href="javascript:void(0)" class="dropdown-item text-danger btn-email-delete" data-key-account-id="'.trim(strip_tags($email['nylas_account_id'])).'"  data-key-email="'.trim(strip_tags($email['name'])).'"  data-key-db="'.$email['type'] .'" attr-with-campaign="'.$with_campaign.'" data-key="'.$email['id'].'"><i class="fas fa-trash-alt"></i> Delete</a>
                    </div>
                </div>';

                                        $warmup = "0";
                                        $warm_days_diff = 0;
                                        if($email['warmup']==1){
                                            $warmup = $email['warmup'];
                                            $warm_date = date('Y-m-d',  strtotime($email['warmup_date']));
                                            $datetime1 = date_create_from_format('Y-m-d', $warm_date);
                                            $datetime2 = date_create(date('Y-m-d'));
                                            $warm_diff = date_diff($datetime1, $datetime2);
                                            $warm_days_diff = $warm_diff->format("%a");
                                        }



                                        echo '
                <tr>
                    <td class="name" scope="col">'.$email['from_name'].'</td>
                    <td class="email" scope="col">'.$email['from_email'].'</td>
                    <td scope="col">'. $email_type.'</td>
                    <td scope="col">'. ($email['active'] ? 'Yes': 'No') . '</td>
                    <td class="limit" scope="col">'.$email['sending_limit_per_day'].' <button type="button" class="btn btn-default btn-sm" data-toggle="modal" data-target="#edit" attr-edit-type="'.$email['type'].'" attr-edit-limit="'.$email['id'].'" attr-email-type="'.$email['type'].'" attr-current-val="'.$email['sending_limit_per_day'].'"><i class="far fa-edit"></i></button></td>
                    <td class="action" scope="col">'.$row_actions.'
              ';

                                        ?>
                                        <!-- </td>
                                           </tr> -->


                                        <div class="modal fade" id="2edit_warmup<?php echo $email['id']; ?>" tabindex="1" role="dialog" aria-labelledby="editLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document" style="margin-top: 10vw;">
                                                <form action="" method="post">
                                                    <div class="modal-content">
                                                        <div class="modal-body">
                                                            <div class="row">
                                                                <div class="col-12" style="text-align: center;">
                                                                    <!-- <i class="fas fa-envelope" style="font-size:50px;"></i> -->
                                                                    <img src="img/warm.png" style="width:120px;">
                                                                    <p style="margin-top: 20px; font-size: 30px;margin-bottom: 25px;">Warmup Email</p>
                                                                </div>
                                                            </div>
                                                            <input type="hidden" name="update_warmup" value="">
                                                            <input type="hidden" name="type" value="">
                                                            <input type="hidden" name="update_warmup_stat" value="">
                                                            <div class="row">
                                                                <label> Automailer will send everyday realistic emails from your inbox,<br /> remove these emails from the spam folder, open & bookmark <br /> these emails, reply to a part of these emails and generate <br /> positive interactions with your inbox to raise your email sending <br /> reputation.</label>

                                                            </div>


                                                            <div class="modal-footer" style="display: block;text-align: center;">
                                                                <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;height:45.5px ;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                                                                <button type="submit" class="btn btn-success" style="width:200px;font-size: 21px;">Proceed</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>

                                        <div class="modal fade" id="modal-smtp-edit-<?php echo $email['id']; ?>" data-focus="false" tabindex="1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <div class="modal-content">
                                                    <form action="" method="post" class="frm-edit-smtp-<?php echo $email['id']; ?>">
                                                        <div class="modal-body">
                                                            <div class="form">
                                                                <input type="hidden" name="edit_id" value="<?php echo $email['id']; ?>">
                                                                <input type="hidden" name="action" value="edit">
                                                                <input type="hidden" name="nylas_account_id" class="nylas_account_id">
                                                                <input type="hidden" name="nylas_access_token" class="nylas_access_token">
                                                                <div class="row">
                                                                    <div class="col-12" style="text-align: center;">
                                                                        <i class="fas fa-envelope" style="font-size:50px;"></i>
                                                                        <p style="margin-top: 20px; font-size: 30px;margin-bottom: 13px;">SMTP Settings (sending emails)</p>
                                                                    </div>
                                                                </div>
                                                                <div class="form-input-container" style="max-height: 600px; overflow-x: hidden;overflow-y:auto;">
                                                                    <div style="margin-bottom:30px;" class="modal-edit-smtp-msg"></div>
                                                                    <div class="row">
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_from_name" required="" value="<?php echo $email['from_name']; ?>" placeholder="Sender Name" class="form-control">
                                                                                <label  data-toggle="tooltip" title="Name that will show on the sender name">From Name: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_from_email" required="" value="<?php echo $email['from_email'];  ?>" placeholder="sender@automailer.io" class="form-control">
                                                                                <label data-toggle="tooltip" title="Email that will show on the sender" >From Email: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="email" id="edit_user" name="edit_user" required="" value="<?php echo $email['email'];  ?>" placeholder="youremail@domain.com" class="form-control imap_user_pass_edit edit_user_smtp<?php echo $email['id']; ?>" data-id="<?php echo $email['id']; ?>">
                                                                                <label data-toggle="tooltip" title="SMTP email that the system will use for sending email" >User (usually your email): *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="password" id="edit_password" name="edit_password" required="" value="<?php echo $email['password'];  ?>" placeholder="Password" class="form-control imap_user_pass_edit edit_pass_smtp<?php echo $email['id']; ?>" data-id="<?php echo $email['id']; ?>">
                                                                                <label data-toggle="tooltip" title="Your SMTP email password">Password: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_server" required="" value="<?php echo $email['server'];  ?>" placeholder="mail.automailer.io" class="form-control">
                                                                                <label data-toggle="tooltip" title="SMTP server details can be found on you hosting email setting">SMTP Server: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_port" required="" value="<?php echo $email['port'];  ?>" placeholder="25" class="form-control">
                                                                                <label data-toggle="tooltip" title="SMTP server port can be found on email settings on the cpanel">Port *:</label>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <div class="form-group">
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input type="checkbox" class="custom-control-input" id="edit_usessltls_<?php echo $email['id']; ?>" name="edit_usessltls" value="1" <?php if($email['usessltls']==1){ ?> checked="checked" <?php } ?> >
                                                                                    <label class="custom-control-label" for="edit_usessltls_<?php echo $email['id']; ?>">Use SSL/TLS</label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <div class="custom-control custom-checkbox">
                                                                                <input type="checkbox" class="custom-control-input imap_user_pass_edit " id="same_as_smtp_edit" name="same_as_smtp_edit" value="1" >
                                                                                <label class="custom-control-label" for="same_as_smtp_edit">Use the same Username/Password for SMTP & IMAP</label>
                                                                            </div>
                                                                        </div>
                                                                    </div> <br />
                                                                    <div class="row">
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_imap_user" id="edit_imap_user" value="<?php echo $email['imap_username']; ?>" required="" placeholder="mail.sampledomain.com" class="form-control edit_imap_user<?php echo $email['id']; ?>">
                                                                                <label  data-toggle="tooltip" title="IMAP server details can be found on you hosting email setting" >IMAP Username: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="password" id="edit_imap_password" name="edit_imap_password" required="" value="<?php echo $email['imap_password'];  ?>" placeholder="Password" class="form-control edit_imap_password<?php echo $email['id']; ?>">
                                                                                <label data-toggle="tooltip" title="Your SMTP email password">Password: *</label>
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_imap_server" id="edit_imap_server" value="<?php echo $email['imap_server']; ?>" required="" placeholder="mail.sampledomain.com" class="form-control">
                                                                                <label  data-toggle="tooltip" title="IMAP server details can be found on you hosting email setting" >IMAP Server: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_imap_port" required="" placeholder="993" value="<?php echo $email['imap_port']; ?>" class="form-control">
                                                                                <label data-toggle="tooltip" title="IMAP server port can be found on email settings on the cpanel">IMAP Port *:</label>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <div class="form-group">
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input type="checkbox" class="custom-control-input" id="edit_imap_usessltls_<?php echo $email['id']; ?>" name="edit_imap_usessltls" value="1" <?php if($email['imap_usessltls']==1){ ?> checked="checked" <?php } ?> >
                                                                                    <label class="custom-control-label" for="edit_imap_usessltls_<?php echo $email['id']; ?>">Use SSL/TLS</label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <div class="form-group">

                                                                                <label> Tip: if this is a new email, please use the getting started send speed to warm up your email</label>

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <h4 style="margin-bottom:20px;">Signature</h4>
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <label data-toggle="tooltip" title="Input / Copy paste your signature below">Enter your email signature below (manually or by copy-pasting it from your email).</label>
                                                                            <textarea id="sign" name="sign" class="form-control ckeditor" data-gramm="false" rows="3"><?php echo $email['digital_sign'];  ?></textarea>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer" style="display: block;text-align: center;">

                                                                    <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;height: 49px;">Cancel</button>
                                                                    <button type="submit" class="btn btn-success btn-update-nylas-smtp" style="width:200px;font-size: 21px;" data-key="<?php echo $email['id']; ?>">Save changes</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>




                                        <div class="modal fade" id="modal-smtp-gmail-edit-<?php echo $email['id']; ?>" data-focus="false" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <div class="modal-content">
                                                    <form action="" method="post" class="frm-edit-smtp-gmail-<?php echo $email['id']; ?>">
                                                        <div class="modal-body">
                                                            <div class="form">
                                                                <input type="hidden" name="edit_id" value="<?php echo $email['id']; ?>">
                                                                <input type="hidden" name="action" value="edit">
                                                                <input type="hidden" name="nylas_account_id" class="nylas_account_id">
                                                                <input type="hidden" name="nylas_access_token" class="nylas_access_token">
                                                                <div class="row">
                                                                    <div class="col-12" style="text-align: center;">
                                                                        <i class="fab fa-google" style="font-size:50px;"></i>
                                                                        <p style="margin-top: 20px; font-size: 30px;margin-bottom: 13px;">Gmail Settings<!--  (sending emails) --></p>
                                                                    </div>
                                                                </div>
                                                                <div class="form-input-container" style="max-height: 600px; overflow-x: hidden;overflow-y:auto;">
                                                                    <div style="margin-bottom:30px;" class="modal-edit-smtp-msg"></div>
                                                                    <div class="row">
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_from_name" id="edit_from_name" required="" value="<?php echo $email['from_name']; ?>" placeholder="Sender Name" class="form-control">
                                                                                <label  data-toggle="tooltip" title="Name that will show on the sender name">From Name: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_from_email" required="" value="<?php echo $email['from_email'];  ?>" placeholder="sender@automailer.io" class="form-control">
                                                                                <label data-toggle="tooltip" title="Email that will show on the sender" >From Email: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="email" id="edit_user" name="edit_user" required="" value="<?php echo $email['email'];  ?>" placeholder="youremail@domain.com" class="form-control imap_user_pass_gmail gmail_user ">
                                                                                <label data-toggle="tooltip" title="SMTP email that the system will use for sending email" >User (usually your email): *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="password" id="edit_password" name="edit_password" required="" value="<?php echo $email['password'];  ?>" placeholder="Password" class="form-control gmail_pw imap_user_pass_gmail ">
                                                                                <label data-toggle="tooltip" title="Your SMTP email password">Password: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_server" required="" value="<?php echo $email['server'];  ?>" placeholder="mail.automailer.io" class="form-control">
                                                                                <label data-toggle="tooltip" title="SMTP server details can be found on you hosting email setting">SMTP Server: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_port" required="" value="<?php echo $email['port'];  ?>" placeholder="25" class="form-control">
                                                                                <label data-toggle="tooltip" title="SMTP server port can be found on email settings on the cpanel">Port *:</label>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <div class="form-group">
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input type="checkbox" class="custom-control-input" id="edit_usessltls_<?php echo $email['id']; ?>" name="edit_usessltls" value="1" <?php if($email['usessltls']==1){ ?> checked="checked" <?php } ?> >
                                                                                    <label class="custom-control-label" for="edit_usessltls_<?php echo $email['id']; ?>">Use SSL/TLS</label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_imap_user" id="edit_imap_user" value="<?php echo $email['imap_username']; ?>" required="" placeholder="mail.sampledomain.com" class="form-control imap_gmail_user">
                                                                                <label  data-toggle="tooltip" title="IMAP server details can be found on you hosting email setting" >IMAP Username: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="password" id="edit_imap_password" name="edit_imap_password" required="" value="<?php echo $email['imap_password'];  ?>" placeholder="Password" class="form-control imap_gmail_pass">
                                                                                <label data-toggle="tooltip" title="Your SMTP email password">Password: *</label>
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_imap_server" id="edit_imap_server" value="<?php echo $email['imap_server']; ?>" required="" placeholder="mail.sampledomain.com" class="form-control">
                                                                                <label  data-toggle="tooltip" title="IMAP server details can be found on you hosting email setting" >IMAP Server: *</label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <div class="form-group">
                                                                                <input type="text" name="edit_imap_port" required="" placeholder="993" value="<?php echo $email['imap_port']; ?>" class="form-control">
                                                                                <label data-toggle="tooltip" title="IMAP server port can be found on email settings on the cpanel">IMAP Port *:</label>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <div class="form-group">
                                                                                <div class="custom-control custom-checkbox">
                                                                                    <input type="checkbox" class="custom-control-input" id="edit_imap_usessltls_<?php echo $email['id']; ?>" name="edit_imap_usessltls" value="1" <?php if($email['imap_usessltls']==1){ ?> checked="checked" <?php } ?> >
                                                                                    <label class="custom-control-label" for="edit_imap_usessltls_<?php echo $email['id']; ?>">Use SSL/TLS</label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <div class="form-group">

                                                                                <label> Tip: if this is a new email, please use the getting started send speed to warm up your email</label>

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <h4 style="margin-bottom:20px;">Signature</h4>
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <label data-toggle="tooltip" title="Input / Copy paste your signature below">Enter your email signature below (manually or by copy-pasting it from your email).</label>
                                                                            <textarea id="sign" name="sign" class="form-control ckeditor" data-gramm="false" rows="3"><?php echo $email['digital_sign'];  ?></textarea>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer" style="display: block;text-align: center;">

                                                                    <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;height: 49px;">Cancel</button>
                                                                    <button type="submit" class="btn btn-success btn-update-nylas-smtp-gmail" style="width:200px;font-size: 21px;" data-key="<?php echo $email['id']; ?>">Save changes</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="modal fade" id="modal-other-edit-<?php echo $email['id']; ?>" data-focus="false" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <div class="modal-content">
                                                    <form action="" method="post" class="frm-edit-smtp-<?php echo $email['id']; ?>">
                                                        <div class="modal-body">
                                                            <div class="form">
                                                                <input type="hidden" name="edit_id" value="<?php echo $email['id']; ?>">
                                                                <input type="hidden" name="action" value="edit">
                                                                <input type="hidden" name="nylas_account_id" class="nylas_account_id">
                                                                <input type="hidden" name="nylas_access_token" class="nylas_access_token">
                                                                <div class="row">
                                                                    <div class="col-12" style="text-align: center;">
                                                                        <i class="fas fa-envelope" style="font-size:50px;"></i>
                                                                        <p style="margin-top: 20px; font-size: 30px;margin-bottom: 13px;">SMTP Settings (sending emails)</p>
                                                                    </div>
                                                                </div>
                                                                <div style="margin-bottom:30px;" class="modal-edit-smtp-msg"></div>
                                                                <div class="row">
                                                                    <div class="col-md-6">
                                                                        <div class="form-group">
                                                                            <select name="smtp_type" id="smtp_type" class="form-control">
                                                                                <option value="">Select Type</option>
                                                                                <option value="yahoo" <?php if($email['type']=='yahoo'){echo 'selected';} ?>>Yahoo</option>
                                                                                <option value="outlook" <?php if($email['type']=='outlook'){echo 'selected';} ?>>Outlook</option>
                                                                                <option value="icloud" <?php if($email['type']=='icloud'){echo 'selected';} ?>>iCloud</option>
                                                                                <option value="hotmail" <?php if($email['type']=='hotmail'){echo 'selected';} ?>>Hotmail</option>
                                                                                <option value="aol" <?php if($email['type']=='aol'){echo 'selected';} ?>>Aol</option>
                                                                                <option value="exchange" <?php if($email['type']=='microsoft'){echo 'selected';} ?>>Microsoft</option>
                                                                            </select>
                                                                            <label data-toggle="tooltip" title="Name that will show on the sender name">Email Type: *</label>
                                                                        </div>
                                                                    </div>

                                                                    <div class="col-md-6">
                                                                        <div class="form-group">
                                                                            <input type="text" name="nylas_known_from_name" required="" value="<?php echo $email['from_name']; ?>" placeholder="Sender Name" class="form-control">
                                                                            <label data-toggle="tooltip" title="Name that will show on the sender name">From Name: *</label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <div class="form-group">
                                                                            <input type="text" name="from_email" required="" value="<?php echo $email['from_email'];  ?>" placeholder="sender@domain.com" class="form-control">
                                                                            <label data-toggle="tooltip" title="Email that will show on the sender" >From Email: *</label>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <div class="form-group">
                                                                            <input type="password" name="password" required="" value="<?php echo $email['password'];  ?>" placeholder="Password" class="form-control">
                                                                            <label data-toggle="tooltip" title="Your SMTP email password" >Password: *</label>
                                                                        </div>
                                                                    </div>

                                                                </div>

                                                                <h4 style="margin-bottom:20px;">Signature</h4>
                                                                <div class="row">
                                                                    <div class="col-md-12">
                                                                        <label data-toggle="tooltip" title="Input / Copy paste your signature below">Enter your email signature below (manually or by copy-pasting it from your email).</label>
                                                                        <textarea id="sign" name="sign" class="form-control ckeditor" data-gramm="false" rows="3"><?php echo $email['digital_sign'];  ?></textarea>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer" style="display: block;text-align: center;">

                                                                    <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;height: 49px;">Cancel</button>
                                                                    <button type="submit" class="btn btn-success btn-update-known-smtp" style="width:200px;font-size: 21px;" data-key="<?php echo $email['id']; ?>" data-key="<?php echo $email['id']; ?>">Save changes</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- microsoft edit modal start-->
                                        <div class="modal fade" id="modal-microsoft-edit-<?php echo $email['id']; ?>" data-focus="false" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <div class="modal-content">
                                                    <form action="" method="post" class="frm-edit-gmail-<?php echo $email['id']; ?>">
                                                        <div class="modal-body">
                                                            <div class="form">
                                                                <input type="hidden" name="edit_id" value="<?php echo $email['id']; ?>">
                                                                <input type="hidden" name="action" value="gmail_edit">
                                                                <div class="row">
                                                                    <div class="col-12" style="text-align: center;">
                                                                        <i class="fab fa-microsoft" style="font-size:50px;"></i>
                                                                        <p style="margin-top: 20px; font-size: 30px;margin-bottom: 13px;">Microsoft Exchange Settings<!--  (sending emails) --></p>
                                                                    </div>
                                                                </div>
                                                                <div style="margin-bottom:30px;" class="modal-edit-smtp-msg"></div>
                                                                <div class="row">
                                                                    <div class="col-md-12">
                                                                        <div class="form-group" style="max-width: 100%;">
                                                                            <input type="text" name="edit_gmail_name" required="" value="<?php echo $email['from_name']; ?>" placeholder="Sender Name" class="form-control">
                                                                            <label  data-toggle="tooltip" title="Name that will show on the sender name">From Name: *</label>
                                                                        </div>
                                                                    </div>

                                                                </div>

                                                                <div class="row">
                                                                    <div class="col-md-12">
                                                                        <div class="form-group">
                                                                            <label> Tip: if this is a new email, please use the getting started send speed to warm up your email</label>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <h4 style="margin-bottom:5px;margin-left: 7px;margin-top: 13px;">Signature</h4>
                                                                <div class="row">
                                                                    <div class="col-md-12">
                                                                        <label data-toggle="tooltip" title="Input / Copy paste your signature below">Enter your email signature below (manually or by copy-pasting it from your email).</label>
                                                                        <textarea id="sign" name="sign" class="form-control ckeditor" data-gramm="false" rows="3"><?php echo $email['digital_sign'];  ?></textarea>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer" style="display: block;text-align: center;">

                                                                    <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;height: 49px;">Cancel</button>
                                                                    <button type="submit" class="btn btn-success btn-update-gmail" style="width:200px;font-size: 21px;" data-key="<?php echo $email['id']; ?>">Save changes</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- microsoft edit modal end -->


                                        <div class="modal fade" id="modal-gmail-edit-<?php echo $email['id']; ?>" data-focus="false" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <div class="modal-content">
                                                    <form action="" method="post" class="frm-edit-gmail-<?php echo $email['id']; ?>">
                                                        <div class="modal-body">
                                                            <div class="form">
                                                                <input type="hidden" name="edit_id" value="<?php echo $email['id']; ?>">
                                                                <input type="hidden" name="action" value="gmail_edit">
                                                                <div class="row">
                                                                    <div class="col-12" style="text-align: center;">
                                                                        <i class="fab fa-google" style="font-size:50px;"></i>
                                                                        <p style="margin-top: 20px; font-size: 30px;margin-bottom: 13px;">Gmail Settings<!--  (sending emails) --></p>
                                                                    </div>
                                                                </div>
                                                                <div style="margin-bottom:30px;" class="modal-edit-smtp-msg"></div>
                                                                <div class="row">
                                                                    <div class="col-md-12">
                                                                        <div class="form-group" style="max-width: 100%;">
                                                                            <input type="text" name="edit_gmail_name" required="" value="<?php echo $email['from_name']; ?>" placeholder="Sender Name" class="form-control">
                                                                            <label  data-toggle="tooltip" title="Name that will show on the sender name">From Name: *</label>
                                                                        </div>
                                                                    </div>

                                                                </div>

                                                                <div class="row">
                                                                    <div class="col-md-12">
                                                                        <div class="form-group">
                                                                            <label> Tip: if this is a new email, please use the getting started send speed to warm up your email</label>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                <h4 style="margin-bottom:5px;margin-left: 7px;margin-top: 13px;">Signature</h4>
                                                                <div class="row">
                                                                    <div class="col-md-12">
                                                                        <label data-toggle="tooltip" title="Input / Copy paste your signature below">Enter your email signature below (manually or by copy-pasting it from your email).</label>
                                                                        <textarea id="sign" name="sign" class="form-control ckeditor" data-gramm="false" rows="3"><?php echo $email['digital_sign'];  ?></textarea>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer" style="display: block;text-align: center;">

                                                                    <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;height: 49px;">Cancel</button>
                                                                    <button type="submit" class="btn btn-success btn-update-gmail" style="width:200px;font-size: 21px;" data-key="<?php echo $email['id']; ?>">Save changes</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>


                                        </td>

                                    <?php }  ?>
                                    <?php
                                }


                                ?>
                                </tr>



                                </tbody>
                            </table>

                        </div>
                    </div>
                    <div class="col-lg-12 col-md-12" style="margin-top: 55px;">
                        <h6>Inactive Accounts</h6>
                        <div class="dataTables_wrapper">
                            <?php
                            $imap = $pdo->prepare('SELECT id,member_id,name,email,smtp_type,inactive_reason FROM `nylas_smtp` WHERE `member_id`=?  AND `active`=0' );
                            $imap->execute(array($member['id']));
                            ?>
                            <table class="table datatable">
                                <thead>
                                <tr>
                                    <th scope="col">Name</th>
                                    <th scope="col">Email</th>
                                    <th scope="col">Email Type</th>
                                    <th scope="col">Inactive Reason</th>
                                    <th scope="col">Actions</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach( $imap as $i ){ ?>
                                    <?php
                                    $row_actions = '<div class="dropdown">
                                  <button type="button" class="btn btn-default btn-sm dropdown-toggle no-caret" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
                                  <div class="dropdown-menu dropdown-menu-right">
                                    <a href="javascript:void(0);" class="dropdown-item btn-reactivate-imap" data-toggle="tooltip" data-key="' .$i['id']. '" title="Reactivate"><i class="fas fa-check"></i> Reactivate</a>                                    
                                  </div>
                                </div>';


                                    echo '
                            <tr>
                              <td class="name" scope="col">'.$i['name'].'</td>
                              <td class="email" scope="col">'.$i['email'].'</td>
                              <td scope="col">'.$i['smtp_type'].'</td>
                              <td scope="col">'.$i['inactive_reason'].'</td>
                              <td class="action" scope="col">'.$row_actions.'</div>
                          ';
                                    ?>
                                <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>

            </div>
            <!-- /.container-fluid -->

        </div>
        <!-- End of Main Content -->

        <!-- Modal -->
        <div class="modal fade" id="modal-verify-smtp-msg" tabindex="-1" role="dialog" aria-labelledby="editLabel" aria-hidden="true">
            <div class="modal-dialog" role="document" style="margin-top: 10vw;">
                <div class="modal-content">
                    <!-- <div class="modal-header">
                      <h5 class="modal-title" id="editLabel">Notification</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div> -->
                    <div class="modal-body">
                        <h4 class="modal-heading">Notification</h4>
                        <div class="list-smtp-verify-msg"></div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade modal-connect-info" id="modal-connect-info" tabindex="-1" role="dialog" aria-labelledby="editLabel" aria-hidden="true">
            <div class="modal-dialog" role="document" style="margin-top: 10vw;">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editLabel">Gmail</h5>
                    </div>
                    <div class="modal-body"></div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="edit" tabindex="-1" role="dialog" aria-labelledby="editLabel" aria-hidden="true">
            <div class="modal-dialog" role="document" style="margin-top: 10vw;">
                <form action="" method="post">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-12" style="text-align: center;">
                                    <i class="fas fa-envelope" style="font-size:50px;"></i>
                                    <p style="margin-top: 20px; font-size: 30px;margin-bottom: 56px;">Daily Send Limit</p>
                                </div>
                            </div>
                            <input type="hidden" name="update_limit" value="">
                            <input type="hidden" name="type" value="">
                            <div class="form-group">
                                <input type="number" class="form-control" name="limit" value="">
                                <label>0 to unlimited (we recommend not to exceed 200)</label>
                            </div>
                            <div class="checkbox-inline label-inline">
                                <label class="checkbox-label">
                                    <input type="checkbox" class="form-check-input form-control" name="terms" value="" id="defaultCheck1" required="">
                                    <span class="checkbox-custom"></span>
                                </label>
                                <label class="form-check-label" for="defaultCheck1">I have read and agree to these <a href="javascript:void(0);" id="important_notes_toggle">important notes</a></label>
                            </div>
                            <p id="important_notes" class="small mt-2" style="display: none;">
                                When using <?php echo SITE_NAME; ?> you agree to ensure your sending account stays within Google's quota limits and across all email-sending apps.
                                <br/><br/>
                                By using <?php echo SITE_NAME; ?> you are responsible for sending authentic emails and following all pertinent spam laws. If our monitoring system flags your account's sending history we will block this email and disable your account.
                            </p>
                            <div class="modal-footer" style="display: block;text-align: center;">
                                <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                                <button type="submit" class="btn btn-success" style="width:200px;font-size: 21px;">Save changes</button>
                            </div>
                        </div>
                </form>
            </div>
        </div>

        



    </div>


    <div class="modal fade" id="add-smtp" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="form">
                        <form action="" method="post" id="frm-add-smtp">
                            <input type="hidden" name="action" value="add-smtp">
                            <input type="hidden" name="nylas_account_id" class="nylas_account_id">
                            <input type="hidden" name="nylas_access_token" class="nylas_access_token">
                            <div class="row">
                                <div class="col-12" style="text-align: center;">
                                    <i class="fas fa-envelope" style="font-size:50px;"></i>
                                    <p style="margin-top: 20px; font-size: 30px;margin-bottom: 12px;">SMTP Settings <!-- (sending emails) --></p>
                                </div>
                            </div>
                            <div style="margin-bottom:30px;" class="modal-add-smtp-msg"></div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" name="smtp_from_name" required="" placeholder="Sender Name" class="form-control">
                                        <label data-toggle="tooltip" title="Name that will show on the sender name">From Name: *</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" name="from_email" required="" placeholder="sender@domain.com" class="form-control">
                                        <label data-toggle="tooltip" title="Email that will show on the sender" >From Email: *</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" name="user" id="user" required="" placeholder="youremail@domain.com" class="form-control imap_user_pass">
                                        <label data-toggle="tooltip" title="SMTP email that the system will use for sending email" >User (usually your email): *</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="password" name="password" id="password" required="" placeholder="Password" class="form-control imap_user_pass">
                                        <label data-toggle="tooltip" title="Your SMTP email password" >Password: *</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" name="server" id="server" required="" placeholder="mail.sampledomain.com" class="form-control">
                                        <label data-toggle="tooltip" title="SMTP server details can be found on you hosting email setting" >SMTP Server: *</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" name="port" required="" placeholder="587" value="587" class="form-control">
                                        <label data-toggle="tooltip" title="SMTP server port can be found on email settings on the cpanel" >SMTP Port *:</label>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="usessltls" name="usessltls" value="1" checked="checked">
                                        <label class="custom-control-label" for="usessltls">Use SSL/TLS</label>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input imap_user_pass" id="same_as_smtp" name="same_as_smtp" value="1" >
                                        <label class="custom-control-label" for="same_as_smtp">Use the same Username/Password for SMTP & IMAP</label>
                                    </div>
                                </div>
                            </div> <br />
                            <h4 style="margin-bottom:20px;">IMAP Settings (receiving emails)</h4>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" name="imap_username" id="imap_username" required="" placeholder="youremail@domain.com" class="form-control">
                                        <label data-toggle="tooltip" title="IMAP email that the system will use for receiving email" >User (usually your email): *</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="password" id="imap_password" name="imap_password" required="" placeholder="Password" class="form-control">
                                        <label data-toggle="tooltip" title="Your IMAP email password" >Password: *</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" name="imap_server" id="imap_server" required="" placeholder="mail.sampledomain.com" class="form-control">
                                        <label  data-toggle="tooltip" title="IMAP server details can be found on you hosting email setting" >IMAP Server: *</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" name="imap_port" required="" placeholder="993" value="993" class="form-control">
                                        <label data-toggle="tooltip" title="IMAP server port can be found on email settings on the cpanel">IMAP Port *:</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="imap_usessltls" name="imap_usessltls" value="1" checked="checked">
                                        <label class="custom-control-label" for="imap_usessltls">Use SSL/TLS</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">

                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label> Tip: if this is a new email, please use the getting started send speed to warm up your email</label>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer" style="display: block;text-align: center;">
                                <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                                <button type="submit" class="btn btn-success btn-save-nylas-smtp" style="width:200px;font-size: 21px;">Save changes</button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="modal fade" id="add-known-smtp" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="form">
                        <form action="" method="post" id="frm-add-known-smtp">
                            <input type="hidden" name="action" value="add-known-smtp">
                            <input type="hidden" name="nylas_account_id" class="nylas_account_id">
                            <input type="hidden" name="nylas_access_token" class="nylas_access_token">
                            <div class="row">
                                <div class="col-12" style="text-align: center;">
                                    <img src="img/yahoo+outlook.png" style="width:200px;">
                                    <p style="margin-top: 20px; font-size: 30px;margin-bottom: 13px;">Yahoo + Outlook <!-- (sending emails) --></p>
                                </div>
                            </div>
                            <div style="margin-bottom:30px;" class="modal-add-known-smtp-msg"></div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <select name="smtp_type" id="smtp_type" class="form-control">
                                            <option value="">Select Type</option>
                                            <option value="yahoo">Yahoo</option>
                                            <option value="outlook">Outlook</option>
                                            <option value="icloud">iCloud</option>
                                            <option value="hotmail">Hotmail</option>
                                            <option value="aol">Aol</option>
                                        </select>
                                        <label data-toggle="tooltip" title="Name that will show on the sender name">SMTP Type: *</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" name="nylas_known_from_name" required="" placeholder="Sender Name" class="form-control">
                                        <label data-toggle="tooltip" title="Name that will show on the sender name">From Name: *</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" name="from_email" required="" placeholder="sender@domain.com" class="form-control">
                                        <label data-toggle="tooltip" title="Email that will show on the sender" >From Email: *</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="password" name="password" required="" placeholder="Password" class="form-control">
                                        <label data-toggle="tooltip" title="Your SMTP email password" >Password: *</label>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer" style="display: block;text-align: center;">
                                <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                                <button type="submit" class="btn btn-success btn-save-known-smtp" style="width:200px;font-size: 21px;">Save changes</button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <div class="modal fade" id="add-gmail-smtp" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="form">
                        <form action="" method="post" id="frm-add-gmail-smtp">
                            <input type="hidden" name="action" value="add-gmail-smtp">
                            <input type="hidden" name="nylas_account_id" class="nylas_account_id">
                            <input type="hidden" name="nylas_access_token" class="nylas_access_token">
                            <div class="row">
                                <div class="col-12" style="text-align: center;">
                                    <i class="fab fa-google" style="font-size:50px;"></i>
                                    <p style="margin-top: 20px; font-size: 30px;margin-bottom: 13px;">Gmail / G Suite <!-- (sending emails) --></p>
                                </div>
                            </div>
                            <div style="margin-bottom:30px;" class="modal-add-known-smtp-msg"></div>

                            <div id="gmail_part1" class="row" > <!-- part 1 -->
                                <div class="col-md-12" style="text-align: center;">
                                    <label > First, let's <b> enable IMAP</b> access for your Google account </label>
                                </div>

                                <hr size="8" width="90%" color="black">
                                <ul style="list-style-type: none; padding: 0px; margin: 0 auto;margin-bottom: 34px;" class="list-gmail-steps">
                                    <li>1. Log into your Gmail account.</li>
                                    <li>2. Click the <i class='fas fa-cog'></i> gear icon in the top right corner.</li>
                                    <li>3. Click <b>All Settings.</b> </li>
                                    <li>4. Click the <a href="https://mail.google.com/mail/u/0/#settings/fwdandpop" target="_blank"><span style="color: #0064A596;"><strong>Forwording and POP/IMAP</strong></span></a> tab. </li>
                                    <li>5. In the "IMAP access" section, select <strong>Enable IMAP.</strong></li>
                                    <li>6. Click <strong>Save Changes.</strong></li>
                                </ul>
                                <div class="col-12">
                                    <div class="form-group" style="max-width:100% !important; text-align: center;margin-bottom: 0px;">
                                        <button type="button" class="btn btn-success btn-imap-enabled" style="width:250px;font-size: 16px;">Yes, IMAP has been enabled <i class="fas fa-angle-right"></i></button>
                                    </div>
                                </div>
                            </div> <!-- end part 1 -->


                            <div id="gmail_part2" class="row" style="display: none;" > <!-- part 2 -->

                                <div class="col-md-12" style="text-align: center;">
                                    <label >Enable 2-step verification & generate App password</label><br />
                                    <a href="https://www.youtube.com/watch?v=J4CtP1MBtOE&t=10s&ab_channel=TonyTeachesTech" target="_blank"><span style="color: #0064A596;"><strong><i class='fa fa-tv'></i> See tutorial video</strong></span></a>
                                </div>

                                <hr size="8" width="90%" color="black">
                                <ul style="list-style-type: none; padding: 3px; margin: 0 auto;margin-bottom: 9px;" class="list-gmail-steps">
                                    <li>1. Go to your Google Account's <a href=" https://myaccount.google.com/security" target="_blank"><span style="color: #0064A596;"><strong>Security Settings</strong></span></a></li>
                                    <li>2. Enable <strong>2-step verification</strong></li>
                                    <li>3. Create an <a href="https://myaccount.google.com/apppasswords" target="_blank"><span style="color: #0064A596;"><strong>App password</strong></span></a> </li>
                                    <li>  &nbsp&nbsp&nbsp <span style="color: #c1c1c1;">Select 'Other' for both App and Device and name it </span>&nbsp&nbsp&nbsp&nbsp<span style="color: #c1c1c1;">Automailer.</span></li>
                                </ul>

                                <div class="col-12">
                                    <div class="form-group" style="max-width:100% !important; text-align: center;">
                                        <button type="button" class="btn btn-step2-back" style="width:200px;font-size: 21px;">Back </button>
                                        <button type="button" class="btn btn-success btn-step2-next" style="width:200px;font-size: 21px;">Next </button>
                                    </div>
                                </div>

                            </div> <!-- end part 2 -->

                            <div id="gmail_part3" class="row" style="display: none;" > <!-- part 3 -->
                                <input type="hidden" name="gmail_server" id="gmail_server" value="smtp.gmail.com">
                                <input type="hidden" name="gmail_port" id="gmail_port" value="465">
                                <input type="hidden" name="gmail_imap_server" id="gmail_imap_server" value="imap.gmail.com">
                                <input type="hidden" name="gmail_imap_port" id="gmail_imap_server" value="993">

                                <div class="col-12">
                                    <div style="margin-bottom:30px;" class="modal-add-gmail-smtp-msg"></div>
                                </div>

                                <div class="col-6">
                                    <div class="form-group">
                                        <input type="text" name="google_fname" id="google_fname" required="" placeholder="First Name" class="form-control">
                                        <label data-toggle="tooltip" title="First name of the user">First Name: *</label>
                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="form-group">
                                        <input type="text" name="google_lname" id="google_lname" required="" placeholder="Last Name" class="form-control">
                                        <label data-toggle="tooltip" title="Last name of the user">Last Name: *</label>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group" style="max-width:100% !important;">
                                        <input type="text" name="gmail_email" id="gmail_email" required="" placeholder="Email address to connect" class="form-control">
                                        <label data-toggle="tooltip" title="Email that will show on the sender" >Email: *</label>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <label data-toggle="tooltip" title="Use your app password" ><strong>App Password: *</strong></label><br />
                                    <span style="color: #c1c1c1; font-size: 13px;"> Enter your 16 character app password </span><br />
                                    <span style="color: #0064A596; font-size: 13px;"><strong>without any spaces</strong></span>
                                </div>
                                <div class="col-12">
                                    <div class="form-group" style="max-width:100% !important;">
                                        <input type="password" name="app_password" id="app_password" required="" placeholder="App Password" class="form-control">
                                        <label data-toggle="tooltip" title="Email that will show on the sender" ></label>

                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group" style="max-width:100% !important; text-align: center;">
                                        <button type="button" class="btn btn-default btn-step3-back" style="width:200px;font-size: 21px;">Back </button>
                                        <button type="submit" class="btn btn-success btn-save-gmail-changes" style="width:200px;font-size: 21px;">Save changes</button>
                                    </div>
                                </div>
                            </div> <!-- End part 3 -->

                            <div class="modal-footer" style="display: block;text-align: center;">
                                <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>

                            </div>


                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- Modal Delete Confirmation -->
    <!-- <div class="modal fade modal-enhanced modal-danger" id="modalDeleteConfirmation" tabindex="-1" role="dialog" aria-labelledby="modalDeleteConfirmationlabel" aria-hidden="true">
         <div class="modal-dialog modal-md" role="document">
             <form action="#" method="post">
                 <input type="hidden" value="" name="eid" class="eid">
                 <input type="hidden" value="" name="etype" class="etype">
                 <input type="hidden" value="" name="account_id" class="account_id">
                 <div class="modal-content">
                     <div class="modal-header">
                         <h5 class="modal-title"><i class="far fa-trash-alt"></i> Delete</h5>
                         <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                             <span aria-hidden="true">&times;</span>
                         </button>
                     </div>
                     <div class="modal-body">
                         <div class="autoreply-selected-msg"><span class="delete-msg"></span> <strong><span class="eemail"></span></strong> </div>
                         <div class="modal-footer">
                             <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                             <button type="submit" class="btn btn-danger" name="action" value="delete">Yes</button>
                         </div>
                     </div>
                 </div>
             </form>
         </div>
     </div> -->

    <!-- Modal Delete Confirmation -->
    <div class="modal fade modal-enhanced modal-danger" id="modalDeleteConfirmation" tabindex="-1" role="dialog" aria-labelledby="modalDeleteConfirmation" aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <form action="" method="post">
                <input type="hidden" value="" name="eid" class="eid">
                <input type="hidden" value="" name="etype" class="etype">
                <input type="hidden" value="" name="account_id" class="account_id">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="col-md-12">
                            <img src="<?php echo $root; ?>/img/delete-icon.png" class="img-delete">
                            <h3 class="hdr-delete" style="font-size:29px; font-weight: bold;">Are you sure</h3>
                            <div class="list-selected-msg" style="text-align:center;font-size: 18px;"> <span class="delete-msg"></span> <strong><span class="eemail"></span></strong> <br />This process cannot be undone</div>
                        </div>
                        <div class="modal-footer" style="display: block;text-align: center;">
                            <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                            <button type="submit" class="btn btn-danger" name="action" value="delete" style="width:200px;font-size: 21px;">Delete</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Modal Delete Confirmation -->
    <div class="modal fade modal-enhanced modal-danger" id="modalDeleteConfirmation" tabindex="-1" role="dialog" aria-labelledby="modalDeleteConfirmation" aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <form action="" method="post">
                <input type="hidden" value="" name="eid" class="eid">
                <input type="hidden" value="" name="etype" class="etype">
                <input type="hidden" value="" name="account_id" class="account_id">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="col-md-12">
                            <img src="<?php echo $root; ?>/img/delete-icon.png" class="img-delete">
                            <h3 class="hdr-delete" style="font-size:29px; font-weight: bold;">Are you sure?</h3>
                            <div class="list-selected-msg" style="text-align:center;font-size: 18px;"> <span class="delete-msg"></span> <strong><span class="eemail1"></span></strong> <br />This process cannot be undone!</div>
                        </div>
                        <div class="modal-footer" style="display: block;text-align: center;">
                            <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                            <button type="submit" class="btn btn-danger" name="action" value="delete" style="width:200px;font-size: 21px;">Delete</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>


    <!-- Modal Reactivate Confirmation -->
    <div class="modal fade modal-enhanced modal-info" id="modalReactivateConfirmation" tabindex="-1" role="dialog" aria-labelledby="modalReactivateConfirmationlabel" aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <form action="#" method="post">
                <input type="hidden" value="" name="imap_id" id="imap_id">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="fa fa-question"></i> Confirmation</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        Reactivate selected SMTP?
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                            <button type="submit" class="btn btn-success" name="action" value="reactivate">Yes</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- Footer -->
    <footer class="sticky-footer bg-white">
        <div class="container my-auto">
            <div class="copyright text-center my-auto">
                <span>Copyright &copy; <?php echo date('Y'); ?></span>
            </div>
        </div>
    </footer>
    <!-- End of Footer -->

</div>
<!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>
<script src="https://apis.google.com/js/client.js?onload=checkAuth"/></script>


<script>
    $(function() {
        $('#toggle-event').change(function() {
            $('#console-event').html('Toggle: ' + $(this).prop('checked'))
        })
    })
</script>

<script type="text/javascript">
    $(document).on('click', '.btn-edit-smtp-gmail-integration', function(){
        var data_id = $(this).attr('data-key');
        $(".modal-edit-smtp-msg").html("");
        $('#modal-smtp-gmail-edit-' + data_id).modal('show');
    });

    $(document).on('click', '.btn-edit-smtp-integration', function(){
        var data_id = $(this).attr('data-key');
        $(".modal-edit-smtp-msg").html("");
        $('#modal-smtp-edit-' + data_id).modal('show');
    });

    function checkAuth() {
        gapi.auth.authorize({
            'client_id' : "<?php echo $googleClientId; ?>",
            'scope' : 'https://www.googleapis.com/auth/userinfo.profile https://www.googleapis.com/auth/userinfo.email https://mail.google.com/',
            'prompt' : 'consent',
            'access_type' : 'offline',
            'response_type': 'code token',
        }, handleAuthResult);
    }

    function handleAuthResult(authResult) {
        //console.log(authResult);
        var msg1 = '<div class="alert alert-info" role="alert"><img src="'+root_dir+'/img/spinner.gif" /> Connecting Gmail Account...</div>';
        var url = "<?php echo $root; ?>" + "/google_login.php";
        var auth_code = authResult['code'];

        if (typeof auth_code !== "undefined") {
            $.ajax({
                type: 'POST',
                url: url,
                data:{token: authResult['code']},
                dataType: 'json',
                beforeSend: function(data) {
                    $(".modal-connect-info .modal-body").html(msg1);
                    $(".modal-connect-info").modal("show");
                },
                success: function(data) {
                    location.href = root_dir + '/email-accounts';
                },
                error: function(e) {
                    //console.log(e);
                    location.href = root_dir + '/email-accounts';
                }
            });
        }
    }


    function gmail_step1(){
        $("#gmail_part1").show();
        $("#gmail_part2").hide();
        $("#gmail_part3").hide();
        $(".modal-add-gmail-smtp-msg").html("");
    }

    function gmail_step2(){
        $("#gmail_part1").hide();
        $("#gmail_part2").show();
        $("#gmail_part3").hide();
    }

    function gmail_step3(){
        $("#gmail_part1").hide();
        $("#gmail_part2").hide();
        $("#gmail_part3").show();
    }

    $(function(){
        $('.dropdown-submenu > a').on("click", function(e){
            $(this).next('.dropdown-menu').toggle();
            e.stopPropagation();
            e.preventDefault();
        });

        $(".btn-reactivate-imap").click(function(){
            var imap_id = $(this).attr("data-key");

            $("#imap_id").val(imap_id);
            $("#modalReactivateConfirmation").modal("show");

        });


        $(".btn-imap-enabled").click(function(){
            gmail_step2();
        });

        $(".btn-step2-back").click(function(){
            gmail_step1();
        });

        $(".btn-step2-next").click(function(){
            gmail_step3();
        });

        $(".btn-step3-back").click(function(){
            gmail_step2();
        });


        $(".imap_user_pass").keyup(function(){
            update_imap_user_pass();
        });

        $(".imap_user_pass").click(function(){
            update_imap_user_pass();
        });

        function update_imap_user_pass(){
            var user = $('#user').val();
            var pass = $('#password').val();

            if($('#same_as_smtp').prop("checked") == true){
                $('#imap_username').val(user);
                $('#imap_password').val(pass);
            }
        }


        $(".imap_user_pass_edit").keyup(function(){
            update_imap_user_pass_edit();
        });

        $(".imap_user_pass_edit").click(function(){
            update_imap_user_pass_edit();
        });

        function update_imap_user_pass_edit(){
            var user_id = $('.imap_user_pass_edit').attr("data-id");
            var edit_user = $('.edit_user_smtp'+user_id).val();
            var edit_pass = $('.edit_pass_smtp'+user_id).val();

            if($('#same_as_smtp_edit').prop("checked") == true){
                $('.edit_imap_user'+user_id).val(edit_user);
                $('.edit_imap_password'+user_id).val(edit_pass);
            }
        }

        $(".imap_user_pass_gmail").keyup(function(){
            update_gmail_imap_user_pass_edit();
        });

        $(".imap_user_pass_gmail").click(function(){
            update_gmail_imap_user_pass_edit();
        });

        function update_gmail_imap_user_pass_edit(){
            var edit_user = $('.gmail_user').val();
            var edit_pass = $('.gmail_pw').val();

            if($('#same_as_smtp_gmail_edit').prop("checked") == true){
                $('.imap_gmail_user').val(edit_user);
                $('.imap_gmail_pass').val(edit_pass);
            }
        }

        $(".btn-email-delete").click(function(){
            var eid = $(this).attr("data-key");
            var etype = $(this).attr("data-key-db");
            var eemail = $(this).attr("data-key-email");
            var with_campaign = $(this).attr("attr-with-campaign");
            var account_id = $(this).attr("data-key-account-id");
            $(".eid").val(eid);
            $(".etype").val(etype);
            $(".eemail").html(eemail);
            $(".account_id").val(account_id);
            if(with_campaign == 0){
                $(".delete-msg").html("Delete selected email?");
            }else{
                $(".delete-msg").html("Deleting this selected email may cause campaigns that are using it to be interrupted.");
            }


            $("#modalDeleteConfirmation").modal('show');
        });


        $(".btn-update-gmail").click(function(){
            var data_id = $(this).attr("data-key");
            $(".submit-edit-gmail-"+data_id).click();
        });

        $(".btn-edit-outlook-integration").click(function(){
            var data_id = $(this).attr('data-key');
            $(".modal-edit-outlook-msg").html("");
            $('#modal-outlook-edit-' + data_id).modal('show');
        });

        $(".btn-edit-gmail-integration").click(function(){
            var data_id = $(this).attr('data-key');
            $(".modal-edit-gmail-msg").html("");
            $('#modal-gmail-edit-' + data_id).modal('show');
        });
    });
</script>