<?php 
require_once './functions.php';

$q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
$q->execute(array($_SESSION['id']));
$member = $q->fetch(PDO::FETCH_ASSOC);

$q = $pdo->prepare('SELECT * FROM `exclusions` WHERE `id`=? AND `member_id`=? LIMIT 1');
$q->execute(array($_POST['exclusion_id'],$member['id']));
$row = $q->fetch(PDO::FETCH_ASSOC);

if( $row['type'] == exclusionEmail() ){
  $exclusion_email_style  = "";
  $exclusion_domain_style = "display: none;";
  $exclusion_email_value  = $row['exclusion'];
  $exclusion_domain_value = '';
}else{
  $exclusion_email_style  = "display: none;";
  $exclusion_domain_style = "";
  $exclusion_email_value  = '';
  $exclusion_domain_value = $row['exclusion'];
}

?>

<div class="row">                  
  <div class="col-md-12">
    <div class="form-group">
      <select class="form-control add-exclusion-type" name="exclusion_type" data-toggle="tooltip" title="Name that will show on the sender name">
        <option value="1" <?php echo($row['type'] == exclusionEmail() ? 'selected="selected"' : ''); ?>>Email</option>
        <option value="2" <?php echo($row['type'] == exclusionDomain() ? 'selected="selected"' : ''); ?>>Domain</option>
      </select>
      <label>Type: *</label>
    </div>
  </div>
  <div class="col-md-12 add-exclusion-email" style="<?php echo $exclusion_email_style; ?>">
    <div class="form-group">
      <input type="email" name="exclusion_email" data-toggle="tooltip" title="Email to add in exclusion" required="" value="<?php echo $exclusion_email_value; ?>" placeholder="user@domain.com" class="form-control add-exclusion-email">
      <label >Email: *</label>
    </div>
  </div>
  <div class="col-md-12 add-exclusion-domain" style="<?php echo $exclusion_domain_style; ?>">
    <div class="form-group">
      <input type="text" name="exclusion_domain" placeholder="domain.com" data-toggle="tooltip" title="Domain name to add in exclusion" value="<?php echo $exclusion_domain_value; ?>" class="form-control add-exclusion-domain">
      <label>Domain: *</label>
    </div>
  </div>                    
</div>  

<script>
$(function(){
  $(".add-exclusion-type").change(function(){
      var selected = $(this).val();
      if( selected == 1 ){
        $(".add-exclusion-email").show();
        $(".add-exclusion-domain").hide();

        $('.add-exclusion-email').attr('required',true);
        $('.add-exclusion-domain').removeAttr('required');          
      }else{
        $(".add-exclusion-email").hide();
        $(".add-exclusion-domain").show();

        $('.add-exclusion-domain').attr('required',true);
        $('.add-exclusion-email').removeAttr('required');          
      }
    });
});  
</script>