<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PhpImap\Mailbox;
use PhpImap\Exceptions\ConnectionException;

require_once 'config.php'; 
require_once 'functions.php';
require_once 'PHPMailer/autoload.php';
require_once 'Google/autoload.php';
require_once 'swiftmailer/autoload.php';
require_once 'php-imap/autoload.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(600);



$mail = new PHPMailer();

//get today running campaigns
$campaign_sending_done = true;
//$campaigns = $pdo->prepare('SELECT * FROM `campaigns` WHERE `status`=?');
$campaigns 	= $pdo->prepare('SELECT * FROM `campaigns` WHERE `status`=?');
$campaigns->execute(array(CAMPAIGN_STATUS_RUNNING));

//loop through each campaign
foreach ($campaigns as $campaign) {
	//get member info for this campaign
	$q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
	$q->execute(array($campaign['member_id']));
	$member = $q->fetch(PDO::FETCH_ASSOC);

	//exclusions
	$exclusions = $pdo->prepare('SELECT * FROM `exclusions` WHERE `member_id`=?');
	$exclusions->execute(array($member['id']));

	$exclusion_emails  = array();
	$exclusion_domains = array();
	foreach( $exclusions as $ex ){
		$s_exclusion = strtolower($ex['exclusion']);
		if( $ex['type'] == exclusionEmail() ){
			$exclusion_emails[$s_exclusion] = $s_exclusion;
		}else{
			$exclusion_domains[$s_exclusion] = $s_exclusion; 
		}
	}

	//set timzone to the member's timezone
	date_default_timezone_set($member['timezone']);
	$date_today   = strtotime(date("m/d/Y h:i A"));
	$trigger_date = $campaign['trigger_date'];
	if( $trigger_date <= $date_today ){
		//Get unsubscribed list
		$unsubscribed_emails = json_decode($campaign['unsubscribed_emails']);
		//check if campaign stop has JSON
		if(isJSON($campaign['stop_at']))
		{
			$stop_at = json_decode($campaign['stop_at'], 1);
		}
		else
		{
			$stop_at = array();
			$stop_at['type'] = $campaign['stop_at'];
		}

		//select all contacts for this campaign
		$contacts = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=?');
		$contacts->execute(array($campaign['list']));
		$contacts = $contacts->fetchAll();

		//loop through all contacts
		foreach ($contacts as $key => $contact) {

			//remove contact if they replied to an email on this campaign
			if($stop_at['type'] == 'reply')
			{
				$replied = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `to_email`=? AND `replied`=1 LIMIT 1');
				$replied->execute(array($campaign['id'], $contact['email']));
				$replies = $replied->fetch(PDO::FETCH_ASSOC);
				if($replied->rowcount()>0)
				{
					//Replies with Stop Automation will be removed on the list
					$reply_data = $pdo->prepare('SELECT * FROM `auto_replies` WHERE `sent_mail_id`=?  LIMIT 1');
                    $reply_data->execute(array($replies['id']));
                    $sent_mail = $reply_data->fetch(PDO::FETCH_ASSOC);
                    if($sent_mail['status']==1){ 
					    unset($contacts[$key]);
				    }// if the status is set to 0 = Continue Automation it will not be unset on the list

				    //if the sent mail has no record on the auto replies it will be unset on the list
				    if($reply_data->rowcount()<=0)
					{
						unset($contacts[$key]);	
					}
				}
			}

		}

		//get emails for this campaign
		$emails = json_decode($campaign['data'], 1);
		$eid = sha1($campaign['id'] . SITE_ENCRYPTION_KEY);
	    //loop through contacts again
		foreach ($contacts as $contact) {

			//remove spaces from contact email
			$contact['email'] = trim($contact['email']);
			
			$i = 0;


			//loop through email
			foreach ($emails as $email) {

				unset($send);

				//generate a unique identifier for this email and contact
				$identifier = base64_encode($email['subject'].$email['email_number'].$contact['id'].$email['trigger'].$campaign['id']);
				//mail footer unsubscribe
				//$eid 	= crypt_jm($campaign['id']);
				$link   = AUTOMAILER_TRACKER_URL ."/_unsubscribe.php?email=".$contact['email']."&eid=".$eid;
				$mail_footer = "<br /><br />";
    			$mail_footer .= "<a href='".$link."'>Unsubscribe</a><br />";
				//replace all links with a trackable redirect
				$email['body'] = str_replace(
					array(
						'href="http://',
						'href="https://'
					),
					array(
						'target="_blank" href="'.AUTOMAILER_TRACKER_URL.'/_track_link.php?identifier='.$identifier.'&link=http://',
						'target="_blank" href="'.AUTOMAILER_TRACKER_URL.'/_track_link.php?identifier='.$identifier.'&link=https://'
					),
					$email['body']
				);

				//replace all default tags with contact values in body of email
				$email['body'] = str_replace('{firstName}', $contact['firstName'], $email['body']);
				$email['body'] = str_replace('{lastName}', $contact['lastName'], $email['body']);
				$email['body'] = str_replace('{email}', $contact['email'], $email['body']);
 
				//replace all default tags with contact values in subject of email
				$email['subject'] = str_replace('{firstName}', $contact['firstName'], $email['subject']);
				$email['subject'] = str_replace('{lastName}', $contact['lastName'], $email['subject']);
				$email['subject'] = str_replace('{email}', $contact['email'], $email['subject']);

				//get custom tag names
				$tagData = json_decode($contact['data'], 1);

				//replace all custom tags with contact values in subjuct and body
				foreach ($tagData as $key => $value) {
					$email['body'] = str_replace('{'.$key.'}', $value, $email['body']);
					$email['subject'] = str_replace('{'.$key.'}', $value, $email['subject']);
				}

				$is_first_email = false;
				
				if($i == 0)
				{
				   //if first email, no trigger necessary				   
				   $day = date("l");
				   $sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
				   $sent->execute(array($identifier));
				   if($sent->rowcount()<1)
				   {
				   	  	if($day == "Monday" && $email['is_mon']==1){
							//unset($send);
							$send = 1;
						}
						if($day == "Tuesday" && $email['is_tues']==1){
							//unset($send);	
							$send = 1;
						}
						if($day == "Wednesday" && $email['is_wed']==1){
							//unset($send);
							$send = 1;
						}
						if($day == "Thursday" && $email['is_thur']==1){
							//unset($send);
							$send = 1;
						}
						if($day == "Friday" && $email['is_fri']==1){
							//unset($send);
							$send = 1;
						}
						if($day == "Saturday" && $email['is_sat']==1){
							//unset($send);
							$send = 1;
						}
						if($day == "Sunday" && $email['is_sun']==1){
							//unset($send);
							$send = 1;
						}

					  if( $send == 1 ){
					  	$is_first_email = true;
					  }				   	  
				   }
				}
				else
				{
					//minus 1 from email number to match the email array
					$email_number = $email['email_number']-1;

					//Time Condition for the email for the day
					/*$time_of_the_day = $email['days_after_time'];
					$time_today = date("m/d/Y h:i A");
					$am_pm = date("a", $time_today);
					$time_minutes = date("i", $time_today);
					$time_of_the_day_sched = "";				
					$time =  date("h:i A");
					$time1 = $email['send_email_time_from'];
					$time2 = $email['send_email_time_to'];
					$day = date('l', strtotime($time_today));
					$time_hours =  date("H", strtotime($time1));
					if($email['is_allday'] == 1){
							$time_of_the_day_sched = " +". $time_hours ." hour";					
					}
					if($day == "Monday" && $email['is_mon']==1){
							$time_of_the_day_sched = " +". $time_hours ." hour";
					}
					if($day == "Tuesday" && $email['is_tues']==1){
							$time_of_the_day_sched = " +". $time_hours ." hour";
					}
					if($day == "Wednesday" && $email['is_wed']==1){
							$time_of_the_day_sched = " +". $time_hours ." hour";
					}
					if($day == "Thursday" && $email['is_thur']==1){
							$time_of_the_day_sched = " +". $time_hours ." hour";
					}
					if($day == "Friday" && $email['is_fri']==1){
							$time_of_the_day_sched = " +". $time_hours ." hour";
					}
					if($day == "Saturday" && $email['is_sat']==1){
							$time_of_the_day_sched = " +". $time_hours ." hour";
					}
					if($day == "Sunday" && $email['is_sun']==1){
							$time_of_the_day_sched = " +". $time_hours ." hour";
					}*/

					//get the trigger email identifier
					$trigger_identifier = base64_encode($emails[$email_number]['subject'].$emails[$email_number]['email_number'].$contact['id'].$emails[$email_number]['trigger'].$campaign['id']);

					//get the trigger email if it was sent
					$trigger_email = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
					$trigger_email->execute(array($trigger_identifier));
					if($trigger_email->rowcount()>0)
					{

						//get trigger email data
						$trigger_email = $trigger_email->fetch(PDO::FETCH_ASSOC);

						//check if email is based on days after
						if(!empty($email['days_after']) && $email['days_after']>0)
						{

							$time_passed = strtotime('+'.$email['days_after'].' days', $trigger_email['last_activity'])<time();

							/* Validation for no send on the day */
							$is_days_after_lapse = true;
							$day = date("l");
							if( $email['days_after'] > 0 ){
								//Base start date in last_activity date
								$add_days   = $email['days_after'];
								$date_start = date("Y-m-d",$trigger_email['last_activity']);
								$date_after_start = date("Y-m-d", strtotime($date_start . " +1 {$add_days} days"));
								if( strtotime($date_after_start) > strtotime($date_start) ){ //Validate if start date lapse the days after
									$is_days_after_lapse = false;
								}
							}
							echo "Subject : " . $email['subject'] . "/ Date : " . $date_start . '/' . $date_after_start;
							if($day == "Monday" && $email['is_mon']==1 && $is_days_after_lapse==true){
								//unset($send);
								$send = 1;
							}
							if($day == "Tuesday" && $email['is_tues']==1 && $is_days_after_lapse==true){
								//unset($send);	
								$send = 1;
							}
							if($day == "Wednesday" && $email['is_wed']==1 && $is_days_after_lapse==true){
								//unset($send);
								$send = 1;
							}
							if($day == "Thursday" && $email['is_thur']==1 && $is_days_after_lapse==true){
								//unset($send);
								$send = 1;
							}
							if($day == "Friday" && $email['is_fri']==1 && $is_days_after_lapse==true){
								//unset($send);
								$send = 1;
							}
							if($day == "Saturday" && $email['is_sat']==1 && $is_days_after_lapse==true){
								//unset($send);
								$send = 1;
							}
							if($day == "Sunday" && $email['is_sun']==1 && $is_days_after_lapse==true){
								//unset($send);
								$send = 1;
							}

							switch ($email['trigger']) {
								case 'no_condition':
								    //check if trigger email no condition
								    //if($time_passed)
								    //{
								    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
								    	$sent->execute(array($identifier));
								    	/*if($sent->rowcount()<1){
								    		$send = 1;
								    	}*/
								    	if($sent->rowcount()>0){
								    		$send = 0;
								    	}
								    //}
									break;	
								case 'opened':
								    //check if trigger email was opened
								    //if($time_passed && $trigger_email['opened'] == 1)
									if($trigger_email['opened'] == 1)
								    {
								    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
								    	$sent->execute(array($identifier));
								    	if($sent->rowcount()>0)
								    	{
								    		 $send = 0;
								    	}
								    }
									break;
								case 'unopened':
								    //check if trigger email was not opened
								    if($trigger_email['opened'] == 0)
								    {
								    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
								    	$sent->execute(array($identifier));
								    	if($sent->rowcount()>0)
								    	{
								    		$send = 0;
								    	}
								    }
									break;
								case 'has_click':
								    $links = $pdo->prepare('SELECT * FROM `links_clicked` WHERE `identifier`=? AND `link`=?');
								    $links->execute(array($trigger_identifier, $email['link']));
								    //if($links->rowcount()>0 && $time_passed)
								    if($links->rowcount()>0)
								    {
								    	$send = 1;
								    }
									break;
							}
						}
						else
						{
							//email is based on a date and time
							switch ($email['trigger']) {
								case 'no_condition':
								    //check if trigger email no condition
								    if($email['time']<time())
								    {
								    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
								    	$sent->execute(array($identifier));
								    	if($sent->rowcount()<1)
								    	{
								    		$send = 1;
								    	}
								    }
									break;	
								case 'opened':
								    //check if trigger email was opened
								    if($email['time']<time() && $trigger_email['opened'] == 1)
								    {
								    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
								    	$sent->execute(array($identifier));
								    	if($sent->rowcount()<1)
								    	{
								    		 $send = 1;
								    	}
								    }
									break;
								case 'unopened':
								    //check if trigger email was not opened
								    if($email['time']<time() && $trigger_email['opened'] == 0)
								    {
								    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
								    	$sent->execute(array($identifier));
								    	if($sent->rowcount()<1)
								    	{
								    		$send = 1;
								    	}
								    }
									break;
								case 'has_click':
								    $links = $pdo->prepare('SELECT * FROM `links_clicked` WHERE `identifier`=? AND `link`=?');
								    $links->execute(array($trigger_identifier, $email['link']));
								    if($links->rowcount()>0 && $email['time']<time())
								    {
								    	$send = 1;
								    }
									break;								
							}
						}
					}

				}

					/*if($day == "Monday" && $email['is_mon']==0){
						unset($send);
					}
					if($day == "Tuesday" && $email['is_tues']==0){
						unset($send);	
					}
					if($day == "Wednesday" && $email['is_wed']==0){
						unset($send);
					}
					if($day == "Thursday" && $email['is_thur']==0){
						unset($send);
					}
					if($day == "Friday" && $email['is_fri']==0){
						unset($send);
					}
					if($day == "Saturday" && $email['is_sat']==0){
						unset($send);
					}
					if($day == "Sunday" && $email['is_sun']==0){
						unset($send);
					}*/

				//echo  $email['subject'] . '/ is send : ' . $send . "<br />";

				/*
				 * Validation for send weekend
				*/
					if($email['send_weekend'] == 1){
						$date = $email['time'];
						if( date('N', $date) < 6 ){
							//if date not Weekend change to next monday
					        $to_send_date = date('Y-m-d', strtotime('next monday', $date)); //Target date to send if set on weekend
					        $today 		  = date("Y-m-d");
					        if( $to_send_date != $today ){
					        	$send = 0;
					        }
						}
					}				
				/* End send weekend validation */

			
				if( $is_first_email ){
					$send = 1;					
				}

				echo "This is First Email Subject : " . $email['subject'] . "/" . $send . "<br />";




				//echo "First Email Subject : " . $email['subject'] . "/" . $send . "<br />";
				if($send > 0)
				{
					if( !in_array($contact['email'], $unsubscribed_emails) ){ //Must not send or create if in unsubscribed list

						//Must not send if in exclusion list
						$email_domain_name = substr(strrchr($contact['email'], "@"), 1);
						if( !in_array(strtolower($contact['email']), $exclusion_emails) && !in_array(strtolower($email_domain_name), $exclusion_domains) ){
							//email sending
							switch ($email['send_server']) {

								case 'gmail':

									$gmail = $pdo->prepare('SELECT * FROM `gmail_accounts` WHERE `id`=?');
									$gmail->execute(array($email['send_id']));
									$gmail = $gmail->fetch(PDO::FETCH_ASSOC);

									$send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
									$send_limit->execute(array($gmail['email'], time()-86400));

									if($gmail['send_limit'] == 0)
									{
										$gmail['send_limit'] = $send_limit->rowcount()+1;
									}

									if(isset($gmail['email']) && $send_limit->rowcount()<$gmail['send_limit'])
									{

										$client = new Google_Client();
										$client->setClientId($clientId);
										$client->setClientSecret($clientSecret);
										$client->setAccessToken($gmail['access_token']);
										$client->refreshToken($gmail['refresh_token']);

										$accessToken = $client->getAccessToken();

										$refreshToken = $pdo->prepare('UPDATE `gmail_accounts` SET `access_token`=?, `refresh_token`=? WHERE `id`=?');
										$refreshToken->execute(array($accessToken['access_token'], $accessToken['refresh_token'], $gmail['id']));

										$service = new \Google_Service_Gmail($client);
										$mailer = $service->users_messages;

										if(!empty($campaign['bcc']))
										{
											$message = (new \Swift_Message($email['subject']))
											    ->setFrom($gmail['email'], $gmail['firstName'])
											    ->setTo([$contact['email']])
											    ->setBcc([$campaign['bcc']])
											    ->setContentType('text/html')
											    ->setCharset('utf-8')
											    ->setBody($email['body'].$mail_footer.' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier.'"/>');
										}
										else
										{
											$message = (new \Swift_Message($email['subject']))
											    ->setFrom($gmail['email'], $gmail['firstName'])
											    ->setTo([$contact['email']])
											    ->setContentType('text/html')
											    ->setCharset('utf-8')
											    ->setBody($email['body'].$mail_footer.' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier.'"/>');
										}

										$encoded = base64url_encode($message->toString());

										$message = new \Google_Service_Gmail_Message();
										$message->setRaw($encoded);
										$message = $mailer->send('me', $message);

										$sent = $pdo->prepare('INSERT INTO `sent_mails` (`campaign_id`, `subject`, `from_email`, `to_contact`, `to_email`, `opened`, `replied`, `last_activity`, `identifier`, `member_id`, `id`) VALUES (?,?,?,?,?,?,?,?,?,?,?)');
										$sent->execute(array($campaign['id'], $email['subject'], $gmail['email'], $contact['id'], $contact['email'], 0, 0, time(), $identifier, $campaign['member_id'], NULL));
									}else{
										$campaign_sending_done = false;
									}

									break;

								case 'smtp':

									$smtp = $pdo->prepare('SELECT * FROM `smtp` WHERE `id`=?');
									$smtp->execute(array($email['send_id']));
									$smtp = $smtp->fetch(PDO::FETCH_ASSOC);

									$send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
									$send_limit->execute(array($smtp['from_email'], time()-86400));

									if($smtp['send_limit'] == 0)
									{
										$smtp['send_limit'] = $send_limit->rowcount()+1;
									}
									//$smtp['send_limit'] = 10000;
									$smtp['port'] > 465 ? $mail->SMTPSecure = 'TLS' : $mail->SMTPSecure = 'SSL';
									if(isset($smtp['from_email']) && $send_limit->rowcount()<$smtp['send_limit'])
									{
										$mail->IsSMTP();
										$mail->Host = $smtp['server'];
										$mail->SMTPAuth = true;
										$mail->SMTPDebug = 2;
										$mail->Username = $smtp['user'];
										$mail->Password = crypt_jm($smtp['password'],'d');
										$mail->Port = $smtp['port'];
										$mail->IsHTML(true);                             
										$mail->setFrom($smtp['from_email']);
										$mail->FromName = $smtp['from_name'];
										$mail->addCustomHeader('In-Reply-To', $identifier);
										$mail->AddAddress($contact['email']);
										if(!empty($campaign['bcc']))
										{
											$mail->addBcc($campaign['bcc']);
										}
										$mail->Subject = $email['subject'];
										
										$message = $email['body'];
										if($smtp['digital_sign']){
										   $message .= $smtp['digital_sign'];
										}
										$message = $message.$mail_footer.' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier.'"/>';
										
										$mail->Body = $message;
										$mail->AltBody = strip_tags($message);
										$mail->Send();
										$sent = $pdo->prepare('INSERT INTO `sent_mails` (`campaign_id`, `subject`, `from_email`, `to_contact`, `to_email`, `opened`, `replied`, `last_activity`, `identifier`, `member_id`, `id`) VALUES (?,?,?,?,?,?,?,?,?,?,?)');
										$mail->ClearAllRecipients();
										$sent->execute(array($campaign['id'], $email['subject'], $smtp['from_email'], $contact['id'], $contact['email'], 0, 0, time(), $identifier, $campaign['member_id'], NULL));
									}else{
										$campaign_sending_done = false;
									}

									break;
							}
						}
					}
				}

				$i++;
			}
		}
		//Update campaign status to paused - already triggered and all emails are sent
		if( $campaign_sending_done ){
			//$emails = json_decode($campaign['data'], 1);
			$campaign_count = 0;
	        foreach ($emails as $email) {
	       		$campaign_count++;
	        } 
	        if( $campaign_count == 1 ){
	        	$sql = "UPDATE campaigns SET status=? WHERE id=?";
				$q = $pdo->prepare($sql);
				$q->execute(array(CAMPAIGN_STATUS_PAUSED, $campaign['id']));
	        }elseif($campaign_count > 1){
	     //        $campaign_countx = 1;
	     //        //Loop through the email again and get the followup email checked
	     //    	foreach ($emails as $email) {
		    //    		if($campaign_count == $campaign_countx){
		    //    			$email_number = $email['email_number']-1;
						// //get the trigger email identifier
						// $trigger_identifier = base64_encode($emails[$email_number]['subject'].$emails[$email_number]['email_number'].$contact['id'].$emails[$email_number]['trigger'].$campaign['id']);

						// //get the trigger email if it was sent then will pause the campaign
						// $trigger_email = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
						// $trigger_email->execute(array($trigger_identifier));
						// if($trigger_email->rowcount()>0){
						// 	$sql = "UPDATE campaigns SET status=? WHERE id=?";
						// 	$q = $pdo->prepare($sql);
						// 	$q->execute(array("paused", $campaign['id']));
						// }
		    //    		}
		    //    		$campaign_countx++;
		    //     } 
	        }
		}

	}
}

exit;
$date = date("Y-m-d");
$default_followup_date = defaultFollowupDate($date);

$q = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `replied`=?');
$q->execute(array(0));

foreach ($q as $row) {
	
	$is_updated = false;

	$gmail = $pdo->prepare('SELECT * FROM `gmail_accounts` WHERE `email`=?');
	$gmail->execute(array($row['from_email']));

	if($gmail->rowcount()>0)
	{
		$gmail = $gmail->fetch(PDO::FETCH_ASSOC);

		$client = new Google_Client();
		$client->setClientId($clientId);
		$client->setClientSecret($clientSecret);
		$client->setAccessToken($gmail['access_token']);
		$client->refreshToken($gmail['refresh_token']);

		$accessToken = $client->getAccessToken();

		$refreshToken = $pdo->prepare('UPDATE `gmail_accounts` SET `access_token`=?, `refresh_token`=? WHERE `id`=?');
		$refreshToken->execute(array($accessToken['access_token'], $accessToken['refresh_token'], $gmail['id']));

		$messages = new Google_Service_Gmail($client);

		$list = $messages->users_messages->listUsersMessages('me',
			[
				'q' => 'from:'.$row['to_email'].' AND to:'.$row['from_email'].' AND subject:'.$row['subject'],
				'maxResults' => 10
		]);

		if($row['from_email'] !== $row['to_email'])
		{
			if(count($list->messages)>0)
			{
				$replied = $pdo->prepare('UPDATE `sent_mails` SET `replied`=1, `last_activity`=? WHERE `id`=?');
				$replied->execute(array(time(), $row['id']));
			}
		}

	}

	// IMAP non ssl
	$imap = $pdo->prepare('SELECT * FROM `imap` WHERE `user`=?');
	$imap->execute(array($row['from_email']));
	if($imap->rowcount()>0) {
		
		$imap = $imap->fetch(PDO::FETCH_ASSOC);

		if( $imap['is_ssl'] == 1 ){
			$mailbox_server = '{'.$imap['server'].':'.$imap['port'].'/imap/ssl}INBOX';
		}else{
			$mailbox_server = '{'.$imap['server'].':'.$imap['port'].'/imap}INBOX';
		}

		$mailbox = new Mailbox(
		    $mailbox_server,
		    $imap['user'],
		    crypt_jm($imap['password'],'d'),
		    __DIR__,
		    'US-ASCII'
		);
		$identifier = $row['identifier'];
		try {
		   $subject = str_replace("@", "", $row['subject']);
		   $mail_ids = $mailbox->searchMailbox('SUBJECT "'.$subject.'"');

		} catch(ConnectionException $ex) {
		    die("IMAP connection failed: " . $ex->getMessage());
		}

		foreach ($mail_ids as $mail_id) {
		    $email = $mailbox->getMail(
		        $mail_id,
		        false
		    );

		    $email_content_raw = htmlentities($email->textHtml);
		    $strpos = strpos($email_content_raw, $identifier);
		    if($strpos !== false){

			    $autoq = $pdo->prepare('SELECT * FROM `auto_replies` WHERE `sent_mail_id`=?');
	            $autoq->execute(array($row['id']));
	            $is_with_auto_reply = false;

	            if($autoq->rowcount()<=0){            	
	            	//Check for auto reply
				    $content = $email->textPlain;
				    $search_pattern = autoReplyStringPattern();
				    foreach($search_pattern as $a){
				    	if(searchContent($a, $content)){
		              		//Save autoreply
				    		$data = array(
				    			NULL,
				    			$row['id'],
				    			strtotime($default_followup_date),
				    			strtotime($email->date),
				    			$content,
				    			0,
				    			$row['member_id']
				    		);
				    		
				    		$q = $pdo->prepare('INSERT INTO `auto_replies` VALUES (?,?,?,?,?,?,?)');		    		
				    		$result = $q->execute($data);
				    		$is_with_auto_reply = true;

				    		break;		
				    	}
				    }
	            }

	            $leads = $pdo->prepare('SELECT * FROM `leads` WHERE `sent_mail_id`=?');
	            $leads->execute(array($row['id']));
	            if($leads->rowcount()<=0){
	            	if( !$is_with_auto_reply ){
	            		$campaign_imap = $pdo->prepare('SELECT * FROM `campaigns` WHERE `id`=?');
						$campaign_imap->execute(array($row['campaign_id']));
						$campaign_imap_id = $campaign_imap->fetch(PDO::FETCH_ASSOC);
	            		//if(strtotime($email->date) >= $campaign_imap_id['trigger_date']){
		            		$data = array(
				    			NULL,
				    			$row['id'],
				    			strtotime($default_followup_date),
				    			strtotime($email->date),
				    			$email->textPlain,
				    			0,
				    			$row['member_id']
				    		);
				    		$q = $pdo->prepare('INSERT INTO `leads` VALUES (?,?,?,?,?,?,?)');
				    		$result = $q->execute($data);
			    		// }
	            	}
	            }

			    // echo ->textHtml; for reply html
			    if(!empty($email->fromAddress)){
			    	$replied = $pdo->prepare('UPDATE `sent_mails` SET `replied`=1, `last_activity`=? WHERE `id`=?');
			    	$replied->execute(array(time(), $row['id']));
			    	$is_updated = true;
			    }
			}
		}

		$mailbox->disconnect();
	}

}

/*Lead Replies*/
/*$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `is_sent`=? AND `is_with_reply`=?');
$q->execute(array(0,0));*/
$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `is_sent`=? ');
$q->execute(array(0));
foreach( $q as $row ){
	$data = $pdo->prepare('SELECT * FROM `campaigns` WHERE `id`=?');
	$data->execute(array($row['campaign_id']));
	$campaign = $data->fetch(PDO::FETCH_ASSOC);

	$data = $pdo->prepare('SELECT * FROM `leads` WHERE `id`=?');
	$data->execute(array($row['lead_id']));
	$lead = $data->fetch(PDO::FETCH_ASSOC);

	$data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `id`=?');
	$data->execute(array($lead['sent_mail_id']));
	$sent_mail = $data->fetch(PDO::FETCH_ASSOC);
    $identifier_smtp = $sent_mail['identifier'];

	$emails = json_decode($campaign['data'], 1);

	$is_sent = false;

	foreach ($emails as $email) {
		if( $email['subject'] == $sent_mail['subject'] ){

			//email sending
			switch ($email['send_server']) {

				case 'gmail':

					$gmail = $pdo->prepare('SELECT * FROM `gmail_accounts` WHERE `id`=?');
					$gmail->execute(array($email['send_id']));
					$gmail = $gmail->fetch(PDO::FETCH_ASSOC);

					$send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
					$send_limit->execute(array($gmail['email'], time()-86400));

					if($gmail['send_limit'] == 0)
					{
						$gmail['send_limit'] = $send_limit->rowcount()+1;
					}

					if(isset($gmail['email']) && $send_limit->rowcount()<$gmail['send_limit'])
					{

						$client = new Google_Client();
						$client->setClientId($clientId);
						$client->setClientSecret($clientSecret);
						$client->setAccessToken($gmail['access_token']);
						$client->refreshToken($gmail['refresh_token']);

						$accessToken = $client->getAccessToken();

						$refreshToken = $pdo->prepare('UPDATE `gmail_accounts` SET `access_token`=?, `refresh_token`=? WHERE `id`=?');
						$refreshToken->execute(array($accessToken['access_token'], $accessToken['refresh_token'], $gmail['id']));

						$service = new \Google_Service_Gmail($client);
						$mailer = $service->users_messages;

						if(!empty($campaign['bcc']))
						{
							$message = (new \Swift_Message($email['subject']))
							    ->setFrom($gmail['email'], $gmail['firstName'])
							    ->setTo([$contact['email']])
							    ->setBcc([$campaign['bcc']])
							    ->setContentType('text/html')
							    ->setCharset('utf-8')
							    ->setBody($row['msg'].$mail_footer.' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier.'"/>');
						}
						else
						{
							$message = (new \Swift_Message($email['subject']))
							    ->setFrom($gmail['email'], $gmail['firstName'])
							    ->setTo([$contact['email']])
							    ->setContentType('text/html')
							    ->setCharset('utf-8')
							    ->setBody($email['body'].$mail_footer.' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier.'"/>');
						}

						$encoded = base64url_encode($message->toString());

						$message = new \Google_Service_Gmail_Message();
						$message->setRaw($encoded);
						$message = $mailer->send('me', $message);

						$is_sent = true;
						
					}

					break;

				case 'smtp':

					$smtp = $pdo->prepare('SELECT * FROM `smtp` WHERE `id`=?');
					$smtp->execute(array($email['send_id']));
					$smtp = $smtp->fetch(PDO::FETCH_ASSOC);

					$send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
					$send_limit->execute(array($smtp['from_email'], time()-86400));

					if($smtp['send_limit'] == 0)
					{
						$smtp['send_limit'] = $send_limit->rowcount()+1;
					}
					
					$smtp['port'] > 465 ? $mail->SMTPSecure = 'TLS' : $mail->SMTPSecure = 'SSL';
					if(isset($smtp['from_email']) && $send_limit->rowcount()<$smtp['send_limit'])
					{
						$mail->IsSMTP();
						$mail->Host = $smtp['server'];
						$mail->SMTPAuth = true;
						$mail->SMTPDebug = 2;
						$mail->Username = $smtp['user'];
						$mail->Password = crypt_jm($smtp['password'],'d');
						$mail->Port = $smtp['port'];
						$mail->IsHTML(true);                             
						$mail->setFrom($smtp['from_email']);
						$mail->FromName = $smtp['from_name'];
						$mail->addCustomHeader('In-Reply-To', $identifier);
						$mail->AddAddress($sent_mail['to_email']);
						if(!empty($campaign['bcc']))
						{
							$mail->addBcc($campaign['bcc']);
						}
						$mail->Subject = $email['subject'];
						$message = $row['msg'];
						$mail->Body = $message . ' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier_smtp.'"/>';
						$mail->AltBody = strip_tags($message);
						$mail->Send();

						$is_sent = true;
						
					}

					break;
			}

			if( $is_sent ){
				//Update lead_replies flag is_sent field to 1
				$q = $pdo->prepare('UPDATE `lead_replies` SET `is_sent`=? WHERE `id`=?');
				$q->execute(array(1,$row['id']));
				$is_sent = false;
			}

			break;
		}		
		
	}
}

/*$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `is_sent`=? AND `is_with_reply`=?');
$q->execute(array(0,0));*/
$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `is_with_reply`=?');
$q->execute(array(0));
foreach( $q as $row ){
	$is_checked = false;
	$data = $pdo->prepare('SELECT * FROM `leads` WHERE `id`=?');
	$data->execute(array($row['lead_id']));
	$lead = $data->fetch(PDO::FETCH_ASSOC);

	$data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `id`=?');
	$data->execute(array($lead['sent_mail_id']));
	$sent_mail = $data->fetch(PDO::FETCH_ASSOC);
	$identifier = $sent_mail['identifier'];

	$data = $pdo->prepare('SELECT * FROM `campaigns` WHERE `id`=?');
	$data->execute(array($sent_mail['campaign_id']));
	$campaign = $data->fetch(PDO::FETCH_ASSOC);

	// IMAP non ssl
	$imap = $pdo->prepare('SELECT * FROM `imap` WHERE `user`=?');
	$imap->execute(array($sent_mail['from_email']));
	if($imap->rowcount()>0) {
		
		$imap = $imap->fetch(PDO::FETCH_ASSOC);

		if( $imap['is_ssl'] == 1 ){
			$mailbox_server = '{'.$imap['server'].':'.$imap['port'].'/imap/ssl}INBOX';
		}else{
			$mailbox_server = '{'.$imap['server'].':'.$imap['port'].'/imap}INBOX';
		}

		$mailbox = new Mailbox(
		    $mailbox_server,
		    $imap['user'],
		    crypt_jm($imap['password'],'d'),
		    __DIR__,
		    'US-ASCII'
		);

		try {
		   $subject = str_replace("@", "", $sent_mail['subject']);
		   $mail_ids = $mailbox->searchMailbox('SUBJECT "'.$subject.'"');

		} catch(ConnectionException $ex) {
		    die("IMAP connection failed: " . $ex->getMessage());
		}
		
		foreach ($mail_ids as $mail_id) {
		    $email = $mailbox->getMail(
		        $mail_id,
		        false
		    );

		    if(!empty($email->fromAddress)){

		    	$email_content_raw = htmlentities($email->textHtml);
			    $strpos = strpos($email_content_raw, $identifier);
			    if($strpos !== false){

			    	$count_replies = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `mail_id`=?');
					$count_replies->execute(array($mail_id));
					$count_replies = $count_replies->fetch(PDO::FETCH_ASSOC);

					if( !$count_replies ){
						if( strtotime($email->date) >= $campaign['trigger_date'] ){ //To prevent fetching old msg with same subject
							//Insert lead reply
					    	$data = array(
					    		NULL,
					    		$row['lead_id'],
					    		$sent_mail['campaign_id'],
					    		$email->textHtml,
					    		strtotime($email->date),
					    		1,
					    		1,
					    		$mail_id
					    	);
					    	$q = $pdo->prepare('INSERT INTO `lead_replies` VALUES (?,?,?,?,?,?,?,?)');		    		
							$result = $q->execute($data);

							$q = $pdo->prepare('UPDATE `lead_replies` SET `is_with_reply`=? WHERE `id`=?');		    		
							$result = $q->execute(array(1,$row['id']));
						}					
					}	
		    		$is_checked = true;
		    	}
		    }
		}

		$mailbox->disconnect();
	}

}

/* this will set is_with_reply to 0 to check if the lead have new reply on email */
$datas = $pdo->prepare('SELECT * FROM `leads`');
$datas->execute(array());
foreach ($datas as $data) {
	$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `lead_id`=? LIMIT 1');
    $q->execute(array($data['id']));	
    $lead = $q->fetch(PDO::FETCH_ASSOC);

    $l = $pdo->prepare('UPDATE `lead_replies` SET `is_with_reply`=? WHERE `id`=?');
	$l->execute(array(0,$lead['id']));
}

?>