<title><?php echo SITE_NAME; ?> - Tutorials</title>
<style>
    .tutorial-header{
        font-size: 21px;
        margin: 3px 0px;
        background-color: #0B92FB;
        color: #ffffff;
        padding: 10px;
    }
    .box-shadow {
        -webkit-box-shadow: 0 10px 6px -6px #777;
        -moz-box-shadow: 0 10px 6px -6px #777;
        box-shadow: 0 10px 6px -6px #777;
    }
    .help-page {
        background: #F8F7FC;
        padding: 25px; font-family: 'Inter', sans-serif;
    }
    .help-head h3 {
        font-family: 'Inter', sans-serif;
        font-weight: 700;
        font-size:24px; line-height:30px; margin:0;
    }
    .help-search button {
        width: 54px;
        height: 38px;
        background: #343A40;
        border-radius: 0 6px 6px 0;
        border: none;
        color: #fff;
        margin: 0;
        padding: 0;
        font-weight:600;
        font-size:16px;
    }
    .help-search {
        display: flex;
    }
    .help-search input[type="text"] {
        background: #FFFFFF;
        border: 1px solid #CED4DA;
        border-radius: 6px 0 0 6px;
        height: 38px;
        width: calc(100% - 56px);
        border-right: none;
        padding: 5px 15px;
        font-weight:400;
        font-size:16px;
    }
    .right-bar .tab{
        display: none;
    }
    .right-bar .tab-active{
        display: block;
    }
    ul.left-bar-nav {
        border: 1px solid #DEE2E6;
        background: #fff;
        border-radius: 6px;
        overflow: hidden;
        list-style: none;
        padding: 0;
        margin: 0;
        margin-left: 10px;
    }
    ul.left-bar-nav li {
        border-top: 1px solid #DEE2E6;
        display: block;
        margin-top: -1px;
    }
    .tab-a {
        font-size: 16px;
        line-height: 28px;
        color: #404040;
        font-family: 'Inter', sans-serif;
        font-weight: 400;
        display: block;
        padding: 11px 15px;
    }
    .tab-a.active, .tab-a:hover {
        background: #0064A5;
        color: #fff;
    }
    .left-bar {
        /*width: 293px !important;*/
        width: 20%;
        margin: 25px 0;
    }
    .right-bar {
        /*width: calc(100% - 184px);*/
        width: 79%;
        margin: 25px 0;
        padding-left: 25px;
    }
    .right-bar .tab .row {
        margin-left: -10px;
        margin-right: -10px;
    }
    .tab-col {
        padding: 0 10px;
    }
    .right-video-img {
        background: #fff;
        border-radius: 6px;
        overflow: hidden;
        margin-bottom: 20px;
    }
    .video-img-con {
        padding: 15px;
    }
    .video-img-con h4 {
        font-size: 16px;
        font-weight: 700;
        margin: 0 0 10px;
        line-height: 22px;
    }
    .video-img-con p {
        font-size: 13px;
        margin: 0;
        letter-spacing: -0.2px;
    }
    .modal-video-container .modal-title {
        font-family: 'Inter', sans-serif;
        font-weight: 700;
        font-size: 24px;
        line-height: 30px;
        margin: 0;
        color: #fff;
    }
    .modal-video-container .modal-header {
        background: #0064A5;
        padding: 6px 23px;
        border: none;
    }
    .modal-video-container {
        border: none;
        border-radius: 8px;
        overflow: hidden;     background-color: transparent;
    }
    .modal-video-container .modal-body {
        padding: 23px; background:#fff;
    }
    .modal-video-container .modal-header .close {
        color: #fff;
        opacity: 1;
    }
    .right-video-img:hover {
        box-shadow: 0 0 12px rgba(0,0,0,0.2);
    }
    .help-search button:hover {
        background: #0064A5;
    }
    .video-img img {
        width: 100%; display:block;
    }
    .video-img {
        position:relative; background:#000;
    }
    .share-icon {
        position: absolute;
        right: 15px;
        top: 10px;
        font-size: 24px;
        color: #fff;
        opacity: 0;
    }
    .right-video-img:hover .video-img img { opacity:0.7}
    .right-video-img:hover .share-icon {opacity:1}
    .right-bar .tab{
        display: none;
    }
    .right-bar .tab-active{
        display: block;
    }
    ul.left-bar-nav {
        border: 1px solid #DEE2E6;
        background: #fff;
        border-radius: 6px;
        overflow: hidden;
    }
    ul.left-bar-nav li {
        border-top: 1px solid #DEE2E6;
        display: block;
        margin-top: -1px;
    }
    .right-bar .tab .row {
        margin-left: -10px;
        margin-right: -10px;
    }
    .help-container{
        display: -webkit-box!important;
    }
    .no-scroll{
        overflow-x: hidden;
    }
    @media (min-width: 992px)
        .col-lg-4 {
            -webkit-box-flex: 0;
            -ms-flex: 0 0 33.33333%;
            flex: 0 0 33.33333%;
            max-width: 32.33333% !important;
        }
        .tutorial-list .alert{
            margin-top: 0px;
        }
        .tab-a:hover{
            text-decoration: none;
        }
</style>
</head>

<body id="page-top">
<!-- Page Wrapper -->
<div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>
    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column no-scroll">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>
            <?php
            $categories = $pdo->prepare('SELECT `id`,`category_name` FROM `tutorial_category` ORDER by id ASC');
            $categories->execute();
            ?>
            <!-- Begin Page Content -->
            <div class="d-flex justify-content-between align-items-center help-header" style="margin-top: 35px;margin-bottom: 12px;">
                <div class="help-head"><h3 style="margin-left: 16px; letter-spacing: -0.2px;">How can we help you?</h3></div>
                <div class="help-search" style="padding-top: 15px; float: right;width: 35%;">
                    <div class="help-search" style="width: 100%;">
                        <input type="text" id="tutorial-search-query" placeholder="Search" />
                        <button type="button" class="btn-tutorial-search">Go</button>
                        </form>
                    </div>
                </div>
            </div>
            <div class="d-flex help-container">
                <div class="left-bar">
                    <ul class="left-bar-nav">
                        <?php $count = 1; foreach ($categories as $c) { ?>
                            <?php
                            $is_active = '';
                            $default_class = '';
                            if($count == 1){
                                $is_active = 'active';
                                $default_class = 'default-category';
                            }
                            ?>
                            <li><a href="javascript:void(0);" class="tab-a <?= $is_active; ?> <?= $default_class; ?> tab-tutorial-category" data-id="<?= $c['id']; ?>"><?= $c['category_name']; ?></a></li>
                            <?php $count++;} ?>
                    </ul>
                </div>
                <div class="right-bar">
                    <div class="tutorial-list"></div>
                </div>
                <!-- Large modal -->
                <div class="modal fade tutorial-vid-modal-lg" id="modal-video" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg modal-dialog-centered">
                        <div class="modal-content modal-video-container">
                            <div class="modal-header">
                                <h5 class="modal-title" style="letter-spacing: -0.2px;" id="vidModalitle"></h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body" style="padding: 0.5rem;">
                                <div class="model-video">
                                    <iframe style="width:100%;" height="315" src="" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="clear"></div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; <?php echo date('Y'); ?></span>
                    </div>
                </div>
            </footer>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>
    <script>
        $(function(){
            $('#modal-video').on('hidden.bs.modal', function () {
                $("#modal-video iframe").attr("src",'');
            });

            load_default_tutorials();

            function load_default_tutorials(){
                var pid = 1;
                var url = root_dir + "/load-tutorials";
                var msg = '<div class="alert alert-info" role="alert" style="width:70%;"><img src="'+root_dir+'/img/spinner.gif" /></div>';

                $(".default-category").addClass('active');
                $(".tutorial-list").html(msg);
                setTimeout(function () {
                    $.ajax({
                        type: "POST",
                        url: url,
                        data: {pid:pid},
                        success: function(o)
                        {

                            $(".tutorial-list").html(o);
                            $(".btn-modal-video").click(function(){
                                var vidSrc = $(this).attr("data-src");
                                var vidTitle = $(this).attr("data-title");

                                $("#vidModalitle").html(vidTitle);
                                $("#modal-video iframe").attr("src",vidSrc);
                            });
                        }
                    });
                }, 500);
            }

            $(".tab-tutorial-category").click(function(){
                var pid = $(this).attr("data-id");
                var search_query = '';

                var url = root_dir + "/load-tutorials";
                var msg = '<div class="alert alert-info" role="alert" style="width:70%;"><img src="'+root_dir+'/img/spinner.gif" /></div>';

                $(".tab-tutorial-category").removeClass('active');
                $(this).addClass('active');

                $(".tutorial-list").html(msg);
                setTimeout(function () {
                    $.ajax({
                        type: "POST",
                        url: url,
                        data: {pid:pid,search_query:search_query},
                        success: function(o)
                        {

                            $(".tutorial-list").html(o);
                            $(".btn-modal-video").click(function(){
                                var vidSrc = $(this).attr("data-src");
                                var vidTitle = $(this).attr("data-title");

                                $("#vidModalitle").html(vidTitle);
                                $("#modal-video iframe").attr("src",vidSrc);
                            });
                        }
                    });
                }, 500);
            });

            $(".btn-tutorial-search").click(function(){
                var search_query = $("#tutorial-search-query").val();
                if( search_query != '' ){
                    var pid = $(this).attr("data-id");
                    var url = root_dir + "/load-tutorials";
                    var msg = '<div class="alert alert-info" role="alert" style="width:70%;"><img src="'+root_dir+'/img/spinner.gif" /></div>';

                    $(".tab-tutorial-category").removeClass('active');

                    $(".tutorial-list").html(msg);
                    setTimeout(function () {
                        $.ajax({
                            type: "POST",
                            url: url,
                            data: {pid:pid,search_query:search_query},
                            success: function(o)
                            {

                                $(".tutorial-list").html(o);
                                $(".btn-modal-video").click(function(){
                                    var vidSrc = $(this).attr("data-src");
                                    var vidTitle = $(this).attr("data-title");

                                    $("#vidModalitle").html(vidTitle);
                                    $("#modal-video iframe").attr("src",vidSrc);
                                });
                            }
                        });
                    }, 500);
                }else{
                    load_default_tutorials();
                }
            });
        });
    </script>
