  <title><?php echo SITE_NAME; ?> - Campaign Report</title>
  <link rel="stylesheet" href="<?php echo $root; ?>/trumbowyg/plugins/colors/ui/trumbowyg.colors.css">
  <link rel="stylesheet" href="<?php echo $root; ?>/trumbowyg/plugins/emoji/ui/trumbowyg.emoji.css">
</head>

<body id="page-top">

  <!-- Page Wrapper -->
  <div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar Navbar -->
        <?php include_once("nav/right_nav.php"); ?>

        <?php
        $q = $pdo->prepare('SELECT * FROM `campaigns` WHERE `id`=? AND `member_id`=? LIMIT 1');
        $q->execute(array($_SEO[2], $member['id']));
        $campaign = $q->fetch(PDO::FETCH_ASSOC);
        ?>

        <!-- Begin Page Content -->
        <div class="container-fluid dashboard">

          <!-- Page Heading -->
          <div class="float-left">
            <h1 class="panel-title">Reports: <?php echo $campaign['name']; ?></h1>
          </div>
          <div class="clearfix"></div>
          

          <div class="row cards-row">

            <?php
            $emails = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `member_id`=?');
            $emails->execute(array($campaign['id'], $member['id']));

            $opened = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `member_id`=? AND `opened`=1');
            $opened->execute(array($campaign['id'], $member['id']));

            $replies = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `member_id`=? AND `replied`=1');
            $replies->execute(array($campaign['id'], $member['id']));

            $bounced = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `member_id`=? AND `bounced`=1');
            $bounced->execute(array($campaign['id'], $member['id']));
            ?>

            <!-- Earnings (Monthly) Card Example -->
            <div class="col-xl-3 col-md-6 mb-4">
              <div class="card total-sent">
                <div class="card-body">
                  <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                      <div class="label">Total Sent</div>
                      <div class="h1 mb-0"><?php echo $emails->rowcount(); ?></div>
                    </div>
                    <div class="col-auto">
                      <img src="<?php echo $root; ?>/img/icon-feather-send.svg" alt="" width="" height="">
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Earnings (Monthly) Card Example -->
            <div class="col-xl-3 col-md-6 mb-4">
              <div class="card total-opened">
                <div class="card-body">
                  <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                      <div class="label">Total Opened</div>
                      <div class="h1 mb-0"><?php echo $opened->rowcount(); ?></div>
                    </div>
                    <div class="col-auto">
                      <img src="<?php echo $root; ?>/img/icon-feather-mail.svg" alt="" width="" height="">
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Earnings (Monthly) Card Example -->
            <div class="col-xl-3 col-md-6 mb-4">
              <div class="card total-replies">
                <div class="card-body">
                  <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                      <div class="label">Total Replies</div>
                      <div class="h1 mb-0"><?php echo $replies->rowcount(); ?></div>
                    </div>
                    <div class="col-auto">
                      <img src="<?php echo $root; ?>/img/icon-material-reply-all.svg" alt="" width="" height="">
                    </div>
                  </div>
                </div>
              </div>
            </div>

             <!-- Earnings (Monthly) Card Example -->
            <div class="col-xl-3 col-md-6 mb-4">
              <div class="card total-replies">
                <div class="card-body">
                  <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                      <div class="label">Bounces</div>
                      <div class="h1 mb-0"><?php echo $bounced->rowcount(); ?></div>
                    </div>
                    <div class="col-auto">
                      <img src="<?php echo $root; ?>/img/icon-material-reply-all.svg" alt="" width="" height="">
                    </div>
                  </div>
                </div>
              </div>
            </div>

          </div>

          <div class="row widgets-row">            
            <div class="col-sm-12">
              <?php 
                if( $success_msg != '' ){
                  echo '
                  <div class="alert alert-success" role="alert">
                    '.$success_msg.'
                  </div>
                  ';
                }
              ?>
              <div class="card shadow mb-4">
                <div class="card-header bg-dark py-3">
                  <div class="float-left">
                    <h6 class="">Opens</h6>
                  </div>
                  <div class="float-left" style="margin-left: 10px;">
                    <select class="form-control open-selected">
                      <option value="">Select Action</option>
                      <option value="stop_sending">Stop Sending</option>
                      <option value="resume_sending">Resume Sending</option>
                    </select>
                  </div>

                  <div class="float-right">
                    <form action="" method="post" class="search-form">
                       <i class="fas fa-search"></i>
                       <input type="text" placeholder="Search" name="search_string" id="search_string" value="<?php echo  (isset($_POST['search_string']) ? htmlspecialchars($_POST['search_string']) : ''); ?>">
                    </form>
                  </div>
                  <div class="clearfix"></div>
                  <div class="float-right">
                      <a href="<?php echo $root."/unsubscribe-list/" . $campaign['id']; ?>">View Unsubscribe list</a>
                  </div>
                  

                  <div class="clearfix"></div>
                </div>
                <div class="card-body">

                  <div class="dataTables_wrapper">

                    <table class="table table-hover datatable">
                      <thead>
                        <tr>
                          <th scope="col" style="width:1%;"><input class="open-check-all" type="checkbox" /></th>
                          <th>
                            First name
                          </th>
                          <th>
                            Last name
                          </th>
                          <th>
                            Email
                          </th>
                          <th>
                            Subject
                          </th>
                          <th>
                            Last activity
                          </th>
                          <th>
                            Stop Sending
                          </th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php                           
                        if( isset($_POST['search_string']) && $_POST['search_string'] != '' ){
                            $_POST['search_string'] = htmlspecialchars($_POST['search_string'],ENT_QUOTES);

                          $sql = '
                            SELECT sm.`id`,sm.`to_contact`,sm.`subject`,sm.`last_activity`,sm.`member_id`, sm.`campaign_id`,sm.`to_email`,
                            IFNULL(
                              (SELECT `id` FROM `opener_stop_sending` WHERE `member_id`=sm.`member_id` AND `campaign_id`=sm.`campaign_id` AND `email`=sm.`to_email` LIMIT 1
                              ),0) AS `is_stop_sending` 
                            FROM `sent_mails` sm WHERE `campaign_id`=? AND `member_id`=? AND `opened`=1 AND (sm.`subject` LIKE "%'.$_POST['search_string'].'%" OR sm.`to_email` LIKE "%'.$_POST['search_string'].'%")
                          ';
                        }else{
                           $sql = '
                            SELECT sm.`id`,sm.`to_contact`,sm.`subject`,sm.`last_activity`,sm.`member_id`, sm.`campaign_id`,sm.`to_email`,
                            IFNULL(
                              (SELECT `id` FROM `opener_stop_sending` WHERE `member_id`=sm.`member_id` AND `campaign_id`=sm.`campaign_id` AND `email`=sm.`to_email` LIMIT 1
                              ),0) AS `is_stop_sending` 
                            FROM `sent_mails` sm WHERE `campaign_id`=? AND `member_id`=? AND `opened`=1 AND (sm.`subject` LIKE "%'.$_POST['search_string'].'%" OR sm.`to_email` LIKE "%'.$_POST['search_string'].'%")
                          ';
                        }
                        
                        $openedList = $pdo->prepare($sql);
                        $openedList->execute(array($campaign['id'], $member['id']));

                        foreach( $openedList as $ol ){
                          $contact = $pdo->prepare('SELECT email,firstName,lastName FROM `contacts` WHERE `id`=?');
                          $contact->execute(array($ol['to_contact']));
                          $row = $contact->fetch();

                          if( $ol['is_stop_sending'] > 0 ){
                            $stop_sending = "<span class='label label-danger'>YES</span>";
                          }else{
                            $stop_sending = "<span class='label label-danger'>NO</span>";
                          }

                          echo '
                            <tr>
                              <td><input type="checkbox" class="open-row" name="open[]" value="'. $ol['id'] .'" /></td>
                              <td>
                                '.$row['firstName'].'
                              </td>
                              <td>
                                '.$row['lastName'].'
                              </td>
                              <td>
                                '.$row['email'].'
                              </td>
                              <td>
                                '.$ol['subject'].'
                              </td>
                              <td>
                                '.time_elapsed_string('@'.$ol['last_activity']).'
                              </td>
                              <td>
                                '.$stop_sending.'
                              </td>
                            </tr>
                          ';
                        }

                        ?>
                        <?php
                        /*$q = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=?');
                        $q->execute(array($campaign['list']));
                        foreach ($q as $row) {
                          $data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `to_contact`=? AND `opened`=1');
                          $data->execute(array($row['id']));
                          foreach ($data as $data2) {
                            echo '
                            <tr>
                              <td>
                                '.$row['firstName'].'
                              </td>
                              <td>
                                '.$row['lastName'].'
                              </td>
                              <td>
                                '.$row['email'].'
                              </td>
                              <td>
                                '.$data2['subject'].'
                              </td>
                              <td>
                                '.time_elapsed_string('@'.$data2['last_activity']).'
                              </td>
                            </tr>
                            ';
                          }
                        }*/
                        ?>
                      </tbody>
                    </table>

                  </div>

                </div>
              </div>

            </div>

            <div class="col-sm-12">
              <div class="card shadow mb-4">
                <div class="card-header bg-dark py-3">
                  <div class="float-left">
                    <h6 class="">Replies</h6>
                  </div>
                  <div class="clearfix"></div>
                </div>
                <div class="card-body">

                  <div class="dataTables_wrapper">

                    <table class="table table-hover datatable">
                      <thead>
                        <tr>
                          <th>
                            First name
                          </th>
                          <th>
                            Last name
                          </th>
                          <th>
                            Email
                          </th>
                          <th>
                            Subject
                          </th>
                          <th>
                            Last activity
                          </th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                        // $q = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=?');
                        // $q->execute(array($campaign['list']));
                        // foreach ($q as $row) {
                        //   $data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `to_contact`=? AND `replied`=1');
                        //   $data->execute(array($row['id']));
                        //   foreach ($data as $data2) {
                        //     echo '
                        //     <tr>
                        //       <td>
                        //         '.$row['firstName'].'
                        //       </td>
                        //       <td>
                        //         '.$row['lastName'].'
                        //       </td>
                        //       <td>
                        //         '.$row['email'].'
                        //       </td>
                        //       <td>
                        //         '.$data2['subject'].'
                        //       </td>
                        //       <td>
                        //         '.time_elapsed_string('@'.$data2['last_activity']).'
                        //       </td>
                        //     </tr>
                        //     ';
                        //   }
                        // }
                        ?>

                        <?php
                          if( $_POST['search_string'] != '' ){
                              $_POST['search_string'] = htmlspecialchars($_POST['search_string'],ENT_QUOTES);
                            $data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `member_id`=? AND `replied`=1 AND (`subject` LIKE "%'.$_POST['search_string'].'%" OR `to_email` LIKE "%'.$_POST['search_string'].'%")');
                            $data->execute(array($campaign['id'], $member['id']));
                          }else{
                            $data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `member_id`=? AND `replied`=1');
                            $data->execute(array($campaign['id'], $member['id']));
                          }
                          $data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `member_id`=? AND `replied`=1');
                          $data->execute(array($campaign['id'], $member['id']));
                          foreach ($data as $data2) {
                            $contact = $pdo->prepare('SELECT email,firstName,lastName FROM `contacts` WHERE `id`=?');
                            $contact->execute(array($data2['to_contact']));
                            $row = $contact->fetch();
                            echo '
                            <tr>
                              <td>
                                '.$row['firstName'].'
                              </td>
                              <td>
                                '.$row['lastName'].'
                              </td>
                              <td>
                                '.$row['email'].'
                              </td>
                              <td>
                                '.$data2['subject'].'
                              </td>
                              <td>
                                '.time_elapsed_string('@'.$data2['last_activity']).'
                              </td>
                            </tr>
                            ';
                          }
                        ?>
                      </tbody>
                    </table>

                  </div>

                </div>
              </div>
            </div>

            <div class="col-sm-12">
              <div class="card shadow mb-4">
                <div class="card-header bg-dark py-3">
                  <div class="float-left">
                    <h6 class="">Bounced</h6>
                  </div>
                  <div class="clearfix"></div>
                </div>
                <div class="card-body">

                  <div class="dataTables_wrapper">

                    <table class="table table-hover datatable">
                      <thead>
                        <tr>
                          <th>
                            First name
                          </th>
                          <th>
                            Last name
                          </th>
                          <th>
                            Email
                          </th>
                          <th>
                            Subject
                          </th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                        // $q = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=?');
                        // $q->execute(array($campaign['list']));
                        // foreach ($q as $row) {
                        //   $data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `to_contact`=? AND `opened`=0');
                        //   $data->execute(array($row['id']));
                        //   if($data->rowcount()<1)
                        //   {
                        //     echo '
                        //     <tr>
                        //       <td>
                        //         '.$row['firstName'].'
                        //       </td>
                        //       <td>
                        //         '.$row['lastName'].'
                        //       </td>
                        //       <td>
                        //         '.$row['email'].'
                        //       </td>
                        //     </tr>
                        //     ';
                        //   }
                        // }
                        ?>
                        <?php
                        if( $_POST['search_string'] != '' ){
                             $_POST['search_string'] = htmlspecialchars($_POST['search_string'],ENT_QUOTES);
                          $data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `member_id`=? AND `bounced`=1 AND (`subject` LIKE "%'.$_POST['search_string'].'%" OR `to_email` LIKE "%'.$_POST['search_string'].'%")');
                          $data->execute(array($campaign['id'], $member['id']));
                        }else{
                          $data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `member_id`=? AND `bounced`=1');
                          $data->execute(array($campaign['id'], $member['id']));
                        }
                        
                          foreach ($data as $data2) {
                            $contact = $pdo->prepare('SELECT email,firstName,lastName FROM `contacts` WHERE `id`=?');
                            $contact->execute(array($data2['to_contact']));
                            $row = $contact->fetch();
                            echo '
                              <tr>
                                <td>
                                  '.$row['firstName'].'
                                </td>
                                <td>
                                  '.$row['lastName'].'
                                </td>
                                <td>
                                  '.$row['email'].'
                                </td>
                                <td>
                                  '.$data2['subject'].'
                                </td>
                              </tr>
                              ';
                          }
                        ?>
                      </tbody>
                    </table>

                  </div>

                </div>
              </div>

            <div class="col-sm-12">
              <div class="card shadow mb-4">
                <div class="card-header bg-dark py-3">
                  <div class="float-left">
                    <h6 class="">Not opened</h6>
                  </div>
                  <div class="clearfix"></div>
                </div>
                <div class="card-body">

                  <div class="dataTables_wrapper">

                    <table class="table table-hover datatable">
                      <thead>
                        <tr>
                          <th>
                            First name
                          </th>
                          <th>
                            Last name
                          </th>
                          <th>
                            Email
                          </th>
                          <th>
                            Subject
                          </th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                        // $q = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=?');
                        // $q->execute(array($campaign['list']));
                        // foreach ($q as $row) {
                        //   $data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `to_contact`=? AND `opened`=0');
                        //   $data->execute(array($row['id']));
                        //   if($data->rowcount()<1)
                        //   {
                        //     echo '
                        //     <tr>
                        //       <td>
                        //         '.$row['firstName'].'
                        //       </td>
                        //       <td>
                        //         '.$row['lastName'].'
                        //       </td>
                        //       <td>
                        //         '.$row['email'].'
                        //       </td>
                        //     </tr>
                        //     ';
                        //   }
                        // }
                        ?>
                        <?php
                        if( $_POST['search_string'] != '' ){
                             $_POST['search_string'] = htmlspecialchars($_POST['search_string'],ENT_QUOTES);
                          $data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `member_id`=? AND `opened`=0 AND (`subject` LIKE "%'.$_POST['search_string'].'%" OR `to_email` LIKE "%'.$_POST['search_string'].'%")');
                          $data->execute(array($campaign['id'], $member['id']));
                        }else{
                          $data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `member_id`=? AND `opened`=0');
                          $data->execute(array($campaign['id'], $member['id']));
                        }
                        
                          foreach ($data as $data2) {
                            $contact = $pdo->prepare('SELECT * FROM `contacts` WHERE `id`=?');
                            $contact->execute(array($data2['to_contact']));
                            $row = $contact->fetch();
                            echo '
                              <tr>
                                <td>
                                  '.$row['firstName'].'
                                </td>
                                <td>
                                  '.$row['lastName'].'
                                </td>
                                <td>
                                  '.$row['email'].'
                                </td>
                                <td>
                                  '.$data2['subject'].'
                                </td>
                              </tr>
                              ';
                          }
                        ?>
                      </tbody>
                    </table>

                  </div>

                </div>
              </div>

              <!-- Modal Selected Confirmation -->
              <div class="modal fade" id="modalSelectedConfirmation" tabindex="-1" role="dialog" aria-labelledby="modalSelectedConfirmationlabel" aria-hidden="true">
                <div class="modal-dialog  modal-md" role="document">
                  <form action="#" method="post">
                    <input type="hidden" value="" class="row-action-confirmation">
                    <div class="modal-content">
                      <div class="modal-body">
                        <h4 class="modal-heading">Confirmation</h4>
                        <div class="row-selected-msg"></div>
                        <div class="modal-footer footer-row-message-confirmation">
                          <button type="button" class="btn btn-default btn-row-selected-close" data-dismiss="modal">No</button>
                          <button type="button" class="btn btn-success btn-row-selected-submit">Yes</button>
                        </div>
                      </div>
                    </div>
                  </form>
                </div>
              </div>

            </div>
          </div>
        </div>
        <!-- /.container-fluid -->

      </div>
      <!-- End of Main Content -->

      <!-- Footer -->
      <footer class="sticky-footer bg-white">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; <?php echo date('Y'); ?></span>
          </div>
        </div>
      </footer>
      <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>
  <script>
  $(function(){
    $(".open-selected").change(function(){
      var numberOfRowsChecked = $('input.open-row:checkbox:checked').length;
      var status = $(this).val();

      if( numberOfRowsChecked > 0 ){
        if( status == 'stop_sending' ){
          var msg = 'stop sending';
        }else{
          var msg = 'resume sending';
        }

        if( status != "" ){
          $(".row-action-confirmation").val(status);
          $(".row-selected-msg").html("Are you sure you want to "+msg+" on selected items?");
          $(".footer-row-message-confirmation").show();
          $("#modalSelectedConfirmation").modal('show');
          $(this).val("");
        }else{
          $(".row-action-confirmation").val(status);
          $(".row-selected-msg").html("Please select action");
          $(".footer-row-message-confirmation").hide();
          $("#modalSelectedConfirmation").modal('show');  
          $(this).val("");
        }          
      }else{
        if( status != "" ){
          $(".row-action-confirmation").val(status);
          $(".row-selected-msg").html("Please select / check table row to update");
          $(".footer-row-message-confirmation").hide();
          $("#modalSelectedConfirmation").modal('show');  
          $(this).val("");
        }
      }      
    });

    $(".btn-row-selected-submit").click(function(){
      var action = $(".row-action-confirmation").val();
      var ids    = $('input[name="open[]"]').map(function(){ 
          return this.value; 
      }).get();

      var ids = [];
      $('.open-row:checked').each(function(i, e) {
          ids.push($(this).val());
      });

      $.post('<?php echo $root; ?>/_add_remove_stop_sending', {"ids[]":ids,"action":action})
      .done(function(data){
        //location.href = '<?php echo $root; ?>' + '/leads';
        location.reload();
      });
    });

    $(".btn-row-selected-close").click(function(){
      $(".row-selected-msg").val("");
    });

    $(".open-check-all").click(function(){
      if(this.checked) {
        $('.open-row').prop('checked', true);
      }else{
        $('.open-row').prop('checked', false);
      }
    });
  }); 
  </script>