  <title><?php echo SITE_NAME; ?> - Notifications</title>
  <style>
  .dataTables_length, .dataTables_wrapper .dataTables_filter{
    display: block !important;
  }
  .dt-cell-wrap{
    white-space:normal;
  }
  </style>
</head>

<body id="page-top">

  <!-- Page Wrapper -->
  <div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar Navbar -->
        <?php include_once("nav/right_nav.php"); ?>

        <!-- Begin Page Content -->
        <div class="container-fluid">  

          <?php 
            if( isset($_POST['action']) ){

              if( $_POST['action'] == 'delete-notification-messages' ){
                // Delete All
                $q = $pdo->prepare('DELETE FROM `notifications` WHERE `member_id`=?');
                $q->execute(array($member['id']));

                echo '
                <div class="alert alert-success" role="alert">
                  All notification messages has been deleted!
                </div>
                ';
              }
            }

            // This set the notifications to seen
            $q = $pdo->prepare('UPDATE `notifications` SET is_seen =? WHERE  `member_id`=?');
            $q->execute(array(1,$member['id']));

          ?>

          <!-- Page Heading -->
          <div class="panel-header">
            <div class="float-left">
              <h1 class="panel-title">Notifications <a class="btn-clear-notification btn-info btn" href="javascript:void(0);" style="font-size: 12px;position: relative;top: -6px;padding: 4px;left: 11px;">Clear Notification</a></h1>
            </div>
            <div class="clearfix"></div>
          </div>
          <div class="row">

            <div class="col-sm-12">
              <div class="dataTables_wrapper">
                <table class="table datatable" id="notification-list-datatable">
                  <thead>                   
                    <tr>
                      <th scope="col"></th>
                      <th scope="col">MODULE</th>
                      <th scope="col">DATE</th>
                    </tr>
                  </thead>
                  <tbody></tbody>
                </table>
              </div>
            </div>

          </div>

          <!-- Modal clear notification confirmation -->
          <div class="modal fade" id="modal-clear-notification" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
              <div class="modal-content">
                <form action="" method="post" class="frm-edit-gmail-<?php echo $email['id']; ?>">
                <div class="modal-body">
                    <div class="row">
                      <div class="col-md-12" style="text-align:center;">
                        <i class="fa fa-question" style="font-size:67px;color: #0576C7;margin-bottom: 32px;text-shadow: 2px 2px #c1c1c1;"></i><br />
                        <p style="font-size:23px;">Do you wish to delete all notification messages?</p>
                      </div>                    
                    </div>   
                  <div class="modal-footer" style="display: block;text-align: center;">
                      <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">No</button>
                      <button type="submit" class="btn btn-danger" name="action" value="delete-notification-messages" style="width:200px;font-size: 21px;">Yes</button>
                  </div>
                </div>
                </form>
              </div>
            </div>
          </div>

        </div>
        <!-- /.container-fluid -->

      </div>
      <!-- End of Main Content -->

      <!-- Footer -->
      <footer class="sticky-footer bg-white">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; <?php echo date('Y'); ?></span>
          </div>
        </div>
      </footer>
      <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>

  <script>
  $(function(){
    $(".btn-clear-notification").click(function(){
      $("#modal-clear-notification").modal('show');
    });
  });
  </script>