/**
 * @license Copyright (c) 2003-2019, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see https://ckeditor.com/legal/ckeditor-oss-license
 */

CKEDITOR.editorConfig = function( config ) {
	// Define changes to default configuration here.
	// For complete reference see:
	// https://ckeditor.com/docs/ckeditor4/latest/api/CKEDITOR_config.html

	//config.filebrowserBrowseUrl = root_dir + '/js/kcfinder/browse.php?type=images';
	//config.filebrowserImageBrowseUrl = root_dir + '/js/kcfinder/browse.php?type=images';
	//config.filebrowserFlashBrowseUrl = root_dir + '/js/kcfinder/browse.php?type=flash';
	config.filebrowserUploadUrl = root_dir + '/js/kcfinder/upload.php?type=images';
	config.filebrowserImageUploadUrl = root_dir + '/js/kcfinder/upload.php?type=images';
	//config.filebrowserFlashUploadUrl = root_dir + '/js/kcfinder/upload.php?type=flash';	
	config.filebrowserUploadMethod = 'form';
	config.enterMode = 2;
	config.allowedContent = true;	

	// The toolbar groups arrangement, optimized for two toolbar rows.
	config.toolbarGroups = [
		{ name: 'styles' },
		{ name: 'colors' },
		{ name: 'clipboard',   groups: [ 'clipboard', 'undo' ] },
		{ name: 'editing',     groups: [ 'find', 'selection', 'spellchecker' ] },
		{ name: 'links' },
		{ name: 'insert' },
		{ name: 'forms' },
		{ name: 'tools' },
		{ name: 'document',	   groups: [ 'mode', 'document', 'doctools' ] },
		{ name: 'others' },
		{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
		{ name: 'paragraph',   groups: [ 'list', 'indent', 'blocks', 'align', 'bidi' ] },		
	];

	// Remove some buttons provided by the standard plugins, which are
	// not needed in the Standard(s) toolbar.
	config.removeButtons = 'Underline,Subscript,Superscript,Maximize,PasteFromWord,PasteText,Anchor,Styles,Symbol';
	config.extraPlugins = 'justify';
	// Set the most common block elements.
	config.format_tags = 'p;h1;h2;h3;pre';

	// Simplify the dialog windows.
	config.removeDialogTabs = 'image:advanced;link:advanced';
};