  <title><?php echo SITE_NAME; ?> - View List</title>
  <style type="text/css">
    .dataTables_wrapper
    {
      overflow-x: scroll !important;
    }
  </style>
</head>

<body id="page-top">

  <!-- Page Wrapper -->
  <div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar Navbar -->
        <?php include_once("nav/right_nav.php"); ?>

        <!-- Begin Page Content -->
        <div class="container-fluid email-accounts dashboard">
          <!-- Page Heading -->
          <a class="btn-default btn btn-back btn-sm" href="javascript:history.back()"><i class="fas fa-chevron-left"></i> Back</a>
          <div class="panel-header">
            <h1 class="panel-title">List Cleaner</h1>
          </div>          
          <div class="clearfix"></div>

          <div class="row">

            <div class="col-sm-12">

              <?php 
              require_once 'config.php'; 
              require_once 'functions.php';

              require_once 'ApiMailClickConvert.php'; 

              $q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
              $q->execute(array($_SESSION['id']));
              $member = $q->fetch(PDO::FETCH_ASSOC);
              $member_id = $member['id'];
              $list_id   = $_SEO[2];

              $contacts = $pdo->prepare("SELECT email,firstName,lastName,status FROM `contacts` WHERE `status` =? AND `list_id` =?"); //Unverified status
              $contacts->execute(array(2, $list_id));

              if( $contacts->rowcount() > 0 ){

                $file = 'csv/automailer_list_' . $list_id . '.csv';
                $csv_handler = fopen($file,'w');

                $csv = "firstname,lastname,email \n";
                fwrite ($csv_handler,$csv);
                foreach( $contacts as $contact ){
                  $csv = $contact['firstName'] . "," . $contact['lastName'] . "," . $contact['email'] . "\n";
                  fwrite ($csv_handler,$csv);
                }



                fclose ($csv_handler);

                //$url = 'http://login.automailer.io/' . $file;
                  $url = $root .'/'. $file;

                $mailClick = new ApiMailClickConvert();
                $mailClickResponse = $mailClick->uploadlistbyurl($url);

                if( $mailClickResponse->listid > 0 ){
                  //Insert list id
                  $data_mail_click_list = array(
                    NULL,
                    $member_id,
                    $mailClickResponse->importid,
                    $mailClickResponse->listid,
                    $list_id,
                    $mailClickResponse->status,
                    0,
                    0,
                    time()
                  );
                  $q = $pdo->prepare('INSERT INTO `mail_click_convert_list` VALUES (?,?,?,?,?,?,?,?,?)');
                  $q->execute($data_mail_click_list);

                  echo '
                  <div class="alert alert-success" role="alert">
                    '. $contacts->rowcount() . ' contacts has been sent for cleaning.' . ' 
                                     
                  </div> 
                  ';
                }else{
                  echo '
                  <div class="alert alert-danger" role="alert">
                    Cannot send data. Please try again.' . '                    
                  </div>
                  <a class="btn btn-primary" href="' . $root . '/clean-email/' . $list_id . '">Retry</a> &nbsp; <a class="btn btn-primary" href="' . $root . '/list-cleaner/' . $list_id . '">Back to list</a> 
                  ';
                }

              }else{
                echo '
                <div class="alert alert-danger" role="alert">
                  No contact(s) found to clean.' . '
                                   
                </div>
                ';
              }
              ?>

            </div>

          </div>

        </div>
        <!-- /.container-fluid -->
        <div class="clearfix"></div>

      </div>
      <!-- End of Main Content -->

      <!-- Footer -->
      <footer class="sticky-footer bg-white">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; <?php echo date('Y'); ?></span>
          </div>
        </div>
      </footer>
      <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>