<?php
$row_identifier = $_POST['row_identifier'];
$q = $pdo->prepare('SELECT `template_category_id` FROM `templates` WHERE `member_id`=? GROUP BY `template_category_id`');
$q->execute(array(0));

$default_template_categories = array();
foreach($q as $r){
    $default_template_categories[$r['template_category_id']] = $r['template_category_id'];
}

$q = $pdo->prepare('SELECT `template_category_id` FROM `templates` WHERE `member_id`=? GROUP BY `template_category_id`');
$q->execute(array($_SESSION['id']));

$member_template_categories = array();
foreach($q as $r){
    $member_template_categories[$r['template_category_id']] = $r['template_category_id'];
}

$default_categories = $pdo->prepare('SELECT `id`, `category_name` FROM `template_category` WHERE `id` IN('.implode(",", $default_template_categories).')');
$default_categories->execute();

$member_categories = $pdo->prepare('SELECT `id`, `category_name` FROM `template_category` WHERE `id` IN('.implode(",", $member_template_categories).')');
$member_categories->execute();

$member_templates = array();
foreach( $member_categories as $c ){
    $q_member_templates = $pdo->prepare('SELECT * FROM `templates` WHERE `template_category_id`=? AND `member_id`=? ORDER BY `name` ASC');
    $q_member_templates->execute(array($c['id'], $_SESSION['id']));
    foreach($q_member_templates as $mt){
        $member_templates[] = $mt;
    }
}

usort($member_templates, function ($item1, $item2) {
    return $item2['last_update'] <=> $item1['last_update'];
});

?>
<style>
    .bs-templates{
        margin: 10px;
    }
    .accordion .fa{
        margin-right: 0.5rem;
    }
    .accordion>.card .card-header{
        background: #F2F8FF;
        box-shadow: 0 1px 3px rgb(0 0 0 / 50%);
        border-radius: 5px;
        margin: 6px;
    }
    .btn-link{
        display: block;
        margin: 0px;
        width: 100%;
        text-align: left;
        color: #656565;
    }
    .btn-link .fa-plus, .btn-link .fa-minus{
        float: right;
    }
    .template-categories-list{
        list-style: none;
        margin: 2px;
        padding: 0px;
        max-height: 500px;
        overflow: auto;
    }
    .template-categories-list li{
        margin: 17px 31px;
        color: #656565;
        padding: 8px;
        margin: 0px;
    }
    .template-categories-list li a:focus,.template-categories-list li a:hover,.template-categories-list li a:link{
        color: #656565;
        text-decoration: none;
        width: 100%;
        display: block;
        margin: 0px;
        padding: 6px;
    }
    .template-categories-list li a{
        outline:none;
        text-decoration: none;
    }
    .btn-link, .btn-link:focus{
        color: inherit;
        border: inherit;
        outline:none;
    }
    .btn-link:link,.btn-link:focus,.btn-link:hover{
        text-decoration: none;
        color: #656565;
    }
    .template-type-header{
        font-size: 20px;
        background-color: #0C91F9;
        padding: 10px;
        color: #ffffff;
    }
    .selected-template{
        background-color: #7E7E7E;
        color:#ffffff !important;
    }
</style>
<div class="row">
    <div class="col-md-4">
        <div class="bs-templates">
            <div class="accordion" id="accordionExample">
                <h3 class="template-type-header">Default Templates</h3>
                <div class="card">
                    <?php foreach($default_categories as $c){ ?>
                        <div class="card-header" id="headingOne">
                            <h2 class="mb-0">
                                <button type="button" class="btn btn-link" data-toggle="collapse" data-target="#collapseDefault<?= $c['id']; ?>"><?= $c['category_name']; ?></a></li> <i class="fa fa-plus"></i></button>
                            </h2>
                        </div>
                        <div id="collapseDefault<?= $c['id']; ?>" class="collapse" aria-labelledby="headingOne" data-parent="#accordionExample">
                            <div class="card-body" style="padding: 0px;">
                                <?php
                                $default_templates = $pdo->prepare('SELECT * FROM `templates` WHERE `template_category_id`=? AND `member_id`=? ORDER BY `name` ASC');
                                $default_templates->execute(array($c['id'], 0));
                                ?>
                                <ul class="template-categories-list">
                                    <?php foreach($default_templates as $d){ ?>
                                        <li>
                                            <a class="btn-template" data-type="default" data-id="<?= $d['id']; ?>" href="javascript:void(0);"><?= $d['name']; ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <h3 class="template-type-header">My Templates</h3>
                <div class="card">
                    <ul class="template-categories-list">
                        <?php foreach($member_templates as $d){ ?>
                            <li>
                                <a class="btn-template" data-type="member" data-id="<?= $d['id']; ?>" href="javascript:void(0);"><?= $d['name']; ?></a>
                            </li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="template-preview" style="padding: 10px; height: 80vh;"></div>
    </div>
</div>

<script>
    $(document).ready(function(){
        // Add minus icon for collapse element which is open by default
        $(".collapse.show").each(function(){
            $(this).prev(".card-header").find(".fa").addClass("fa-minus").removeClass("fa-plus");
        });

        // Toggle plus minus icon on show hide of collapse element
        $(".collapse").on('show.bs.collapse', function(){
            $(this).prev(".card-header").find(".fa").removeClass("fa-plus").addClass("fa-minus");
        }).on('hide.bs.collapse', function(){
            $(this).prev(".card-header").find(".fa").removeClass("fa-minus").addClass("fa-plus");
        });

        $(".btn-template").click(function(){
            var template_id    = $(this).attr("data-id");
            var category_type  = $(this).attr("data-type");
            var row_identifier = "<?= $row_identifier; ?>"
            var loading_msg    = '<img src="'+root_dir+'/img/spinner_dot.gif" style="width:90%;"/>';
            var url            = root_dir + "/get-template-by-category";

            $(".btn-template").removeClass('selected-template');
            $(this).addClass('selected-template');

            $(".template-preview").html(loading_msg);

            setTimeout(function () {
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {template_id:template_id,category_type:category_type,row_identifier:row_identifier},
                    success: function(o)
                    {
                        $('.template-preview').hide().html(o).fadeIn('slow');
                    }
                });
            }, 500);
        });

        $(".btn-category").click(function(){
            var category_id    = $(this).attr("data-id");
            var category_type  = $(this).attr("data-type");
            var row_identifier = "<?= $row_identifier; ?>"
            var loading_msg    = '<div class="alert alert-info" role="alert"><img src="'+root_dir+'/img/spinner.gif" /> Loading...</div>';
            var url            = root_dir + "/get-category-templates";
            $(".template-list").html(loading_msg);

            setTimeout(function () {
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {category_id:category_id,category_type:category_type,row_identifier:row_identifier},
                    success: function(o)
                    {
                        $(".template-list").html(o);
                    }
                });
            }, 500);
        });


    });
</script>