<title><?php echo SITE_NAME; ?> - Dashboard</title>
</head>

<body id="page-top">

<!-- Page Wrapper -->
<div id="wrapper">

    <?php include_once("nav_wrapper_admin.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>

            <!-- Begin Page Content -->
            <div class="container-fluid">

                <!-- Page Heading -->
                <h1 class="h3 mb-4 text-gray-800">Dashboard</h1>

                <div class="row">
                    <div class="col-lg-12" style="padding-left: 2px;">
                        <!-- Stat Counter -->
                        <?php
                        // if( isset($_POST['stat_counter_date_from']) && isset($_POST['stat_counter_date_to']) ){
                        //   $date_from = strtotime($_POST['stat_counter_date_from']);
                        //   $date_to   = strtotime($_POST['stat_counter_date_to']);

                        //   $emails = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `last_activity`>=? AND `last_activity`<=?');
                        //   $emails->execute(array($member['id'], $date_from, $date_to));

                        //   $opened = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `opened`=1 AND `last_activity`>=? AND `last_activity`<=?');
                        //   $opened->execute(array($member['id'], $date_from, $date_to));

                        //   $replies = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `replied`=1 AND `last_activity`>=? AND `last_activity`<=?');
                        //   $replies->execute(array($member['id'], $date_from, $date_to));

                        //   $stat_counter_date = date("F j, Y", $date_from) . ' to ' . date("F j, Y", $date_to);

                        // }else{
                        //   $emails = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=?');
                        //   $emails->execute(array($member['id']));

                        //   $opened = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `opened`=1');
                        //   $opened->execute(array($member['id']));

                        //   $replies = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `replied`=1');
                        //   $replies->execute(array($member['id']));

                        //   $stat_counter_date = date("F j, Y");
                        // }
                        ?>
                        <div class="card shadow mb-4">
                            <div class="card-header bg-dark py-3">
                                <h6 class="m-0 font-weight-bold text-white">Stat counter as of <?php echo $stat_counter_date; ?></h6>
                            </div>
                        </div>
                    </div>
                </div>
                <?php

                $counter_total_customers = $pdo->prepare('SELECT COUNT(id) AS total FROM `members` WHERE `parent_id` = 0 AND `id` >= 148  ');
                $counter_total_customers->execute();
                $counter_total_customers  = $counter_total_customers->fetch(PDO::FETCH_ASSOC);



                $mtd_from = strtotime(date("Y-m-01"));
                $mtd_to   = strtotime(date("Y-m-t"));
                $counter_mtd = $pdo->prepare('SELECT COUNT(id) AS total FROM `members` WHERE `date_created`>=? AND `date_created`<=? AND `parent_id` = 0 AND `id` >= 148  ');
                $counter_mtd->execute(array($mtd_from, $mtd_to));
                $counter_mtd  = $counter_mtd->fetch(PDO::FETCH_ASSOC);



                $ytd_from = strtotime(date("Y-01-01"));
                $ytd_to   = strtotime(date('Y-m-d', strtotime('Dec 31')));
                $counter_ytd = $pdo->prepare('SELECT COUNT(id) AS total FROM `members` WHERE `date_created`>=? AND `date_created`<=? AND `parent_id` = 0 AND `id` >= 148');
                $counter_ytd->execute(array($ytd_from, $ytd_to));
                $counter_ytd  = $counter_ytd->fetch(PDO::FETCH_ASSOC);



                //  $ytd_counter = 0;
                //  for($x=1; $x<=12;$x++){
                //     $graph_date_from = strtotime(date("Y-".$x."-01"));
                //     $graph_date_to   = strtotime(date("Y-".$x."-t"));
                //     $graph_mtd = $pdo->prepare('SELECT * FROM `members` WHERE `date_created`>=? AND `date_created`<=? AND `parent_id` = 0');
                //     $graph_mtd->execute(array($graph_date_from, $graph_date_to));
                //     $ytd_counter = $ytd_counter + $graph_mtd->rowcount();
                //   }



                $today = strtotime(date("Y-m-d"));
                $counter_today = $pdo->prepare('SELECT COUNT(id) AS total  FROM `members` WHERE `date_created`=? AND `parent_id` = 0 AND `id` >= 148  ');
                $counter_today->execute(array($today));
                $counter_today  = $counter_today->fetch(PDO::FETCH_ASSOC);

                $day = date('w');
                $week_from = strtotime(date('Y-m-d', strtotime('-'.$day.' days')));
                $week_to   = strtotime(date('Y-m-d', strtotime('+'.(6-$day).' days')));
                $counter_week = $pdo->prepare('SELECT COUNT(id) AS total FROM `members` WHERE `date_created`>=? AND `date_created`<=? AND `parent_id` = 0 AND `id` >= 148 ');
                $counter_week->execute(array($week_from, $week_to));
                $counter_week  = $counter_week->fetch(PDO::FETCH_ASSOC);

                $total_length_customer = 0;

                $members = $pdo->prepare('SELECT id,date_created FROM `members` WHERE `parent_id` = 0 AND `id` >= 148 ');
                $members->execute();

                foreach( $members as $m ){
                    $member_id    = $m['id'];
                    $date_created = $m['date_created'];
                    $q = $pdo->prepare('SELECT id,last_activity,member_id FROM `sent_mails` WHERE `member_id`=? ORDER BY last_activity DESC LIMIT 1');
                    $q->execute(array($member_id));
                    $recent_activity = $q->fetch(PDO::FETCH_ASSOC);

                    if( $recent_activity ){
                        $days_diff = $recent_activity['last_activity'] - $date_created;
                        $days_diff = round($days_diff / (60 * 60 * 24));
                        $total_length_customer += $days_diff;
                    }
                }

                $q = $pdo->prepare('SELECT COUNT(id) AS total_members FROM `members` WHERE `parent_id` = 0');
                $q->execute();
                $totalMembers = $q->fetch(PDO::FETCH_ASSOC);
                $average_length_customer = $total_length_customer / $totalMembers['total_members'];

                $stripe_active = $pdo->prepare('SELECT COUNT(id) AS total FROM `members` WHERE `parent_id` = 0 AND `stripe_status` = "active" AND `id` >= 148  ');
                $stripe_active->execute();
                $stripe_active  = $stripe_active->fetch(PDO::FETCH_ASSOC);

                $stripe_cancelled = $pdo->prepare('SELECT COUNT(id) AS total FROM `members` WHERE `parent_id` = 0 AND `stripe_status` = "canceled" AND `id` >= 148  ');
                $stripe_cancelled->execute();
                $stripe_cancelled  = $stripe_cancelled->fetch(PDO::FETCH_ASSOC);

                $stripe_trial = $pdo->prepare('SELECT COUNT(id) AS total FROM `members` WHERE `parent_id` = 0 AND `stripe_status` = "trialing" AND `id` >= 148  ');
                $stripe_trial->execute();
                $stripe_trial  = $stripe_trial->fetch(PDO::FETCH_ASSOC);

                $stripe_active_pay = $pdo->prepare('SELECT id, stripe,stripe_status FROM `members` WHERE `parent_id` = 0 AND `stripe_status` = "active" AND `id` >= 148  ');
                $stripe_active_pay->execute();
                $total_pay_amount = 0;
                foreach ($stripe_active_pay as $key => $value) {
                    $stripe_details = json_decode($value['stripe']);
                    if ($stripe_details) {
                        $number = $stripe_details->data->plan->amount;
                        $number = substr($number, 0, -2);
                        $total_pay_amount = $total_pay_amount + number_format($number, 2, '.', '');
                    }

                }



                $membersDateCreated = $pdo->prepare('SELECT SUM(date_created) AS total_date_created FROM `members` WHERE `parent_id` = 0');
                $membersDateCreated->execute();
                $totalDateCreated   = $membersDateCreated->fetch(PDO::FETCH_ASSOC);

                $date_start = strtotime(date("Y-m-01"));
                $date_end   = strtotime(date("Y-m-t"));

                $plans = $pdo->prepare('SELECT * FROM `plans`');
                $plans->execute();
                $total_plan_amount = 0;

                foreach ($plans as $plan) {
                    $q = $pdo->prepare('SELECT COUNT(id) AS total_members FROM `members` WHERE `date_created` >= ? AND `date_created` <= ? AND `plan` = ? AND `parent_id` = 0');
                    $q->execute(array($date_start, $date_end, $plan['id'] ));
                    $totalMembers = $q->fetch(PDO::FETCH_ASSOC);
                    $total_members_plan = $totalMembers['total_members'] * $plan['price_per_month'];

                    $total_plan_amount = $total_plan_amount + $total_members_plan;
                }

                ?>
                <div class="row">
                    <!-- Earnings (Monthly) Card Example -->
                    <div class="col-xl-3 col-md-3 mb-2">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Customer</div>
                                        <div class="h1 mb-0 font-weight-bold text-gray-800"><?php echo $counter_total_customers['total']; //  $counter_total_customers->rowcount(); ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-share-square fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Earnings (Monthly) Card Example -->
                    <div class="col-xl-3 col-md-3 mb-2">
                        <div class="card border-left-primary shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">New Customers<br />Year to date</div>
                                        <div class="h1 mb-0 font-weight-bold text-gray-800"><?php echo $counter_ytd['total']; ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-envelope-open fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Earnings (Monthly) Card Example -->
                    <div class="col-xl-3 col-md-3 mb-2">
                        <div class="card border-left-warning shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">New Customers<br />Month to date</div>
                                        <div class="row no-gutters align-items-center">
                                            <div class="col-auto">
                                                <div class="h1 mb-0 mr-3 font-weight-bold text-gray-800"><?php  echo $counter_mtd['total']; ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-reply fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Earnings (Monthly) Card Example -->
                    <div class="col-xl-3 col-md-3 mb-2">
                        <div class="card border-left-warning shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">New Customers<Br />Week</div>
                                        <div class="row no-gutters align-items-center">
                                            <div class="col-auto">
                                                <div class="h1 mb-0 mr-3 font-weight-bold text-gray-800"><?php  echo $counter_week['total']; ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-reply fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- New Customers -->
                    <div class="col-xl-3 col-md-3 mb-2">
                        <div class="card border-left-warning shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">New Customers<br />Today</div>
                                        <div class="row no-gutters align-items-center">
                                            <div class="col-auto">
                                                <div class="h1 mb-0 mr-3 font-weight-bold text-gray-800"><?php echo $counter_today['total']; ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-reply fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Earnings (Monthly) Card Example -->
                    <div class="col-xl-3 col-md-3 mb-2">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Revenue for month of <b><?php echo date("F") ?></b></div>
                                        <div class="h1 mb-0 font-weight-bold text-gray-800"><?php  echo number_format($total_plan_amount, 2); ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-share-square fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- Earnings (Monthly) Card Example -->
                    <div class="col-xl-3 col-md-3 mb-2">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Average Length of Customer Stay</div>
                                        <div class="h1 mb-0 font-weight-bold text-gray-800"><?php echo number_format($average_length_customer, 2) . " Days"; ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-share-square fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- How many is active? -->
                    <div class="col-xl-3 col-md-3 mb-2">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">How many is active?</div>
                                        <div class="h1 mb-0 font-weight-bold text-gray-800"><?php  echo $stripe_active['total']; ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-share-square fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- How many are cancelled? -->
                    <div class="col-xl-3 col-md-3 mb-2">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">How many are cancelled?</div>
                                        <div class="h1 mb-0 font-weight-bold text-gray-800"><?php  echo $stripe_cancelled['total']; ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-share-square fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- How many are cancelled? -->
                    <div class="col-xl-3 col-md-3 mb-2">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">How many are on free trial?</div>
                                        <div class="h1 mb-0 font-weight-bold text-gray-800"><?php  echo $stripe_trial['total']; ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-share-square fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- How much  did we charge clients? -->
                    <div class="col-xl-3 col-md-3 mb-2">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">How much  did we charge clients?</div>
                                        <div class="h1 mb-0 font-weight-bold text-gray-800"><?php  echo $total_pay_amount; ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-share-square fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>


                <br />

                <div class="row">
                    <div class="col-lg-12" style="padding-left: 2px;">
                        <!-- Area Chart -->
                        <div class="card shadow mb-4">
                            <div class="card-header bg-dark py-3">
                                <h6 class="m-0 font-weight-bold text-white">Overview</h6>
                            </div>
                            <div class="card-body">
                                <canvas id="overviewMembersChart" width="100%" height="400" style="max-height: 500px;"></canvas>
                                <hr>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; <?php echo date('Y'); ?></span>
                    </div>
                </div>
            </footer>
            <!-- End of Footer -->


        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>