<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PhpImap\Mailbox;
use PhpImap\Exceptions\ConnectionException;
define("IN_CRONTAB",1);
require_once dirname(__FILE__) . '/config.php';
require_once dirname(__FILE__) . '/functions.php';
require_once dirname(__FILE__) . '/PHPMailer/autoload.php';
require_once dirname(__FILE__) . '/Google/autoload.php';
require_once dirname(__FILE__) . '/swiftmailer/autoload.php';
require_once dirname(__FILE__) . '/php-imap/autoload.php';
require_once dirname(__FILE__) . '/helper/leads_helper.php';
require_once dirname(__FILE__) . '/helper/cron_helper.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(900);


echo 'Running Cron Send';
flush();

$script_time_start = microtime(true);
$mail = new PHPMailer();
$mail->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;

//Load per active Members 
$members 	= $pdo->prepare('SELECT m.id, m.fname, m.lname, m.timezone FROM (`members` as m)
 LEFT JOIN gmail_accounts as s ON (s.member_id = m.id) WHERE m.status = 1 AND s.active = 1 group by s.member_id');
$members->execute();

foreach ($members as $keyMember => $member) {
    //set timzone to the member's timezone

    echo "<br /><br /> Member: ".   $member['fname'] . " ". $member['lname'];
	//echo "<br /> Timezone: " . $member['timezone'] ;
	date_default_timezone_set($member['timezone']);
	$day = date("l");
	// Load each gmail accounts 
	$gmail_emails 	= $pdo->prepare('SELECT * FROM `gmail_accounts` WHERE active = 1 AND `member_id`=?');
	$gmail_emails->execute(array($member['id']));

	if($gmail_emails->rowcount()>0){
		// get per email settings
		foreach ($gmail_emails as $keyGmail => $gmail_email) {

			$sending_account = "gmail:". $gmail_email['id'];
			//get today running campaigns
			$campaign_sending_done = true;
			$campaigns 	= $pdo->prepare('SELECT * FROM `campaigns` WHERE `status`=? AND `member_id`=? AND `sending_account`=?');
			$campaigns->execute(array(CAMPAIGN_STATUS_RUNNING, $member['id'],$sending_account));
			$total_campaign = $campaigns->rowcount();
			echo "<br />Gmail Account";
			echo "<br /> Timezone: " . $member['timezone'] ;
			echo "<br /> Member ID: " . $member['id']; 
			echo "<br /> Total campaigns: " . $total_campaign; 
			echo "<br /> Allowed Sending time From : " .  date('h:i A', $gmail_email['allowed_time_send_from']);// $gmail_email['allowed_time_send_from'] ;
			echo "<br /> Allowed Sending time To : " . date('h:i A', $gmail_email['allowed_time_send_to']) ;
			echo "<br /> email sending limit per day : " . $gmail_email['sending_limit_per_day'] ;
			echo "<br /> interval per blast: " . $gmail_email['time_between_email_send'] ;
  			echo "<br /> email sent per blast: " . $gmail_email['max_email_per_time'] ;

  			if($total_campaign == 0){
  				$allowed_per_campaign_email = 0;		
  			}else{	

  			 	$allowed_per_campaign_email = $gmail_email['max_email_per_time']  / $total_campaign;
  			 	if($allowed_per_campaign_email < 1){
  			 		$allowed_per_campaign_email = 1;
  			 	} 

  			}	
  			echo "<br /> Per campaign email sent : " . $allowed_per_campaign_email;
  			$time_today   = strtotime(date("h:i A"));	
            echo " <br />  Time now: ".  date('h:i A', $time_today);

            $time_from =  $gmail_email['allowed_time_send_from'];
	        $time_to   =  $gmail_email['allowed_time_send_to'];
            if(($time_today >= $time_from) && ($time_today <= $time_to) ){
				echo "send now";
			}

			flush();
			/*echo "<pre>";
			print_r($gmail_email);
			echo "</pre>";*/
			
			//loop through each campaign
			foreach ($campaigns as $campaign) {				
				echo "To Send Campaign ID : " . $campaign['id'] . "<br />";
                // This will check the interval per send must be higher than the set time between email 
	  			$last_sents = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? ORDER BY last_activity DESC LIMIT 1');
				$last_sents->execute(array($campaign['id']));
				
				if($last_sents->rowcount() >= 1 ) {
					//Went here
					foreach ($last_sents as $keyLastSent => $last_sent) {
					  $diff_time=(strtotime(date("Y/m/d H:i:s"))- $last_sent['last_activity'])/60;
					}

					echo "<pre>";
					//print_r($gmail_email);
					echo "<br /> Time Diff : " . $diff_time;
					//Diff time = 1535.15 
					//time_between_email_send = 20
					if($diff_time > $gmail_email['time_between_email_send']){
						//Went here
						$batch_send = true;
					}else{
						$batch_send = false;
					}
				}else{
					$batch_send = true;
				}
				if($batch_send){
					//Went here
					// this will reset send counts
					$xsend = 0; 					
				    //exclusions
					$exclusions = $pdo->prepare('SELECT * FROM `exclusions` WHERE `member_id`=?');
					$exclusions->execute(array($member['id']));

					$exclusion_emails  = array();
					$exclusion_domains = array();
					foreach( $exclusions as $ex ){
						$s_exclusion = strtolower($ex['exclusion']);
						if( $ex['type'] == exclusionEmail() ){
							$exclusion_emails[$s_exclusion] = $s_exclusion;
						}else{
							$exclusion_domains[$s_exclusion] = $s_exclusion; 
						}
					}
					
					$date_today   = strtotime(date("m/d/Y h:i A"));
					$trigger_date = $campaign['trigger_date'];					
					echo " <br />Date time today:  " . date('m/d/Y h:i A',$date_today );
					echo " <br /> Trigger date:  " . date('m/d/Y h:i A',	$trigger_date );					
					if( $trigger_date <= $date_today ){
						//Went here
						echo "<br /> Trigger on ";

						//check if campaign stop has JSON
						if(isJSON($campaign['stop_at']))
						{
							$stop_at = json_decode($campaign['stop_at'], 1);
						}else{
							$stop_at = array();
							$stop_at['type'] = $campaign['stop_at'];
						}

						//select all contacts for this campaign
						$contacts = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? AND (status=? OR status=?)');
						$contacts->execute(array($campaign['list'],1,0));
						$contacts = $contacts->fetchAll();

						//loop through all contacts
						foreach ($contacts as $key => $contact) {							
							//Went here now
							//remove contact if they replied to an email on this campaign
							if($stop_at['type'] == 'reply')
							{
								$replied = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `to_email`=? AND `replied`=1 LIMIT 1');
								$replied->execute(array($campaign['id'], $contact['email']));
								$replies = $replied->fetch(PDO::FETCH_ASSOC);
								if($replied->rowcount()>0)
								{
									//Replies with Stop Automation will be removed on the list
									$reply_data = $pdo->prepare('SELECT * FROM `leads` WHERE `sent_mail_id`=?  LIMIT 1');
				                    $reply_data->execute(array($replies['id']));
				                    $sent_mail = $reply_data->fetch(PDO::FETCH_ASSOC);
				                    if($sent_mail['continue_automation']==LeadsHelper::stopAutomation()){ 
									    unset($contacts[$key]);
								    }// if the status is set to 0 = Continue Automation it will not be unset on the list

								    //if the sent mail has no record on the auto replies it will be unset on the list
								    if($reply_data->rowcount()<=0)
									{
										unset($contacts[$key]);	
									}

									//Opener with Stop status will be removed on the list
									$opener_data = $pdo->prepare('SELECT * FROM `opener_stop_sending` WHERE `campaign_id`=? AND `email`=? LIMIT 1');
				                    $opener_data->execute(array($campaign['id'], $contact['email']));
				                    $opener_data_mail = $opener_data->fetch(PDO::FETCH_ASSOC);
				                    if($opener_data_mail->rowcount()==1){ 
									    unset($contacts[$key]);
								    }
								}
							}
						}
						//get emails for this campaign
						$emails = json_decode($campaign['data'], 1);
						$eid = sha1($campaign['id'] . SITE_ENCRYPTION_KEY);
						 //loop through contacts again
						foreach ($contacts as $contact) {
							//Went here
							//remove spaces from contact email
							$contact['email'] = trim($contact['email']);
							
							$i = 0;

							//$allowed_per_campaign_email = 2;
							//$allowed_per_campaign_email = $allowed_per_campaign_email - 1;

							//loop through email
							foreach ($emails as $email) {
								$email['body'] = linkify($email['body']);
								echo "<br />--Test Email--";
								echo "<br /> Email Sending Campaign : " . $email['subject'] . "<br />";
								// set limit the sent per campaign
								echo "<br />  Allowed: " . $allowed_per_campaign_email . " - ". $xsend;
								if( $xsend <= $allowed_per_campaign_email){
									//Went here
									echo "<br /> Send counter " .  $xsend ."<br />";	
									unset($send);
									$send = 0;
									$mail_footer = "";
									//generate a unique identifier for this email and contact
									$identifier = base64_encode($email['subject'].'-' . $email['email_number'].$contact['id'].'-' . $email['trigger'].'-' . $campaign['id']);
									//mail footer unsubscribe
									//$eid 	= crypt_jm($campaign['id']);
									$link   = AUTOMAILER_TRACKER_URL ."/_unsubscribe.php?email=".$contact['email']."&campaign=" . $campaign['id']  ."&eid=".$eid;
					    			$mail_footer = "<br /><br /><a href='".$link."'>Unsubscribe</a><br />";
									//replace all links with a trackable redirect
									$email['body'] = str_replace(
										array(
											'href="http://',
											'href="https://'
										),
										array(
											'target="_blank" href="'.AUTOMAILER_TRACKER_URL.'/_track_link.php?identifier='.$identifier.'&link=http://',
											'target="_blank" href="'.AUTOMAILER_TRACKER_URL.'/_track_link.php?identifier='.$identifier.'&link=https://'
										),
										$email['body']
									);

									//replace all default tags with contact values in body of email
									$email['body'] = str_replace('{FirstName}', $contact['firstName'], $email['body']);
									$email['body'] = str_replace('{LastName}', $contact['lastName'], $email['body']);
									$email['body'] = str_replace('{Email}', $contact['email'], $email['body']);

									$email['body'] = str_replace('{firstName}', $contact['firstName'], $email['body']);
									$email['body'] = str_replace('{lastName}', $contact['lastName'], $email['body']);
									$email['body'] = str_replace('{email}', $contact['email'], $email['body']);
					 
									//replace all default tags with contact values in subject of email
									$email['subject'] = str_replace('{FirstName}', $contact['firstName'], $email['subject']);
									$email['subject'] = str_replace('{LastName}', $contact['lastName'], $email['subject']);
									$email['subject'] = str_replace('{Email}', $contact['email'], $email['subject']);

									$email['subject'] = str_replace('{firstName}', $contact['firstName'], $email['subject']);
									$email['subject'] = str_replace('{lastName}', $contact['lastName'], $email['subject']);
									$email['subject'] = str_replace('{email}', $contact['email'], $email['subject']);

									//get custom tag names
									$tagData = json_decode($contact['data'], 1);

									//replace all custom tags with contact values in subject and body
									foreach ($tagData as $key => $value) {
										$email['body'] = str_replace('{'.$key.'}', $value, $email['body']);
										$email['subject'] = str_replace('{'.$key.'}', $value, $email['subject']);
									}

									$is_first_email = false;
									echo "<br /> email counter: " . $i;
									if($i == 0)
									{
										//Went here
									   echo "<br /> SUBJECT : " . $email['subject'] . "<br />";
									   //if first email, no trigger necessary				   									   
									   $sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
									   $sent->execute(array($identifier));
									   echo "<br /> Send rowcount: " . $sent->rowcount();
									   if($sent->rowcount()<1)
									   { 
								   			$time_from =  $gmail_email['allowed_time_send_from'];
			                                $time_to   =  $gmail_email['allowed_time_send_to'];
			                                $time_today   = strtotime(date("h:i A"));
									    	if($day == "Monday" && $email['is_mon']==1){
												if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													$send = 1;
												}	
											}
											if($day == "Tuesday" && $email['is_tues']==1){
												if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													$send = 1;
												}	
											}
											if($day == "Wednesday" && $email['is_wed']==1){
												if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													$send = 1;
												}	
											}
											if($day == "Thursday" && $email['is_thur']==1){
												if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													$send = 1;
												}	
											}
											if($day == "Friday" && $email['is_fri']==1){
												if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													$send = 1;
												}	
											}
											if($day == "Saturday" && $email['is_sat']==1){
												if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													$send = 1;
												}	
											}
											if($day == "Sunday" && $email['is_sun']==1){
												if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													$send = 1;
												}	
											}

										   echo "<br /> Send value: ". $send;

										  if( $send == 1 ){
										  	$is_first_email = true;
										  }				   	  
									   }
									}
									else
									{
										echo "SUBJECT NOT SEND TODAY : " . $email['subject'] . "<br />";
										//minus 1 from email number to match the email array
										$email_number = $email['email_number'] - 2;

										//get the trigger email identifier
										$trigger_identifier = base64_encode($emails[$email_number]['subject'].'-' . $emails[$email_number]['email_number'].$contact['id'].'-' . $emails[$email_number]['trigger'].'-' . $campaign['id']);
										/*echo "Trigger identifier : " . $trigger_identifier . "/" . $emails[$email_number]['subject'] . "/Campaign ID : " . $campaign['id'] . "/" . $emails[$email_number]['email_number'] . "/" . $emails[$email_number]['trigger'] . "/Current Subject : " . $email['subject'] . " / Identifier B : " . $identifier . "<br />";*/
										/*echo "<pre>";
										print_r($emails[$email_number]);*/
										//get the trigger email if it was sent
										$trigger_email = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
										$trigger_email->execute(array($trigger_identifier));
										if($trigger_email->rowcount()>0)
										{
											echo "<br /> SUBJECT TRIGGER EMAIL : " . $email['subject'] . "/ DAYS AFTER : " . $email['days_after'] . "<br />";
											//get trigger email data
											$trigger_email = $trigger_email->fetch(PDO::FETCH_ASSOC);

											//check if email is based on days after
											if(!empty($email['days_after']) && $email['days_after']>0)
											{
												echo "<br />  Days after validated <br /> ";
												$time_passed = strtotime('+'.$email['days_after'].' days', $trigger_email['last_activity'])<time();

												/* Validation for no send on the day */
												$is_days_after_lapse = true;
												$day = date("l");
												if( $email['days_after'] > 0 ){
													//Base start date in last_activity date
													$add_days   = $email['days_after'];
													$last_activity  = date("Y-m-d",$trigger_email['last_activity']);
													$expected_start = date("Y-m-d", strtotime($last_activity . " + {$add_days} days"));
													if( strtotime($expected_start) > strtotime(date("Y-m-d")) ){ //Validate if start date lapse the days after
														$is_days_after_lapse = false;
													}
												}

												if( $is_days_after_lapse ){
													$debug_con = "Yes";
												}else{
													$debug_con = "False";
												}												

												$time_from =  $gmail_email['allowed_time_send_from'];
				                                $time_to   =  $gmail_email['allowed_time_send_to'];

				                                echo "<br /> Time From: " . date('h:i A', $time_from );
				                                echo "<br /> Time To: " . date('h:i A',$time_to);
				                                echo   "<br /> is day after lapse: ". $is_days_after_lapse;
				                                $time_today   = strtotime(date("h:i A"));

				                                echo " <br />Date time today:  " . date('m/d/Y h:i A',$date_today );
												echo " <br /> Trigger date:  " . date('m/d/Y h:i A', $trigger_date );

				                                if($time_from <= $time_today && $time_to >= $time_today  ){
													echo "send now";
												}

												if($day == "Monday" && $email['is_mon']==1 && $is_days_after_lapse==true){
													//unset($send);
													if(($time_today >= $time_from) && ($time_today <= $time_to) ){
														$send = 1;
													}	
												}
												if($day == "Tuesday" && $email['is_tues']==1 && $is_days_after_lapse==true){
													//unset($send);	
													if(($time_today >= $time_from) && ($time_today <= $time_to) ){
														$send = 1;
													}	
												}
												if($day == "Wednesday" && $email['is_wed']==1 && $is_days_after_lapse==true){
													//unset($send);
													if(($time_today >= $time_from) && ($time_today <= $time_to) ){
														$send = 1;
													}	 
												}
												if($day == "Thursday" && $email['is_thur']==1 && $is_days_after_lapse==true){
													//unset($send);
													//if(($time_today >= $time_from) && ($time_today <= $time_to) ){
														$send = 1;
													//}
													echo "<br /> second email send Thursday : " . $send; 
												}
												if($day == "Friday" && $email['is_fri']==1 && $is_days_after_lapse==true){
													if(($time_today >= $time_from) && ($time_today <= $time_to) ){
														$send = 1;
													}
												}
												if($day == "Saturday" && $email['is_sat']==1 && $is_days_after_lapse==true){
													if(($time_today >= $time_from) && ($time_today <= $time_to) ){
														$send = 1;
													}
												}
												if($day == "Sunday" && $email['is_sun']==1 && $is_days_after_lapse==true){
													if(($time_today >= $time_from) && ($time_today <= $time_to) ){
														$send = 1;
													}
												}
												
												if( $send == 1 ){
													echo "<br />";
													echo "Send Subject Is : " . $email['subject'] ." / Last Activity : " . $trigger_email['last_activity'] . " / Is Lapse : " . $debug_con . "<br />"; 
												}
											
												$trigger_identifier = base64_encode($emails[$email_number]['subject'].'-' . $emails[$email_number]['email_number'].'-' . $contact['id'].'-' . $emails[$email_number]['trigger'].'-' . $campaign['id']);
												switch ($email['trigger']) {
													case 'no_condition':
													    //check if trigger email no condition
													    //if($time_passed)
													    //{
													    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
													    	$sent->execute(array($identifier));
													    	/*if($sent->rowcount()<1){
													    		$send = 1;
													    	}*/
													    	if($sent->rowcount()>0){
													    		$send = 0;
													    	}
													    //}
														break;	
													case 'opened':
													    //check if trigger email was opened
													    //if($time_passed && $trigger_email['opened'] == 1)
														if($trigger_email['opened'] == 1)
													    {
													    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
													    	$sent->execute(array($identifier));
													    	if($sent->rowcount()>0)
													    	{
													    		 $send = 0;
													    	}
													    }
														break;
													case 'unopened':
													    //check if trigger email was not opened
													    if($trigger_email['opened'] == 0)
													    {
													    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
													    	$sent->execute(array($identifier));
													    	if($sent->rowcount()>0)
													    	{
													    		$send = 0;
													    	}
													    }
														break;
													case 'has_click':
													    $links = $pdo->prepare('SELECT * FROM `links_clicked` WHERE `identifier`=? AND `link`=?');
													    $links->execute(array($trigger_identifier, $email['link']));
													    //if($links->rowcount()>0 && $time_passed)
													    if($links->rowcount()>0)
													    {
													    	$send = 1;
													    }
														break;
												}
											}
											else
											{
												echo "SUBJECT SEND CONDITION : " . $email['subject'] . "/" . $email['trigger'] . "<br />";
												//email is based on a date and time
												switch ($email['trigger']) {
													case 'no_condition':
														$day_is_valid = false;
														if($day == "Monday" && $email['is_mon']==1){
															$day_is_valid = true;
														}
														if($day == "Tuesday" && $email['is_tues']==1){
															$day_is_valid = true;
														}
														if($day == "Wednesday" && $email['is_wed']==1){
															$day_is_valid = true;
														}
														if($day == "Thursday" && $email['is_thur']==1){
															$day_is_valid = true;
														}
														if($day == "Friday" && $email['is_fri']==1){
															$day_is_valid = true;
														}
														if($day == "Saturday" && $email['is_sat']==1){
															$day_is_valid = true;
														}
														if($day == "Sunday" && $email['is_sun']==1){
															$day_is_valid = true;
														}

														if( $day_is_valid ){
															//check if trigger email no condition
														    if($email['time']<time())
														    {
														    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
														    	$sent->execute(array($identifier));
														    	if($sent->rowcount()<1)
														    	{
														    		$send = 1;
														    	}
														    }
														}		
																									    
														break;	
													case 'opened':
													    //check if trigger email was opened
													    if($email['time']<time() && $trigger_email['opened'] == 1)
													    {
													    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
													    	$sent->execute(array($identifier));
													    	if($sent->rowcount()<1)
													    	{
													    		 $send = 1;
													    	}
													    }
														break;
													case 'unopened':
													    //check if trigger email was not opened
													    if($email['time']<time() && $trigger_email['opened'] == 0)
													    {
													    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
													    	$sent->execute(array($identifier));
													    	if($sent->rowcount()<1)
													    	{
													    		$send = 1;
													    	}
													    }
														break;
													case 'has_click':
													    $links = $pdo->prepare('SELECT * FROM `links_clicked` WHERE `identifier`=? AND `link`=?');
													    $links->execute(array($trigger_identifier, $email['link']));
													    if($links->rowcount()>0 && $email['time']<time())
													    {
													    	$send = 1;
													    }
														break;								
												}
											}
										}
									}

									// Sending of Email
									if( $is_first_email ){
										$send = 1;
										//echo "This is First Email Subject : " . $email['subject'] . "/" . $send . "<br />";
									}
									//echo "First Email Subject : " . $email['subject'] . "/" . $send . "<br />";
									if($send > 0)
									{

                                        $resultUnsubscribe = $pdo->prepare('SELECT email FROM `unsubscribed_emails` WHERE member_id = ? AND `email`=?');
                                        $resultUnsubscribe->execute(array($campaign['member_id'], $contact['email']));

										if ($resultUnsubscribe->rowcount() == 0){ //Must not send or create if in unsubscribed list

											echo "<br /> email passed: " . $contact['email'] ;
											//Must not send if in exclusion list
											$email_domain_name = substr(strrchr($contact['email'], "@"), 1);
											if( !in_array(strtolower($contact['email']), $exclusion_emails) && !in_array(strtolower($email_domain_name), $exclusion_domains) ){
												echo "<br /> exclusion passed! ";
												//email sending
												$gmail = $pdo->prepare('SELECT * FROM `gmail_accounts` WHERE active = 1 AND id=?');
												$gmail->execute(array($email['send_id']));
												$gmail = $gmail->fetch(PDO::FETCH_ASSOC);

												$send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
												$send_limit->execute(array($gmail['email'], time()-86400));

												if($gmail['send_limit'] == 0)
												{
													$gmail['send_limit'] = $send_limit->rowcount()+1;
												}
												echo "<br /> Sender last activity: " . time()-86400;
												echo "<br /> Sender Email: " . $gmail['email'];
												echo "<br /> Sender ID: " . $email['send_id'];
												echo "<br /> Sent Count: " . $send_limit->rowcount();
												echo "<br /> Sending Limit " . $gmail['send_limit'] ;																						

												if(isset($gmail['email']) && $send_limit->rowcount()<$gmail['send_limit'])
												{ 
													echo "<br /> Send Try and catch ";

												    try
                                                    {
                                                    	echo "<br /> Try mail";
														$sender = CronHelper::cronGmailMailer($gmail,$email,$campaign,$contact,$identifier,$mail_footer,$googleSecretId,$googleClientId);
														$client = new Google_Client();
														$client->setClientId($googleClientId);
														$client->setClientSecret($googleSecretId);
														$client->setAccessToken($gmail['access_token']);
														$client->refreshToken($gmail['refresh_token']);
														$accessToken = $client->getAccessToken();
														$refreshToken = $pdo->prepare('UPDATE `gmail_accounts` SET `access_token`=?, `refresh_token`=? WHERE `id`=?');
														$refreshToken->execute(array($accessToken['access_token'], $accessToken['refresh_token'], $gmail['id']));
														$sent = $pdo->prepare('INSERT INTO `sent_mails` (`campaign_id`, `subject`, `from_email`, `to_contact`, `to_email`, `opened`, `replied`, `last_activity`, `identifier`, `member_id`, `id`) VALUES (?,?,?,?,?,?,?,?,?,?,?)');
														$sent->execute(array($campaign['id'], $email['subject'], $gmail['email'], $contact['id'], $contact['email'], 0, 0, time(), $identifier, $campaign['member_id'], NULL));
														$xsend++;
	                                                }
	                                                catch (Exception $e)
	                                                {
	                                                	echo "<br /> Catch mail";
	                                                    // Account no longer active...
	                                                    $updateActive = $pdo->prepare('UPDATE `gmail_accounts` SET active = 0, inactive_reason =? WHERE `id`=?');
	                                                    $updateActive->execute(array($e->getMessage(),$gmail['id']));
	                                                    // don't want to get stuck in loop
	                                                    $xsend++;

	                                                    error_log("Cron Send GMAIL Fail: " . $gmail['id'] . " Reason: " .  $e->getMessage());

	                                                    AddNotification("gmail", "GMAIL Account " . $gmail['gmail'] . " inactive - " . $e->getMessage(),$campaign['member_id']);
	                                                }
												}else{
													$campaign_sending_done = false;
												}
											}
										}
									}									
								} // limit the sent per campaign	
								$i++;
							} //end of email 

						} // end of loop through contacts again 
					} // end of trigger date
				} // checker if the last send is Time between email sends 	

				// This will check if the sending is done
				if( $campaign_sending_done ){ 
					$campaign_count = 0;
					if(isset($emails)){
					    foreach ($emails as $email) {
					   		$campaign_count++;
					    }
					}     
				    if( $campaign_count == 1 ){

				    	$contacts_verify = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? AND (status=? OR status=?)');
						$contacts_verify->execute(array($campaign['list'],1,0));

				    	$campaign_sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=?');
						$campaign_sent->execute(array($campaign['id']));
						if($campaign_sent->rowcount() == $contacts_verify->rowcount()){
					    	$sql = "UPDATE campaigns SET status=? WHERE id=?";
							$q = $pdo->prepare($sql);
							$q->execute(array(CAMPAIGN_STATUS_COMPLETED, $campaign['id']));
						}	
				    }elseif($campaign_count > 1){
				 		$contacts_verify = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? AND (status=? OR status=?)');
						$contacts_verify->execute(array($campaign['list'],1,0));
						$contact_count = $contacts_verify->rowcount();	
						$total_contact_to_send = $contact_count * $contact_count;

				    	$campaign_sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=?');
						$campaign_sent->execute(array($campaign['id']));
						if($campaign_sent->rowcount() >= $total_contact_to_send){
					    	$sql = "UPDATE campaigns SET status=? WHERE id=?";
							$q = $pdo->prepare($sql);
							$q->execute(array(CAMPAIGN_STATUS_COMPLETED, $campaign['id']));
						}	
				    }
				}

			} // end of the campaign loop
		} // end of the gmail loop
	} //end check if has gmail

} // end of the member

//exit();
$time_end = microtime(true);
$time = $time_end - $script_time_start;

echo ' End Cron Send - Time Taken: ' . $time . '<br>';
?>