  <title><?php echo SITE_NAME; ?> - Settings</title>
</head>
<style>
.select2-container--default .select2-selection--single {
  border-radius: 7px !important;
}
</style>
<body id="page-top">

  <!-- Page Wrapper -->
  <div id="wrapper">
    <?php include_once("nav_wrapper.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar Navbar -->
        <?php include_once("nav/right_nav.php"); ?>

        <!-- Begin Page Content -->
        <div class="container-fluid dashboard">

          <!-- Page Heading -->
          <div class="panel-header">
            <h1 class="panel-title">Settings</h1>
          </div>
          



              <?php

              if(!empty($_POST['cpassword']))
              {
                if(password_verify($_POST['cpassword'], $member['password']) && $_POST['password'] == $_POST['rpassword'])
                {
                  $q = $pdo->prepare('UPDATE `members` SET `password`=? WHERE `id`=?');
                  $q->execute(array(password_hash($_POST['password'], PASSWORD_BCRYPT), $member['id']));
                  echo '                <div class="row widgets-row">
                    <div class="col-md-12">
                    <div class="alert alert-success">
                   Password successfully updated.
                  </div>
                  </div>';
                }
                else
                {
                  echo '                <div class="row widgets-row">
                    <div class="col-md-12"><div class="alert alert-warning">
                   Error: Invalid password details.
                  </div></div>
                  </div>';
                }
              }

              if(!empty($_POST['user_timezone'])){
                $data = array($_POST['user_timezone'], $member['id']);
                $q = $pdo->prepare('UPDATE `members` SET `timezone`=? WHERE `id`=?');
                $q->execute($data);

                $q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
                $q->execute(array($member['id']));
                $member = $q->fetch(PDO::FETCH_ASSOC);
                date_default_timezone_set($member['timezone']);

                echo '                <div class="row widgets-row">
                    <div class="col-md-12"><div class="alert alert-success">
                   Your timezone was updated.
                  </div></div>';
              }

              $stripe = json_decode($member['stripe'], 1);

              $ch = curl_init();

              curl_setopt($ch, CURLOPT_URL, 'https://api.stripe.com/v1/customers/'.$stripe['customer']);
              curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
              curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
              curl_setopt($ch, CURLOPT_USERPWD, $new_stripe_pk.':');
              $customer = json_decode(curl_exec($ch), 1);
              curl_close($ch);

              $source = $customer['sources']['data'][0];

              if(isset($_POST['plan_']))
              {

                if($_POST['plan_']>$member['plan'])
                {

                  $ch = curl_init();
                  curl_setopt($ch, CURLOPT_URL, 'https://api.stripe.com/v1/subscriptions/'.$stripe['subscription']);
                  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                  curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
                  curl_setopt($ch, CURLOPT_USERPWD, $new_stripe_pk.':');
                  curl_close($ch);

                  $ch = curl_init();
                  curl_setopt($ch, CURLOPT_URL, 'https://api.stripe.com/v1/subscriptions');
                  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                  curl_setopt($ch, CURLOPT_POSTFIELDS, "items[0][plan]=".$_POST['plan_']."&customer=".$stripe['customer']);
                  curl_setopt($ch, CURLOPT_POST, 1);
                  curl_setopt($ch, CURLOPT_USERPWD, $new_stripe_pk.':'.'');

                  $headers = array();
                  $headers[] = 'Content-Type: application/x-www-form-urlencoded';
                  curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                  $result = json_decode(curl_exec($ch), 1);
                  if (curl_errno($ch)) {
                      echo 'Error:' . curl_error($ch);
                  }
                  curl_close($ch);

                  if(isset($result['id']))
                  {

                    $stripe['subscription'] = $result['id'];
                    switch ($_POST['plan_']) {
                      case '2':
                        $stripe['data']['plan']['nickname'] = 'Business';
                        break;
                      case '3':
                        $stripe['data']['plan']['nickname'] = 'Enterprise';
                        break;
                    }

                    $q = $pdo->prepare('UPDATE `members` SET `plan`=?, `stripe`=? WHERE `id`=?');
                    $q->execute(array($_POST['plan_'], json_encode($stripe), $member['id']));

                    $q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
                    $q->execute(array($_SESSION['id']));
                    $member = $q->fetch(PDO::FETCH_ASSOC);

                    $stripe = json_decode($member['stripe'], 1);

                    echo '                <div class="row widgets-row">
                    <div class="col-md-12"><div class="alert alert-warning">
                     Your membership has been updated!
                    </div></div>';
                  }
                  else
                  {
                    echo '                <div class="row widgets-row">
                    <div class="col-md-12"><div class="alert alert-warning">
                     Unable to upgrade subscription, please contact us.
                    </div></div>';
                  }

                }
                else
                {
                  echo '
                <div class="row widgets-row">
                    <div class="col-md-12">
                <div class="alert alert-warning">
                   Downgrading is not allowed at this time.
                  </div>
                  
                  </div></div>';
                }

              }

              ?>
            <div class="row widgets-row">
            <div class="col-md-6">
              <div class="card shadow mb-4">
                <div class="card-header bg-dark py-3">
                  <h6 class="mb-4">Membership</h6>
                </div>
                <div class="card-body">
                  <form action="<?php echo $root; ?>/settings/upgrade" method="post">
                    <h4>Plan - <?php echo $stripe['data']['plan']['nickname']; ?></h4>
                    <select name="plan_" class="form-control">
                      <option value="1" <?php if($member['plan'] == 1) { echo 'selected disabled'; } ?>>Professional - $29/month</option>
                      <option value="2" <?php if($member['plan'] == 2) { echo 'selected disabled'; } ?>>Business - $69/month</option>
                      <option value="3" <?php if($member['plan'] == 3) { echo 'selected disabled'; } ?>>Enterprise - $109/month</option>
                    </select>
                    <?php
                    echo '<p style="margin:10px 0 0;">Billing method: '.$source['brand'].' ending in '.$source['last4']. '</p>';
                    ?>
                    <button class="btn btn-secondary" style="margin-top: 15px;">Change Plan</button>
                    
                  </form>
                </div>
              </div>
              <div class="card shadow mb-4">
                <div class="card-header bg-dark py-3">
                  <h6 class="mb-4">Update Timezone</h6>
                </div>
                <div class="card-body">
                  <form action="" method="post">
                    <?php 
                      $timezones = $pdo->prepare('SELECT * FROM `timezones`');
                      $timezones->execute();
                    ?>
                    <select class="form form-control timezone-list" name="user_timezone" required="">
                      <option value="">-- Select timezone --</option>
                      <?php foreach($timezones as $value){ ?>
                        <option <?php echo($member['timezone'] == $value['timezone'] ? 'selected="selected"' : ''); ?> value="<?php echo $value['timezone']; ?>"><?php echo $value['utc_gmt'] . " - " . $value['timezone']; ?></option>
                      <?php } ?>
                    </select>
                    <button class="btn btn-secondary" style="margin-top:15px;">Change Timezone</button>
                  </form>
                </div>
              </div>
            </div>            
            <div class="col-md-6">
              <?php if( in_array("update_password", $setting_roles) || $member['account_type'] == 0 ){ ?>
              <div class="card shadow mb-4">
                <div class="card-header bg-dark py-3">
                  <h6 class="mb-4">Update Password</h6>
                </div>
                <div class="card-body">
                  <form action="" method="post">
                    <div class="form-group">
                      <input type="password" name="cpassword" class="form-control" required>
                      <label>Current password</label>
                    </div>
                    <div class="form-group">
                      <input type="password" name="password" class="form-control" required>
                      <label>New password</label>
                    </div>
                    <div class="form-group">
                      <input type="password" name="rpassword" class="form-control" required>
                      <label>Repeat new password</label>
                    </div>
                    <button class="btn btn-secondary">Update</button>
                  </form>
                </div>
              </div>
              <?php } ?>
            </div>
          </div>

        </div>
        <!-- /.container-fluid -->

      </div>
      <!-- End of Main Content -->

      <!-- Footer -->
      <footer class="sticky-footer bg-white">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; <?php echo date('Y'); ?></span>
          </div>
        </div>
      </footer>
      <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>