  <title><?php echo SITE_NAME; ?> - Campaign Recipients</title>
  <link rel="stylesheet" href="<?php echo $root; ?>/trumbowyg/plugins/colors/ui/trumbowyg.colors.css">
  <link rel="stylesheet" href="<?php echo $root; ?>/trumbowyg/plugins/emoji/ui/trumbowyg.emoji.css">
</head>
<style>
.dataTables_length, .dataTables_wrapper .dataTables_filter{
  display: block !important;
}
.chart {
  position: relative;
  display: inline-block;
  width: 159px;
  height: 110px;
  margin-top: 50px;
  margin-bottom: 50px;
  text-align: center;
}
.chart canvas {
  position: absolute;
  top: 0;
  left: 0;
}
.percent {
  display: inline-block;
  line-height: 146px;
  z-index: 2;
}
.percent:after {
  content: '%';
  margin-left: 0.1em;
  font-size: .8em;
}
</style>
<body id="page-top">
  <!-- Page Wrapper -->
  <div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>
    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar Navbar -->
        <?php include_once("nav/right_nav.php"); ?>
        <!-- Begin Page Content -->
        <div class="container-fluid dashboard">
          <?php 
            $q = $pdo->prepare('SELECT * FROM `contacts` LEFT JOIN `lists` ON `contacts`.list_id = `lists`.id WHERE `contacts`.id=? AND `lists`.member_id=? LIMIT 1');
            $q->execute(array($_SEO[3], $member['id']));
            $contact = $q->fetch(PDO::FETCH_ASSOC);
                
            $active_tab = 'email_tab';
            include_once("nav/email_view_nav.php"); 
          ?>

          <div class="row">
            <div class="col-sm-12">
              <h3><?php echo $contact['email']; ?></h3>
              <small style="letter-spacing: 6px;font-size: 16px;">Name : <?php echo $contact['firstName'] . ' ' . $contact['lastName']; ?></small>
            </div>
          </div>
          <hr />
          <div class="row">
            <?php 
              $q = $pdo->prepare('SELECT COUNT(s.`id`) as `total_opened` FROM `sent_mails` s WHERE s.`to_contact`=? AND s.`opened`=?');
              $q->execute(array($_SEO[3], 1));
              $mail_opened = $q->fetch(PDO::FETCH_ASSOC);

              $q = $pdo->prepare('SELECT COUNT(s.`id`) as `total_unread` FROM `sent_mails` s WHERE s.`to_contact`=? AND s.`opened`=?');
              $q->execute(array($_SEO[3], 0));
              $mail_unread = $q->fetch(PDO::FETCH_ASSOC);

              $q = $pdo->prepare('SELECT COUNT(s.`id`) as `total_clicked` FROM `sent_mails` s WHERE s.`to_contact`=? AND s.`clicked`=?');
              $q->execute(array($_SEO[3], 1));
              $mail_clicked = $q->fetch(PDO::FETCH_ASSOC);

              $q = $pdo->prepare('SELECT COUNT(s.`id`) as `total_mail_sent` FROM `sent_mails` s WHERE s.`to_contact`=?');
              $q->execute(array($_SEO[3]));
              $mail_sent = $q->fetch(PDO::FETCH_ASSOC);

              $percent_open  = ($mail_opened['total_opened'] / $mail_sent['total_mail_sent']) * 100;
              $percent_click = ($mail_clicked['total_clicked'] / $mail_sent['total_mail_sent']) * 100;
            ?>
            <div class="col-5">
              <div class="row">
                <div class="col-3 text-center">
                    <h2 class="color-primary"><?php echo $mail_sent['total_mail_sent'] ; ?></h2>
                    <span>Campaigns sent</span>
                </div>
                <div class="col-3 text-center">
                    <h2 class="color-marine"><?php echo $mail_opened['total_opened']; ?></h2>
                    <span>Read</span>
                </div>
                <div class="col-3 text-center">
                    <h2 class="color-success"><?php echo $mail_clicked['total_clicked']; ?></h2>
                    <span>clicks</span>
                </div>
                <div class="col-3 text-center">
                    <h2 class="color-light"><?php echo $mail_unread['total_unread']; ?></h2>
                    <span>Unread</span>
                </div>                
              </div>
              <br />
                <a class="btn btn-warning" href="<?php echo $root; ?>/exclusions" style="margin-top: 23px;">Exclusion</a>
            </div>
            <div class="col-7">
              <div class="row">
                <div class="col-4 text-center">
                  <span id="chart-open" class="chart" data-percent="<?php echo $percent_open; ?>">
                    <span class="percent"></span>
                  </span>
                </div>
                <div class="col-4 text-center">
                  <span id="chart-click" class="chart" data-percent="<?php echo $percent_click; ?>">
                    <span class="percent"></span>
                  </span>
                </div>
              </div>
            </div>              
          </div>

          <div class="row">            
            <div class="col-12">
              <div class="dataTables_wrapper">
                  <h4 class="panel-title">IN MAILING LIST</h4>
                  <table class="table email-view-datatable">
                    <thead>
                      <tr>
                        <th scope="col" width="40%">List Name</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php 

                        $q = $pdo->prepare('SELECT c.`list_id`,c.`email`,l.`name` FROM `contacts` c LEFT JOIN `lists` l ON c.`list_id` = l.`id`  WHERE `email`=? AND l.`member_id` =? GROUP BY `list_id`');
                        $q->execute(array($contact['email'], $member['id']));
                      ?>
                      <?php foreach ($q as $row) {  
                            $hashids = new Hashids\Hashids();
                            $eid = $hashids->encode($row['list_id']);
                       ?>
                        <tr>
                          <td><a href="<?php echo $root; ?>/list/<?php echo $eid; ?>"><?php echo $row['name']; ?></a></td>
                        </tr>
                      <?php } ?>
                    </tbody>
                  </table>
              </div>
            </div>
          </div>

          <div class="row">            
            <div class="col-12">
              <div class="dataTables_wrapper">
                  <h4 class="panel-title">ACTIVITY DATA</h4>
                  <table class="table email-view-datatable">
                    <thead>
                      <tr>
                        <th scope="col" width="10%">Date</th>
                        <th scope="col" width="30%">Campaign Name</th>
                        <th scope="col" width="30%">Subject</th>
                        <th scope="col" width="5%">Opened</th>
                        <th scope="col" width="5%">Replied</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php 
                        $q = $pdo->prepare('SELECT s.`campaign_id`, s.`subject`,s.`campaign_id`,s.`opened`,s.`replied`,s.`last_activity`,c.`name`, c.`id` FROM `sent_mails` s LEFT JOIN `campaigns` c ON s.`campaign_id`=c.`id` WHERE s.`to_contact`=?');
                        $q->execute(array($_SEO[3]));
                      ?>
                      <?php foreach ($q as $row) { 
                            $hashids = new Hashids\Hashids();
                            $eid = $hashids->encode($row['id']);
                        ?>
                        <tr>
                          <td><?php echo date("Y-m-d H:i:s",$row['last_activity']); ?></td>
                          <td><a href="<?php echo $root; ?>/campaign-reports/<?php echo $eid; ?>"><?php echo $row['name']; ?></a></td>
                          <td><?php echo $row['subject']; ?></td>
                          <td style="text-align: center;">
                            <?php 
                              if($row['opened'] == 1){ 
                                echo "<div class='alert alert-info' style='font-size:22px;padding:1px;'><i class='fas fa-check-square'></i></div>";
                              }else{
                                echo "<div class='alert alert-danger' style='font-size:22px;padding:1px;'><i class='fas fa-window-close'></i></div>";
                              }
                            ?>
                          </td>
                          <td style="text-align: center;">
                            <?php 
                              if($row['replied'] == 1){ 
                                echo "<div class='alert alert-info' style='font-size:22px;padding:1px;'><i class='fas fa-check-square'></i></div>";
                              }else{
                                echo "<div class='alert alert-danger' style='font-size:22px;padding:1px;'><i class='fas fa-window-close'></i></div>";
                              }
                            ?>
                          </td>
                        </tr>
                      <?php } ?>
                    </tbody>
                  </table>
              </div>
            </div>
          </div>            
        </div>

        <!-- Modal Exclude Confirmation -->
        <div class="modal fade modal-enhanced modal-info" id="modalExcludeContactConfirmation" tabindex="-1" role="dialog" aria-labelledby="modalExcludeContactConfirmationlabel" aria-hidden="true">
          <div class="modal-dialog modal-md" role="document">
            <form action="#" method="post">
              <input type="hidden" value="" name="contact_id" id="ecid">
              <input type="hidden" value="" name="eaction" id="eaction">
              <input type="hidden" value="<?php echo $campaign['id']; ?>" name="campaign_id">
              <div class="modal-content">                      
                <div class="modal-header">
                  <h5 class="modal-title"><i class="fa fa-question"></i> Confirmation</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <div class="exclude-contact-msg"></div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                    <button type="submit" class="btn btn-success" name="action">Yes</button>
                  </div>
                </div>
              </div>
            </form>
          </div>
        </div>

        <!-- /.container-fluid -->
      </div>
      <!-- End of Main Content -->

      <!-- Footer -->
      <footer class="sticky-footer bg-white">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; <?php echo date('Y'); ?></span>
          </div>
        </div>
      </footer>
      <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->
  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>