<title><?php echo SITE_NAME; ?> - Billing Information</title>
</head>
<style>
    .tabsBtns{
        width: 100%;
        display: inline-block;
        background: white;
        text-align: center;
        color: black;
        padding: 10px;
        transition: 0.7s;
        border-radius: 5px;
    }
    .tabsBtns:hover{
        text-decoration: none;
        color: white;
        background: #0a93fe;
        box-shadow: 7px 8px 6px 2px #00000040;
    }
    .tabsBtns.active{
        background: #0a93fe;
        color: white;
    }
</style>
<body id="page-top">

<!-- Page Wrapper -->
<div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>
    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>

            <!-- Begin Page Content -->
            <div class="container-fluid">

                <div class="container">
                    <div class="row">
                        <div class="col-12" style="margin-bottom: 40px;">
                            <div class="row">
                                <div class="col-sm-6">
                                    <a class="tabsBtns active" href="#">Email Plans</a>
                                </div>
                                <div class="col-sm-6">
                                    <a class="tabsBtns" href="<?= $root ?>/prospect-billing">Prospect Finder</a>
                                </div>
                            </div>
                            <!-- <ul class="nav nav-tabs" id="myTab" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active show"  id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Home</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="profile-tab" data-toggle="tab" href="#" onclick="window.location.href = '<?= $root ?>'" role="tab" aria-controls="profile" aria-selected="false">Profile</a>
                                </li>
                            </ul> -->
                        </div>
                        <div class="col-sm-12">
                            <!-- Page Heading -->
                            <div class="panel-header">
                                <div class="float-left">
                                    <h1 class="panel-title">Billing Information</h1>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php
                if(isset($_SESSION['id']) && $_SESSION['id'] != '') {
                    $q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
                    $q->execute(array($_SESSION['id']));
                    $member = $q->fetch(PDO::FETCH_ASSOC);

                    //check for sub account member login then need to check parent account information
                    if ($member['parent_id'] != 0) {
                        $qm = $pdo->prepare('SELECT id,stripe_status,parent_id FROM `members` WHERE `id`=? LIMIT 1');
                        $qm->execute(array($member['parent_id']));
                        $member = $qm->fetch(PDO::FETCH_ASSOC);
                    }
                    //end

                    $flg = 0;
                    if ($member['stripe_status'] == 'active') {
                        $flg = 1;
                    }

                    if ($member['stripe_status'] == 'trialing') {
                        $flg = 1;
                    }

                    if ($flg == 0 && SITE_DEVMODE != 2 && (!in_array($member['id'], SKIP_PAYMENT)) && ($member['id'] > SKIP_PAYMENT_FIXED)) {
                        echo '<div class="alert alert-danger" role="alert">Account disabled, please select a package to continue to use Automailer</div>';
                    }
                }
                ?>
                <?php
                if( isset($_POST['update-payment-information']) ){
                    $data_member = array(
                        $_POST['country_id'],
                        $_POST['address'],
                        $_POST['city'],
                        $_POST['state'],
                        $_POST['postal_code'],
                        $member['id']
                    );
                    $q = $pdo->prepare('UPDATE `members` SET `country_id`=?, `address`=?, `selected_city`=?, `selected_state`=?, `selected_postal_code`=? WHERE `id`=?');
                    $q->execute($data_member);

                    $q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
                    $q->execute(array($member['id']));
                    $member = $q->fetch(PDO::FETCH_ASSOC);

                    echo '
              <div class="alert alert-success" role="alert">
                Payment Information was successfully updated!
              </div>
              ';
                }

                if (isset($_POST['update-billing'])){

                    $stripe_decoded = json_decode(base64_decode($_POST['stripe']));
                    $stripe_status = isset($stripe_decoded->data->status)?$stripe_decoded->data->status:'';

                    $data_member = array(
                        $_POST['plan_id'],
                        base64_decode($_POST['stripe']),
                        $stripe_status,
                        $_POST['plan_quantity'],
                        $_POST['total_cleaning_credit'],
                        $_POST['selected_state'],
                        $_POST['selected_country'],
                        $_POST['selected_city'],
                        $_POST['selected_postal_code'],
                        $_POST['selected_address'],
                        $_POST['cc_4digits'],
                        $_POST['cc_month'],
                        $_POST['cc_year'],
                        $_POST['stripe_card_brand'],
                        $member['id']
                    );
                    $q = $pdo->prepare('UPDATE `members` SET `plan`=?, `stripe`=?, `stripe_status`=?, `plan_quantity`=?, `cleaning_credits`=?, `selected_state`=?,`country_id`=?,`selected_city`=?,`selected_postal_code`=?, `address`=?, `cc_4digits`=?, `cc_month`=?, `cc_year`=?, `stripe_card_brand`=? WHERE `id`=?');
                    $q->execute($data_member);

                    $q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
                    $q->execute(array($member['id']));
                    $member = $q->fetch(PDO::FETCH_ASSOC);

                    /*echo '
                    <div class="alert alert-success" role="alert">
                      You plan was successfully updated!
                    </div>
                    ';*/
                    header('Location: '.$root.'/billing');
                    exit();
                }

                $countries = $pdo->prepare('SELECT * FROM `countries` ORDER BY `name` ASC');
                $countries->execute();

                $states = $pdo->prepare('SELECT * FROM `states` WHERE `country_id` = ? ORDER BY `name` ASC');
                $states->execute(array(225));
                ?>
                <form class="user" action="" method="post" id="register_form">
                    <input type="hidden" name="plan" id="plan" value="">
                    <input type="hidden" name="plan_id" id="plan_id" >
                    <input type="hidden" name="stripe" id="stripe">
                    <input type="hidden" name="plan_quantity" id="plan_quantity" value="1">
                    <input type="hidden" name="plan_amount" id="plan_amount">
                    <input type="hidden" name="total_cleaning_credit" id="total_cleaning_credit">
                    <input type="hidden" name="total_billing_amount" id="total_billing_amount">
                    <input type="hidden" name="plan_cleaning_credits" id="plan_cleaning_credits">

                    <input type="hidden" name="selected_country" id="selected_country">
                    <input type="hidden" name="selected_state" id="selected_state">
                    <input type="hidden" name="selected_address" id="selected_address">
                    <input type="hidden" name="selected_postal_code" id="selected_postal_code">
                    <input type="hidden" name="selected_city" id="selected_city">
                    <input type="hidden" name="cc_4digits" id="cc_4digits">
                    <input type="hidden" name="cc_month" id="cc_month">
                    <input type="hidden" name="cc_year" id="cc_year">
                    <input type="hidden" name="stripe_card_brand" id="stripe_card_brand">
                    <input type="hidden" name="selected_stripe_plan_id" id="selected_stripe_plan_id" value="">
                    <?php
                    $sub_id = "";
                    $cus_id = "";
                    if(!empty($member['stripe'] && $member['stripe']!=0))
                    {
                        $stripe = json_decode($member['stripe']);
                        $sub_id = $stripe->subscription;
                        $cus_id = $stripe->customer;
                    }else{
                        if(!empty($member['stripe_customer_id']))
                        {
                            $cus_id = $member['stripe_customer_id'];
                        }
                    }

                    ?>
                    <input type="hidden" name="sub_id" id="sub_id" value="<?php echo $sub_id; ?>">
                    <input type="hidden" name="cus_id" id="cus_id" value="<?php echo $cus_id; ?>">

                    <input type="submit" name="update-billing" value="update" id="submitBtn" style="display: none;">
                </form>

                <div id="billing-step1">
                    <div class="container">
                        <?php include_once("billing_element/select_plan.php"); ?>
                    </div>
                </div>
                <div id="billing-step2" class="container" style="display: none;">
                    <?php include_once("billing_element/billing_info.php"); ?>
                </div>


            </div>
            <!-- /.container-fluid -->

        </div>
        <!-- End of Main Content -->

        <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Copyright &copy; <?php echo date('Y'); ?></span>
                </div>
            </div>
        </footer>
        <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>

<script type="text/javascript">
    var displayError = document.getElementById('card-errors-drop');
    // var newForm = document.getElementById('new-payment-form');
    $('.chk-terms-condition').change(function(){
        if($('.chk-terms-condition').prop('checked')){
            $("#modal-terms-condition").modal('show');
        }
    });

    $(".btn-change-plan").click(function(){
        $('#billing-step1').show();
        $('#billing-step2').hide();
    });

    function selectPlan() {
        $('.select-payment-plan').on('click', '.btn', function() {
            $(this).siblings().removeClass('active');
            $(this).addClass('active').siblings().removeClass('active');
        });
    }

    function switchWrap() {

        if ($('.switch-wrap input').is(':checked')) {
            $('.billed-mo-an').addClass('checked');
            $("#billing_type").val("yearly");

            $('.plan-package').each(function(i) {
                var plan_amount  = parseFloat($(this).attr("data-value")) * 12;
                var discount     = plan_amount * .2;
                var total_amount = plan_amount - discount;
                total_amount = total_amount.toFixed(2);

                $(this).html(total_amount + "<small class='text-muted'>/yr</small>");
            });

        } else {
            $('.billed-mo-an').removeClass('checked');
            $("#billing_type").val("monthly");

            $('.plan-package').each(function(i) {
                var plan_amount  = parseFloat($(this).attr("data-value"));
                var total_amount = plan_amount;
                total_amount = total_amount.toFixed(2);

                $(this).html(total_amount + "<small class='text-muted'>/mo</small>");
            });
        };
    }

    function signup_toggle(id){
        var plan_btn = $('#btn_plan'+id).html();
        if(plan_btn != "Proceed to billing"){
            var plan_btn1 = $('#plan_name1').val();
            var plan_btn2 = $('#plan_name2').val();
            var plan_btn3 = $('#plan_name3').val();
            $('#btn_plan1').html(plan_btn1);
            $('#btn_plan2').html(plan_btn2);
            $('#btn_plan3').html(plan_btn3);
            $('#btn_plan'+id).html("Proceed to billing");
            $('.card').removeClass('selected');
            $('.card'+id).addClass('selected');
            setTimeout(function(){ signup_step2(id); }, 1500)
        }else{
            signup_step2(id);
        }
    }

    change_plan = false;
    function change_palan(plan_obj)
    {
        change_plan = true;
        $("#stripe_card").css('display','');
        signup_step2(plan_obj.value);
    }

    function signup_step2(id){
        var number_of_email       = $('#plan_email_quantity').val();
        var plan_amount           = $('#plan_amount'+id).val();
        var total_amount          = number_of_email * plan_amount;
        var plan_id               = $('#plan'+id).val();
        var cleaning_credits      = $('#plan_cleaning_credit'+id).val();
        var total_cleaning_credit = cleaning_credits;
        var annual_ammount      = plan_amount * 12;
        var plan_amount_billing = plan_amount * 1;
        var selected_plan       = $("#plan_name_"+id).val();
        var current_plan_id     = $("#current_plan_id").val();
        var current_plan_type   = $("#current_plan_type").val();

        var discount            = (plan_amount * 12) * .2;
        var total_yearly_amount = (plan_amount * 12) - discount;

        $('#plan_cleaning_credits').val(cleaning_credits);
        $('.plan_amount_billing').html(plan_amount_billing);
        $('#plan_id').val(plan_id);
        $('#plan').val(plan_id);
        $('#total_cleaning_credit').val(total_cleaning_credit);
        $('#plan_quantity').val(number_of_email);
        $('#plan_amount').val(plan_amount);

        $('#total-amount').html(total_amount);
        $('#total-email').html(number_of_email);
        $('.btn-monthly-plan').attr('data-key', id);
        $('.btn-annual-plan').attr('data-key', id);
        $('.input-number').val(number_of_email);

        $(".selected-plan").text(selected_plan + ' Account Plan');

        if( $("#billing_type").val() == 'monthly' ){
            var order_summary_amount = "$" + plan_amount;
            var plan_amount    = $("#plan_amount").val();
            var total_discount = 0;
            var total_amount = parseInt(plan_amount);
            var summary_annual_monthly = "Per Month";
            var annual_percentage_discount = 0;
            //$(".order-summary-annual").text("");
            $("#selected_stripe_plan_id").val($("#stripe_plan_monthly"+id).val());
            $(".annual-discount-text").hide();
            $(".order-summary-savings").text(0);
        }else{
            var total_amount = (plan_amount * 12) - discount;
            var order_summary_amount = "$" + total_amount;
            var plan_amount = $("#plan_amount").val() * 12;
            var total_discount = plan_amount * .2;
            var summary_annual_monthly = "Per Year";
            var annual_percentage_discount = "20%";
            var total_discount = parseInt(discount);
            total_discount     = total_discount.toFixed(2);
            $(".order-summary-savings").text(total_discount);
            $("#selected_stripe_plan_id").val($("#stripe_plan_yearly"+id).val());
            $(".annual-discount-text").show();
        }

        total_amount = total_amount.toFixed(2);
        discount     = discount.toFixed(2);
        total_yearly_amount = total_yearly_amount.toFixed(2);
        var total_email = $("#plan_quantity").val();

        if( $("#billing_type").val() == 'monthly' ){
            $(".selected-plan-amount").text("$" + total_amount + "/month");
            total_amount = plan_amount * total_email;
            var total_discount_amount = 0;
            $('.active_toggle').removeClass('active');
            $('.btn-monthly-plan').addClass('active');
        }else{
            $(".selected-plan-amount").text("$" + total_amount + "/year");
            total_amount = (plan_amount - discount) * total_email;
            var total_discount_amount = discount * total_email;
            $('.active_toggle').removeClass('active');
            $('.btn-annual-plan').addClass('active');
        }

        $('.plan_amount_yearly_billing').html(total_yearly_amount);
        $(".order-summary-monthly-charge").text("$" + plan_amount);
        $(".order-summary-amount-year").text('');
        $(".order-summary-amount-year-discount").text(discount);
        $(".discount-amount-annual-plan").text(annual_percentage_discount);

        total_amount = total_amount.toFixed(2);
        total_discount_amount = total_discount_amount.toFixed(2);
        $("#total_billing_amount").val(total_amount);

        var msg = '<img src="'+root_dir+'/img/spinner.gif" />';
        $(".order-summary-total-amount").html(msg);
        setTimeout(function () {


            if( $("#billing_type").val() == 'monthly' ){
                if(id > current_plan_id){
                    var current_plan_amount = $('#plan_amount'+current_plan_id).val();
                    var current_total_amount = current_plan_amount * number_of_email;
                    var new_total_amount =   total_amount - current_total_amount;
                    total_amount = new_total_amount.toFixed(2);
                }

                if(id < current_plan_id){
                    var new_total_amount =  0;
                    total_amount = new_total_amount.toFixed(2);
                }

                if(id == current_plan_id){
                    var new_total_amount =  0;
                    total_amount = new_total_amount.toFixed(2);
                }

            }else{
                if(id > current_plan_id){
                    var current_plan_amount = $('#plan_amount'+current_plan_id).val() * 12;
                    var current_plan_discount = current_plan_amount * 0.2;
                    var current_annual_plan_discounted = current_plan_amount - current_plan_discount;
                    var current_total_amount = current_annual_plan_discounted * number_of_email;
                    var new_total_amount =  total_amount - current_total_amount;
                    total_amount = new_total_amount.toFixed(2);
                }

                if(id == current_plan_id){
                    var new_total_amount =  0;
                    total_amount = new_total_amount.toFixed(2);
                }

                if(id < current_plan_id){
                    var new_total_amount =  0;
                    total_amount = new_total_amount.toFixed(2);
                }
            }


            $(".order-summary-total-amount").html("<big>$"+total_amount+ " / " + summary_annual_monthly + "</big>");
            $(".order-summary-savings").text(total_discount_amount);
        }, 1000);

        $(".list-cleaning-credits").html("<big>"+thousands_separators(total_cleaning_credit)+"</big>");
        if(!change_plan){
            newCard.unmount('#card-element-drop');
            newCard.mount('#card-element');
            displayError = document.getElementById('card-errors');
            $("#stripe_card").css('display','none');
            $('#billing-step1').hide();
            $('#billing-step2').show();
        }
        change_plan = false;
    }

    function thousands_separators(num){
        var num_parts = num.toString().split(".");
        num_parts[0] = num_parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        return num_parts.join(".");
    }

    $('.btn-number').click(function(e){
        e.preventDefault();

        fieldName = $(this).attr('data-field');
        type      = $(this).attr('data-type');
        var input = $("input[name='"+fieldName+"']");
        var currentVal = parseInt(input.val());
        if (!isNaN(currentVal)) {
            if(type == 'minus') {

                if(currentVal > input.attr('min')) {
                    input.val(currentVal - 1).change();
                }
                if(parseInt(input.val()) == input.attr('min')) {
                    $(this).attr('disabled', true);
                }

            } else if(type == 'plus') {

                if(currentVal < input.attr('max')) {
                    input.val(currentVal + 1).change();
                }
                if(parseInt(input.val()) == input.attr('max')) {
                    $(this).attr('disabled', true);
                }

            }
        } else {
            input.val(0);
        }

        $(".total-email-account").text(input.val());
        $("#plan_quantity").val(input.val());
        compute_total_bill();

        var total_cleaning_credits = $('#plan_cleaning_credits').val() * input.val();
        //$(".list-cleaning-credits").html("<big>"+total_cleaning_credits+"</big>");
    });

    function compute_total_bill(){
        if( $("#billing_type").val() == 'monthly' ){
            var plan_amount    = $("#plan_amount").val();
            var total_discount = 0;
        }else{
            var plan_amount = $("#plan_amount").val() * 12;
            var total_discount = plan_amount * .2;
        }

        var id           = $('#plan_id').val();
        var current_plan_id     = $("#current_plan_id").val();
        var current_plan_type   = $("#current_plan_type").val();
        var total_email = $("#plan_quantity").val();
        var total_amount = (plan_amount - total_discount) * total_email;
        var total_discount_amount = total_discount * total_email;
        total_discount_amount = total_discount_amount.toFixed(2);
        total_amount = total_amount.toFixed(2);

        $("#total_billing_amount").val(total_amount);

        var msg = '<img src="'+root_dir+'/img/spinner.gif" />';
        $(".order-summary-total-amount").html(msg);
        setTimeout(function () {
            if( $("#billing_type").val() == 'monthly' ){

                if(id > current_plan_id){
                    var current_plan_amount = $('#plan_amount'+current_plan_id).val();
                    var current_total_amount = current_plan_amount * total_email;
                    var new_total_amount =   total_amount - current_total_amount;
                    total_amount = new_total_amount.toFixed(2);
                }

                if(id < current_plan_id){
                    var new_total_amount =  0;
                    total_amount = new_total_amount.toFixed(2);
                }

                if(id == current_plan_id){
                    var new_total_amount =  0;
                    total_amount = new_total_amount.toFixed(2);
                }

                $(".order-summary-total-amount").html("<big>$"+total_amount+" / Per Month</big>");
                $(".order-summary-savings").text(total_discount_amount);
            }else{

                if(id > current_plan_id){
                    var current_plan_amount = $('#plan_amount'+current_plan_id).val() * 12;
                    var current_plan_discount = current_plan_amount * 0.2;
                    var current_annual_plan_discounted = current_plan_amount - current_plan_discount;
                    var current_total_amount = current_annual_plan_discounted * total_email;
                    var new_total_amount =  total_amount - current_total_amount;
                    total_amount = new_total_amount.toFixed(2);
                }

                if(id == current_plan_id){
                    var new_total_amount =  0;
                    total_amount = new_total_amount.toFixed(2);
                }

                if(id < current_plan_id){
                    var new_total_amount =  0;
                    total_amount = new_total_amount.toFixed(2);
                }

                $(".order-summary-total-amount").html("<big>$"+total_amount+" / Per Year</big>");
                $(".order-summary-savings").text(total_discount_amount);
            }

        }, 1000);
    }

    $(".input-number").keydown(function (e) {
        // Allow: backspace, delete, tab, escape, enter and .
        if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 190]) !== -1 ||
            // Allow: Ctrl+A
            (e.keyCode == 65 && e.ctrlKey === true) ||
            // Allow: home, end, left, right
            (e.keyCode >= 35 && e.keyCode <= 39)) {
            // let it happen, don't do anything
            return;
        }
        // Ensure that it is a number and stop the keypress
        if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
            e.preventDefault();
        }
    });

    $('.input-number').change(function() {
        minValue =  parseInt($(this).attr('min'));
        maxValue =  parseInt($(this).attr('max'));
        valueCurrent = parseInt($(this).val());

        name = $(this).attr('name');
        if(valueCurrent >= minValue) {
            $(".btn-number[data-type='minus'][data-field='"+name+"']").removeAttr('disabled')
        } else {
            alert('Sorry, the minimum value was reached');
            $(this).val($(this).data('oldValue'));
        }
        if(valueCurrent <= maxValue) {
            $(".btn-number[data-type='plus'][data-field='"+name+"']").removeAttr('disabled')
        } else {
            alert('Sorry, the maximum value was reached');
            $(this).val($(this).data('oldValue'));
        }

        $(".total-email-account").text($(this).val());
        $("#plan_quantity").val($(this).val());
        compute_total_bill();
    });

    $("#country_id").change(function(){
        var country_id = $("#country_id").val();
        var url = root_dir + "/ajax_state_input.php";
        $.ajax({
            type: "POST",
            url: url,
            data: {country_id:country_id},
            success: function(o)
            {
                $(".state-input").html(o);
                $(".state-list").select2();
            }
        });
    });

    $(".btn-monthly-plan").click(function(){
        var id           = $(this).attr('data-key');
        var plan_id      = $('#plan'+id).val();
        var plan_amount  = parseInt($('#plan_amount'+id).val());
        var total_email  = $("#plan_quantity").val();
        var total_amount = plan_amount * total_email;
        var number_of_email       = $('#plan_email_quantity').val();
        var current_plan_id     = $("#current_plan_id").val();
        var current_plan_type   = $("#current_plan_type").val();
        plan_amount = plan_amount.toFixed(2);

        $(this).addClass('active');
        $(".btn-annual-plan").removeClass('active');

        $('#plan_id').val(plan_id);
        $('#plan').val(plan_id);
        $(".selected-plan-amount").text("$" + plan_amount + "/month");
        $(".discount-amount-annual-plan").text(0);

        $(".order-summary-monthly-charge").text("$" + plan_amount);
        $("#billing_type").val("monthly");
        $("#selected_stripe_plan_id").val($("#stripe_plan_monthly"+id).val());

        var msg = '<img src="'+root_dir+'/img/spinner.gif" />';
        $(".order-summary-total-amount").html(msg);
        setTimeout(function () {


            if(id > current_plan_id){
                var current_plan_amount = $('#plan_amount'+current_plan_id).val();
                var current_total_amount = current_plan_amount * number_of_email;
                var new_total_amount =   total_amount - current_total_amount;
                total_amount = new_total_amount.toFixed(2);
            }

            if(id < current_plan_id){
                var new_total_amount =  0;
                total_amount = new_total_amount.toFixed(2);
            }

            if(id == current_plan_id){
                var new_total_amount =  0;
                total_amount = new_total_amount.toFixed(2);
            }



            $(".order-summary-total-amount").html("<big>$"+total_amount+" / Per Month</big>");
            $(".order-summary-savings").text(0);
        }, 1000);

    });

    $(".btn-annual-plan").click(function(){
        var id           = $(this).attr('data-key');
        var plan_id      = $('#plan'+id).val();
        var plan_amount  = $('#plan_amount'+id).val() * 12;
        var total_email  = $("#plan_quantity").val();
        var total_amount = plan_amount * total_email;
        var total_discount = plan_amount * .2;
        var total_discount_amount = total_discount * total_email;
        var plan_amount_less_discount = plan_amount - total_discount;
        var number_of_email       = $('#plan_email_quantity').val();
        var current_plan_id     = $("#current_plan_id").val();
        var current_plan_type   = $("#current_plan_type").val();
        plan_amount_less_discount = plan_amount_less_discount.toFixed(2);
        total_discount_amount = total_discount_amount.toFixed(2);

        $(this).addClass('active');
        $(".btn-monthly-plan").removeClass('active');

        $('#plan_id').val(plan_id);
        $('#plan').val(plan_id);
        $(".selected-plan-amount").text("$" + plan_amount_less_discount + "/year");
        $(".discount-amount-annual-plan").text('20%');

        $(".order-summary-monthly-charge").text("$" + plan_amount);
        $("#billing_type").val("yearly");
        $("#selected_stripe_plan_id").val($("#stripe_plan_monthly"+id).val());

        var msg = '<img src="'+root_dir+'/img/spinner.gif" />';
        $(".order-summary-total-amount").html(msg);
        setTimeout(function () {
            total_amount = total_amount - total_discount_amount;


            if(id > current_plan_id){
                var current_plan_amount = $('#plan_amount'+current_plan_id).val() * 12;
                var current_plan_discount = current_plan_amount * 0.2;
                var current_annual_plan_discounted = current_plan_amount - current_plan_discount;
                var current_total_amount = current_annual_plan_discounted * number_of_email;
                var new_total_amount =  total_amount - current_total_amount;
                total_amount = new_total_amount.toFixed(2);
            }

            if(id == current_plan_id){
                var new_total_amount =  0;
                total_amount = new_total_amount.toFixed(2);
            }

            if(id < current_plan_id){
                var new_total_amount =  0;
                total_amount = new_total_amount.toFixed(2);
            }


            $(".order-summary-total-amount").html("<big>$"+total_amount+" / Per Year</big>");
            $(".order-summary-savings").text(total_discount_amount);
        }, 1000);

    });

    //Stripe
    var newStripe 		  = Stripe('<?php echo $new_stripe_pk; ?>');
    var newStripeElements = newStripe.elements();

    var style = {
        base: {
            color: '#32325d',
            fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
            fontSmoothing: 'antialiased',
            fontSize: '16px',
            '::placeholder': {
                color: '#aab7c4'
            }
        },
        invalid: {
            color: '#fa755a',
            iconColor: '#fa755a'
        }


        //   $(".order-summary-total-amount").html("<big>$"+total_amount+" / Per Year</big>");
        //   $(".order-summary-savings").text(total_discount_amount);
        // }, 1000);

    };

    //Stripe
    var newStripe 		  = Stripe('<?php echo $new_stripe_pk; ?>');
    var newStripeElements = newStripe.elements();

    var style = {
        base: {
            color: '#32325d',
            fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
            fontSmoothing: 'antialiased',
            fontSize: '16px',
            '::placeholder': {
                color: '#aab7c4'
            }
        },
        invalid: {
            color: '#fa755a',
            iconColor: '#fa755a'
        }
    };

    var newCard   = newStripeElements.create('card', {hidePostalCode: true,style: style});
    newCard.mount('#card-element-drop');
    newCard.addEventListener('change', function(event) {
        if (event.error) {
            displayError.textContent = event.error.message;
        } else {
            displayError.textContent = '';
        }
    });

    function payment_form(status) {
        if(status=='dropdown')
        {
            if(!$("#stripe_card").is(":visible")){
                $("#update-all-info-form").submit();
            }
        }
        // event.preventDefault();
        newStripe.createToken(newCard).then(function(result) {
            if (result.error) {
                // var errorElement = document.getElementById('card-errors');
                displayError.textContent = result.error.message;
                $('#verify_payment_method').text(prev_text);
            } else {
                $("#selected_country").val($("#country_id").val());
                $("#selected_state").val($("#state").val());
                $("#selected_address").val($("#address").val());
                $("#selected_postal_code").val($("#postal_code").val());
                $("#selected_city").val($("#city").val());
                $.post('<?php echo $root; ?>/_new_stripe_upgrade_downgrade.php', {
                    token: result.token.id,
                    email: $('[name="email"]').val(),
                    plan: $('#selected_stripe_plan_id').val(),
                    plan_qty: $("#plan_quantity").val(),
                    sub_id: $("#sub_id").val(),
                    cus_id: $("#cus_id").val()
                })
                    .done(function(data){
                        if(data !== 0)
                        {
                            submit = 1;
                            $('#stripe').val(btoa(data));
                            $("#cc_4digits").val(result.token.card.last4);
                            $("#cc_month").val(result.token.card.exp_month);
                            $("#cc_year").val(result.token.card.exp_year);
                            $("#stripe_card_brand").val(result.token.card.brand);
                            setTimeout(function(){
                                $('#submitBtn').click();
                            }, 1000);
                        }
                        else
                        {
                            alert('Error verifying your payment method, please double check and try again.');
                            $('#verify_payment_method').text(prev_text);
                        }
                    });
            }
        });
    };

    $('#verify_payment_method').click(function(){
        prev_text = $(this).text();
        $(this).text('Updating plan...').addClass('disabled');
    });
</script>