<?php
require_once 'config.php';
require_once 'functions.php';

$no_emojis = remove_emoji($_POST['subject']);
$contact_data = array();

//Without Tags
if( $_POST['type'] == 'sent' ){
    $data = $pdo->prepare('SELECT s.id, s.to_email, s.last_activity, s.to_contact, c.id, c.firstName, c.lastName FROM `sent_mails` s LEFT JOIN  `contacts` c ON s.to_contact = c.id WHERE `campaign_id`=? AND `email_number`=?');
    $data->execute(array($_POST['campaign_id'],$_POST['email_number']));
    $type = "Sent List";
}elseif( $_POST['type'] == 'bounces' ){
    $data = $pdo->prepare('SELECT s.id, s.to_email, s.last_activity, s.to_contact, c.id, c.firstName, c.lastName FROM `sent_mails` s LEFT JOIN  `contacts` c ON s.to_contact = c.id WHERE `campaign_id`=? AND `email_number`=? AND `bounced`=1 ');
    $data->execute(array($_POST['campaign_id'],$_POST['email_number']));
    $type = "Bounce List";
}elseif( $_POST['type'] == 'replies' ){
    $data = $pdo->prepare('SELECT s.id, s.to_email, s.last_activity, s.to_contact, c.id, c.firstName, c.lastName FROM `sent_mails` s LEFT JOIN  `contacts` c ON s.to_contact = c.id WHERE `campaign_id`=? AND `email_number`=? AND `replied`=1 AND s.id NOT IN( SELECT `sent_mail_id` FROM auto_replies WHERE `member_id`=? ) ');
    $data->execute(array($_POST['campaign_id'],$_POST['email_number'], $_POST['member_id']));
    $type = "Replies List";
}elseif( $_POST['type'] == 'clicks' ){
     $data = $pdo->prepare('SELECT s.id, s.to_email, s.last_activity, s.to_contact, c.id, c.firstName, c.lastName FROM `sent_mails` s LEFT JOIN  `contacts` c ON s.to_contact = c.id WHERE `campaign_id`=? AND `email_number`=? AND `clicked`=1 ');
    $data->execute(array($_POST['campaign_id'],$_POST['email_number']));
    $type = "Clicked List";    
}else{
    //opened
    $data = $pdo->prepare('SELECT s.id, s.to_email, s.last_activity, s.to_contact, c.id, c.firstName, c.lastName FROM `sent_mails` s LEFT JOIN  `contacts` c ON s.to_contact = c.id WHERE `campaign_id`=? AND `email_number`=? AND `opened`=1');
    $data->execute(array($_POST['campaign_id'],$_POST['email_number']));
    $type = "Opened List";
}

foreach( $data as $d ){
    $contact_data[] = $d;
}



?>
<style>
    .dataTables_length, .dataTables_wrapper .dataTables_filter{
        display: block !important;
    }
</style>
<h4 style="background-color: #bdbdbd; padding: 10px; font-size: 15px;"><?php echo $type; ?></h4>

<?php
if( $_POST['type'] == 'sent' ){
    require_once('Hashid/vendor/autoload.php');
    $hashids = new Hashids\Hashids();
    $eid = $hashids->encode($_POST['campaign_id']); ?>
    <a class="btn btn-primary" href="<?php echo $root . "/export-campaign-reports/sent-messages/" . $eid; ?>" style="float: right;"><i class="fa fa-file"></i> Export to excel sent messages</a>
<?php } ?>
<div class="table-container">
    <table class="table datatable report-details-datatable">
        <thead>
        <tr>
            <th scope="col">First Name</th>
            <th scope="col">Last Name</th>
            <th scope="col">Email</th>
            <th scope="col">Last Activity</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach($contact_data as $d){ ?>
            <tr>
                <td><?php echo $d['firstName']; ?></td>
                <td><?php echo $d['lastName']; ?></td>
                <td><?php echo $d['to_email']; ?></td>
                <td><?php echo date("Y-m-d H:i:s", $d['last_activity']); ?></td>
            </tr>
        <?php } ?>
        </tbody>
    </table>
</div>
<script>
    $(function(){
        $('table.report-details-datatable').DataTable({"pageLength": 10, filter: true});
    });
</script>

