<?php

define("IN_CRONTAB", 1);
require_once dirname(__FILE__) . '/config.php';
require_once dirname(__FILE__) . '/functions.php';
require_once dirname(__FILE__) . '/helper/cron_helper.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(900);

echo 'Running Cron Send Lead Replies';
flush();
$script_time_start = microtime(true);


/*Send Lead Replies*/
/*$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `is_sent`=? AND `is_with_reply`=?');
$q->execute(array(0,0));*/
$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `is_sent`=? LIMIT 10');
$q->execute(array(0));
/*$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `id`=? LIMIT 10');
$q->execute(array(167));*/
foreach ($q as $row) {
    $data = $pdo->prepare('SELECT `id`, `data`, `member_id`, `bcc` FROM `campaigns` WHERE `id`=?');
    $data->execute(array($row['campaign_id']));
    $campaign = $data->fetch(PDO::FETCH_ASSOC);

    $data = $pdo->prepare('SELECT * FROM `leads` WHERE `id`=?');
    $data->execute(array($row['lead_id']));
    $lead = $data->fetch(PDO::FETCH_ASSOC);

    $data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `id`=?');
    $data->execute(array($lead['sent_mail_id']));
    $sent_mail = $data->fetch(PDO::FETCH_ASSOC);
    $identifier_smtp = $sent_mail['identifier'];

    $emails = json_decode($campaign['data'], 1);

    $is_sent = false;
    foreach ($emails as $email) {
        //if ($email['subject'] == $sent_mail['subject']) {
        //email sending

        $smtp = $pdo->prepare('SELECT * FROM `nylas_smtp` WHERE active = 1 AND `id`=?');
        $smtp->execute(array($email['send_id']));
        $smtp = $smtp->fetch(PDO::FETCH_ASSOC);

        $send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
        $send_limit->execute(array($smtp['email'], time() - 86400));

        if ($smtp['send_limit'] == 0) {
            $smtp['send_limit'] = $send_limit->rowcount() + 1;
        }

        if (isset($smtp['email']) && $send_limit->rowcount() < $smtp['sending_limit_per_day']) {


            $contact = $pdo->prepare('SELECT * FROM `contacts` WHERE `id`=?');
            $contact->execute(array($sent_mail['to_contact']));
            $contact = $contact->fetch(PDO::FETCH_ASSOC);

            //replace all default tags with contact values in subject of email
            $email['subject'] = str_replace('{FirstName}', $contact['firstName'], $email['subject']);
            $email['subject'] = str_replace('{LastName}', $contact['lastName'], $email['subject']);
            $email['subject'] = str_replace('{Email}', $contact['email'], $email['subject']);

            $email['subject'] = str_replace('{firstName}', $contact['firstName'], $email['subject']);
            $email['subject'] = str_replace('{lastName}', $contact['lastName'], $email['subject']);
            $email['subject'] = str_replace('{email}', $contact['email'], $email['subject']);

            //get custom tag names
            $tagData = json_decode($contact['data'], 1);

            //replace all custom tags with contact values in subject and body
            if (is_array($tagData)) {
                foreach ($tagData as $key => $value) {
                    $email['subject'] = str_replace('{' . $key . '}', $value, $email['subject']);
                }
            }

            $contact = array();
            $contact['email'] = $sent_mail['to_email'];
            $email['body'] = $row['msg'];
            $sent_data = json_decode($sent_mail['nylas_response']);
            $email['is_thread'] = $sent_data->id;
            $identifier = base64_encode($email['subject'] . '-' . $email['email_number'] . '-' . $sent_mail['to_contact'] . '-' . $email['trigger'] . '-' . $campaign['id']);

            $sender = CronHelper::cronNylasSmtpMailer($smtp, $email, $campaign, $contact, $identifier);
            echo "<pre>";
            print_r($sender);
            echo "</pre>";

            if(isset($res->message)){
                echo "smtp", "SMTP Account " . $smtp['email'] . " send failure - " . $res->message, $campaign['member_id'];
                AddNotification("smtp", "SMTP Account " . $smtp['email'] . " send failure - " . $res->message, $campaign['member_id']);
            } else {
                $is_sent = true;
            }
        }


        if ($is_sent) {
            //Update lead_replies flag is_sent field to 1
            $q = $pdo->prepare('UPDATE `lead_replies` SET `is_sent`=? WHERE `id`=?');
            $q->execute(array(1, $row['id']));
            $is_sent = false;
        }

        break;
        //}

    }
}

$time_end = microtime(true);
$time = $time_end - $script_time_start;

echo ' End Cron Send Lead Replies - Time Taken: ' . $time . '<br>';