<?php
//exit();

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PhpImap\Mailbox;
use PhpImap\Exceptions\ConnectionException;

define("IN_CRONTAB",1);
require_once dirname(__FILE__) . '/config.php';
require_once dirname(__FILE__) . '/functions.php';
require_once dirname(__FILE__) . '/PHPMailer/autoload.php';
require_once dirname(__FILE__) . '/Google/autoload.php';
require_once dirname(__FILE__) . '/swiftmailer/autoload.php';
require_once dirname(__FILE__) . '/php-imap/autoload.php';
require_once dirname(__FILE__) . '/helper/leads_helper.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);
//set_time_limit(900);
set_time_limit(0);

$unsubscribe_list = array(
    'STOP',
    'Unsubscribe',
    'Remove from list'
);

//echo 'Running Cron Mark Replies';

$leadsHelper = new LeadsHelper();

$script_time_start = microtime(true);

//Marked email if replied
$date = date("Y-m-d");
$default_followup_date = defaultFollowupDate($date);

$data = $pdo->prepare('SELECT `id`, `cron_module`,`last_id_checked`,`last_activity` FROM `cron_last_activities` WHERE `cron_module`="lead_replies"');
$data->execute();
$cron = $data->fetch(PDO::FETCH_ASSOC);
$last_id_checked = $cron['last_id_checked'];

//$q = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `bounced`=? AND nylas_response IS NOT NULL AND `id` >= ? LIMIT 200');
//$q = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `bounced`=? AND `opened`=? AND nylas_response IS NOT NULL AND `id` >= ? LIMIT 300');
//$q->execute(array(0,1,$last_id_checked));
$q = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `bounced`=? AND `need_to_refresh`=? AND nylas_response IS NOT NULL AND `id` >= ? LIMIT 300');
$q->execute(array(0,'yes',$last_id_checked));

//$q = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `replied`=? AND `bounced`=? AND nylas_response IS NOT NULL');
//$q->execute(array(0,0));
/*$q = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `bounced`=? AND nylas_response IS NOT NULL');
$q->execute(array(0));*/
$all_mails = $q->fetchAll();
//echo '<pre>';print_r($all_mails);

foreach ($all_mails as $row) {

    $last_id_checked = $row['id'];

    //prevent duplicate entry if cron run parallel
    /*$sent_update = $pdo->prepare('UPDATE `sent_mails` SET `need_to_refresh`=? WHERE `id`=?');
    $sent_update->execute(array('no', $row['id']));*/
    //end

    /*added due to sub account campaign thread not fetch*/
    $members = $pdo->prepare('SELECT m.id, m.fname, m.lname, m.timezone, m.parent_id, m.email, m.email_notification_recipient FROM (`members` as m) WHERE m.status = 1 AND m.id = ?');
    $members->execute(array($row['member_id']));
    $member = $members->fetch(PDO::FETCH_ASSOC);

    if( $member['parent_id'] > 0 ){
        $smtp_member_id = $member['parent_id'];
    }else{
        $smtp_member_id = $member['id'];
    }
    //end

    $imap = $pdo->prepare('SELECT `id`,`name`,`email`,`username`,`member_id`,`nylas_account_id`,`nylas_access_token` FROM `nylas_smtp` WHERE  active = 1  AND `member_id`=? AND `email`=?');
    //$imap->execute(array($row['member_id']));
    $imap->execute(array($smtp_member_id,$row['from_email']));

    echo '<br/>';
    echo 'this is for campaign id--> '.$row['campaign_id'].'<br/>';
    echo 'this is for member id original--> '.$row['member_id'].'<br/>';
    echo 'this is for member id if sub account campaign--> '.$smtp_member_id.'<br/>';
    echo 'current count--> '.$row['message_count'].'<br/>';

    if($imap->rowcount()>0) {
        $imap = $imap->fetch(PDO::FETCH_ASSOC);

        $is_bounced = 0;
        //if($strpos !== false){
        $leads = $pdo->prepare('SELECT `id`,`member_id`,`mail_id`,`sent_mail_id` FROM `leads` WHERE `sent_mail_id`=?');
        $leads->execute(array($row['id']));

        //nylas stuff
        $nylas_access_token = $imap['nylas_access_token'];

        $nylas_response = json_decode($row['nylas_response']);

        if(isset($nylas_response->thread_id)) {
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://api.nylas.com/threads/" . $nylas_response->thread_id,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: application/json",
                    "Authorization: Bearer " . $nylas_access_token,
                ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);

            $res = json_decode($response);

            if (isset($res->message)) {

                //$updateActive = $pdo->prepare('UPDATE `nylas_smtp` SET active = ?, inactive_reason=? WHERE `id`=?');
                //$updateActive->execute(array(0, $res->message, $imap['id']));
                //exit;
            }

            if(isset($res->message_ids))
                $msg_count = count($res->message_ids);
            else
                $msg_count = 0;

            //if(!empty($res->last_message_received_timestamp)){
            echo 'nylas count --> '.$msg_count.' <----<br/>';

            //  if(($res->last_message_received_timestamp > $row['last_message_received_timestamp']) ) {
            if ($msg_count > 1) {
                if (($msg_count > $row['message_count'])) {

                    $curl = curl_init();

                    curl_setopt_array($curl, array(
                        CURLOPT_URL => "https://api.nylas.com/messages/" . $res->message_ids[$msg_count - 1],
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => "GET",
                        CURLOPT_HTTPHEADER => array(
                            "Content-Type: application/json",
                            "Authorization: Bearer " . $nylas_access_token,
                        ),
                    ));

                    $response_msg = curl_exec($curl);

                    curl_close($curl);

                    $res_msg = json_decode($response_msg);

                    //$mail_date = $res_msg->date;
                    date_default_timezone_set($member['timezone']);
                    $mail_date = time();
                    $content = $res_msg->body;
                    //end

                    //$owned_msg = array('couldn\'t be delivered','wasn\'t delivered to','could not be delivered','created automatically by mail delivery software','INVALID_ADDRESS','This is a permanent error','Delivery has failed','The email address that you entered couldn\'t be found','This message was created automatically by mail delivery system','mx.google.com rejected your message to the following email addresses','mx.google.com gave this error','email address is no longer active','rejected your message to the following','The email system had a problem processing this message','There was a temporary problem delivering your message','The recipient server did not accept our requests to connect','Recipient address rejected','has been blocked');

                    $q = $pdo->prepare('SELECT * FROM `bouncerules` where `bounce_type`=? OR `bounce_type`=?');
                    $q->execute(array('soft','hard'));
                    $owned_msg = $q->fetchAll();

                    $auto_replies = false;
                    $bounced = false;
                    $bounced_val = '';

                    //foreach ($owned_msg as $str) {
                    foreach ($owned_msg as $str) {
                        //if (strpos($content, $str) !== FALSE) { // Yoshi version
                        if (strpos($content, $str['filter_text']) !== FALSE) { // Yoshi version
                            $bounced = true;
                            if($str['bounce_type'] == 'soft'){
                                $bounce_type  = 1;
                            }else{
                                $bounce_type = 2;
                            }
                        }
                    }
 
                    //$owned_auto_msg = array('out of office','out of the office','I am on vacation or otherwise unable to read my email','I am unavailable to read your message at this time','when I return to the office','I am out of town','I will be on vacation','I shall be out of office','I will be out of the office','I am currently out of office','I am currently out of the office','away from the office','on maternity leave','This is an autoresponder','currently on holiday','currently on vacation');
                    //$search_pattern = autoReplyStringPattern();
                    $q = $pdo->prepare('SELECT * FROM `bouncerules` where `bounce_type`=?');
                    $q->execute(array('auto_reply'));
                    $search_pattern = $q->fetchAll();
                    foreach ($search_pattern as $str) {
                        //if (strpos($content, $str) !== FALSE) { // Yoshi version
                        if (strpos($content, $str['filter_text']) !== FALSE) { // Yoshi version
                            $auto_replies = true;
                        }
                        if(searchContent($str['filter_text'], $content)){
                            //Save autoreply
                            $auto_replies = true;
                        }

                        if($auto_replies) {
                            $data = array(
                                NULL,
                                $row['id'],
                                strtotime($default_followup_date),
                                $mail_date,
                                $content,
                                0,
                                $row['member_id']
                            );

                            $q = $pdo->prepare('INSERT INTO `auto_replies` VALUES (?,?,?,?,?,?,?)');
                            $result = $q->execute($data);
                        }
                    }

                    /*$auto_unsubscribe = false;
                    foreach ($unsubscribe_list as $unsubscribe_value) {
                        if(strpos($content, $unsubscribe_value) !== FALSE) { // Yoshi version
                            $auto_unsubscribe = true;
                        }
                        if(searchContent($unsubscribe_value, $content)){
                            $auto_unsubscribe = true;
                        }

                    }

                    if($auto_unsubscribe == true) {
                        $resultUnsubscribe = $pdo->prepare('SELECT * FROM `unsubscribed_emails` WHERE campaign_id = ? AND `email`=?');
                        $resultUnsubscribe->execute(array($row['campaign_id'], $row['to_email']));
                        if ($resultUnsubscribe->rowcount() == 0)
                        {
                            // Insert the unsubscribe
                            $unsubscribeInsert = $pdo->prepare('INSERT INTO `unsubscribed_emails` (member_id,campaign_id,email,date_created) VALUES (?,?,?,?)');
                            $unsubscribeInsert->execute(array($smtp_member_id, $row['campaign_id'], $row['to_email'], time()));
                        }

                    }*/

                    //if (strstr($string, $url)) { // mine version
                    if ($bounced == true) {
                        echo "\"undeliverable\" exists in the content variable<br/>";

                        $replied = $pdo->prepare('UPDATE `sent_mails` SET  `message_count`=?, `bounced`=?,`bounce_type`=? ,`need_to_refresh`=? WHERE `id`=?');
                        $replied->execute(array($msg_count, 1, $bounce_type,'no', $row['id']));

                        if($bounce_type == 2){ //only for hard bounce

                            //bounce pertage checking and its setting in admin side.
                            $bounce_percentage = $pdo->prepare('SELECT * FROM `bounce_percent_detection` WHERE `id`=?');
                            $bounce_percentage->execute(array(1));
                            $bounce_percentage = $bounce_percentage->fetch(PDO::FETCH_ASSOC);

                            $bounce_percent = $bounce_percentage['bounce_percent'];

                            $sent_email = $pdo->prepare('SELECT `id` FROM `sent_mails` WHERE `campaign_id`=?');
                            $sent_email->execute(array($row['campaign_id']));
                            $total_sent  = $sent_email->rowcount();

                            $bounced = $pdo->prepare('SELECT `id` FROM `sent_mails` WHERE `campaign_id`=? AND `bounced`=1 AND `bounce_type`=2');
                            //$bounced = $pdo->prepare('SELECT `id` FROM `sent_mails` WHERE `campaign_id`=? AND `bounced`=1');
                            $bounced->execute(array($row['campaign_id']));
                            $total_bounced = $bounced->rowcount();

                            $campaign_details = $pdo->prepare('SELECT `list`,`bounce_tag_1`,`bounce_tag_2`,`name`,`member_id`,`id` FROM `campaigns` WHERE `id`=?');
                            $campaign_details->execute(array($row['campaign_id']));
                            $campaign = $campaign_details->fetch(PDO::FETCH_ASSOC);

                            //update that contact as hard bounce so will never send any mail to this email
                            /*$q = $pdo->prepare('UPDATE `contacts` SET `status`=? WHERE `list_id`=?');
                            $q->execute(array(4, $campaign['list']));*/
                            //end

                            //Check if the email is on the global_bounce_list
                            $q = $pdo->prepare('SELECT * FROM `global_bounce_list` WHERE `bounce_email`=?');
                            $q->execute(array($row['to_email']));
                            $contact_total_count = $q->rowcount();
                            //end

                            //This will add the email to global_bounce_list if Hard bounce and not yet on the list
                            if($contact_total_count == 0){
                                $data = array(
                                    $row['member_id'],
                                    $row['to_email'],
                                    $mail_date
                                );

                                $q = $pdo->prepare('INSERT INTO `global_bounce_list` (member_id,bounce_email,created) VALUES (?,?,?)');
                                $result = $q->execute($data);
                            }
                            //end

                            $contact_total = $pdo->prepare('SELECT `id` FROM `contacts` WHERE `list_id`=? AND (status=? OR status=?)');
                            $contact_total->execute(array($campaign['list'], 1, 0));
                            $contact_total_count = $contact_total->rowcount();

                            echo "total bounce ".$total_bounced. "<br>";
                            echo "total contact ".$contact_total_count. "<br>";
                            echo "total sent ".$total_sent. "<br>";

                            $sent_bounced_percentage = ($total_bounced * 100)/$contact_total_count;

                            $bounced_1_confirm = false;
                            $bounced_2_confirm = false;

                            if($sent_bounced_percentage >= $bounce_percent){
                                $bounced_1_confirm = true;
                            }

                            // computation 10%

                            if($total_sent >= SENT_MINIMUM_MAIL) {
                                $sent_bounced_percentage_2 = ($total_bounced * 100)/$contact_total_count;
                                if ($sent_bounced_percentage_2 >= BOUNCE_PERCENTAGE_2) {
                                    $bounced_2_confirm = true;
                                }
                            }

                            if($bounced_1_confirm && $campaign['bounce_tag_1'] != 1){

                                //send mail
                                $subject = "Automailer Notification: You have reached our 3% bounce threshold";
                                $body_reply = "<p>Hi ".ucfirst($member['fname']).", </p><p>Your campaign ".$campaign['name']." has reached a 3% bounce rate threshold and we have proactively paused your campaign to help protect your email reputation. Your email reputation plays a huge role when it comes to deliverability and inbox placement and sending to bad emails can drastically affect how ESP’s treat your email. </p>";
                                $body_reply .= "<p>Please take a look at your emailing list and make sure you're sending to good contacts. If your list has not yet been cleaned, this would be a good time to do it.</p>";
                                $body_reply .= "<p>However, you may choose to resume your campaign at any time by navigating to the campaign page and changing the status from Paused to ACTIVE.</p>";
                                $body_reply .= "<br /><p>Thank you,<br/>Automailer Support team</p>";

                                $mail_res = new PHPMailer();
                                $mail_res->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;

                                $mail_res->IsSMTP();
                                $mail_res->Host = SMTP_HOST;
                                $mail_res->SMTPAuth = false;
                                //$mail->SMTPDebug = 2;
                                //$mail_res->Username = SMTP_USERNAME;
                                //$mail_res->Password = SMTP_PASSWORD;
                                $mail_res->Port = SMTP_PORT;
                                $mail_res->IsHTML(true);
                                $mail_res->setFrom(SMTP_FROM_EMAIL);
                                $mail_res->FromName = SMTP_FROM_NAME;

                                $mail_res->addAddress($member['email']);

                                $mail_res->Subject = $subject;
                                $mail_res->Body = $body_reply;
                                $mail_res->AltBody = strip_tags($body_reply);
                                $mail_res->Send();
                                //end

                                // TODO TRAP Campaign that reach the bounce percentage to set as paused and add notification to system
                                AddNotification("Campaign", "Bounce percentage reached! we pause your campaign name: ". $campaign['name'] ." - Please clean your list used in this campaign and set to active again.",$campaign['member_id']);

                                //This will set the particular campaign to pause when the bounce percentage is reached it will auto set the campaign to Pause

                                $q = $pdo->prepare('UPDATE `campaigns` SET `status`=? , `bounce_tag_1`=? WHERE `member_id`=?  AND `id`=?');
                                $q->execute(array(CAMPAIGN_STATUS_PAUSED, 1, $campaign['member_id'], $campaign['id']));

                            }

                            if($bounced_2_confirm && $campaign['bounce_tag_2'] != 1){

                                //send mail
                                $subject = "Automailer Notification: You have reached our 10% bounce threshold";
                                $body_reply = "<p>Hi ".ucfirst($member['fname']).", </p><p>Your campaign ".$campaign['name']." has reached a 10% bounce rate threshold and we have proactively paused your campaign to help protect your email reputation. Your email reputation plays a huge role when it comes to deliverability and inbox placement and sending to bad emails can drastically affect how ESP’s treat your email. </p>";
                                $body_reply .= "<p>Please take a look at your emailing list and make sure you're sending to good contacts. If your list has not yet been cleaned, this would be a good time to do it.</p>";
                                $body_reply .= "<p>However, you may choose to resume your campaign at any time by navigating to the campaign page and changing the status from Paused to ACTIVE.</p>";
                                $body_reply .= "<br /><p>Thank you,<br/>Automailer Support team</p>";

                                $mail_res = new PHPMailer();
                                $mail_res->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;

                                $mail_res->IsSMTP();
                                $mail_res->Host = SMTP_HOST;
                                $mail_res->SMTPAuth = false;
                                //$mail->SMTPDebug = 2;
                                // $mail_res->Username = SMTP_USERNAME;
                                // $mail_res->Password = SMTP_PASSWORD;
                                $mail_res->Port = SMTP_PORT;
                                $mail_res->IsHTML(true);
                                $mail_res->setFrom(SMTP_FROM_EMAIL);
                                $mail_res->FromName = SMTP_FROM_NAME;

                                $mail_res->addAddress($member['email']);

                                $mail_res->Subject = $subject;
                                $mail_res->Body = $body_reply;
                                $mail_res->AltBody = strip_tags($body_reply);
                                $mail_res->Send();
                                //end

                                // TODO TRAP Campaign that reach the bounce percentage to set as paused and add notification to system
                                AddNotification("Campaign", "Bounce percentage reached! we pause your campaign name: ". $campaign['name'] ." - Please clean your list used in this campaign and set to active again.",$campaign['member_id']);

                                //This will set the particular campaign to pause when the bounce percentage is reached it will auto set the campaign to Pause

                                $q = $pdo->prepare('UPDATE `campaigns` SET `status`=? , `bounce_tag_2`=? WHERE `member_id`=?  AND `id`=?');
                                $q->execute(array(CAMPAIGN_STATUS_PAUSED, 1, $campaign['member_id'], $campaign['id']));

                            }
                            //end

                        }
                        //added later on 5-3-21
                        $continue_automation = $leadsHelper->stopAutomation();
                        //AddNotification("autoreply", "Received new auto reply Subject: ".$row['subject'], $row['member_id']);
                        //end
                    } else {
                        if ($leads->rowcount() <= 0) {

                            //echo '<pre>';print_r($res_msg);exit;

                            /*$status = $leadsHelper->cronSetLeadStatus($content);

                            if ($status == 0) {
                                $continue_automation = $leadsHelper->continueAutomation();
                                //AddNotification("leads", "New Lead", $row['member_id']);
                                AddNotification("leads", "New Lead Subject: ".$row['subject'], $row['member_id']);
                            } else {
                                $is_bounced = 1;
                                $continue_automation = $leadsHelper->stopAutomation();
                                //AddNotification("autoreply", "Received new auto reply", $row['member_id']);
                                AddNotification("autoreply", "Received new auto reply Subject: ".$row['subject'], $row['member_id']);
                            }*/

                            if($auto_replies == true){
                                $continue_automation = $leadsHelper->stopAutomation();
                                AddNotification("autoreply", "Received new auto reply Subject: ".$row['subject'], $row['member_id']);
                                $status = 3; //this is auto reply status
                            }else {
                                $continue_automation = $leadsHelper->continueAutomation();
                                AddNotification("leads", "New Lead Subject: " . $row['subject'], $row['member_id']);
                                $status = 0;
                            }

                            $campaign_imap = $pdo->prepare('SELECT * FROM `campaigns` WHERE `id`=?');
                            $campaign_imap->execute(array($row['campaign_id']));
                            $campaign_imap_id = $campaign_imap->fetch(PDO::FETCH_ASSOC);
                            //if(strtotime($email->date) >= $campaign_imap_id['trigger_date']){
                            $data = array(
                                $row['id'],
                                strtotime($default_followup_date),
                                //$res->last_message_sent_timestamp,
                                $mail_date,
                                $content,
                                $status,
                                //0,
                                $row['member_id'],
                                $nylas_response->thread_id,
                                $continue_automation
                            );

                            $q = $pdo->prepare('INSERT INTO `leads` (sent_mail_id,followup_date,replied_date,content,status,member_id,mail_id,continue_automation) VALUES (?,?,?,?,?,?,?,?)');
                            $result = $q->execute($data);
                            print_r($q->errorInfo());

                            //this is for replied count
                            $replied = $pdo->prepare('UPDATE `sent_mails` SET `replied`=1, `last_activity`=?, `bounced`=?, `is_verified`=1, `need_to_refresh`=? WHERE `id`=?');
                            //$replied->execute(array(time(), $is_bounced, $row['id']));
                            $replied->execute(array(time(), 0, 'no', $row['id']));
                            //end


                            $first_name = $member['fname'];
                            $campaign = $campaign_imap_id['name'];
                            $subject = "Automailer Notification: New reply received";
                            $body_reply = "<link href='http://fonts.googleapis.com/css?family=Lato:400,700' rel='stylesheet' type='text/css'>";
                            $body_reply .= '<p style="font-family: \'Lato\', sans-serif; font-size:15px;" >Hi '.ucfirst($first_name).', </p> <p style="font-family: \'Lato\', sans-serif; font-size:15px;" > Your campaign <a href="'. $root."/leads" . '"> '.$campaign.' </a> has a new reply.</p>';
                            $body_reply .= '<p style="font-family: \'Lato\', sans-serif; font-size:15px;" >Login to your account and check you messages/inbox section. </p>';
                            $body_reply .= '<p style="font-family: \'Lato\', sans-serif; font-size:15px;margin-top:30px;" >Thank you,</p><p style="font-family: \'Arial\', sans-serif;margin-top:30px;margin-bottom:0px;font-size: 16px;"> <b> Automailer Support</b> </p><img src="https://jrhwv.stripocdn.email/content/guids/CABINET_72b1e6e71b4adb8c2515e18274d4aa55/images/75061614616805393.png" style="margin-top:1px" width="147px" height="27px" ><p style="color:#808080;font-family: \'Lato\', sans-serif; font-size:12px;"><b>Need help?</b> Feel free to reach out to us by submitting a ticket. Here is how: Login to your Automailer account -> Main Menu -> Support tab -> Submit Ticket | Our support hours are from Monday to Friday 9:00am to 5:00pm CST.</p>';

                            $email_notification_reply = "";

                            if($member['email_notification_recipient'] != ""){
                                $email_notification_reply = $member['email_notification_recipient'];
                            }

                            if($campaign_imap_id['email_notification_recipient'] != ""){
                                $email_notification_reply = $campaign_imap_id['email_notification_recipient'];
                            }

                            if($email_notification_reply == ""){
                                $email_notification_reply = $member['email'];
                            }

                            if($campaign_imap_id['enable_email_notification']==1){

                                $mail_res = new PHPMailer();
                                $mail_res->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;

                                $mail_res->IsSMTP();
                                $mail_res->Host = SMTP_HOST;
                                $mail_res->SMTPAuth = false;

                                $mail_res->Port = SMTP_PORT;
                                $mail_res->IsHTML(true);
                                $mail_res->setFrom(SMTP_FROM_EMAIL);
                                $mail_res->FromName = SMTP_FROM_NAME;

                                $mail_res->addAddress($email_notification_reply);

                                $mail_res->Subject = $subject;
                                $mail_res->Body = $body_reply;
                                $mail_res->AltBody = strip_tags($body_reply);
                                $mail_res->Send();
                                //end
                            }

                            // add notification to system for reply
                            AddNotification("Campaign", "New Reply on Inbox subject: ". $row['subject'] ." - Please check on the inbox for more details.",$campaign['member_id']);









//                            $lead_id = $pdo->lastInsertId();
//
//                            //Insert lead reply
//                            $data = array(
//                                $lead_id,
//                                $row['campaign_id'],
//                                $content,
//                                $res->last_message_sent_timestamp,
//                                1,
//                                1,
//                                0
//                            );
//                            $q = $pdo->prepare('INSERT INTO `lead_replies` (lead_id,campaign_id,msg,replied_date,is_with_reply,is_sent,mail_id)  VALUES (?,?,?,?,?,?,?)');
//                            $result = $q->execute($data);
//
//                            AddNotification("leads", "New Lead Reply",$row['member_id']);

                            //}

                        } else {

                            $leadThread = $pdo->prepare('SELECT `id`,`mail_id` FROM `lead_replies` WHERE `mail_id`=? AND `campaign_id`=?');
                            $leadThread->execute(array($nylas_response->thread_id,$row['campaign_id']));

                            $leadThread_Sent = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `mail_id`=? AND `campaign_id`=?');
                            $leadThread_Sent->execute(array(0,$row['campaign_id']));
                            //$content_with_replace = preg_replace("/<img[^>]+\>/i", "", $content);

                            //this logic for while send some reply from automailer platform and then receive same content again.
                            $duplicate=false;
                            /*foreach ($leadThread_Sent as $reply_check){
                                $content_with_replace = preg_replace("/<img[^>]+\>/i", "(image) ", $content);
                                if($reply_check['msg'] == trim(strip_tags($content))){
                                    $duplicate = true;
                                }
                            }*/
                            if($res_msg->folder->name != 'inbox'){
                                $duplicate = true;
                            }
                            //end

                            //if ($leadThread->rowcount() <= 0) {
                            if(!$duplicate) {
                                $leads = $leads->fetch(PDO::FETCH_ASSOC);
                                //Insert lead reply
                                $data = array(
                                    $leads['id'],
                                    $row['campaign_id'],
                                    $content,
                                    //$res->last_message_sent_timestamp,
                                    $mail_date,
                                    1,
                                    1,
                                    $nylas_response->thread_id
                                );
                                $q = $pdo->prepare('INSERT INTO `lead_replies` (lead_id,campaign_id,msg,replied_date,is_with_reply,is_sent,mail_id)  VALUES (?,?,?,?,?,?,?)');
                                $result = $q->execute($data);

                                //AddNotification("leads", "New Lead Reply", $row['member_id']);
                                AddNotification("leads", "New Lead Reply Subject: ".$row['subject'], $row['member_id']);
                            }
                            //}
                        }

//                                    $replied = $pdo->prepare('UPDATE `sent_mails` SET  `message_count`=?, `last_message_received_timestamp`=?, `is_verified`=1 WHERE `id`=?');
//                                    $replied->execute(array($msg_count, $res->last_message_received_timestamp, $row['id']));
                        $replied = $pdo->prepare('UPDATE `sent_mails` SET  `message_count`=?, `last_message_received_timestamp`=?, `bounced`=?, `is_verified`=1, `need_to_refresh`=? WHERE `id`=?');
                        $replied->execute(array($msg_count, $res->last_message_received_timestamp, 0 , 'no', $row['id']));

                        // echo ->textHtml; for reply html
                        /*if (count($res->message_ids) > 1) {
                            $replied = $pdo->prepare('UPDATE `sent_mails` SET `replied`=1, `last_activity`=?, `bounced`=?, `is_verified`=1 WHERE `id`=?');
                            $replied->execute(array(time(), $is_bounced, $row['id']));
                            $is_updated = true;
                        }*/

                    }

                    //}


                }
            }
        }


    }
    echo '<br/>';

}

if($last_id_checked == $cron['last_id_checked']){
    $q = $pdo->prepare('UPDATE `cron_last_activities` SET `last_id_checked`=?, `last_activity`=? WHERE `cron_module`="lead_replies"');
    $result = $q->execute(array(0,time()));
}else{
    if($last_id_checked > 0){
        $q = $pdo->prepare('UPDATE `cron_last_activities` SET `last_id_checked`=?, `last_activity`=? WHERE `cron_module`="lead_replies"');
        $result = $q->execute(array($last_id_checked,time()));
    }
}

$time_end = microtime(true);
$time = $time_end - $script_time_start;

echo ' End Cron Mark Replies: - Time Taken: ' . $time . '<br/>';

//Delete old notifications
$date_query = date('Y-m-d', strtotime('-15 days'));
$date_query = strtotime($date_query);
$notifications = $pdo->prepare('DELETE FROM notifications WHERE date_time < ?');
$notifications->execute(array($date_query));

//Resume Date Trigger
$q = $pdo->prepare('SELECT * FROM `leads` WHERE `continue_automation`=? AND status = 3  AND resume_date <> 0');
$q->execute(array(0));
$all_resume_dates = $q->fetchAll();

foreach ($all_resume_dates as $row) {
    $date_today = strtotime(date("m/d/Y h:i A"));
    $resume_date = $row['resume_date'];
    if ($resume_date <= $date_today) {
        $sql = "UPDATE leads SET continue_automation=? WHERE id=?";
        $q = $pdo->prepare($sql);
        $q->execute(array(1, $row['id']));
    }
}