<title><?php echo SITE_NAME; ?> - User Preferences</title>
</head>
<style>
    #show-password{
        z-index: 9999 !important;
    }
    .unsubscribe-p{
        margin-bottom: -1.5 !important;
    }
    .modal.modal-enhanced .modal-header {
        padding: 1rem 1.5rem;
    }

    .modal .modal-content .modal-body {
        padding: 24px;
        color: #404040;
    }
    #unsubscribe, #email-notification{
        height: 16px !important;
        width: 19px !important;
        position: relative;
        top: 3px;
    }

    .unsubscribe-p{
        margin-bottom: -1.5 !important;
    }
    .modal.modal-enhanced .modal-header {
        padding: 1rem 1.5rem;
    }
    .hidden{
        display: none;
    }
</style>
<body id="page-top">


<!-- Page Wrapper -->
<div id="wrapper">
    <?php include_once("nav_wrapper.php"); ?>
    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>

            <!-- Begin Page Content -->
            <div class="container-fluid">

                <!-- Page Heading -->
                <div class="panel-header">
                    <div class="float-left">
                        <h1 class="panel-title">User Preferences</h1>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <?php
                if (isset($_POST['action'])){
                    // $password = $_POST['settings_user_password'];
                    // $password = htmlspecialchars($password, ENT_QUOTES);
                    // if( $password != '' && password_verify($password, $member['password'])){
                    //   $_POST['settings_user_password'] = htmlspecialchars($_POST['settings_user_password'], ENT_QUOTES);

                    $unsubscribe_link = 0;
                    $unsubscribe_link_text = '';
                    if( isset($_POST['unsubscribe_link']) ){
                        $unsubscribe_link = 1;
                        $unsubscribe_link_text = $_POST['unsubscribe_link_text'];
                    }

                    $enable_email_notification = 0;
                    if( isset($_POST['email_notification_chk']) ){
                        $enable_email_notification = 1;
                    }

                    $data_member = array(
                        $_POST['email_notification'],
                        $unsubscribe_link,
                        $unsubscribe_link_text,
                        $enable_email_notification,
                        $member['id']
                    );
                    $sql = 'UPDATE `members` SET `email_notification_recipient`=?, `unsubscribe_link`=?, `text_to_display`=?, `enable_email_notification`=?  WHERE `id`=?';
                    $q = $pdo->prepare($sql);
                    $q->execute($data_member);

                    $q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
                    $q->execute(array($member['id']));
                    $member = $q->fetch(PDO::FETCH_ASSOC);

                    echo '
                <div class="alert alert-success" role="alert">
                  User setting was successfully updated!
                </div>
                ';
                    // }else{
                    //   echo '
                    //   <div class="alert alert-danger" role="alert">
                    //     Invalid password!
                    //   </div>
                    //   ';
                    // }
                }
                ?>
                <div class="container" style="margin-top: 30px;">
                    <form class="" action="" method="post" id="user_preferences_setting">
                        <div class="row">
                            <div class="col-md-8">
                                <label style="padding-left: 0px; "><input type="checkbox" name="unsubscribe_link" id="unsubscribe" <?php echo($member['unsubscribe_link'] == 1 ? 'checked' : ''); ?> value="1"> <b>Unsubscribe Link </b> - Unchecking this option will disable the built in unsubscribe link in your emails.</label>

                                <div class="form-group unsubscribe-text <?php echo($member['unsubscribe_link'] == 1 ? '' : 'hidden'); ?>" style="margin-top: 25px;max-width: 100%;">
                                    <input type="text" name="unsubscribe_link_text" id="unsubscribe_link_text" value="<?php echo $member['text_to_display']; ?>" class="form-control" required>
                                    <label for="unsubscribe_link_text">Text to display on unsubscribe link</label>
                                </div>

                                <label style="padding-left: 0px; "><input type="checkbox" name="email_notification_chk" id="email-notification" <?php echo($member['enable_email_notification'] == 1 ? 'checked' : ''); ?> value="1"> <b>Reply Notification </b> - Unchecking this option will disable the campaign reply email notification.</label>


                                <?php

                                if($member['email_notification_recipient'] != NULL){
                                    $email = $member['email_notification_recipient'];
                                }else{
                                    $email = $member['email'];
                                }

                                ?>

                                <div class="form-group email-notification-input <?php echo($member['enable_email_notification'] == 1 ? '' : 'hidden'); ?>" style="margin-top: 25px;max-width: 100%;">
                                    <input type="text" name="email_notification" id="email_notification" value="<?php echo $email; ?>" class="form-control" required>
                                    <label for="email_notification">Email where your notifications will be sent to</label>
                                </div>

                            </div>
                        </div>
                        <div class="row" style="margin-top: 40px;">
                            <div class="col-md-6">
                                <button class="btn btn-success btn-lg btn-user-preferences-update" type="button">Update Settings</button>
                            </div>
                        </div>

                        <div class="modal fade" id="modal-user-preferences-update-settings" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <h4 class="modal-heading">Update Settings</h4>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <input type="password" name="settings_user_password" placeholder="********" value="" class="form-control" required="">
                                                    <label>Enter your password to update settings: *</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                            <button type="submit" class="btn btn-success" name="action" value="update-user-preferences">Update</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="modal fade modal-enhanced" id="modalUnsubscribe" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                            <div class="modal-dialog modal-m" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title"><i class="far fa-plus-square"></i> Unsubscribe</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <!-- <form action="" method="post" id="">   -->
                                    <div class="modal-body">
                                        <input type="hidden" name="action" value="add">
                                        <div class="modal-add-smtp-msg"></div>
                                        <div class="row">
                                            <div class="col-md-12 add-exclusion-domain" style="">
                                                <div class="form-group">

                                                    <p style="margin-bottom: -1.5em;">By unchecking this box you agree to disable the Unsubscribe link on the email sending.</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-success unsubscribe-save" name="action-unsubscribe" data-dismiss="modal">Agree</button>
                                        </div>
                                    </div>
                                    <!-- </form> -->
                                </div>
                            </div>
                        </div>

                        <div class="modal fade modal-enhanced" id="modalEmailNotification" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                            <div class="modal-dialog modal-m" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title"><i class="far fa-plus-square"></i> Email Notification</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <!-- <form action="" method="post" id="">   -->
                                    <div class="modal-body">
                                        <input type="hidden" name="action" value="add">
                                        <div class="modal-add-smtp-msg"></div>
                                        <div class="row">
                                            <div class="col-md-12 add-exclusion-domain" style="">
                                                <div class="form-group">

                                                    <p style="margin-bottom: -1.5em;">By unchecking this box you agree to disable sending email notification.</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-success" data-dismiss="modal">Agree</button>
                                        </div>
                                    </div>
                                    <!-- </form> -->
                                </div>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
            <!-- /.container-fluid -->

        </div>
        <!-- End of Main Content -->

        <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Copyright &copy; <?php echo date('Y'); ?></span>
                </div>
            </div>
        </footer>
        <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>


<script>
    $(function(){
        $(".btn-user-preferences-update").click(function(){
            $("#user_preferences_setting").submit();
            // $("#modal-user-preferences-update-settings").modal('show');
        });

        $('#unsubscribe').click(function(){
            if($(this).is(":not(:checked)")){
                $("#modalUnsubscribe").modal("show");
                $(".unsubscribe-text").fadeOut();
            }else{
                $(".unsubscribe-text").fadeIn();
            }
        });

        $('#email-notification').click(function(){
            if($(this).is(":not(:checked)")){
                $("#modalEmailNotification").modal("show");
                $(".email-notification-input").fadeOut();
            }else{
                $(".email-notification-input").fadeIn();
            }
        });

        $(".unsubscribe-cancel").click(function(){
            $("#unsubscribe").prop('checked', true);
        });

    });
</script>

