<?php

require_once dirname(__FILE__) . '/vendor/autoload.php'; //added for raabitmq
//require_once dirname(__FILE__) . '/config.php';
//require_once dirname(__FILE__) . '/functions.php';

use PhpAmqpLib\Connection\AMQPStreamConnection;
use PhpAmqpLib\Exchange\AMQPExchangeType;

//define("AUTOMAILER_TRACKER_URL",'https://login.automailer.io');
//define("AUTOMAILER_TRACKER_URL",'https://www.automailertrack.com');
define("AUTOMAILER_TRACKER_URL",'https://devtest.automailer.io');
define("PHPMAILER_TIMEOUT", 10);
define("MAILVERIFY_TIMEOUT", 15);
define("CAMPAIGN_STATUS_INACTIVE",2);

//local
//$dbhost = "127.0.0.1";
//$dbname = "automailer_k";
//$dbuser = "root";
//$dbpass = "root";

//dev
//$dbhost = "localhost";
//$dbname = "dev_automailer";
//$dbuser = "devdbuser";
//$dbpass = "gVQz5QXWhp4kBpR!";

//live
//$dbhost = "localhost";
//$dbname = "automailer";
//$dbuser = "automailer_user";
//$dbpass = "i@LIKEMailYaklga2!";

class DB
{
    protected static $pdo = null;

    public static function getConnection() {
        // initialize $pdo on first call
        if (self::$pdo == null) {
            self::init();
        }

        // now we should have a $pdo, whether it was initialized on this call or a previous one
        // but it could have experienced a disconnection
        try {
            echo "Testing connection...\n";
            $old_errlevel = error_reporting(0);
            self::$pdo->query("SELECT 1");
        } catch (PDOException $e) {
            echo "Connection failed, reinitializing...\n";
            self::init();
        }
        error_reporting($old_errlevel);

        return self::$pdo;
    }

    protected static function init() {
        try {
            echo "Opening new connection...\n";
            //self::$pdo = new PDO("mysql:host=127.0.0.1;dbname=automailer_k", "root", "root");
            self::$pdo = new PDO("mysql:host=localhost;dbname=dev_automailer", "devdbuser", "gVQz5QXWhp4kBpR!");
            //self::$pdo = new PDO("mysql:host=localhost;dbname=automailer", "automailer_user", "i@LIKEMailYaklga2!");
            self::$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            die($e->getMessage());
        }
    }
}

/*try
{
    $pdo = new PDO("mysql:host=$dbhost;dbname=$dbname", $dbuser, $dbpass, array(PDO::ATTR_PERSISTENT => false));
}
catch (PDOException $e)
{

    print "Error!: Database Connection Error<br/>";

    die();
}*/

$exchange = 'send_emails_router';
$queue = 'send_emails';
$consumerTag = 'consumer';

//$connection = new AMQPStreamConnection('localhost', '5672', 'guest', 'guest', '/');
$connection = new AMQPStreamConnection('localhost', '5672', 'admin', 'RabAuto824!', '/');
$channel = $connection->channel();

/*
    The following code is the same both in the consumer and the producer.
    In this way we are sure we always have a queue to consume from and an
        exchange where to publish messages.
*/

/*
    name: $queue
    passive: false
    durable: true // the queue will survive server restarts
    exclusive: false // the queue can be accessed in other channels
    auto_delete: false //the queue won't be deleted once the channel is closed.
*/
$channel->queue_declare($queue, false, true, false, false);

/*
    name: $exchange
    type: direct
    passive: false
    durable: true // the exchange will survive server restarts
    auto_delete: false //the exchange won't be deleted once the channel is closed.
*/

$channel->exchange_declare($exchange, AMQPExchangeType::DIRECT, false, true, false);

$channel->queue_bind($queue, $exchange);

function cronNylasSmtpMailer($smtp,$email,$campaign,$contact,$identifier='',$mail_footer=''){

    echo "\n------------------------------------------------------------------------\n";

    if(!empty($smtp['nylas_account_id'])){

        $message = $email['body'];
        //$message = str_replace("\r\n","",$message); //issue while sending with \r\n with nylas
        //preg_match("/<body[^>]*>(.*?)<\/body>/is", $message, $matches);
        //preg_match("/<body>(.*)<\/body>/s", $message, $matches);

        //$message = $matches[1];
        /*$a = explode('body>', $message );
        if(isset($a[1])){
            $message = substr($a[1] ,  0 , -2 ) ;
        }*/


        $message = sanitize_output($message);
        //$message = addslashes($message);

        $message = $message . $mail_footer . ' <img src="' . AUTOMAILER_TRACKER_URL . '/_track.php?id=' . $identifier . '" />';
        //$message = addcslashes($message, '"');
        //echo '<pre>';print_r($message);exit;

        $subject = $email['subject'];
        $subject = sanitize_output($subject);
        //$subject = addcslashes($subject, '"');

        $from_name = $smtp['name'];
        $from_email = $smtp['email'];
        $to_email = $contact['email'];
        $nylas_access_token = $smtp['nylas_access_token'];
        $password = '';

        //$bcc = isset($campaign['bcc']) && !empty($campaign['bcc'])?$campaign['bcc']:'';
        //$message_id = isset($email['is_thread'])?$email['is_thread']:'';

        $curl = curl_init();

        if(isset($email['is_thread']) && !empty($email['is_thread'])){ //this works while from send lead replies cron

            $message_id = $email['is_thread'];
            if (!empty($campaign['bcc'])) {
                $bcc = $campaign['bcc'];

                $post = [
                    'body' => $message,
                    'subject' => $subject,
                    'reply_to_message_id' => $message_id,
                    'bcc'   => [[
                        'name' => 'Automailer BCC',
                        'email' => $bcc
                    ]],
                    'from'   => [[
                        'name' => $from_name,
                        'email' => $from_email
                    ]],
                    'to'   => [[
                        'email' => $to_email
                    ]],
                    'tracking'   => [
                        'opens' => false,
                        'links' => false,
                        'thread_replies' => true,
                        'payload' => $identifier
                    ]
                ];

                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://api.nylas.com/send",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    //CURLOPT_POSTFIELDS => "{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n  \"reply_to_message_id\": \"$message_id\",\n    \"bcc\": \"$bcc\",\n    \"to\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$to_email\"\n        }\n    ]\n}",
                    //CURLOPT_POSTFIELDS =>"{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n  \"reply_to_message_id\": \"$message_id\",\n    \"bcc\": [\n        {\n            \"name\": \"automailer bcc\",\n            \"email\":\"$bcc\"\n        }\n    ],\n    \"to\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$to_email\"\n        }\n    ],\n    \"tracking\": {\n \"opens\":\"true\", \n \"links\":\"true\", \n \"thread_replies\":\"true\", \n \"payload\":\"$identifier\" \n }\n      \n}",
                    //CURLOPT_POSTFIELDS =>"{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n  \"reply_to_message_id\": \"$message_id\",\n    \"bcc\": [\n        {\n            \"name\": \"Automailer BCC\",\n            \"email\":\"$bcc\"\n        }\n    ],\n  \"from\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$from_email\"\n        }\n    ],\n    \"to\": [\n        {\n           \"email\": \"$to_email\"\n        }\n    ],\n    \"tracking\": {\n \"opens\":\"false\", \n \"links\":\"false\", \n \"thread_replies\":\"true\", \n \"payload\":\"$identifier\" \n }\n      \n}",
                    CURLOPT_POSTFIELDS => json_encode($post),

                    CURLOPT_HTTPHEADER => array(
                        "Content-Type: application/json",
                        "Authorization: Bearer " . $nylas_access_token
                    ),
                ));

            } else {

                $post = [
                    'body' => $message,
                    'subject' => $subject,
                    'reply_to_message_id' => $message_id,
                    'from'   => [[
                        'name' => $from_name,
                        'email' => $from_email
                    ]],
                    'to'   => [[
                        'email' => $to_email
                    ]],
                    'tracking'   => [
                        'opens' => false,
                        'links' => false,
                        'thread_replies' => true,
                        'payload' => $identifier
                    ]
                ];

                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://api.nylas.com/send",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    //CURLOPT_POSTFIELDS => "{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n \"reply_to_message_id\": \"$message_id\",\n    \"to\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$to_email\"\n        }\n    ],\n    \"tracking\":  {\n \"opens\":\"true\", \n \"links\":\"true\", \n \"thread_replies\":\"true\", \n \"payload\":\"$identifier\" \n}\n      \n}",
                    //CURLOPT_POSTFIELDS => "{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n \"reply_to_message_id\": \"$message_id\",\n  \"from\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$from_email\"\n        }\n    ],\n    \"to\": [\n        {\n          \"email\": \"$to_email\"\n        }\n    ],\n    \"tracking\":  {\n \"opens\":\"false\", \n \"links\":\"false\", \n \"thread_replies\":\"true\", \n \"payload\":\"$identifier\" \n}\n      \n}",
                    CURLOPT_POSTFIELDS => json_encode($post),

                    CURLOPT_HTTPHEADER => array(
                        "Content-Type: application/json",
                        "Authorization: Bearer " . $nylas_access_token
                    ),
                ));

            }

        }else {

            if (!empty($campaign['bcc'])) {
                $bcc = $campaign['bcc'];

                $post = [
                    'body' => $message,
                    'subject' => $subject,
                    'bcc'   => [[
                        'name' => 'Automailer BCC',
                        'email' => $bcc
                    ]],
                    'from'   => [[
                        'name' => $from_name,
                        'email' => $from_email
                    ]],
                    'to'   => [[
                        'email' => $to_email
                    ]],
                    'tracking'   => [
                        'opens' => false,
                        'links' => false,
                        'thread_replies' => true,
                        'payload' => $identifier
                    ]
                ];

                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://api.nylas.com/send",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    //CURLOPT_POSTFIELDS => "{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n    \"bcc\": \"$bcc\",\n    \"to\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$to_email\"\n        }\n    ]\n}",
                    //CURLOPT_POSTFIELDS =>"{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n    \"bcc\": [\n        {\n            \"name\": \"automailer bcc\",\n            \"email\":\"$bcc\"\n        }\n    ],\n    \"to\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$to_email\"\n        }\n    ],\n    \"tracking\":  {\n \"opens\":\"true\", \n \"links\":\"true\", \n \"thread_replies\":\"true\", \n \"payload\":\"$identifier\" \n }\n     \n}",
                    //CURLOPT_POSTFIELDS =>"{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n    \"bcc\": [\n        {\n            \"name\": \"Automailer BCC\",\n            \"email\":\"$bcc\"\n        }\n    ],\n  \"from\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$from_email\"\n        }\n    ],\n    \"to\": [\n        {\n    \"email\": \"$to_email\"\n        }\n    ],\n    \"tracking\":  {\n \"opens\":\"false\", \n \"links\":\"false\", \n \"thread_replies\":\"true\", \n \"payload\":\"$identifier\" \n }\n     \n}",
                    CURLOPT_POSTFIELDS => json_encode($post),

                    CURLOPT_HTTPHEADER => array(
                        "Content-Type: application/json",
                        "Authorization: Bearer " . $nylas_access_token
                    ),
                ));
            } else {

                $post = [
                    'body' => $message,
                    'subject' => $subject,
                    'from'   => [[
                        'name' => $from_name,
                        'email' => $from_email
                    ]],
                    'to'   => [[
                        'email' => $to_email
                    ]],
                    'tracking'   => [
                        'opens' => false,
                        'links' => false,
                        'thread_replies' => true,
                        'payload' => $identifier
                    ]
                ];

                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://api.nylas.com/send",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    //CURLOPT_POSTFIELDS => "{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n  \"from\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$from_email\"\n        }\n    ],\n    \"to\": [\n        {\n           \"email\": \"$to_email\"\n        }\n    ],\n    \"tracking\":  {\n \"opens\":\"false\", \n \"links\":\"false\", \n \"thread_replies\":\"true\", \n \"payload\":\"$identifier\" \n }\n       \n}",
                    CURLOPT_POSTFIELDS => json_encode($post),

                    CURLOPT_HTTPHEADER => array(
                        "Content-Type: application/json",
                        "Authorization: Bearer " . $nylas_access_token
                    ),
                ));

            }
        }

//        echo "\n----post request----\n";
//        echo '<pre>';print_r($post);
        echo "\n----json encoded----\n";
        echo '<pre>';print_r(json_encode($post));
        echo "\n--------\n";

        $response = curl_exec($curl);
        $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        curl_close($curl);

        $res = json_decode($response);
        //echo '<pre>';print_r($res);exit;

        if(isset($res->message)){
            //return false;
            //return $res;
            return array($res, $httpcode);
        }else{
            //return $res;
            return array($res, $httpcode);
        }


    }
}

function AddNotification($module = '',$description = '',$memberID = 0)
{
    //global $pdo;
    $pdo = DB::getConnection();

    if (empty($description))
        return false;

    if (empty($memberID))
        return false;

    $members = $pdo->prepare('SELECT m.id, m.fname, m.lname, m.timezone, m.parent_id FROM (`members` as m) WHERE m.status = 1 AND m.id = ?');
    $members->execute(array($memberID));
    $member = $members->fetch(PDO::FETCH_ASSOC);
    if(isset($member['timezone']) && $member['timezone'] != '') {
        date_default_timezone_set($member['timezone']);
    }

    $q = $pdo->prepare('INSERT INTO `notifications`(member_id,module,description,date_time,is_seen) VALUES (?,?,?,?,?)');
    $data_notification = array($memberID, $module,$description, time(), 0);
    $q->execute($data_notification);
}

function sanitize_output($buffer) {

    $search = array(
        '/\>[^\S ]+/s',     // strip whitespaces after tags, except space
        '/[^\S ]+\</s',     // strip whitespaces before tags, except space
        '/(\s)+/s',         // shorten multiple whitespace sequences
        '/<!--(.|\s)*?-->/' // Remove HTML comments
    );

    $replace = array(
        '>',
        '<',
        '\\1',
        ''
    );

    $buffer = preg_replace($search, $replace, $buffer);

    return $buffer;
}

function ReadFromDB($str) {
    $str = str_replace('\r\n', "", $str);
    $str = str_replace("&quot;", "'", $str);
    $str = htmlentities(stripslashes($str),ENT_COMPAT,'UTF-8');
    return $str;
}

/**
 * @param \PhpAmqpLib\Message\AMQPMessage $message
 */
function process_message($message)
{

    $data = json_decode($message->body, true);

//    echo "\n--------\n";
//    echo "\n---smtp-----\n";
//    print_r($data['smtp']);
//    echo "\n--------\n";
//
//    echo "\n----campaign----\n";
//    print_r($data['campaign']);
//    echo "\n--------\n";
//
//    echo "\n---email-----\n";
//    print_r($data['email']);
//    echo "\n--------\n";
//
//    echo "\n----contact----\n";
//    print_r($data['contact']);
//    echo "\n--------\n";
//
//    echo "\n---identifier-----\n";
//    print_r($data['identifier']);
//    echo "\n--------\n";
//
//    echo "\n---mail_footer-----\n";
//    print_r($data['mail_footer']);
//    echo "\n--------\n";
//    echo "\n--------\n";

    //$sender = cronNylasSmtpMailer($data['smtp'],$data['email'],$data['campaign'],$data['contact'],$data['identifier'],$data['mail_footer']);
    list($sender, $httpcode) = cronNylasSmtpMailer($data['smtp'],$data['email'],$data['campaign'],$data['contact'],$data['identifier'],$data['mail_footer']);

    echo "\n---httpcode-----\n";
    echo $httpcode;
    echo "\n--------\n";

    echo "\n---response-----\n";
    echo '<pre>';print_r(json_encode($sender));
    echo "\n--------\n";

    /*echo "\n---pdo response-----\n";
    //echo '<pre>';print_r($pdo->getAttribute(PDO::ATTR_SERVER_INFO));
    echo "\n--------\n";

    if ($pdo->getAttribute(PDO::ATTR_SERVER_INFO)=='MySQL server has gone away')
    {
        $pdo = new PDO("mysql:host=$dbhost;dbname=$dbname", $dbuser, $dbpass, array(PDO::ATTR_PERSISTENT => false));
    }*/

    //global $pdo;

    $pdo = DB::getConnection();

        //https://developer.nylas.com/docs/connectivity/email/send-emails-with-nylas/#sending-errors
        // 200 - OK - Your message was submitted successfully for sending.
        if($httpcode == 200){

            echo '200 Mail sent Identifier: ' . $data['identifier'] . "<br>";

            if(!empty($sender) && $data['identifier'] != '') {
                $q = $pdo->prepare('UPDATE `sent_mails` SET `nylas_response`=? WHERE `identifier`=?');
                $q->execute(array(json_encode($sender), $data['identifier']));
            }

        }

        // 402 - Message Rejected - The mail provider rejected your message because of its content or recipients. If the message includes "Sending to at least one recipient failed", it means that your message may have been delivered to only a subset of participants.
        if($httpcode == 402){

            echo '402 Mail Not sent Identifier: ' . $data['identifier'] . " " . $sender->message . "<br>";

            $q = $pdo->prepare('UPDATE `sent_mails` SET `bounced`=?,`bounce_type`=? WHERE `identifier`=?');
            $q->execute(array(1, 1, $data['identifier'])); //soft bounce

        }

        // 400 - Bad Request - Your request was malformed or contained an invalid parameter. The most common issue is invalid JSON.
        if($httpcode == 400){

            echo '400 Mail Not sent Identifier: ' . $data['identifier'] . " " . $sender->message . "<br>";

            $sentDelete = $pdo->prepare('DELETE FROM `sent_mails` WHERE `identifier`=? AND `member_id`=?');
            $sentDelete->execute(array($data['identifier'], $data['campaign']['member_id']));

            $nylas_sending_account = $data['smtp']['smtp_type'] . ":" . $data['smtp']['id'];
            $q = $pdo->prepare('UPDATE `campaigns` SET `status`=? WHERE `member_id`=?  AND `sending_account`=?');
            $q->execute(array(CAMPAIGN_STATUS_INACTIVE, $data['campaign']['member_id'], $nylas_sending_account));

        }

        // 429 - Quota Exceeded - maximum one email can send 500 msg - The user has exceeded their mail provider's sending quota. Unfortunately, there is no reliable way to determine these limits. Wait and try again later.
        if($httpcode == 429){

            echo '429 Mail Not sent Identifier: ' . $data['identifier'] . " " . $sender->message . "<br>";

            $sentDelete = $pdo->prepare('DELETE FROM `sent_mails` WHERE `identifier`=? AND `member_id`=?');
            $sentDelete->execute(array($data['identifier'], $data['campaign']['member_id']));

            $nylas_sending_account = $data['smtp']['smtp_type'] . ":" . $data['smtp']['id'];
            $q = $pdo->prepare('UPDATE `campaigns` SET `status`=? WHERE `member_id`=?  AND `sending_account`=?');
            $q->execute(array(CAMPAIGN_STATUS_INACTIVE, $data['campaign']['member_id'], $nylas_sending_account));

        }

        // 403 - Unauthorized - The server was unable to authenticate with the user's mail provider. Re-authenticate the user and try again.
        if($httpcode == 403) {

            echo '403 Mail Not sent Identifier: ' . $data['identifier'] . " " . $sender->message . "<br>";

            $sentDelete = $pdo->prepare('DELETE FROM `sent_mails` WHERE `identifier`=? AND `member_id`=?');
            $sentDelete->execute(array($data['identifier'], $data['campaign']['member_id']));

            $smtp_word = "smtp";

            $error_string = "SMTP Account " . $data['smtp']['email'] . " Email Authentication failed - Please check your email SMTP settings or password - " . $sender->message;

            $check_error_send = $pdo->prepare('SELECT * FROM `notifications` WHERE `member_id`=? AND `module`=? AND `description`=? ');
            $check_error_send->execute(array($data['campaign']['member_id'], $smtp_word, $error_string));

            if ($check_error_send->rowcount() < 1) {
                // TODO TRAP SMTP Connect errors mark account as in-active and add notification to system
                AddNotification("smtp", "SMTP Account " . $data['smtp']['email'] . " Email Authentication failed - Please check your email SMTP settings or password - " . $sender->message, $data['campaign']['member_id']);

                //This will set all the campaign to inactive when there is an issue on the SMTP account
                $nylas_sending_account = $data['smtp']['smtp_type'] . ":" . $data['smtp']['id'];
                $q = $pdo->prepare('UPDATE `campaigns` SET `status`=? WHERE `member_id`=?  AND `sending_account`=?');
                $q->execute(array(CAMPAIGN_STATUS_INACTIVE, $data['campaign']['member_id'], $nylas_sending_account));

            }

        }


    //echo "\n--------\n";
    //echo $message->body;
    //echo "\n--------\n";

    echo "\n------------------------------------------------------------------------\n";

    //$pdo = null; //disconnect connection
    $message->ack();

    // Send a message with the string "quit" to cancel the consumer.
    if ($message->body === 'quit') {
        $message->getChannel()->basic_cancel($message->getConsumerTag());
    }
}

/*
    queue: Queue from where to get the messages
    consumer_tag: Consumer identifier
    no_local: Don't receive messages published by this consumer.
    no_ack: If set to true, automatic acknowledgement mode will be used by this consumer. See https://www.rabbitmq.com/confirms.html for details.
    exclusive: Request exclusive consumer access, meaning only this consumer can access the queue
    nowait:
    callback: A PHP Callback
*/

$channel->basic_consume($queue, $consumerTag, false, false, false, false, 'process_message');

/**
 * @param \PhpAmqpLib\Channel\AMQPChannel $channel
 * @param \PhpAmqpLib\Connection\AbstractConnection $connection
 */
function shutdown($channel, $connection)
{
    $channel->close();
    $connection->close();
}

register_shutdown_function('shutdown', $channel, $connection);

// Loop as long as the channel has callbacks registered
while ($channel->is_consuming()) {
    $channel->wait();
}
