<title><?php echo SITE_NAME; ?> - Campaign Report</title>
<!--<link rel="stylesheet" href="--><?php //echo $root; ?><!--/trumbowyg/plugins/colors/ui/trumbowyg.colors.css">-->
<!--<link rel="stylesheet" href="--><?php //echo $root; ?><!--/trumbowyg/plugins/emoji/ui/trumbowyg.emoji.css">-->
<!--<link rel="stylesheet" href="--><?php //echo $root; ?><!--/sidebar/slidebars.css">-->
</head>

<style>
    .progress {
        background-color:#dddddd;
        border-radius:20px;
    }
    .progress-bar {
        background-color:#30D5CB;
    }
    .btn-report-details:hover{
        text-decoration: none;
    }
    /*Calendar*/
    .fc-col-header{
        margin-bottom: 0px;
    }
    /* Body animation when right panel is opened */
    body {
        overflow-x: hidden;
        font-family: Arial;
        background: #eee;

        /* Panel animation should last 200ms */
        transition: transform .2s;
        -webkit-transition: -webkit-transform .2s;
    }
    body.ps-active-right {
        -webkit-transform: translateX(-760px);
        -ms-transform: translateX(-760px);
        transform: translateX(-760px);
    }

    /* Panel styles */
    .panel {
        position: fixed;
        top: 0;
        width: 720px;
        /*height: 100%;*/
        padding: 20px;
        background-color: rgb(22,133,230);
        color: #fff;
        box-shadow: inset 0 0 28px 3px #222;
    }

    #right-panel {
        right: -500px;

        /* Hide panel on the right of the page. When this panel is opened the
        class .ps-active-right will be apllied to body, and it's X translation
        will reveal the panel. */
        -webkit-transform: translateX(260px);
        -ms-transform: translateX(260px);
        transform: translateX(260px);
    }
    /*Tooltip*/
    /*.tooltip-table td{
        text-align: left;
    }
    .dot {
        height: 15px;
        width: 15px;
        border-radius: 50%;
        display: inline-block;
    }
    .fc .fc-scrollgrid, .fc .fc-scrollgrid table {
        width: 101% !important;
    }
    .list-campaign-legend{
        list-style: none;
        padding: 0px;
        margin: 0px;
    }
    .tooltip{
        opacity: 1;
    }
    .calendar-tooltip .tooltip-inner{
        background: #0B92FB;
        color : #ffffff;
    }
    .calendar-tooltip .popper,.calendar-tooltip .tooltip {
        position: absolute;
        z-index: 9999;
        background: #0B92FB;
        color: #ffffff;
        width: auto;
        border-radius: 3px;
        box-shadow: 0 0 2px rgba(0,0,0,0.5);
        padding: 10px;
        text-align: center;
    }
    .calendar-tooltip .style5 .tooltip {
        background: #1E252B;
        color: #FFFFFF;
        max-width: 200px;
        width: auto;
        font-size: .8rem;
        padding: .5em 1em;
    }
    .calendar-tooltip .popper .popper__arrow,
    .calendar-tooltip .tooltip .tooltip-arrow {
        width: 0;
        height: 0;
        border-style: solid;
        position: absolute;
        margin: 5px;
    }

    .calendar-tooltip .tooltip .tooltip-arrow,
    .calendar-tooltip .popper .popper__arrow {
        border-color: #0B92FB;
    }
    .calendar-tooltip .style5 .tooltip .tooltip-arrow {
        border-color: #1E252B;
    }
    .calendar-tooltip .popper[x-placement^="top"],
    .calendar-tooltip .tooltip[x-placement^="top"] {
        margin-bottom: 5px;
    }
    .calendar-tooltip .popper[x-placement^="top"] .popper__arrow,
    .calendar-tooltip .tooltip[x-placement^="top"] .tooltip-arrow {
        border-width: 5px 5px 0 5px;
        border-left-color: transparent;
        border-right-color: transparent;
        border-bottom-color: transparent;
        bottom: -5px;
        left: calc(50% - 5px);
        margin-top: 0;
        margin-bottom: 0;
    }
    .calendar-tooltip .popper[x-placement^="bottom"],
    .calendar-tooltip .tooltip[x-placement^="bottom"] {
        margin-top: 5px;
    }
    .calendar-tooltip .tooltip[x-placement^="bottom"] .tooltip-arrow,
    .calendar-tooltip .popper[x-placement^="bottom"] .popper__arrow {
        border-width: 0 5px 5px 5px;
        border-left-color: transparent;
        border-right-color: transparent;
        border-top-color: transparent;
        top: -5px;
        left: calc(50% - 5px);
        margin-top: 0;
        margin-bottom: 0;
    }
    .calendar-tooltip .tooltip[x-placement^="right"],
    .calendar-tooltip .popper[x-placement^="right"] {
        margin-left: 5px;
    }
    .calendar-tooltip .popper[x-placement^="right"] .popper__arrow,
    .calendar-tooltip .tooltip[x-placement^="right"] .tooltip-arrow {
        border-width: 5px 5px 5px 0;
        border-left-color: transparent;
        border-top-color: transparent;
        border-bottom-color: transparent;
        left: -5px;
        top: calc(50% - 5px);
        margin-left: 0;
        margin-right: 0;
    }
    .calendar-tooltip .popper[x-placement^="left"],
    .calendar-tooltip .tooltip[x-placement^="left"] {
        margin-right: 5px;
    }
    .calendar-tooltip .popper[x-placement^="left"] .popper__arrow,
    .calendar-tooltip .tooltip[x-placement^="left"] .tooltip-arrow {
        border-width: 5px 0 5px 5px;
        border-top-color: transparent;
        border-right-color: transparent;
        border-bottom-color: transparent;
        right: -5px;
        top: calc(50% - 5px);
        margin-left: 0;
        margin-right: 0;
    }*/
</style>
<body id="page-top">
<!-- Page Wrapper -->
<div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>

            <?php

            $q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
            $q->execute(array($_SESSION['id']));
            $member = $q->fetch(PDO::FETCH_ASSOC);
            date_default_timezone_set($member['timezone']);

            $q = $pdo->prepare('SELECT * FROM `campaigns` WHERE `id`=? AND `member_id`=? LIMIT 1');
            $q->execute(array($_SEO[2], $member['id']));
            $campaign = $q->fetch(PDO::FETCH_ASSOC);
            $campaign_id = $_SEO[2];

            // if(!isset($campaign['member_id'])){
            //    header('Location: '.$root.'/all-campaigns');
            // }

            $sending_account = $campaign['sending_account'];
            $recipients = $pdo->prepare('SELECT `id`, `email`, `list_id`, COUNT(*) AS total FROM `contacts` WHERE `list_id`=? AND `status`=1');
            $recipients->execute(array($campaign['list']));
            $recipientsTotal =  $recipients->fetch(PDO::FETCH_ASSOC);
            $drip_total_recipients = $recipientsTotal['total'];
            $summary_total_recipients = 0;
            $summary_total_recipients += $drip_total_recipients;
            ?>

            <!-- Begin Page Content -->
            <div class="container-fluid dashboard">
                <?php
                $active_tab = 'campaign_reports';
                include_once("nav/reports_tabs.php");
                ?>

                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <div class="report-tab-1">
                                <!--                                <a id="right-panel-link" href="#right-panel" class="btn btn-info btn-sm float-right" style="margin-left: 20px;"><i class="far fa-calendar-alt"></i> Show Calendar</a>-->
                                <?php include_once("reports2_tab_1.php"); ?>
                            </div>
                            <div id="right-panel" class="panel">
                                <h2 style="float: left;">Campaign Calendar</h2>
                                <button id="close-panel-bt" class="btn btn-info" style="margin-left: 10px;">Close</button>
                                <div class="clear"></div>
                                <?php include_once("reports2_tab_2.php"); ?>
                            </div>
                            <br />

                            <?php
                            $data_opened = $pdo->prepare('SELECT s.id, s.to_email, s.last_activity, s.to_contact, c.id, c.firstName, c.lastName FROM `sent_mails` s LEFT JOIN  `contacts` c ON s.to_contact = c.id WHERE `campaign_id`=? AND `opened`=1');
                            $data_opened->execute(array($campaign_id));

                            $data_replies = $pdo->prepare('SELECT s.id, s.to_email, s.last_activity, s.to_contact, c.id, c.firstName, c.lastName FROM `sent_mails` s LEFT JOIN  `contacts` c ON s.to_contact = c.id WHERE `campaign_id`=? AND `replied`=1');
                            $data_replies->execute(array($campaign_id));
                            ?>
                            <style>
                                .dataTables_length, .dataTables_wrapper .dataTables_filter{
                                    display: block !important;
                                }
                            </style>





                            <!-- <h4 style="background-color: #bdbdbd; padding: 10px; font-size: 15px;">Opened</h4> -->
                            <h3>OPENED</h3>
                            <div class="table-container">
                                <table class="table datatable report-details-datatable2">
                                    <thead>
                                    <tr>
                                        <th scope="col">First Name</th>
                                        <th scope="col">Last Name</th>
                                        <th scope="col">Email</th>
                                        <th scope="col">Last Activity</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach($data_opened as $d){ ?>
                                        <tr>
                                            <td><?php echo $d['firstName']; ?></td>
                                            <td><?php echo $d['lastName']; ?></td>
                                            <td><?php echo $d['to_email']; ?></td>
                                            <td><?php echo date("Y-m-d H:i:s", $d['last_activity']); ?></td>
                                        </tr>
                                    <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                            <br />
                            <br />
                            <!-- <h4 style="background-color: #bdbdbd; padding: 10px; font-size: 15px;">Opened</h4> -->
                            <h3>REPLIES</h3>
                            <div class="table-container">
                                <table class="table datatable report-details-datatable2">
                                    <thead>
                                    <tr>
                                        <th scope="col">First Name</th>
                                        <th scope="col">Last Name</th>
                                        <th scope="col">Email</th>
                                        <th scope="col">Last Activity</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach($data_replies as $d){ ?>
                                        <tr>
                                            <td><?php echo $d['firstName']; ?></td>
                                            <td><?php echo $d['lastName']; ?></td>
                                            <td><?php echo $d['to_email']; ?></td>
                                            <td><?php echo date("Y-m-d H:i:s", $d['last_activity']); ?></td>
                                        </tr>
                                    <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                            <script>
                                $(function(){
                                    $('table.report-details-datatable2').DataTable({"pageLength": 10, filter: true});
                                });
                            </script>

                            <br />
                            <br />
                            <h3>SUMMARY</h3>
                            <table class="table leads-datatable datatable">
                                <thead>
                                <tr>
                                    <th>Campaign Name</th>
                                    <th>Recipients</th>
                                    <th>Emails Sent</th>
                                    <th>Replies</th>
                                    <th>Opens</th>
                                    <th>Clicks</th>
                                    <th>Bounces</th>
                                    <th>Status</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td><?php echo $campaign['name']; ?></td>
                                    <td><?php echo $summary_total_recipients; ?></td>
                                    <td><?php echo $campaign['emails']; ?></td>
                                    <td><?php echo $campaign['replies']; ?></td>
                                    <td><?php echo $campaign['opens']; ?></td>
                                    <td>
                                        <?php
                                        // Only fetch data that is needed
                                        $clicks  = $pdo->prepare('SELECT count(*) as total FROM (`links_clicked` as m)
                                LEFT JOIN sent_mails as s ON (s.identifier = m.identifier) WHERE s.campaign_id =?');
                                        $clicks->execute(array($campaign['id']));
                                        $clicksTotal = $clicks->fetch(PDO::FETCH_ASSOC);
                                        $click_count =$clicksTotal['total'];


                                        echo $click_count;
                                        ?>
                                    </td>
                                    <td><?php echo $campaign['bounces']; ?></td>
                                    <td>
                                        <?php
                                        if($campaign['status'] == CAMPAIGN_STATUS_RUNNING){
                                            $stats = '<span class="text-success">&bull; Active</span>';
                                        }elseif($campaign['status'] ==  CAMPAIGN_STATUS_INACTIVE){
                                            $stats = '<span class="text-danger">&bull; In-active</span>';
                                        }elseif($campaign['status'] == CAMPAIGN_STATUS_PAUSED){
                                            $stats = '<span class="text-danger">&bull; Paused</span>';
                                        }elseif($campaign['status'] == CAMPAIGN_STATUS_COMPLETED){
                                            $stats = '<span class="text-danger">&bull; Completed</span>';
                                        }
                                        echo $stats;
                                        ?>
                                    </td>
                                </tr>
                                </tbody>
                            </table>

                            <div class="modal fade" id="modal-report-details" data-focus="false" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                                <div class="modal-dialog modal-lg" role="document" style="max-width:1100px;">
                                    <div class="modal-content">
                                        <div class="modal-body">
                                            <div class="form">
                                                <h4 class="modal-heading report-detail-title"></h4>
                                                <div class="report-detail-body"></div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <br />
                            <br />
                            <!-- <div class="card-header py-3" style="margin-top: 10px; "> --> <!-- background-color:#0064A5 !important; -->
                            <!-- <h6 class="">Recent activity</h6> -->
                            <h3>RECENT ACTIVITY</h3>
                            <!-- </div> -->
                            <div class="card-body" style="max-height: 400px; overflow-y: scroll;">  <!-- background-color:#0064A5 !important; -->
                                <?php
                                $q = $pdo->prepare('SELECT sent_mails.*, campaigns.id, campaigns.name FROM `sent_mails` LEFT JOIN `campaigns` ON sent_mails.campaign_id = campaigns.id WHERE sent_mails.campaign_id=? ORDER BY sent_mails.last_activity DESC LIMIT 50');
                                $q->execute(array($campaign['id']));
                                foreach ($q as $row) {
                                    $campaign_name = $row['name'];

                                    if($row['opened'] == 1)
                                    {
                                        $message = 'Email "'.$row['subject'].'" sent to '.$row['to_email'].' has been opened <span class="blue">'.time_elapsed_string('@'.$row['last_activity']).'</span>';
                                    }

                                    if($row['replied'] == 1)
                                    {

                                        $message = ''.$row['to_email'].' <span> REPLIED </span> to '.$row['subject'].' from campaign '.$campaign_name.' <span class="blue">'.time_elapsed_string('@'.$row['last_activity']).'</span>';

                                        // $message = 'Email "'.$row['subject'].'" sent to '.$row['to_email'].' has been replied to <span class="blue">'.time_elapsed_string('@'.$row['last_activity']).'</span>';
                                    }
                                    if($row['replied'] == 0 && $row['opened'] == 0)
                                    {
                                        $message =  'Email "'.$row['subject'].'" sent to '.$row['to_email'].' from '.$row['from_email'].' <span class="blue">'.time_elapsed_string('@'.$row['last_activity']).'</span>';
                                    }

                                    if($row['bounced'] == 1)
                                    {

                                        $message = ''.$row['to_email'].' <span> BOUNCED </span> to '.$row['subject'].' from campaign '.$campaign_name.' <span class="blue">'.time_elapsed_string('@'.$row['last_activity']).'</span>';

                                    }
                                    echo $message.'<hr/>';
                                }
                                if($q->rowcount()<1)
                                {
                                    echo '<p>No recent activity to display.</p>';
                                }
                                ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <!-- /.container-fluid -->

        </div>

        <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Copyright &copy; <?php echo date('Y'); ?></span>
                </div>
            </div>
        </footer>
        <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>

<script>
    $(function(){
        /*Panel*/
        $('#right-panel-link').panelslider({
            bodyClass: 'ps-active-right',
            clickClose: false,
            onOpen: function() {
                console.log('right panel open');
            }
        });

        $('#close-panel-bt').click(function() {
            $.panelslider.close();
        });

        $('#left-panel, #right-panel').on('psBeforeOpen psOpen psBeforeClose psClose', function(e) {
            console.log(e.type, e.target.getAttribute('id'));
        });

        $(".btn-report-details").click(function(){
            var campaign_id = $(this).attr("data-id");
            var subject = $(this).attr("data-subject");
            var type = $(this).attr("data-key");
            var email_number = $(this).attr("data-email-number");
            var member_id = $(this).attr("data-member-id");

            var msg = '<div class="alert alert-info" role="alert"><img src="'+root_dir+'/img/spinner.gif" /> Loading data...</div>';
            var url = root_dir + "/load-drip-report-details";

            $("#modal-report-details").modal("show");
            $(".report-detail-title").html(subject);
            $(".report-detail-body").html(msg);

            setTimeout(function () {
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {campaign_id:campaign_id, type:type, subject:subject, email_number:email_number, member_id:member_id},
                    success: function(o)
                    {
                        $(".report-detail-body").html(o);
                    }
                });
            }, 1000);
        });

        //var events_url = root_dir + "/_sending_calendar_events_campaign";
        //var calendarEl = document.getElementById('calendar');
        //var calendar = new FullCalendar.Calendar(calendarEl, {
        //    schedulerLicenseKey: 'CC-Attribution-NonCommercial-NoDerivatives',
        //    initialView: 'dayGridMonth',
        //    events: {
        //        url: events_url,
        //        method: 'POST',
        //        extraParams: {
        //            sending_account: '<?php //echo $sending_account; ?>//',
        //            timezone: '<?php //echo $member['timezone']; ?>//',
        //            campaign_id: '<?php //echo  $campaign_id; ?>//'
        //        }
        //    },
        //    eventDidMount: function(info) {
        //        var tooltip = new Tooltip(info.el, {
        //            title: info.event.extendedProps.description,
        //            placement: 'top',
        //            trigger: 'hover',
        //            html:true,
        //            container: '.calendar-tooltip'
        //        });
        //    },
        //    /*events:[
        //       {
        //         resourceId:'a',
        //         title:"My repeating event",
        //         start:'2020-08-26 10:00',
        //         end:'2020-08-27 13:00',
        //         eventColor: '#378006',
        //       },
        //     ]*/
        //});
        //calendar.render();

    });
</script>