<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PhpImap\Exceptions\ConnectionException;
require_once dirname(__FILE__) . '/config.php';
require_once dirname(__FILE__) . '/PHPMailer/autoload.php';
require_once 'vendor/stripe/stripe-php/init.php';
$stripe = \Stripe\Stripe::setApiKey($new_stripe_sk);
?>

<title>Register</title>
</head>
<?php
$plans = $pdo->prepare('SELECT * FROM `prospect_plans` ');
$plans->execute();
$_POST['plan'] = 1;
?>
<body class="login-page">
<?php
if(isset($_POST['plan']))
{
    switch ($_POST['plan']) {
        case '1':
            $plan = 'Personal';
            $text = '$19/month incl. 14 day free trial';
            break;
        case '2':
            $plan = 'Business';
            $text = '$29/month incl. 14 day free trial';
            break;
        case '3':
            $plan = 'Enterprise';
            $text = '$49/month incl. 14 day free trial';
            break;
    }
}
else
{
    $_POST['plan'] = 1;
    $plan = 'Professional';
    $text = '$29/month';
}
if(!empty($_POST['fname']))
{

    foreach ($_POST as $key => $value) {
        $_POST[$key] = htmlspecialchars($value, ENT_QUOTES);
    }

    $validSignup = true;

    if (empty($_POST['password']))
    {
        echo '<p class="text-danger mb-4">Error: Password is required.</p>';
        $validSignup = false;
    }

    if (empty($_POST['email']))
    {
        echo '<p class="text-danger mb-4">Error: Email Address is required.</p>';
        $validSignup = false;
    }

    if (empty($_POST['username']))
    {
        echo '<p class="text-danger mb-4">Error: Username is required.</p>';
        $validSignup = false;
    }

    $isUsernameExists = $pdo->prepare('SELECT * FROM `members` WHERE `username`=?');
    $isUsernameExists->execute(array($_POST['username']));

    if($isUsernameExists->rowcount() > 0)
    {
        echo '<p class="text-danger mb-4">Error: Username already exists.</p>';
        $validSignup = false;

    }

    // Check if email exists for forgot password....
    $isEmailExists = $pdo->prepare('SELECT * FROM `members` WHERE `email`=?');
    $isEmailExists->execute(array($_POST['email']));

    if($isEmailExists->rowcount() > 0)
    {
        echo '<p class="text-danger mb-4">Error: Email already exists.</p>';
        $validSignup = false;
    }



    if ($validSignup == true)
    {
        if(isset(json_decode(base64_decode($_POST['stripe']))->customer)){
            if($_POST['prospect_stripe_id']!="")
            {
                $customer_id = json_decode(base64_decode($_POST['stripe']))->customer;
                $subscription = \Stripe\Subscription::create(array(
                    "customer" => $customer_id,
                    "items" => array(
                        array(
                            "plan" => $_POST['prospect_stripe_id'],
                        ),
                    ),
                ));
            }
        }
        $q = $pdo->prepare('INSERT INTO `members` (fname,lname,email,username,password,plan,stripe,stripe_status,timezone,date_created,status,parent_id,account_type,
country_id,address,signature,plan_quantity,cleaning_credits,is_startup,selected_state,selected_city,selected_postal_code,super_admin,cc_4digits,cc_month,cc_year,
ipaddress,date_lastlogin,utm_source,utm_medium,utm_campaign,utm_term,utm_content,prospect_stripe,search_credit,prospect_selected_plan,stripe_card_brand,stripe_customer_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');

        $stripe_decoded = json_decode(base64_decode($_POST['stripe']));
        $stripe_status = isset($stripe_decoded->data->status)?$stripe_decoded->data->status:'';

        $sql =  $q->execute(array(
            $_POST['fname'],
            $_POST['lname'],
            $_POST['email'],
            $_POST['username'],
            password_hash($_POST['password'], PASSWORD_BCRYPT),
            $_POST['plan_id'],
            base64_decode($_POST['stripe']),
            $stripe_status,
            //$_SESSION['timezone'],
            //$_POST['user_timezone'],
            'America/Chicago',
            time(),
            1,
            0,
            0,
            $_POST['selected_country'],
            $_POST['selected_address'],
            NULL,
            $_POST['plan_quantity'],
            $_POST['total_cleaning_credit'],
            1,
            $_POST['selected_state'],
            $_POST['selected_city'],
            $_POST['selected_postal_code'],
            0,
            $_POST['cc_last_4d'],
            $_POST['cc_month'],
            $_POST['cc_year'],
            $_SERVER['REMOTE_ADDR'],
            time(),
            $utmData['utm_source'],
            $utmData['utm_medium'],
            $utmData['utm_campaign'],
            $utmData['utm_term'],
            $utmData['utm_content'],
            isset($subscription) ? json_encode($subscription) : NULL,
            empty($_POST['search_credit']) ? 0 : $_POST['search_credit'],
            empty($_POST['selected_plan_id']) ? NULL : $_POST['selected_plan_id'],
            $_POST['stripe_card_brand'],
            $_POST['stripe_customer_id']
        ));


        if($_POST['plan_billing_type']=="yearly"){
            $renewdate = date('m/d/Y',  strtotime($_POST['renew_date']));
        }else{
            $renewdate = date('m/d/Y',  strtotime($_POST['renew_date']));
        }

        $first_name = $_POST['fname'];
        $package  = $_POST['selected_plan'] . "  $"  . $_POST['total_billing_amount'] . " / " .$_POST['selected_plan_amount'] ;
        $username = $_POST['username'];
        $password = $_POST['password'];

        try {
            $fraudScore = ReturnMaxMindCheckSignupFraud();
        } catch (Exception $e)
        {
            error_log("Fraud Score failed:" . $e->getMessage() . "\n");
        }

        $message = "<p>Hi, New registration has been created</p>";
        $message .= "<table>";
        $message .= "<tr><td>Name</td><td>: " . $_POST['fname'] . " " .  $_POST['lname']. "</td></tr>";
        $message .= "<tr><td>Email</td><td>: ". $_POST['email'] ." </td></tr>";
        $message .= "<tr><td>Package</td><td>: ". $package ."</td></tr>";
        $message .= "<tr><td>Bill Date</td><td>: ". $renewdate ."</td></tr>";
        $message .= "<tr><td>Username</td><td>: ".  $username ."</td></tr>";
        $message .= "<tr><td>Fraud Score</td><td>: ".  $fraudScore ."</td></tr>";
        $message .= "</table>";
        $message .= "<br /><p>Thank you</p><br />";

        // UTM Tracking
        if (!empty($utmData['utm_source']))
            $message .= "UTM-Source: " . $utmData['utm_source'] . "<br />";

        if (!empty($utmData['utm_medium']))
            $message .= "UTM-Medium: " . $utmData['utm_medium'] . "<br />";

        if (!empty($utmData['utm_campaign']))
            $message .= "UTM-Campaign: " . $utmData['utm_campaign'] . "<br />";

        if (!empty($utmData['utm_term']))
            $message .= "UTM-Term: " . $utmData['utm_term'] . "<br />";

        if (!empty($utmData['utm_content']))
            $message .= "UTM-Content: " . $utmData['utm_content']. "<br />";


        $msg = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
            <html xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office">
             <head> 
              <meta charset="UTF-8"> 
              <meta content="width=device-width, initial-scale=1" name="viewport"> 
              <meta name="x-apple-disable-message-reformatting"> 
              <meta http-equiv="X-UA-Compatible" content="IE=edge"> 
              <meta content="telephone=no" name="format-detection"> 
              <title>Automailer - Welcome</title> 
              <!--[if (mso 16)]>
                <style type="text/css">
                a {text-decoration: none;}
                </style>
                <![endif]--> 
              <!--[if gte mso 9]><style>sup { font-size: 100% !important; }</style><![endif]--> 
              <!--[if gte mso 9]>
            <xml>
                <o:OfficeDocumentSettings>
                <o:AllowPNG></o:AllowPNG>
                <o:PixelsPerInch>96</o:PixelsPerInch>
                </o:OfficeDocumentSettings>
            </xml>
            <![endif]--> 
              <style type="text/css">
            #outlook a {
              padding:0;
            }
            .es-button {
              mso-style-priority:100!important;
              text-decoration:none!important;
            }
            a[x-apple-data-detectors] {
              color:inherit!important;
              text-decoration:none!important;
              font-size:inherit!important;
              font-family:inherit!important;
              font-weight:inherit!important;
              line-height:inherit!important;
            }
            .es-desk-hidden {
              display:none;
              float:left;
              overflow:hidden;
              width:0;
              max-height:0;
              line-height:0;
              mso-hide:all;
            }
            @media only screen and (max-width:600px) {p, ul li, ol li, a { font-size:16px!important; line-height:150%!important } h1 { font-size:30px!important; text-align:center; line-height:120% } h2 { font-size:26px!important; text-align:center; line-height:120% } h3 { font-size:20px!important; text-align:center; line-height:120% } h1 a { font-size:30px!important } h2 a { font-size:26px!important } h3 a { font-size:20px!important } .es-menu td a { font-size:16px!important } .es-header-body p, .es-header-body ul li, .es-header-body ol li, .es-header-body a { font-size:16px!important } .es-footer-body p, .es-footer-body ul li, .es-footer-body ol li, .es-footer-body a { font-size:16px!important } .es-infoblock p, .es-infoblock ul li, .es-infoblock ol li, .es-infoblock a { font-size:12px!important } *[class="gmail-fix"] { display:none!important } .es-m-txt-c, .es-m-txt-c h1, .es-m-txt-c h2, .es-m-txt-c h3 { text-align:center!important } .es-m-txt-r, .es-m-txt-r h1, .es-m-txt-r h2, .es-m-txt-r h3 { text-align:right!important } .es-m-txt-l, .es-m-txt-l h1, .es-m-txt-l h2, .es-m-txt-l h3 { text-align:left!important } .es-m-txt-r img, .es-m-txt-c img, .es-m-txt-l img { display:inline!important } .es-button-border { display:block!important } .es-adaptive table, .es-left, .es-right { width:100%!important } .es-content table, .es-header table, .es-footer table, .es-content, .es-footer, .es-header { width:100%!important; max-width:600px!important } .es-adapt-td { display:block!important; width:100%!important } .adapt-img { width:100%!important; height:auto!important } .es-m-p0 { padding:0px!important } .es-m-p0r { padding-right:0px!important } .es-m-p0l { padding-left:0px!important } .es-m-p0t { padding-top:0px!important } .es-m-p0b { padding-bottom:0!important } .es-m-p20b { padding-bottom:20px!important } .es-mobile-hidden, .es-hidden { display:none!important } tr.es-desk-hidden, td.es-desk-hidden, table.es-desk-hidden { width:auto!important; overflow:visible!important; float:none!important; max-height:inherit!important; line-height:inherit!important } tr.es-desk-hidden { display:table-row!important } table.es-desk-hidden { display:table!important } td.es-desk-menu-hidden { display:table-cell!important } .es-menu td { width:1%!important } table.es-table-not-adapt, .esd-block-html table { width:auto!important } table.es-social { display:inline-block!important } table.es-social td { display:inline-block!important } a.es-button, button.es-button { font-size:20px!important; display:block!important; border-width:10px 0px 10px 0px!important } }
            </style> 
             </head> 
             <body style="width:100%;font-family:arial, \'helvetica neue\', helvetica, sans-serif;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;padding:0;Margin:0"> 
              <div class="es-wrapper-color" style="background-color:#F6F6F6"> 
               <!--[if gte mso 9]>
                  <v:background xmlns:v="urn:schemas-microsoft-com:vml" fill="t">
                    <v:fill type="tile" color="#f6f6f6"></v:fill>
                  </v:background>
                <![endif]--> 
               <table class="es-wrapper" width="100%" cellspacing="0" cellpadding="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;padding:0;Margin:0;width:100%;height:100%;background-repeat:repeat;background-position:center top"> 
                 <tr> 
                  <td valign="top" style="padding:0;Margin:0"> 
                   <table class="es-header" cellspacing="0" cellpadding="0" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%;background-color:transparent;background-repeat:repeat;background-position:center top"> 
                     <tr> 
                      <td align="center" style="padding:0;Margin:0"> 
                       <table class="es-header-body" cellspacing="0" cellpadding="0" bgcolor="#ffffff" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#FFFFFF;width:600px"> 
                         <tr> 
                          <td align="left" style="padding:0;Margin:0;padding-top:20px;padding-left:20px;padding-right:20px"> 
                           <table cellspacing="0" cellpadding="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px"> 
                             <tr> 
                              <td align="left" style="padding:0;Margin:0;width:560px"> 
                               <table width="100%" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px"> 
                                 <tr> 
                                  <td align="center" style="padding:0;Margin:0;font-size:0px"><img class="adapt-img" src="https://jrhwv.stripocdn.email/content/guids/CABINET_72b1e6e71b4adb8c2515e18274d4aa55/images/70961614614361452.png" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" width="450"></td> 
                                 </tr> 
                               </table></td> 
                             </tr> 
                           </table></td> 
                         </tr> 
                       </table></td> 
                     </tr> 
                   </table> 
                   <table class="es-content" cellspacing="0" cellpadding="0" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%"> 
                     <tr> 
                      <td align="center" style="padding:0;Margin:0"> 
                       <table class="es-content-body" cellspacing="0" cellpadding="0" bgcolor="#ffffff" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#FFFFFF;width:600px"> 
                         <tr> 
                          <td align="left" style="padding:0;Margin:0;padding-top:20px;padding-left:20px;padding-right:20px"> 
                           <table width="100%" cellspacing="0" cellpadding="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px"> 
                             <tr> 
                              <td valign="top" align="center" style="padding:0;Margin:0;width:560px"> 
                               <table width="100%" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px"> 
                                 <tr> 
                                  <td align="left" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, \'helvetica neue\', helvetica, sans-serif;line-height:21px;color:#333333">Dear ' . $first_name .',</p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, \'helvetica neue\', helvetica, sans-serif;line-height:21px;color:#333333"><br></p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, \'helvetica neue\', helvetica, sans-serif;line-height:21px;color:#333333">Thank you for signing up and <strong>Welcome to Automailer. </strong>With Automailer you can engage with your cold contacts and automate your lead generation with our drip cold email marketing software.</p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, \'helvetica neue\', helvetica, sans-serif;line-height:21px;color:#333333"><br></p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, \'helvetica neue\', helvetica, sans-serif;line-height:21px;color:#333333">For the first 14&nbsp;days, a free trial of our software is on us! When the complimentary trial ends, your account will continue on the paid package&nbsp;you selected.<br><br></p></td> 
                                 </tr> 
                               </table></td> 
                             </tr> 
                           </table></td> 
                         </tr> 
                         <tr> 
                          <td align="left" style="padding:0;Margin:0;padding-top:20px;padding-left:20px;padding-right:20px"> 
                           <table cellpadding="0" cellspacing="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px"> 
                             <tr> 
                              <td align="center" valign="top" style="padding:0;Margin:0;width:560px"> 
                               <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px"> 
                                 <tr> 
                                  <td align="left" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, \'helvetica neue\', helvetica, sans-serif;line-height:21px;color:#333333">Here are the details of your account:<br><br></p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, \'helvetica neue\', helvetica, sans-serif;line-height:21px;color:#333333"><strong>Package: '. $package .' </strong></p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, \'helvetica neue\', helvetica, sans-serif;line-height:21px;color:#333333"><b>Bill date: '. $renewdate .'</b></p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, \'helvetica neue\', helvetica, sans-serif;line-height:21px;color:#333333"><strong>Username: '. $username .'</strong></p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, \'helvetica neue\', helvetica, sans-serif;line-height:21px;color:#333333"><strong>Password: '. $password .'  </strong></p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, \'helvetica neue\', helvetica, sans-serif;line-height:21px;color:#333333"><br></p></td> 
                                 </tr> 
                                 <tr> 
                                  <td align="center" style="padding:0;Margin:0"><span class="es-button-border" style="border-style:solid;border-color:#2CB543;background:#3D85C6;border-width:0px;display:inline-block;border-radius:4px;width:auto"><a href="https://login.automailer.io/login" class="es-button" target="_blank" style="mso-style-priority:100 !important;text-decoration:none;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:arial, \'helvetica neue\', helvetica, sans-serif;font-size:16px;color:#FFFFFF;border-style:solid;border-color:#3D85C6;border-width:10px 20px;display:inline-block;background:#3D85C6;border-radius:4px;font-weight:normal;font-style:normal;line-height:19px;width:auto;text-align:center">Login to Automailer</a></span></td> 
                                 </tr> 
                               </table></td> 
                             </tr> 
                           </table></td> 
                         </tr> 
                         <tr> 
                          <td align="left" style="padding:0;Margin:0;padding-left:20px;padding-right:20px;padding-top:25px"> 
                           <table cellpadding="0" cellspacing="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px"> 
                             <tr> 
                              <td align="center" valign="top" style="padding:0;Margin:0;width:560px"> 
                               <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px"> 
                                 <tr> 
                                  <td align="left" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, \'helvetica neue\', helvetica, sans-serif;line-height:21px;color:#333333">We hope you enjoy using Automailer, and we are here to help if you run into any issues. If you\'re still not sure how to begin, here are helpful videos: <a target="_blank" href="https://bit.ly/2NGHVKp" style="-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:arial, \'helvetica neue\', helvetica, sans-serif;font-size:14px;text-decoration:underline;color:#3D85C6">Tutorial Videos</a></p></td> 
                                 </tr> 
                               </table></td> 
                             </tr> 
                           </table></td> 
                         </tr> 
                         <tr> 
                          <td align="left" style="padding:0;Margin:0;padding-top:20px;padding-left:20px;padding-right:20px"> 
                           <table cellpadding="0" cellspacing="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px"> 
                             <tr> 
                              <td align="center" valign="top" style="padding:0;Margin:0;width:560px"> 
                               <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px"> 
                                 <tr> 
                                  <td align="center" style="padding:0;Margin:0;padding-top:5px"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:14px;font-family:arial, \'helvetica neue\', helvetica, sans-serif;line-height:21px;color:#333333">Questions? Feel free to contact our support team via Chat or Email: <a target="_blank" href="mailto:Support@automailer.io" style="-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:arial, \'helvetica neue\', helvetica, sans-serif;font-size:14px;text-decoration:underline;color:#3D85C6">Support@automailer.io</a></p></td> 
                                 </tr> 
                               </table></td> 
                             </tr> 
                           </table></td> 
                         </tr> 
                         <tr> 
                          <td align="left" style="padding:0;Margin:0;padding-top:20px;padding-left:20px;padding-right:20px"> 
                           <table cellpadding="0" cellspacing="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px"> 
                             <tr> 
                              <td align="center" valign="top" style="padding:0;Margin:0;width:560px"> 
                               <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px"> 
                                 <tr> 
                                  <td align="center" style="padding:0;Margin:0;padding-top:20px;font-size:0px"><img class="adapt-img" src="https://jrhwv.stripocdn.email/content/guids/CABINET_72b1e6e71b4adb8c2515e18274d4aa55/images/75061614616805393.png" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" width="200"></td> 
                                 </tr> 
                                 <tr> 
                                  <td align="center" style="padding:0;Margin:0;padding-top:10px;padding-bottom:15px"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-size:11px;font-family:arial, \'helvetica neue\', helvetica, sans-serif;line-height:13px;color:#999999">Your email is not shared with third parties and is only used for account-related questions, communication, and recovery. If you would like to update your email preferences, just login to your dashboard.</p></td> 
                                 </tr> 
                               </table></td> 
                             </tr> 
                           </table></td> 
                         </tr> 
                       </table></td> 
                     </tr> 
                   </table></td> 
                 </tr> 
               </table> 
              </div>  
             </body>
            </html>';

        $recipient =  $_POST['email'];

        // Send Welcome Email
        PhpMailerSendEmail($recipient,'Welcome to Automailer',$msg,'Automailer.io',true);

        // Send new user registration email to support@
        PhpMailerSendEmail('support@automailer.io','Automailer New User Registration',$message,'Automailer.io',true);

        // Send new user registration email to malik185@gmail.com
        PhpMailerSendEmail('malik1185@gmail.com','Automailer New User Registration',$message,'Automailer.io',true);

        // Send new user registration email to malik@sourceitmarketing.com
        PhpMailerSendEmail('malik@sourceitmarketing.com','Automailer New User Registration',$message,'Automailer.io',true);

        // Send new user registration email to support@
        PhpMailerSendEmail('brian@sourceitmarketing.com','Automailer New User Registration',$message,'Automailer.io',true);

        $_SESSION['id'] = $pdo->lastInsertId();

        header('Location: '.$root.'/startup-setup');
        exit();
    }
}
?>
<style>
    .checkbox-inline-error{
        border: 1px solid red;
        padding: 11px;
    }
</style>
<main>
    <?php
    //$_POST['plan'] = 0;
    $countries = $pdo->prepare('SELECT * FROM `countries` ORDER BY `name` ASC');
    $countries->execute();

    $states = $pdo->prepare('SELECT * FROM `states` WHERE `country_id` = ? ORDER BY `name` ASC');
    $states->execute(array(225));
    ?>

    <section>
        <div class="container-fluid" style="display:block;">
            <div class="row no-gutters login-page-row">
                <div class="col-md-4 banner">
                    <nav class="navbar navbar-expand-lg navbar-dark">
                        <a href="<?php echo $root; ?>" class="navbar-brand">
                            <img src="<?php echo $root; ?>/img/automailer-logo-ver2.png">
                        </a>
                    </nav>


                    <div class="login-slider d-none d-md-block">
                        <div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
                            <ol class="carousel-indicators" style="display:none;">
                                <li data-target="#carouselExampleIndicators" data-slide-to="0" class="active"></li>
                                <li data-target="#carouselExampleIndicators" data-slide-to="1"></li>
                                <li data-target="#carouselExampleIndicators" data-slide-to="2"></li>
                            </ol>
                            <div class="carousel-inner">
                                <div class="carousel-item active">
                                    <h2>Automate Your Email Outreach and Follow-ups</h2>
                                    <p>Easily create email sequences to boost your lead generation efforts.  Our software automates your cold email campaigns so you don’t have to manually send hundreds or thousands of emails one by one to potential clients and partners.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-8 login-form align-self-center">
                    <div class="form-inner">
                        <div class="heading">
                            <h1 class="h4 text-gray-900 mb-4">Try AutoMailer for Free</h1>
                            <h5>Sign Up for a 14-Day Free Trial</h5>
                        </div>
                        <div class="login-signup">
                            <a href="https://login.automailer.io/login" class="btn btn-lg btn-link">Log in</a>
                            <a href="javascript:void(0);" class="btn btn-lg btn-link active">Sign up</a>
                        </div>

                        <div id="signup-form1">
                            <form class="user" action="" method="post" id="register_form">
                                <input type="hidden" value="monthly" id="billing_type" />
                                <div class="form-group ">
                                    <input type="text" name="fname" class="form-control form-control-user" required>
                                    <label for="">Full name</label>
                                    <span class="err-fname alert-danger"></span>
                                </div>
                                <!-- <div class="form-group">
                                    <input type="text" name="lname" class="form-control form-control-user" required>
                                    <label for="">Last name</label>
                                    <span class="err-lname alert-danger"></span>
                                </div> -->
                                <div class="form-group">
                                    <input type="text" name="email" class="form-control form-control-user" required>
                                    <label for="">Email address</label>
                                    <span class="err-email alert-danger"></span>
                                </div>
                                <div class="form-group">
                                    <input type="text" name="username" class="form-control form-control-user" required>
                                    <label for="">Username</label>
                                    <div class="err-username"></div>
                                </div>
                                <div class="form-group">
                                    <input type="password" name="password" id="password" class="form-control form-control-user" required>
                                    <label for="">Password</label>
                                    <span id="show-password" onclick="showpass();">
                        <svg class="hide-pass" fill="none" height="24" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg">
                          <path d="M17.94 17.94A10.07 10.07 0 0 1 12 20c-7 0-11-8-11-8a18.45 18.45 0 0 1 5.06-5.94M9.9 4.24A9.12 9.12 0 0 1 12 4c7 0 11 8 11 8a18.5 18.5 0 0 1-2.16 3.19m-6.72-1.07a3 3 0 1 1-4.24-4.24"/>
                          <line x1="1" x2="23" y1="1" y2="23"/>
                        </svg>
                        <svg class="show-pass" xmlns="http://www.w3.org/2000/svg">
                          <path id="svg_1" d="m12.500024,5.221397c5.497863,0 8.968661,5.198402 10.137382,7.278493c-1.170795,2.083726 -4.640821,7.278493 -10.137382,7.278493c-5.497081,0 -8.967362,-5.16825 -10.137119,-7.239762c1.168977,-2.092048 4.640038,-7.317224 10.137119,-7.317224m0,-2.079572c-8.318277,0 -12.477416,9.401215 -12.477416,9.401215s4.159139,9.314912 12.477416,9.314912s12.477418,-9.358062 12.477418,-9.358062s-4.15914,-9.358065 -12.477418,-9.358065l0,0z"/>
                          <path id="svg_2" d="m12.500985,10.344938c1.187673,0 2.154023,0.966351 2.154023,2.154022s-0.966351,2.154022 -2.154023,2.154022s-2.154023,-0.966351 -2.154023,-2.154022s0.966351,-2.154022 2.154023,-2.154022m0,-2.154023c-2.379115,0 -4.308045,1.92893 -4.308045,4.308045c0,2.379385 1.92893,4.308046 4.308045,4.308046c2.379385,0 4.308045,-1.928661 4.308045,-4.308046c0,-2.379115 -1.92866,-4.308045 -4.308045,-4.308045l0,0z"/>
                        </svg>
                      </span>
                                    <span class="err-password alert-danger"></span>
                                </div>
                                <div class="form-group terms-condition-container1">
                                    <div class="checkbox-inline label-inline">
                                        <label class="checkbox-label" style="display: none;" >
                                            <input type="checkbox" name="terms" class="form-control chk-terms-condition" id="chk-terms-condition" checked="checked" required>
                                            <span class="checkbox-custom"></span>
                                        </label>
                                        <label class="form-check-label" for="chk-terms-condition">By signing up you agree to Automailer's <a target="_blank" href="https://automailer.io/terms-of-service/" > Terms of use and Conditions.</a></label>
                                    </div>
                                </div>
                                <div>
                                    <input type="hidden" class="selected-plan" name="selected_plan" id="selected_plan" value="">
                                    <input type="hidden" class="selected-total-plan-amount" name="selected_plan_amount" id="selected_plan_amount" >
                                    <input type="hidden" name="renew_date" id="renew_date" value=" <?php echo date("m/d/Y", strtotime("+15 days")); ?>" >

                                    <input type="hidden" name="plan" id="plan" value="">
                                    <input type="hidden" name="plan_id" id="plan_id" >
                                    <input type="hidden" name="stripe" id="stripe">
                                    <input type="hidden" name="plan_quantity" id="plan_quantity">
                                    <input type="hidden" name="plan_amount" id="plan_amount">
                                    <input type="hidden" name="total_cleaning_credit" id="total_cleaning_credit">
                                    <input type="hidden" name="total_billing_amount" id="total_billing_amount">
                                    <input type="hidden" name="plan_cleaning_credits" id="plan_cleaning_credits">
                                    <input type="hidden" name="plan_billing_type" id="plan_billing_type">

                                    <input type="hidden" name="cc_last_4d" value="" id="cc_last_4d">
                                    <input type="hidden" name="cc_month" value="" id="cc_month">
                                    <input type="hidden" name="cc_year" value="" id="cc_year">

                                    <input type="hidden" name="selected_country" id="selected_country">
                                    <input type="hidden" name="selected_state" id="selected_state">
                                    <input type="hidden" name="selected_address" id="selected_address">
                                    <input type="hidden" name="selected_postal_code" id="selected_postal_code">
                                    <input type="hidden" name="selected_city" id="selected_city">
                                    <input type="hidden" name="prospect_stripe_id" id="prospect_stripe_id">
                                    <input type="hidden" name="selected_plan_id" id="selected_plan_id">
                                    <input type="hidden" name="stripe_card_brand" id="stripe_card_brand">
                                    <input type="hidden" name="search_credit" id="search_credit">
                                    <input type="hidden" name="stripe_customer_id" id="stripe_customer_id">
                                    <input type="hidden" name="selected_stripe_plan_id" id="selected_stripe_plan_id" value="">
                                    <input type="submit" name="submitBtn" id="submitBtn" style="display: none;">
                                    <button type="button" class="btn btn-success btn-signup-step1 btn-block btn-lg" onclick="signup_step1()" >GET STARTED WITH FREE TRIAL</button>

                                </div>

                            </form>
                        </div>





                        <div class="text-center"></div>
                    </div>
                </div>
            </div>
        </div><!-- .container-fluid -->


        <div class="select-plans" id="signup-form2" tabindex="-1" role="dialog" aria-labelledby="pricingModalLabel" style="display: none;">

            <div class="container-fluid">
                <div class="row  no-gutters">
                    <div class="col-md-12">
                        <nav class="navbar navbar-expand-lg navbar-dark">
                            <a href="<?php echo $root; ?>" class="navbar-brand">
                                <img src="<?php echo $root; ?>/img/automailer-logo-ver2.png">
                            </a>
                        </nav>
                    </div>
                </div>
            </div>

            <div class="container">

                <div class="row">
                    <div class="col-md-12 text-center">
                        <div class="heading">
                            <h1>Select a Plan to Get Started</h1>
                            <h5>14 Day Free Trial on All Plans - Cancel at Anytime</h5>
                            <div class="billed-mo-an">
                                <span class="monthly">Billed Monthly</span>
                                <label class="switch-wrap">
                                    <input type="checkbox" onclick="switchWrap()" />
                                    <div class="switch"></div>
                                </label>
                                <span class="annual order-summary-annual">Billed Annually <big>Save 20%</big></span>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="row">
                    <?php
                    $q = $pdo->prepare('SELECT * FROM `plans` ');
                    $q->execute();
                    if($q->rowcount()>0)
                    { foreach ($q as $row) {
                        ?>
                        <div class="col-lg-4">
                            <input type="hidden" id="plan_name_<?php echo $row['id']; ?>" value="<?php echo $row['plan_name']; ?>">
                            <div class="card card<?php echo $row['id']; ?>  <?php if($row['id'] ==2){ echo "selected"; } ?> mb-4 shadow-sm card-<?php echo $row['plan_name']; ?>">
                                <div class="card-header">
                                    <h4 class="my-0 font-weight-normal"><?php echo $row['plan_name']; ?></h4>
                                </div>
                                <div class="card-body" style="position: relative; padding-bottom: 70px;">
                                    <h1 class="card-title pricing-card-title plan-package" data-value="<?php echo $row['price_per_month']; ?>"><?php echo $row['price_per_month'];?><small class="text-muted">/mo</small></h1>
                                    <big><?php echo $row['total_list_cleaning_credits']; ?> List Cleaning and Verification Credits <small>Per Email Account</small></big>
                                    <p class="darken">All Features Included</p>
                                    <p>Unlimited Campaigns</p>
                                    <p>Customize Sending Speeds</p>
                                    <p>Email Integration</p>
                                    <p>Personalize Email Messages</p>
                                    <p>Add Custom Fields</p>
                                    <p>Customize Time and Day for Emails</p>
                                    <p>Track Opens, Clicks, Replies</p>
                                    <p>Automatic Reply Detection</p>
                                    <p>Sort Replies</p>
                                    <p>Bounce back reports</p>
                                    <p>Manage and Track Leads</p>
                                    <p>Automatically Detect Out-of-Office Replies</p>
                                    <p>And Much More!</p>
                                    <form action="<?php echo $root; ?>/register" method="post">
                                        <!-- Emails: <input type="number" min="1" max="100" name="number_of_email<?php echo $row['id']; ?>" id="number_of_email<?php echo $row['id']; ?>" class="form-control form-control-user" placeholder="1" required>
                          <?php echo $row['feature_breakdown']; ?> -->
                                        <input type="hidden" name="plan<?php echo $row['id']; ?>" id="plan<?php echo $row['id']; ?>" value="<?php echo $row['id']; ?>">
                                        <input type="hidden" name="plan_amount<?php echo $row['id']; ?>" id="plan_amount<?php echo $row['id']; ?>" value="<?php echo $row['price_per_month'];?>">
                                        <input type="hidden" name="plan_cleaning_credit<?php echo $row['id']; ?>" id="plan_cleaning_credit<?php echo $row['id']; ?>" value="<?php echo $row['total_list_cleaning_credits'];?>">
                                        <input type="hidden" name="stripe_plan_monthly<?php echo $row['id']; ?>" id="stripe_plan_monthly<?php echo $row['id']; ?>" value="<?php echo $row['stripe_plan_id_monthly'];?>">
                                        <input type="hidden" name="stripe_plan_yearly<?php echo $row['id']; ?>" id="stripe_plan_yearly<?php echo $row['id']; ?>" value="<?php echo $row['stripe_plan_id_yearly'];?>">
                                        <button type="button" class="btn btn-lg btn-block btn-primary btn-plan" id="btn_plan<?php echo $row['id']; ?>"  onclick="signup_toggle(<?php echo $row['id']; ?>)">Select <?php echo $row['plan_name']; ?> Plan</button>
                                        <input type="hidden" id="plan_name<?php echo $row['id']; ?>" value="Select <?php echo $row['plan_name']; ?> Plan">
                                        <p>14-DAY FREE TRIAL</p>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <?php
                    }
                    }

                    ?>

                </div>
            </div>

            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="heading faq">
                            <h3>Frequently Asked Questions</h3>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="accordion" id="faq">
                            <div class="card">
                                <div class="card-header" id="question1">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#questionOne" aria-expanded="true" aria-controls="questionOne">
                                            What is consider an email account and how am I being charged?
                                        </button>
                                    </h2>
                                </div>

                                <div id="questionOne" class="collapse" aria-labelledby="question1" data-parent="#faq">
                                    <div class="card-body">
                                        You are charged for each email account used for sending emails from Automailer.   For example, If you have 3 emails accounts that you want to connect for sending cold email campaigns, then you would need to select any plan from above and add 2 additional email accounts to the plan.
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="accordion" id="faq2">
                            <div class="card">
                                <div class="card-header" id="question2">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#questionTwo" aria-expanded="true" aria-controls="questionTwo">
                                            How many emails can I send from one email account in a single day?
                                        </button>
                                    </h2>
                                </div>

                                <div id="questionTwo" class="collapse" aria-labelledby="question2" data-parent="#faq2">
                                    <div class="card-body">
                                        You can send up to 500 emails from email account in all plans.  This is to protect you from being negatively impacted by spam and low deliverability scores.  Contact support if you would like to increase your email sends per day.
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="accordion" id="faq3">
                            <div class="card">
                                <div class="card-header" id="question3">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#questionThree" aria-expanded="true" aria-controls="questionThree">
                                            What are List Cleaning and Verification Credits?
                                        </button>
                                    </h2>
                                </div>

                                <div id="questionThree" class="collapse" aria-labelledby="question3" data-parent="#faq3">
                                    <div class="card-body">
                                        Your email outreach success depends on the quality of your email lists.  When you send emails to a bad or non-existing email address, you’re hurting the reputation of your email address.  The verification credits are used for running each email in your contact list through our rigorous 18-point email verification process to see if the email address exists and isn’t someone who is known as a “complainer”
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="accordion" id="faq4">
                            <div class="card">
                                <div class="card-header" id="question4">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#questionFour" aria-expanded="true" aria-controls="questionFour">
                                            How many users can I have and how does the team functionality work?
                                        </button>
                                    </h2>
                                </div>

                                <div id="questionFour" class="collapse" aria-labelledby="question4" data-parent="#faq4">
                                    <div class="card-body">
                                        Each email you purchase gives you 1 user and 1 admin account you can assign particular email on the sub accounts for the user you can manage the access of the user to the particular modules.
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="accordion" id="faq5">
                            <div class="card">
                                <div class="card-header" id="question5">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#questionFive" aria-expanded="true" aria-controls="questionFive">
                                            Can I change my plan at anytime?
                                        </button>
                                    </h2>
                                </div>

                                <div id="questionFive" class="collapse" aria-labelledby="question5" data-parent="#faq5">
                                    <div class="card-body">
                                        Yes, you can upgrade or downgrade your plan at anytime.  For monthly plans, The new plan will take effect on the next billing cycle.
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="accordion" id="faq6">
                            <div class="card">
                                <div class="card-header" id="question6">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#questionSix" aria-expanded="true" aria-controls="questionSix">
                                            Can I cancel at anytime?
                                        </button>
                                    </h2>
                                </div>

                                <div id="questionSix" class="collapse" aria-labelledby="question6" data-parent="#faq6">
                                    <div class="card-body">
                                        Yes, you can cancel your service with Automailer and anytime.  If you cancel within your 14-day Free Trial period, your credit card will not be charged.  If you cancel after the free trial period, your service will be canceled on the next billing cycle.  Please note that we do not provide refunds for past or current month(s) service.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>



        <div class="account-billing" id="signup-form3" style="display:none" >

            <div class="container-fluid">
                <div class="row  no-gutters">
                    <div class="col-md-12">
                        <nav class="navbar navbar-expand-lg navbar-dark">
                            <a href="<?php echo $root; ?>" class="navbar-brand">
                                <img src="<?php echo $root; ?>/img/automailer-logo-ver2-dark.png">
                            </a>
                        </nav>
                    </div>
                </div>
            </div>
            <form action="/charge" method="post" id="new-payment-form" class="user">
                <div class="container">
                    <div class="row">

                        <div class="col-md-7">
                            <div class="card">
                                <h5 class="card-header">Account and Billing Information <a class="btn btn-sm btn-primary pull-right btn-change-plan" href="javascript:void(0);">Change Plan</a></h5>
                                <div class="card-body">
                                    <center class="select-payment-plan">
                                        <button type="button" class="btn active_toggle btn-outline-secondary btn-monthly-plan">
                                            <small class="plan">Monthly Plan</small>
                                            <big><small>$</small><span class="plan_amount_billing"></span></big>
                                            <!-- <span class="cost">monthly cost</span> -->
                                            <span class="billed">Billed monthly</span>
                                        </button>
                                        <button type="button" class="btn active_toggle btn-outline-secondary btn-annual-plan">
                                            <small class="plan">Annual Plan</small>
                                            <big><small>$</small><span class="plan_amount_yearly_billing"></span></big>
                                            <!-- <span class="cost">yearly cost</span> -->
                                            <span class="billed"><span class="order-summary-amount-year"></span> Billed annually</span>
                                            <span class="save">Save $<span class="order-summary-amount-year-discount"></span></span>
                                        </button>
                                        <p>100% Risk Free Trial for 14 Days</p>
                                    </center>
                                    <div class="separator"></div>
                                    <div class="row">
                                        <div class="col-md-7">
                                            <p><big><strong><span class="selected-plan"></span></strong></big></p>
                                        </div>
                                        <div class="col-md-5 text-center">
                                            <big><span class="selected-plan-amount"></span></big>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="col-md-7">
                                            <p>Number of Email Accounts</p>
                                        </div>
                                        <div class="col-md-5 text-center">
                                            <div class="input-group group-number">
                          <span class="input-group-btn">
                              <button type="button" class="btn btn-number btn-outline"  data-type="minus" data-field="quant[2]">-</button>
                          </span>
                                                <input type="text" name="quant[2]" class="form-control input-number" value="1" min="1" max="100">
                                                <span class="input-group-btn">
                              <button type="button" class="btn btn-number btn-outline" data-type="plus" data-field="quant[2]">+</button>
                          </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-7">
                                            <p>List Cleaning Credits Per Month</p>
                                        </div>
                                        <div class="col-md-5 text-center">
                                            <span class="list-cleaning-credits"></span>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <p>All Features Included</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card credit-card">
                                <h5 class="card-header">Prospect Finder (Add-on)</h5>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12" style="border: none;">
                                            <p style="font-size:13px; color:#888888;">Find Email addresses for targeted prospects. You’ll getaccess to our database of 100+ million b2b contacts and their emails. Use custom filters to build your highly targeted prospects list.</p>
                                            <div class="form-group">
                                                <select class="form-control plans-list plans_info" id="plans" name="plan_id" style="width:100%;">
                                                    <option value="" selected>Please Choose a Plan</option>
                                                    <?php if($plans->rowcount()>0){ ?>
                                                        <?php foreach ($plans as $row) { ?>
                                                            <option data-planid = '<?= $row['id'] ?>' data-stripeid = '<?= $row['stripe_plan_id_monthly'] ?>' data-credit='<?= $row['credit'] ?>' data-price='<?= $row['price_per_month'] ?>'><?= $row['plan_name'] .'    $'.   $row['price_per_month'].'/'.$row['credit'] ?></option>
                                                        <?php } } ?>
                                                </select>
                                                <div>
                                                    <span class=""></span><br>
                                                    <span>Email CreditsPerMonth:</span><span class="ml-2" id="plan_info_credits">$00</span><br>
                                                    <span>Recurring :</span><span class="ml-2" id="credits">Annually/Monthly</span>

                                                </div>
                                                <span class="err-plans alert-danger"></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card credit-card">
                                <h5 class="card-header">Credit Card Information</h5>
                                <div class="card-body">
                                    <script src="https://js.stripe.com/v3/"></script>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div id="card-element" class="form-control"></div>
                                                <label for="">Credit or Debit Card</label>
                                                <div id="card-errors" style="color: red;" role="alert"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <select class="form-control country-list" id="country_id" name="country_id" style="width:100%;">
                                                    <?php foreach($countries as $c){ ?>
                                                        <option value="<?php echo $c['id']; ?>" <?php echo $c['id'] == 225 ? "selected='selected'" : ''; ?>><?php echo $c['name']; ?></option>
                                                    <?php } ?>
                                                </select>
                                                <label for="">Country</label>
                                                <span class="err-country alert-danger"></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-7">
                                            <div class="form-group">
                                                <input type="text" name="address" id="address" class="form-control form-control-user" required>
                                                <label for="">Street Address</label>
                                                <span class="err-fname alert-danger"></span>
                                            </div>
                                        </div>
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                <input type="text" name="city" id="city" class="form-control form-control-user" required>
                                                <label for="">City</label>
                                                <span class="err-fname alert-danger"></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-7">
                                            <div class="form-group">
                                                <div class="state-input">
                                                    <select class="form-control state-list" id="state" name="state" style="width:100%;">
                                                        <?php foreach($states as $s){ ?>
                                                            <option value="<?php echo $s['name']; ?>"><?php echo $s['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                                <label for="">State</label>
                                                <span class="err-fname alert-danger"></span>
                                            </div>
                                        </div>
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                <input type="text" name="postal_code" id="postal_code" class="form-control form-control-user" required>
                                                <label for="">Postal Code</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="card border-primary order-summary">
                                <h5 class="card-header">Order Summary</h5>
                                <div class="card-body">
                                    <div class="item">
                                        <div class="float-right price-breakdown">
                                            <span class="price order-summary-amount"></span>
                                            <div class="annual-discount-text">
                                                <span class="lighten"></span>
                                                <span class="red"></span>
                                            </div>
                                        </div>
                                        <p class="item-name"><span class="selected-plan"></span></p>
                                    </div>
                                    <div class="separator"></div>
                                    <div class="item">
                                        <span class="float-right discount-amount-annual-plan"></span>
                                        <p class="item-name">Discount for Annual Plan</p>
                                    </div>
                                    <div class="item">
                                        <span class="float-right order-summary-monthly-charge"></span>
                                        <p class="item-name">Price Per User</p>
                                    </div>
                                    <div class="item">
                                        <span class="float-right lighten"><span class="total-email-account">1</span></span>
                                        <p class="item-name">Number of Users</p>
                                    </div>
                                    <div class="separator"></div>
                                    <div class="item">
                                        <span class="float-right"><?php echo date("m/d/Y", strtotime("+15 days")); ?></span>
                                        <p class="item-name">Bill Date:</p>
                                        <p class="item-name">Your credit card will be charged after the 14-day free trial period ends.</p>
                                    </div>
                                    <!-- <div class="item">
                                      <span class="float-right">$0.00</span>
                                      <p class="item-name lighten">Have discount code?</p>
                                    </div> -->
                                    <div class="separator"></div>
                                    <div class="item">
                                        <span class="float-right blue order-summary-total-amount"></span>
                                        <p class="item-name blue"><big>Total after Trial:</big></p>
                                    </div>
                                    <div class="item">
                                        <span class="float-right"><big class="blue order-summary-savings-off">$ 0.00 </big></span>
                                        <p class="item-name blue"><big>Due Today:</big></p>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-success btn-block btn-lg" id="verify_payment_method">START 14-DAY FREE TRIAL</button>
                            <div class="notes">
                                <ul>
                                    <li><i class="fas fa-check"></i><span id="bill-today"> You won't be billed today </span></li>
                                    <li><i class="fas fa-check"></i> <span id="cancel-time"> Cancel anytime before (Bill date listed on Order Summary).</span></li>
                                </ul>
                                <p id="details">By clicking "Start 14-day Free Trial" you agree to Automailer's Terms of Service and <a href="https://automailer.io/privacy-policy/"> Privacy Policy</a>. Your credit card will be charged monthly or annually based on the plan you selected.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>

    <!-- Modal Terms Condition -->
    <div class="modal fade" id="modal-terms-condition" tabindex="-1" role="dialog" aria-labelledby="addPOP3Label" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <h4 class="modal-heading">Terms and Condition</h4>
                    <div class="terms-content" style="max-height: 500px; overflow: auto;padding: 0 20px 0 0;">
                        <h4>What is Lorem Ipsum?</h4>
                        <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>
                        <h4>Why do we use it?</h4>

                        <p>It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using 'Content here, content here', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for 'lorem ipsum' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).</p>

                        <h4>Where does it come from?</h4>

                        <p>Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of "de Finibus Bonorum et Malorum" (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, "Lorem ipsum dolor sit amet..", comes from a line in section 1.10.32.</p>

                        <p>The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections 1.10.32 and 1.10.33 from "de Finibus Bonorum et Malorum" by Cicero are also reproduced in their exact original form, accompanied by English versions from the 1914 translation by H. Rackham.</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

</main>

<script type="text/javascript">
    $('.chk-terms-condition').change(function(){
        if($('.chk-terms-condition').prop('checked')){
            $("#modal-terms-condition").modal('show');
        }
    });

    function selectPlan() {
        jQuery('.select-payment-plan').on('click', '.btn', function() {
            jQuery(this).siblings().removeClass('active');
            jQuery(this).addClass('active').siblings().removeClass('active');
        });
    }

    function showpass() {
        var x = document.getElementById("password");
        var element = document.getElementById("show-password");
        if (x.type === "password") {
            x.type = "text";
            document.getElementById("show-password").className = true;
            element.classList.add("show");
        } else {
            x.type = "password";
            element.classList.remove("show");
        }
    }

    function switchWrap() {

        if (jQuery('.switch-wrap input').is(':checked')) {
            jQuery('.billed-mo-an').addClass('checked');
            $("#billing_type").val("yearly");

            $('.plan-package').each(function(i) {
                var plan_amount  = parseFloat($(this).attr("data-value")) * 12;
                var discount     = plan_amount * .2;
                var total_amount = plan_amount - discount;
                total_amount = total_amount.toFixed(2);

                $(this).html(total_amount + "<small class='text-muted'>/yr</small>");
            });

        } else {
            jQuery('.billed-mo-an').removeClass('checked');
            $("#billing_type").val("monthly");

            $('.plan-package').each(function(i) {
                var plan_amount  = parseFloat($(this).attr("data-value"));
                var total_amount = plan_amount;
                total_amount = total_amount.toFixed(2);

                $(this).html(total_amount + "<small class='text-muted'>/mo</small>");
            });
        };
    }

    $('[name="username"]').blur(function(){
        isUsernameExists();
    });

    $('[name="email"]').blur(function(){
        isEmailExists();
    });

    function validateEmail(email) {
        var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,10})+$/;
        return regex.test(email);
    }

    function isEmailExists(){
        if( $('[name="email"]').val().length<1 ){
            $('[name="email"]').addClass('inline-error');
        }else if(!validateEmail($('[name="email"]').val())){
            $(".err-email").addClass("inline-error");
            $(".err-email").html("<div class='alert alert-danger'>Not a valid email</div>");
        }else{
            var url = root_dir + "/validate-email";
            var msg = '<div class="alert alert-warning" role="alert"><img src="'+root_dir+'/img/spinner.gif" /> Checking email if taken...</div>';

            $(".err-email").removeClass('inline-error');
            $(".err-email").html(msg);

            setTimeout(function () {
                $.ajax({
                    type: "POST",
                    url: url,
                    dataType: "json",
                    data: {email:$('[name="email"]').val()},
                    success: function(o)
                    {
                        if( o.is_email_taken ){
                            $(".err-email").addClass("inline-error");
                            $(".err-email").html("<div class='alert alert-danger'>Email already in used</div>");
                        }else{
                            var msg = '<div class="alert alert-success alert-validate-email" role="alert">Email Available</div>';
                            $(".err-email").removeClass("inline-error");
                            $(".err-email").html(msg);
                        }
                    }
                });
            }, 1000);
        }
    }

    function isUsernameExists(){
        if( $('[name="username"]').val().length>1 ){
            var url = root_dir + "/validate-username";
            var msg = '<div class="alert alert-warning" role="alert"><img src="'+root_dir+'/img/spinner.gif" /> Checking username if taken...</div>';

            $(".err-username").removeClass('inline-error');
            $(".err-username").html(msg);

            setTimeout(function () {
                $.ajax({
                    type: "POST",
                    url: url,
                    dataType: "json",
                    data: {username:$('[name="username"]').val(), email:$('[name="email"]').val()},
                    success: function(o)
                    {
                        if( o.is_length_valid ){
                            if( o.is_taken ){
                                $(".err-username").addClass("inline-error");
                                $(".err-username").html("<div class='alert alert-danger'>Username already in used</div>");
                                is_valid = false;
                            }else{
                                if( o.is_valid_pattern ){
                                    var msg = '<div class="alert alert-success alert-validate-username" role="alert">Valid Username</div>';
                                    $(".err-username").removeClass("inline-error");
                                    $(".err-username").html(msg);
                                }else{
                                    $(".err-username").addClass("inline-error");
                                    $(".err-username").html("<div class='alert alert-danger'>Cannot special characters or empty space</div>");
                                    is_valid = false;
                                }

                            }
                        }else{
                            $(".err-username").addClass("inline-error");
                            $(".err-username").html("<div class='alert alert-danger'>Username too short. Minimum length is 5.</div>");
                            is_valid = false;
                        }

                        if( o.is_email_taken ){
                            $(".err-email").addClass("inline-error");
                            $(".err-email").html("<div class='alert alert-danger'>Email already in used</div>");
                            is_valid = false;
                        }else{
                            var msg = '<div class="alert alert-success alert-validate-email" role="alert">Email Available</div>';
                            $(".err-email").removeClass("inline-error");
                            $(".err-email").html(msg);
                        }
                    }
                });
            }, 1000);
        }else{
            if( $('[name="username"]').val().length<1 ){
                $('[name="username"]').addClass('inline-error');
            }
        }
    }

    function signup_step1() {
        var is_valid = true;
        var email_valid = true;

        if( $('[name="fname"]').val().length<1 ){
            $('[name="fname"]').addClass('inline-error');
            is_valid = false;
        }else{
            $('[name="fname"]').removeClass('inline-error');
        }

        if( $(".chk-terms-condition").prop("checked") != true ){
            $('.terms-condition-container').addClass('checkbox-inline-error');
            is_valid = false;
        }else{
            $('.terms-condition-container').removeClass('checkbox-inline-error');
            is_valid = true;
        }

        // if( $('[name="lname"]').val().length<1 ){
        //     $('[name="lname"]').addClass('inline-error');
        //     is_valid = false;
        // }else{
        //     $('[name="lname"]').removeClass('inline-error');
        // }

        if( $('[name="email"]').val().length<1 ){
            $('[name="email"]').addClass('inline-error');
            is_valid = false;
            email_valid = false;
        }else if(!validateEmail($('[name="email"]').val())){
            $(".err-email").addClass("inline-error");
            $(".err-email").html("<div class='alert alert-danger'>Not a valid email</div>");
            is_valid = false;
            email_valid = false;
        }else{
            $('[name="email"]').removeClass('inline-error');
            $(".err-email").removeClass("inline-error");
        }

        if( $('[name="country_id"]').val().length<1 ){
            $('[name="country_id"]').addClass('inline-error');
            is_valid = false;
        }else{
            $('[name="country_id"]').removeClass('inline-error');
        }

        if( $('[name="password"]').val().length<1 ){
            $('[name="password"]').addClass('inline-error');
            is_valid = false;
        }else{
            $('[name="password"]').removeClass('inline-error');
        }

        if( $('[name="username"]').val().length>1 ){
            var url = root_dir + "/ajax_validate_username_email.php";
            var msg = '<div class="alert alert-warning" role="alert"><img src="'+root_dir+'/img/spinner.gif" /> Checking username if taken...</div>';
            var msg2 = '<div class="alert alert-warning" role="alert"><img src="'+root_dir+'/img/spinner.gif" /> Checking email if taken...</div>';
            $(".err-username").removeClass('inline-error');
            $(".err-username").html(msg);

            if( email_valid ){
                $(".err-email").removeClass('inline-error');
                $(".err-email").html(msg2);
            }

            setTimeout(function () {
                $.ajax({
                    type: "POST",
                    url: url,
                    dataType: "json",
                    data: {username:$('[name="username"]').val(), email:$('[name="email"]').val()},
                    success: function(o)
                    {
                        if( o.is_length_valid ){
                            if( o.is_taken ){
                                $(".err-username").addClass("inline-error");
                                $(".err-username").html("<div class='alert alert-danger'>Username already in used</div>");
                                is_valid = false;
                            }else{
                                if( o.is_valid_pattern ){
                                    var msg = '<div class="alert alert-success alert-validate-username" role="alert">Valid Username</div>';
                                    $(".err-username").removeClass("inline-error");
                                    $(".err-username").html(msg);
                                }else{
                                    $(".err-username").addClass("inline-error");
                                    $(".err-username").html("<div class='alert alert-danger'>Cannot special characters or empty space</div>");
                                    is_valid = false;
                                }

                            }
                        }else{
                            $(".err-username").addClass("inline-error");
                            $(".err-username").html("<div class='alert alert-danger'>Username too short. Minimum length is 5.</div>");
                            is_valid = false;
                        }

                        if( o.is_email_taken ){
                            $(".err-email").addClass("inline-error");
                            $(".err-email").html("<div class='alert alert-danger'>Email already in used</div>");
                            is_valid = false;
                        }else{
                            var msg = '<div class="alert alert-success alert-validate-email" role="alert">Email Available</div>';
                            $(".err-email").removeClass("inline-error");
                            $(".err-email").html(msg);
                        }

                        if( is_valid ){
                            $('.login-page-row').hide();
                            $('#signup-form1').hide();
                            $('#signup-form2').show();
                        }
                    }
                });
            }, 1000);
        }else{
            if( $('[name="username"]').val().length<1 ){
                $('[name="username"]').addClass('inline-error');
                is_valid = false;
            }

            if( is_valid ){
                $('#signup-form1').hide();
                $('#signup-form2').show();
            }
        }

        /*if($('[name="password"]').val().length<1 || $('[name="username"]').val().length<1 || $('[name="email"]').val().length<1 || $('[name="lname"]').val().length<1 || $('[name="fname"]').val().length<1){

          }else{
          $('#signup-form1').hide();
          $('#signup-form2').show();
        }*/
    }

    function signup_toggle(id){
        var plan_btn = $('#btn_plan'+id).html();
        if(plan_btn != "Proceed to billing"){
            var plan_btn1 = $('#plan_name1').val();
            var plan_btn2 = $('#plan_name2').val();
            var plan_btn3 = $('#plan_name3').val();
            $('#btn_plan1').html(plan_btn1);
            $('#btn_plan2').html(plan_btn2);
            $('#btn_plan3').html(plan_btn3);
            $('#btn_plan'+id).html("Proceed to billing");
            $('.card').removeClass('selected');
            $('.card'+id).addClass('selected');
            setTimeout(function(){ signup_step2(id); }, 1500)
        }else{
            signup_step2(id);
        }
    }

    function signup_step2(id){
        var number_of_email       = $('.input-number').val();
        var plan_amount           = $('#plan_amount'+id).val();
        var total_amount          = number_of_email * plan_amount;
        var plan_id               = $('#plan'+id).val();
        var cleaning_credits      = $('#plan_cleaning_credit'+id).val();
        var total_cleaning_credit = cleaning_credits;
        var annual_ammount      = plan_amount * 12;
        var plan_amount_billing = plan_amount * 1;
        var selected_plan       = $("#plan_name_"+id).val();

        var discount            = (plan_amount * 12) * .2;
        var total_yearly_amount = (plan_amount * 12) - discount;

        $('#plan_cleaning_credits').val(cleaning_credits);
        $('.plan_amount_billing').html(plan_amount_billing);
        $('#plan_id').val(plan_id);
        $('#plan').val(plan_id);
        $('#total_cleaning_credit').val(total_cleaning_credit);
        $('#plan_quantity').val(number_of_email);
        $('#plan_amount').val(plan_amount);

        $('#total-amount').html(total_amount);
        $('#total-email').html(number_of_email);
        $('.btn-monthly-plan').attr('data-key', id);
        $('.btn-annual-plan').attr('data-key', id);


        $(".selected-plan").text(selected_plan + ' Account Plan');
        $(".selected-plan").val(selected_plan + ' Account Plan');

        //$(".selected-plan").text('Price Per User');

        if( $("#billing_type").val() == 'monthly' ){
            var order_summary_amount = "$" + plan_amount;
            var plan_amount    = $("#plan_amount").val();
            var total_discount = 0;
            var total_amount = parseInt(plan_amount);
            var summary_annual_monthly = "Per Month";
            var annual_percentage_discount = 0;
            //$(".order-summary-annual").text("");
            $("#selected_stripe_plan_id").val($("#stripe_plan_monthly"+id).val());
            $(".annual-discount-text").hide();
            $(".order-summary-savings").text(0);
        }else{
            var total_amount = (plan_amount * 12) - discount;
            var order_summary_amount = "$" + total_amount;
            var plan_amount = $("#plan_amount").val() * 12;
            var total_discount = plan_amount * .2;
            var summary_annual_monthly = "Per Year";
            var annual_percentage_discount = "20%";
            //$(".order-summary-annual").text("Billed Annually<br />Save 20%");
            var total_discount = parseInt(discount);
            total_discount     = total_discount.toFixed(2);
            $(".order-summary-savings").text(total_discount);
            $("#selected_stripe_plan_id").val($("#stripe_plan_yearly"+id).val());
            $(".annual-discount-text").show();
        }

        total_amount = total_amount.toFixed(2);
        discount     = discount.toFixed(2);
        total_yearly_amount = total_yearly_amount.toFixed(2);
        var total_email = $("#plan_quantity").val();

        if( $("#billing_type").val() == 'monthly' ){
            $(".selected-plan-amount").text("$" + total_amount + "/month");
            $(".selected-plan-amount").val("$" + total_amount + "/month");
            total_amount = plan_amount * total_email;
            var total_discount_amount = 0;
            $('.active_toggle').removeClass('active');
            $('.btn-monthly-plan').addClass('active');
        }else{
            $(".selected-plan-amount").text("$" + total_amount + "/year");
            $(".selected-plan-amount").val("$" + total_amount + "/year");

            total_amount = (plan_amount - discount) * total_email;
            var total_discount_amount = discount * total_email;
            $('.active_toggle').removeClass('active');
            $('.btn-annual-plan').addClass('active');
        }

        var billing_type = $("#billing_type").val();
        $("#plan_billing_type").val(billing_type);



        $('.plan_amount_yearly_billing').html(total_yearly_amount);
        $(".order-summary-monthly-charge").text("$" + plan_amount);
        //$(".order-summary-amount").text(order_summary_amount);
        //$(".order-summary-amount-year").text(total_amount);
        $(".order-summary-amount-year").text('');
        $(".order-summary-amount-year-discount").text(discount);
        $(".discount-amount-annual-plan").text(annual_percentage_discount);

        $('#signup-form2').hide();
        $('#signup-form3').show();

        total_amount = total_amount.toFixed(2);
        total_discount_amount = total_discount_amount.toFixed(2);
        $("#total_billing_amount").val(total_amount);

        var msg = '<img src="'+root_dir+'/img/spinner.gif" />';
        $(".order-summary-total-amount").html(msg);
        $("#selected_plan_amount").val('');
        setTimeout(function () {
            $(".order-summary-total-amount").html("<big>$"+total_amount+ " / " + summary_annual_monthly + "</big>");
            $(".selected-total-plan-amount").val(summary_annual_monthly);
            $(".order-summary-savings").text(total_discount_amount);
        }, 1000);

        total_cleaning_credit
        $(".list-cleaning-credits").html("<big>"+thousands_separators(total_cleaning_credit)+"</big>");
    }

    function thousands_separators(num){
        var num_parts = num.toString().split(".");
        num_parts[0] = num_parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        return num_parts.join(".");
    }
    $("#plans").change(function(){
        var selected = $(this);
        if(selected.val()=="")
        {
            $("#plan_info_credits").text('$00');
            $("#verify_payment_method").text('START 14-DAY FREE TRIAL');
            $("#prospect_stripe_id").val('');
            $("#selected_plan_id").val('');
            $("#search_credit").val('');
            $("#bill-today").text("You won't be billed today");
            $("#cancel-time").text('Cancel anytime before (Bill date listed on Order Summary).');
            $(".order-summary-savings-off").text('$ 0.00');
            $("#details").html(`By clicking "Start 14-day Free Trial" you agree to Automailer's Terms of Service and <a href="https://automailer.io/privacy-policy/">Privacy Policy</a>. Your credit card will be charged monthly or annually based on the plan you selected.`);
            return;
        }
        var price = selected.find(':selected').data('price');
        var credit = selected.find(':selected').data('credit');
        var stripe_id = selected.find(':selected').data('stripeid');
        var planid = selected.find(':selected').data('planid');
        $("#verify_payment_method").text('Get Started Now');
        $("#prospect_stripe_id").val(stripe_id);
        $("#selected_plan_id").val(planid);
        $("#search_credit").val(credit);
        $("#plan_info_credits").text('$'+price);
        $(".order-summary-savings-off").text('$ '+price+'.00');
        $("#bill-today").text('You will be billed immediately for your Prospect Finder Add-On package');
        $("#cancel-time").text('You may cancel your email plan anytime before (bill date listed on Order Summary)');
        $("#details").html("By clicking on Get Started Now, you agree to Automailer's terms of service and <a href='https://automailer.io/privacy-policy/'> Privacy Policy</a>. Your credit card will be charged monthly or annually based on the plan you selected.");
    });
</script>


<script type="text/javascript">
    maxmind_user_id = "<?php echo MAXMIND_USERID; ?>";
    (function() {
        var loadDeviceJs = function() {
            var element = document.createElement('script');
            element.src = 'https://device.maxmind.com/js/device.js';
            document.body.appendChild(element);
        };
        if (window.addEventListener) {
            window.addEventListener('load', loadDeviceJs, false);
        } else if (window.attachEvent) {
            window.attachEvent('onload', loadDeviceJs);
        }
    })();
</script>