<?php
checkSuperAdmin();
ini_set('display_errors', 0);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
?>

<title><?php echo SITE_NAME; ?> - Member Accounts</title>
<style>
    .form-control {
        width: 80%;
    }
</style>
</head>
<style>
    .dataTables_length, .dataTables_wrapper .dataTables_filter{
        display: block !important;
    }
</style>
<body id="page-top">
<style>
    .btn-custom{
        width: 31px;
    }
    .select2-container--default .select2-selection--single {
        border-radius: 7px !important;
    }
    .dropdown-menu{
        left: -38px;
    }
</style>
<!-- Page Wrapper -->
<div id="wrapper">

    <?php include_once("nav_wrapper_admin.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>

            <!-- Begin Page Content -->
            <div class="container-fluid">

                <!-- Page Heading -->
                <div class="float-left">
                    <h1 class="h3 mb-4 text-gray-800">Member Accounts</h1>
                </div>
                <div class="float-right" style="margin-right: 10vw;">

                </div>
                <div class="clearfix"></div>


                <div class="row">

                    <div class="col-sm-12">
                        <?php

                        if( isset($_POST['action']) && $_POST['action'] == 'add-sub-account' ){
                            $q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
                            $q->execute(array($_POST['parent_id']));
                            $main_account = $q->fetch(PDO::FETCH_ASSOC);

                            $plan = $pdo->prepare("SELECT * FROM `plans` WHERE `id`=? LIMIT 1");
                            $plan->execute(array($main_account['plan']));
                            $planData = $plan->fetch(PDO::FETCH_ASSOC);

                            $total_sub_accounts =  $planData['total_sub_accounts'] * $main_account['plan_quantity'];
                            $total_admin_sub_accounts = $planData['total_admin_sub_accounts'] * $main_account['plan_quantity'];

                            $subAccounts = $pdo->prepare('SELECT * FROM `members` WHERE `parent_id`=?');
                            $subAccounts->execute(array($_POST['parent_id']));

                            $subAccountAdmin = $pdo->prepare("SELECT * FROM `members` WHERE `parent_id`=? AND `account_type`=?");
                            $subAccountAdmin->execute(array($_POST['parent_id'], 0));
                            //Check if max sub account
                            if( $subAccounts->rowcount() < $total_sub_accounts ){
                                $valid = true;
                                if( $_POST['sub_account_type'] == 0 ){
                                    //Check if max can create admin
                                    $msg   = '';
                                    if( $subAccountAdmin->rowcount() >= $total_admin_sub_accounts ){
                                        $valid = false;
                                        $msg   = "You have reached maximum admin sub accounts you can create. Please upgrade plan to increase limit.";
                                    }
                                }

                                if( $valid ){
                                    //Check if username exists
                                    $isUsernameExists = $pdo->prepare('SELECT* FROM `members` WHERE `username`=?');
                                    $isUsernameExists->execute(array($_POST['username']));

                                    // Check if email exists for forgot password....
                                    $isEmailExists = $pdo->prepare('SELECT* FROM `members` WHERE `email`=?');
                                    $isEmailExists->execute(array($_POST['email']));

                                    if( $isUsernameExists->rowcount() <= 0 && $isEmailExists->rowcount()  <= 0){
                                        $q = $pdo->prepare('SELECT* FROM `members` WHERE `id`=? LIMIT 1');
                                        $q->execute(array($_POST['username']));



                                        $data_sub_account = array(
                                            $_POST['firstname'],
                                            $_POST['lastname'],
                                            $_POST['email'],
                                            $_POST['username'],
                                            password_hash($_POST['password'], PASSWORD_BCRYPT),
                                            $main_account['plan'],
                                            $main_account['stripe'],
                                            $main_account['timezone'],
                                            NULL,
                                            strtotime(date("Y-m-d")),
                                            1,
                                            $main_account['id'],
                                            $_POST['sub_account_type'],
                                            $main_account['plan_quantity'],
                                            $main_account['cleaning_credits'],
                                            1,
                                            $main_account['selected_state'],
                                            $main_account['selected_city'],
                                            $main_account['selected_postal_code'],
                                            $main_account['super_admin'],
                                            $main_account['cc_4digits'],
                                            $main_account['cc_month'],
                                            $main_account['cc_year'],
                                            '',
                                            time()
                                        );
                                        //Create Sub Account
                                        //$q = $pdo->prepare('INSERT INTO `members` VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)');
                                        $q = $pdo->prepare('INSERT INTO `members` (fname,lname,email,username,password,plan,stripe,timezone,id,date_created,status,parent_id,account_type,plan_quantity,cleaning_credits,is_startup,selected_state,selected_city,selected_postal_code,super_admin,cc_4digits,cc_month,cc_year,ipaddress,date_lastlogin) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
                                        $q->execute($data_sub_account);
                                        $new_member_id = $pdo->lastInsertId();

                                        if( $_POST['sub_account_type'] == 0 ){
                                            $json_roles_data = json_encode(array('all_access'));
                                            $data_roles = array(
                                                $new_member_id,
                                                'all_modules',
                                                $json_roles_data,
                                                strtotime(date("Y-m-d"))
                                            );
                                            //Create Roles
                                            $q = $pdo->prepare('INSERT INTO `user_roles` (member_id,module,action,created) VALUES (?,?,?,?)');
                                            $q->execute($data_roles);

                                        }else{
                                            foreach( $_POST['roles'] as $key => $values ){
                                                $roles = array();
                                                foreach($values as $subKey => $subValue){
                                                    $roles[] = $subKey;
                                                }

                                                $json_roles_data = json_encode($roles);
                                                $data_roles = array(
                                                    $new_member_id,
                                                    $key,
                                                    $json_roles_data,
                                                    strtotime(date("Y-m-d"))
                                                );
                                                //Create Roles
                                                $q = $pdo->prepare('INSERT INTO `user_roles` (member_id,module,action,created) VALUES (?,?,?,?)');
                                                $q->execute($data_roles);
                                            }
                                        }

                                        echo '
                      <div class="alert alert-success" role="alert">
                        User '.$_POST['firstname'].' '. $_POST['lastname'] .' sub account successfully added!
                      </div>
                      ';
                                    }else{

                                        if ($isEmailExists->rowcount() > 0 )
                                            echo '
                                 <div class="alert alert-danger" role="alert">
                                    Email Address is already used!
                                  </div>
                                                  ';
                                        else
                                            echo '
                      <div class="alert alert-danger" role="alert">
                        Username already taken!
                      </div>
                      ';
                                    }
                                }else{
                                    echo '
                      <div class="alert alert-danger" role="alert">
                        '. $msg .'
                      </div>
                      ';
                                }
                            }else{
                                echo '
                    <div class="alert alert-danger" role="alert">
                      You have reached maximum sub accounts you can create. Please upgrade plan to increase limit.
                    </div>
                    ';
                            }

                        }elseif( isset($_POST['action']) && $_POST['action'] == 'assign-email-account' ){
                            $q = $pdo->prepare('DELETE FROM `sub_account_emails` WHERE `member_id`=?');
                            $q->execute(array($_POST['member_id']));
                            foreach( $_POST['email'] as $type => $email_id ){
                                $data_assigned_email = array(
                                    $_POST['member_id'],
                                    $email_id,
                                    $type,
                                    strtotime(date("Y-m-d"))
                                );

                                $q = $pdo->prepare('INSERT INTO `sub_account_emails` (member_id,email_id,type,created) VALUES (?,?,?,?)');
                                $q->execute($data_assigned_email);
                            }

                            echo '
                <div class="alert alert-success" role="alert">
                  Record saved!
                </div>
                ';
                        }elseif( isset($_POST['action']) && $_POST['action'] == 'update-sub-account' ){

                            $valid = true;
                            $msg   = '';

                            $q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
                            $q->execute(array($_POST['editUser_id']));
                            $main_account = $q->fetch(PDO::FETCH_ASSOC);

                            if( $_POST['sub_account_type'] == 0 ){
                                //Check if max can create admin
                                $subAccountAdmin = $pdo->prepare("SELECT* FROM `members` WHERE `parent_id`=? AND `account_type`=?");
                                $subAccountAdmin->execute(array($main_account['id'], 0));
                                if( $subAccountAdmin->rowcount() >= $total_admin_sub_accounts ){
                                    $valid = false;
                                    $msg   = "You have reached maximum admin sub accounts you can create. Please upgrade plan to increase limit.";
                                }
                            }

                            if( $valid ){
                                $q = $pdo->prepare('UPDATE `members` SET `fname` =?, `lname`=?, `email`=?, `account_type`=? WHERE `id`=?');
                                $q->execute(array(
                                    $_POST['edit_firstname'],
                                    $_POST['edit_lastname'],
                                    $_POST['edit_email'],
                                    $_POST['sub_account_type'],
                                    $_POST['editUser_id']
                                ));

                                //Delete roles
                                $q = $pdo->prepare('DELETE FROM `user_roles` WHERE `member_id`=?');
                                $q->execute(array($_POST['editUser_id']));

                                if( $_POST['sub_account_type'] == 0 ){
                                    $json_roles_data = json_encode(array('all_access'));
                                    $data_roles = array(
                                        $_POST['editUser_id'],
                                        'all_modules',
                                        $json_roles_data,
                                        strtotime(date("Y-m-d"))
                                    );
                                    //Create Roles
                                    $q = $pdo->prepare('INSERT INTO `user_roles` (member_id,module,action,created) VALUES (?,?,?,?)');
                                    $q->execute($data_roles);

                                }else{
                                    foreach( $_POST['roles'] as $key => $values ){
                                        $roles = array();
                                        foreach($values as $subKey => $subValue){
                                            $roles[] = $subKey;
                                        }

                                        $json_roles_data = json_encode($roles);
                                        $data_roles = array(
                                            $_POST['editUser_id'],
                                            $key,
                                            $json_roles_data,
                                            strtotime(date("Y-m-d"))
                                        );
                                        //Create Roles
                                        $q = $pdo->prepare('INSERT INTO `user_roles` (member_id,module,action,created) VALUES (?,?,?,?)');
                                        $q->execute($data_roles);
                                    }
                                }

                                echo '
                  <div class="alert alert-success" role="alert">
                    User '.$_POST['edit_firstname'].' '. $_POST['edit_lastname'] .' account has been successfully updated!
                  </div>
                  ';
                            }else{
                                echo '
                    <div class="alert alert-danger" role="alert">
                      '. $msg .'
                    </div>
                    ';
                            }

                        }elseif( isset($_POST['action']) && $_POST['action'] == 'add-smtp' ){
                            //Default Settings
                            $limit_per_day = 25;
                            $allowed_time_from = strtotime("7:00 AM");
                            $allowed_time_to   = strtotime("5:00 PM");
                            $time_between_email_sent = 20;
                            $max_email_per_time      = 1;

                            if(isset($_POST['usessltls'])){
                                $usessltls = 1;
                            }else{
                                $usessltls = 0;
                            }

                            $passwordD = crypt_jm($_POST['password']);
                            $q = $pdo->prepare('INSERT INTO `smtp` (from_name,
                                                          from_email,
                                                          user,
                                                          password,
                                                          server,
                                                          port,
                                                          send_limit,
                                                          member_id,
                                                          digital_sign,
                                                          sending_limit_per_day,
                                                          allowed_time_send_from,
                                                          allowed_time_send_to,
                                                          time_between_email_send,
                                                          max_email_per_time,
                                                          active,
                                                          usessltls) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
                            $q->execute(
                                array(
                                    $_POST['from_name'],
                                    $_POST['from_email'],
                                    $_POST['user'],
                                    $passwordD,
                                    $_POST['server'],
                                    $_POST['port'],
                                    200,
                                    $_POST['mid'],
                                    NULL,
                                    $limit_per_day,
                                    $allowed_time_from,
                                    $allowed_time_to,
                                    $time_between_email_sent,
                                    $max_email_per_time,
                                    1,
                                    $usessltls
                                )
                            );

                            $smtpID =  $pdo->lastInsertId();

                            $passwordD = crypt_jm($_POST['password']);
                            $q = $pdo->prepare('INSERT INTO `imap` (user,password,server,port,member_id,is_ssl,active,smtp_id) VALUES (?,?,?,?,?,?,?,?)');
                            $q->execute(
                                array(
                                    $_POST['user'],
                                    $passwordD,
                                    $_POST['imap_server'],
                                    $_POST['imap_port'],
                                    $_POST['mid'],
                                    $usessltls,
                                    1,
                                    $smtpID
                                )
                            );

                            echo '
                  <div class="alert alert-success" role="alert">
                    SMTP account successfully added!
                  </div>
                  ';
                        }


                        if(isset($_POST['edit_email_id']))
                        {
                            if(isset($_POST['edit_usessltls'])){
                                $usessltls = 1;
                            }else{
                                $usessltls = 0;
                            }


                            $passwordD = crypt_jm($_POST['edit_password']);
                            $q = $pdo->prepare('UPDATE `smtp` SET `from_name`=?, `from_email`=?, `user`=?, `password`=?, `server`=?, `port`=?, `usessltls`=?, active = 1 WHERE `id`=? LIMIT 1');
                            $smtp_data = array(
                                $_POST['edit_from_name'],
                                $_POST['edit_from_email'],
                                $_POST['edit_user'],
                                $passwordD,
                                $_POST['edit_server'],
                                $_POST['edit_port'],
                                $usessltls,
                                $_POST['edit_email_id']
                            );
                            $sql =  $q->execute($smtp_data);

                            if(isset($_POST['edit_imap_server'])){
                                $q = $pdo->prepare('UPDATE `imap` SET `server`=?, `port`=?, `active` = 1, `is_ssl`=? WHERE `smtp_id`=? AND `member_id`=? ');
                                $smtp_imap_data = array(
                                    $_POST['edit_imap_server'],
                                    $_POST['edit_imap_port'],
                                    $usessltls,
                                    $_POST['edit_email_id'],
                                    $_POST['edit_member_id']
                                );
                                $sql =  $q->execute($smtp_imap_data);
                            }

                            echo '
                <div class="alert alert-success" role="alert">
                  SMTP account successfully updated!
                </div>
                ';
                        }

                        if(isset($_POST['deactivateMemberPass_id']))
                        {
                            //pause running campaign
                            $q = $pdo->prepare('UPDATE `campaigns` SET `status`=? WHERE `member_id`=?');
                            $q->execute(array(CAMPAIGN_STATUS_PAUSED, $_POST['deactivateMemberPass_id']));

                            //stop if they created sub account and its running any campaign
                            $sub_members = $pdo->prepare('SELECT m.id, m.fname, m.lname, m.timezone, m.parent_id, m.stripe FROM (`members` as m) WHERE m.status = 1 AND parent_id = ?');
                            $sub_members->execute($_POST['deactivateMemberPass_id']);

                            foreach ($sub_members as $sub_member){
                                $q = $pdo->prepare('UPDATE `campaigns` SET `status`=? WHERE `member_id`=?');
                                $q->execute(array(CAMPAIGN_STATUS_PAUSED, $sub_member['id']));
                            }
                            //end

                            $q = $pdo->prepare('UPDATE `members` SET `status`=? WHERE `id`=? LIMIT 1');
                            $q->execute(array(2, $_POST['deactivateMemberPass_id']));


                            echo '
                <div class="alert alert-danger" role="alert">
                  User account successfully deactivated!
                </div>
                ';
                        }

                        if(isset($_POST['activateMemberPass_id']))
                        {
                            $q = $pdo->prepare('UPDATE `members` SET `status`=? WHERE `id`=? LIMIT 1');
                            $q->execute(array(1, $_POST['activateMemberPass_id']));


                            echo '
                <div class="alert alert-success" role="alert">
                  User account successfully activated!
                </div>
                ';
                        }

                        if(isset($_POST['deleteMemberPass_id']))
                        {

                            //pause running campaign
                            $q = $pdo->prepare('UPDATE `campaigns` SET `status`=? WHERE `member_id`=?');
                            $q->execute(array(CAMPAIGN_STATUS_PAUSED, $_POST['deleteMemberPass_id']));

                            //stop if they created sub account and its running any campaign
                            $sub_members = $pdo->prepare('SELECT m.id, m.fname, m.lname, m.timezone, m.parent_id, m.stripe FROM (`members` as m) WHERE m.status = 1 AND parent_id = ?');
                            $sub_members->execute($_POST['deleteMemberPass_id']);

                            foreach ($sub_members as $sub_member){
                                $q = $pdo->prepare('UPDATE `campaigns` SET `status`=? WHERE `member_id`=?');
                                $q->execute(array(CAMPAIGN_STATUS_PAUSED, $sub_member['id']));
                            }
                            //end

                            $q = $pdo->prepare('DELETE FROM `members` WHERE `id`=? LIMIT 1');
                            $q->execute(array($_POST['deleteMemberPass_id']));
                            echo '
                <div class="alert alert-danger" role="alert">
                  User account successfully deleted!
                </div>
                ';
                        }

                        if(!empty($_POST['rpassword']))
                        {
                            if($_POST['password'] == $_POST['rpassword'])
                            {
                                $q = $pdo->prepare('UPDATE `members` SET `password`=? WHERE `id`=?');
                                $q->execute(array(password_hash($_POST['password'], PASSWORD_BCRYPT), $_POST['editMemberPass_id']));
                                echo '<div class="alert alert-success">
                   Password successfully updated.
                  </div>';
                            }
                            else
                            {
                                echo '<div class="alert alert-warning">
                   Error: Invalid password details.
                  </div>';
                            }
                        }

                        if(isset($_POST['editMember']))
                        {
                            $q = $pdo->prepare('UPDATE `members` SET `fname`=?, `lname`=?, `email`=?, `plan`=?, `status`=?, `timezone`=? WHERE `id`=?');
                            $save =  $q->execute(array(
                                $_POST['edit_firstname'],
                                $_POST['edit_lastname'],
                                $_POST['edit_email'],
                                $_POST['edit_plan'],
                                $_POST['edit_status'],
                                $_POST['edit_timezone'],
                                $_POST['editMember']
                            ));
                            echo '
                <div class="alert alert-success" role="alert">
                  User '.$_POST['edit_firstname'].' '. $_POST['edit_lastname'] .' account has been successfully updated!
                </div>
                ';
                        }

                        if(isset($_POST['action']) && $_POST['action'] == 'add-main-account')
                        {
                            $q = $pdo->prepare('SELECT * FROM `members` WHERE `username`=?');
                            $q->execute(array($_POST['username']));

                            // Check if email exists for forgot password....
                            $isEmailExists = $pdo->prepare('SELECT * FROM `members` WHERE `email`=?');
                            $isEmailExists->execute(array($_POST['email']));


                            if( $q->rowCount() > 0 ||  $isEmailExists->rowCount() > 0)
                            {


                                if ($isEmailExists->rowCount() > 0)
                                    echo '
                  <div class="alert alert-danger" role="alert">
                    Email address is already taken!
                  </div>
                  ';

                                if ($q->rowCount() > 0)
                                    echo '
                  <div class="alert alert-danger" role="alert">
                    Username already taken!
                  </div>
                  ';


                            }else{
                                $q = $pdo->prepare('INSERT INTO `members` (fname,lname,email,username,password,plan,stripe,timezone,date_created,status) VALUES (?,?,?,?,?,?,?,?,?,?)');
                                $q->execute(array(
                                    $_POST['firstname'],
                                    $_POST['lastname'],
                                    $_POST['email'],
                                    $_POST['username'],
                                    password_hash($_POST['password'], PASSWORD_BCRYPT),
                                    $_POST['plan'],
                                    0,
                                    $_POST['timezone'],
                                    strtotime(date("Y-m-d")),
                                    1
                                ));

                                echo '
                  <div class="alert alert-success" role="alert">
                    User '.$_POST['firstname'].' '. $_POST['lastname'] .' account successfully added!
                  </div>
                  ';
                            }

                        }

                        $parentAccount = $pdo->prepare('SELECT `id`,`fname`,`lname` FROM `members` WHERE `parent_id`=0');
                        $parentAccount->execute();
                        ?>

                        <div class="card shadow mb-4">
                            <div class="card-header bg-dark py-3">
                                <div class="float-left">
                                    <h6 class="m-0 font-weight-bold text-white">Member Management</h6>
                                </div>
                                <div class="float-right">

                                </div>
                                <div class="clearfix"></div>
                            </div>
                            <div class="card-body">
                                Add Member (This will manage the members account).<br/>
                                <button class="btn btn-primary" style="margin-top: 15px;" data-toggle="modal" data-target="#addIMAP">Add Main Account</button>
                                <button class="btn btn-primary" style="margin-top: 15px;" data-toggle="modal" data-target="#addSubAccount">Add Sub Account</button>
                                <?php
                                $q = $pdo->prepare('SELECT * FROM `members` ORDER BY id DESC');
                                $q->execute();
                                if($q->rowcount()>0)
                                {
                                ?>
                                <br/><br/>
                                <?php 
                                    require_once('Hashid/vendor/autoload.php');
                                 ?>

                                <table class="table admin-members-datatable datatable">
                                    <thead class="bg-default text-dark">
                                    <tr>
                                        <th scope="col">FIRST NAME</th>
                                        <th scope="col">LAST NAME</th>
                                        <th scope="col">EMAIL</th>
                                        <th scope="col">USERNAME</th>
                                        <th scope="col">PLAN</th>
                                        <th scope="col">TIMEZONE</th>
                                        <th scope="col">ACCOUNT TYPE</th>
                                        <th scope="col">ACTION</th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </div>

                        <!--  Modal for deactivate member -->
                        <div class="modal fade" id="deactivateMember" tabindex="-1" role="dialog" aria-labelledby="deactiavateMemberLabel" aria-hidden="true">
                            <div class="modal-dialog modal-md" role="document">
                                <div class="modal-content">
                                    <form action="" method="post">
                                        <input type="hidden" name="deactivateMemberPass_id" id="deactivate-member-id" class="form-control" value="">
                                        <div class="modal-body">
                                            <h4 class="modal-heading"><i class="fa fa-info"></i> Deactivate Member<br><small style="font-size: 13px;margin-left: 26px;"></small></h4>
                                            <div class="row">
                                                    <div class="col-md-12">
                                                        <label style="display: block; margin-top: 10px;" class="daeactivate-member-label"></label>
                                                    </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary">Confirm</button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!--  Modal for activate member -->
                        <div class="modal fade" id="activateMember" tabindex="-1" role="dialog" aria-labelledby="addIMAPLabel" aria-hidden="true">
                            <div class="modal-dialog modal-md" role="document">
                                <div class="modal-content">
                                    <form action="" method="post">
                                        <input type="hidden" name="activateMemberPass_id" id="activate-member-id" class="form-control" value="">
                                        <div class="modal-body">
                                            <h4 class="modal-heading"><i class="fa fa-info"></i> Activate Member<br><small style="font-size: 13px;margin-left: 26px;"></small></h4>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <label style="display: block; margin-top: 10px;" class="activate-member-label"></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary">Confirm</button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- Modal Delete Confirmation -->
                        <div class="modal fade modal-enhanced modal-danger" id="deleteMember" tabindex="-1" role="dialog" aria-labelledby="modalDeleteConfirmationlabel" aria-hidden="true">
                            <div class="modal-dialog modal-md" role="document">
                                <form action="#" method="post">
                                    <input type="hidden" name="deleteMemberPass_id" class="form-control" id="delete-member-id" value="">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title"><i class="far fa-trash-alt"></i> Delete Member</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <label style="display: block; margin-top: 10px;" class="delete-member-label"></label>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                                                <button type="submit" class="btn btn-danger" name="action" value="help_delete">Yes</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <!--  Modal for changepassword -->
                        <div class="modal fade" id="viewMemberOtherDetails" tabindex="-1" role="dialog" aria-labelledby="addIMAPLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <form action="" method="post">
                                        <input type="hidden" name="editMemberPass_id" class="form-control" value="<?php echo $row['id']; ?>">
                                        <div class="modal-body">
                                            <h4 class="modal-heading"><i class="fas fa-search"></i> Member Other Details<small style="font-size: 13px;margin-left: 26px;"></small></h4>
                                            <div class="modal-member-other-details-body"></div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- Modal for edit subaccount -->
                        <div class="modal fade" id="editSubAccount" tabindex="-1" role="dialog" aria-labelledby="editSubAccountLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <form action="" method="post">
                                        <input type="hidden" name="editUser_id" id="edit-sub-account-id" value="">
                                        <div class="modal-body edit-sub-account-body">
                                            <h4 class="modal-heading"><i class="fa fa-pen"></i> Edit Sub Account <br><small style="font-size: 13px;margin-left: 26px;">Edit your sub account details.</small></h4>
                                            <div class="edit-sub-account-form"></div>
                                            <div class="modal-footer">
                                                <button type="submit" class="btn btn-success" name="action" value="update-sub-account">Save</button>
                                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- Modal Edit Main Account -->
                        <div class="modal fade" id="editMember" tabindex="-1" role="dialog" aria-labelledby="addIMAPLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <form action="" method="post">
                                        <input type="hidden" name="editMember" id="edit-main-account-id" class="form-control" value="">
                                        <div class="modal-body">
                                            <h4 class="modal-heading"><i class="fa fa-pen"></i> Edit Main Account<br><small style="font-size: 13px;margin-left: 26px;">Edit your member account details.</small></h4>
                                            <div class="edit-main-account-form"></div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary">Save</button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!--  Modal for changepassword -->
                        <div class="modal fade" id="editMemberPass" tabindex="-1" role="dialog" aria-labelledby="editMemberPassLabel" aria-hidden="true">
                            <div class="modal-dialog modal-md" role="document">
                                <div class="modal-content">
                                    <form action="" method="post">
                                        <input type="hidden" name="editMemberPass_id" id="member-change-pass-id" class="form-control" value="">
                                        <div class="modal-body">
                                            <h4 class="modal-heading"><i class="fas fa-user-lock"></i> Change Password<br><small style="font-size: 13px;margin-left: 36px;">Update your member password account.</small></h4>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <label style="display: block; margin-top: 10px;">Password: *</label>
                                                    <input type="password" name="password" class="form-control" required="" style="width: 100%;">
                                                </div>
                                                <div class="col-md-12">
                                                    <label style="display: block; margin-top: 10px;">Repeat Password: *</label>
                                                    <input type="password" name="rpassword" class="form-control" required="" style="width: 100%;">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary">Save</button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!--  Modal for view member details  -->
                        <div class="modal fade" id="viewMemberDetails" tabindex="-1" role="dialog" aria-labelledby="addIMAPLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <form action="" method="post">
                                        <input type="hidden" name="activateMemberPass_id" class="form-control" id="view-member-details-id" value="">
                                        <div class="modal-body">
                                            <h4 class="modal-heading"><i class="fas fa-search"></i> Member details<br><small style="font-size: 13px;margin-left: 26px;">View your member account details.</small></h4>
                                            <div class="view-member-details-form"></div>                                            
                                        </div>
                                        <div class="modal-footer">

                                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- Modal Add SMTP -->
                        <div class="modal fade" id="addSmtp" tabindex="-1" role="dialog" aria-labelledby="addSmtpLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <div class="form">
                                            <form action="" method="post" id="frm-add-smtp">
                                                <input type="hidden" name="mid" id="mid" value="">
                                                <input type="hidden" name="action" value="add-smtp">
                                                <h4 class="modal-heading"><i class="fas fa-envelope"></i> SMTP Settings (sending emails)</h4>
                                                <div style="margin-bottom:30px;" class="modal-add-smtp-msg"></div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <input type="text" name="from_name" required="" placeholder="Sender Name" class="form-control">
                                                            <label data-toggle="tooltip" title="Name that will show on the sender name">From Name: *</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <input type="text" name="from_email" required="" placeholder="sender@domain.com" class="form-control">
                                                            <label data-toggle="tooltip" title="Email that will show on the sender" >From Email: *</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <input type="text" name="user" required="" placeholder="youremail@domain.com" class="form-control verify-mx-record-smtp">
                                                            <label data-toggle="tooltip" title="SMTP email that the system will use for sending email" >User (usually your email): *</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <input type="password" name="password" required="" placeholder="Password" class="form-control">
                                                            <label data-toggle="tooltip" title="Your SMTP email password" >Password: *</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <input type="text" name="server" id="server" required="" placeholder="mail.sampledomain.com" class="form-control">
                                                            <label data-toggle="tooltip" title="SMTP server details can be found on you hosting email setting" >SMTP Server: *</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <input type="text" name="port" required="" placeholder="587" value="587" class="form-control">
                                                            <label data-toggle="tooltip" title="SMTP server port can be found on email settings on the cpanel" >SMTP Port *:</label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <h4 style="margin-bottom:20px;">IMAP Settings (receiving emails)</h4>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <input type="text" name="imap_server" id="imap_server" required="" placeholder="mail.sampledomain.com" class="form-control">
                                                            <label  data-toggle="tooltip" title="IMAP server details can be found on you hosting email setting" >IMAP Server: *</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <input type="text" name="imap_port" required="" placeholder="993" value="993" class="form-control">
                                                            <label data-toggle="tooltip" title="IMAP server port can be found on email settings on the cpanel">IMAP Port *:</label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="custom-control custom-checkbox">
                                                            <input type="checkbox" class="custom-control-input" id="usessltls" name="usessltls" value="1" checked="checked">
                                                            <label class="custom-control-label" for="usessltls">Use SSL/TLS</label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button style="margin-left: 20px;" type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                    <button type="submit" class="btn btn-success btn-save-smtp">Save Changes</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <!-- Modal Add Main Account -->
                        <div class="modal fade" id="addIMAP" tabindex="-1" role="dialog" aria-labelledby="addIMAPLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <form action="" method="post">
                                        <div class="modal-body">
                                            <h4 class="modal-heading"><i class="fa fa-plus"></i> Add Main Account<br><small style="font-size: 13px;margin-left: 26px;">Add main user account.</small></h4>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <br />
                                                    <span style="font-size:20px;font-weight: 800;margin-top: 10px;" data-toggle="tooltip" title="User account details" >User Details</span>
                                                </div>
                                                <div class="col-md-6">
                                                    <label style="display: block; margin-top: 10px;">First Name: *</label>
                                                    <input type="text" name="firstname" class="form-control">
                                                </div>
                                                <div class="col-md-6">
                                                    <label style="display: block; margin-top: 10px;">Last Name: *</label>
                                                    <input type="text" name="lastname" class="form-control">
                                                </div>
                                                <div class="col-md-6">
                                                    <label style="display: block; margin-top: 10px;">Email: *</label>
                                                    <input type="text" name="email" class="form-control">
                                                </div>
                                                <div class="col-md-6">
                                                    <label style="display: block; margin-top: 10px;">Plan: *</label>
                                                    <select name="plan" id="plan" class="form-control">
                                                        <option value="1">Professional - $29/month </option>
                                                        <option value="2">Business - $69/month</option>
                                                        <option value="3">Enterprise - $109/month</option>
                                                    </select>
                                                </div>

                                                <div class="col-md-12">
                                                    <?php
                                                    $timezones = $pdo->prepare('SELECT * FROM `timezones`');
                                                    $timezones->execute();
                                                    ?>
                                                    <label style="display: block; margin-top: 10px;">Timezone: *</label>
                                                    <select class="form form-control timezone-list" name="timezone" required="" style="width: 50%;">
                                                        <option value="">-- Select timezone --</option>
                                                        <?php foreach($timezones as $value){ ?>
                                                            <option value="<?php echo $value['timezone']; ?>"><?php echo $value['utc_gmt'] . " - " . $value['timezone']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>

                                                <div class="col-md-12">
                                                    <br />
                                                    <span style="font-size:20px;font-weight: 800;margin-top: 10px;" data-toggle="tooltip" title="Login account info" >Login account</span>
                                                </div>
                                                <div class="col-md-6">
                                                    <label style="display: block; margin-top: 10px;">Username: *</label>
                                                    <input type="text" name="username" class="form-control">
                                                </div>
                                                <div class="col-md-6">
                                                    <label style="display: block; margin-top: 10px;">Password: *</label>
                                                    <input type="password" name="password" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary" value="add-main-account" name="action">Save</button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="modal fade" id="modal-assign-email-accounts" tabindex="-1" role="dialog" aria-labelledby="assignEmailAccountsLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg" role="document" style="margin-top: 10vw;">
                                <div class="modal-content">
                                    <form action="" method="post">
                                        <div class="modal-body ">
                                            <h4 class="modal-heading"><i class="fas fa-envelope-open"></i> Assign Email Accounts</h4>
                                            <div class="assign-account-container"></div>
                                            <div class="modal-footer">
                                                <button type="submit" class="btn btn-success" name="action" value="assign-email-account">Save</button>
                                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="modal fade" id="addSubAccount" tabindex="-1" role="dialog" aria-labelledby="addSubAccountLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <form action="" method="post">
                                        <div class="modal-body">
                                            <h4 class="modal-heading"><i class="fa fa-plus"></i> Add Sub Account<br /><small style="font-size: 13px;margin-left: 26px;">Add sub account that will manage parent account data.</small> </h4>

                                            <div class="row" style="margin-bottom:20px;">
                                                <div class="col-md-12">
                                                    <label style="display: block; margin-top: 10px;">Main Account</label>
                                                    <select class="form form-control default-select-list" name="parent_id" required="" style="width: 50%;">
                                                        <option value="">-- Select parent account --</option>
                                                        <?php foreach($parentAccount as $value){ ?>
                                                            <option value="<?php echo $value['id']; ?>"><?php echo $value['fname'] . " " . $value['lname']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <hr /><br />
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <input type="text" name="firstname" class="form-control">
                                                        <label>First Name:*</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <input type="text" name="lastname" class="form-control">
                                                        <label>Last Name:*</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <input type="text" name="email" class="form-control">
                                                        <label>Email:*</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <h4 style="margin-bottom:20px;">Login account</h4>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <input type="text" name="username" class="form-control">
                                                        <label>Username:*</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <input type="password" name="password" class="form-control">
                                                        <label>Password:*</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <h4 style="margin-bottom:20px;">Roles</h4>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <select class="form-control sub-account-type" name="sub_account_type">
                                                            <option value="1">User</option>
                                                            <option value="0">Admin</option>
                                                        </select>
                                                        <label>Sub Account Type:*</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="user-roles">
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <h3>LIST</h3>
                                                        <ul class="roles-list">
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addlistView<?= $row['id']; ?>" name="roles[list][view]">
                                                                    <label class="custom-control-label" for="addlistView<?= $row['id']; ?>">Can View</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addlistAdd<?= $row['id']; ?>" name="roles[list][add]">
                                                                    <label class="custom-control-label" for="addlistAdd<?= $row['id']; ?>">Can Add</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addlistEdit<?= $row['id']; ?>" name="roles[list][edit]">
                                                                    <label class="custom-control-label" for="addlistEdit<?= $row['id']; ?>">Can Edit</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addlistDelete<?= $row['id']; ?>" name="roles[list][delete]">
                                                                    <label class="custom-control-label" for="addlistDelete<?= $row['id']; ?>">Can Delete</label>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </div>

                                                    <div class="col-md-4">
                                                        <h3>TEMPLATE</h3>
                                                        <ul class="roles-list">
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addtemplateView<?= $row['id']; ?>" name="roles[template][view]">
                                                                    <label class="custom-control-label" for="addtemplateView<?= $row['id']; ?>">Can View</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addtemplateAdd<?= $row['id']; ?>" name="roles[template][add]">
                                                                    <label class="custom-control-label" for="addtemplateAdd<?= $row['id']; ?>">Can Add</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addtemplateEdit<?= $row['id']; ?>" name="roles[template][edit]">
                                                                    <label class="custom-control-label" for="addtemplateEdit<?= $row['id']; ?>">Can Edit</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addtemplateDelete<?= $row['id']; ?>" name="roles[template][delete]">
                                                                    <label class="custom-control-label" for="addtemplateDelete<?= $row['id']; ?>">Can Delete</label>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </div>

                                                    <div class="col-md-4">
                                                        <h3>CAMPAIGN</h3>
                                                        <ul class="roles-list">
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addcampaignView<?= $row['id']; ?>" name="roles[campaign][view]">
                                                                    <label class="custom-control-label" for="addcampaignView<?= $row['id']; ?>">Can View</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addcampaignStart<?= $row['id']; ?>" name="roles[campaign][start]">
                                                                    <label class="custom-control-label" for="addcampaignStart<?= $row['id']; ?>">Can Start Campaign</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addcampaignEdit<?= $row['id']; ?>" name="roles[campaign][edit]">
                                                                    <label class="custom-control-label" for="addcampaignEdit<?= $row['id']; ?>">Can Edit Existing Campaign</label>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </div>

                                                    <div class="col-md-4">
                                                        <h3>LEADS</h3>
                                                        <ul class="roles-list">
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addleadsView<?= $row['id']; ?>" name="roles[leads][view]">
                                                                    <label class="custom-control-label" for="addleadsView<?= $row['id']; ?>">Can View</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addleadsChangeStatus<?= $row['id']; ?>" name="roles[leads][change_status]">
                                                                    <label class="custom-control-label" for="addleadsChangeStatus<?= $row['id']; ?>">Can Change status</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addleadsReply<?= $row['id']; ?>" name="roles[leads][reply]">
                                                                    <label class="custom-control-label" for="addleadsReply<?= $row['id']; ?>">Can Reply</label>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </div>

                                                    <div class="col-md-4">
                                                        <h3>SETTINGS</h3>
                                                        <ul class="roles-list settings-role">
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addsettingsUpdateName" name="roles[settings][update_name]">
                                                                    <label class="custom-control-label" for="addsettingsUpdateName">Can Update Name</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addsettingsChangePassword" name="roles[settings][update_password]">
                                                                    <label class="custom-control-label" for="addsettingsChangePassword">Can Update Password</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addsettingsChangeSignature<?= $row['id']; ?>" name="roles[settings][update_signature]">
                                                                    <label class="custom-control-label" for="addsettingsChangeSignature<?= $row['id']; ?>">Can Update Signature</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addsettingsUpdateTimezoe<?= $row['id']; ?>" name="roles[settings][update_timezone]">
                                                                    <label class="custom-control-label" for="addsettingsUpdateTimezoe<?= $row['id']; ?>">Can Update Timezone</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addsettingsChangeSendingSpeed<?= $row['id']; ?>" name="roles[settings][change_sending_speed]">
                                                                    <label class="custom-control-label" for="addsettingsChangeSendingSpeed<?= $row['id']; ?>">Can Change Sending Speed</label>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </div>

                                                    <div class="col-md-4">
                                                        <h3>EXCLUSIONS</h3>
                                                        <ul class="roles-list">
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addexclusionsView<?= $row['id']; ?>" name="roles[exclusions][view]">
                                                                    <label class="custom-control-label" for="addexclusionsView<?= $row['id']; ?>">Can View</label>
                                                                </div>
                                                            </li>
                                                            <li>
                                                                <div class="custom-control custom-checkbox">
                                                                    <input type="checkbox" class="custom-control-input" id="addexclusionsManage<?= $row['id']; ?>" name="roles[settings][manage]">
                                                                    <label class="custom-control-label" for="addexclusionsManage<?= $row['id']; ?>">Can Manage Exclusions</label>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                <button type="submit" class="btn btn-success" value="add-sub-account" name="action">Save</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    <?php
                    }
                    ?>

                    </div>

                </div>

            </div>
            <!-- /.container-fluid -->

        </div>
        <!-- End of Main Content -->

        <script>
            $(function(){

                $(document).on('click', '.action-deactivate-member', function(){
                    var mid = $(this).attr('data-id');
                    var mname = $(this).attr('data-name');
                    $("#deactivateMember").modal('show');
                    $("#deactivate-member-id").val(mid);

                    $(".daeactivate-member-label").html("Are you sure you want to deactivate member? <br /> <b>"+mname+"</b>");
                });

                $(document).on('click', '.action-activate-member', function(){
                    var mid = $(this).attr('data-id');
                    var mname = $(this).attr('data-name');
                    $("#activateMember").modal('show');
                    $("#activate-member-id").val(mid);

                    $(".activate-member-label").html("Are you sure you want to activate member? <br /> <b>"+mname+"</b>");
                });

                $(document).on('click', '.action-delete-member', function(){
                    var mid = $(this).attr('data-id');
                    var mname = $(this).attr('data-name');
                    $("#deleteMember").modal('show');
                    $("#delete-member-id").val(mid);

                    $(".delete-member-label").html("Are you sure you want to delete member? <br /> <b>"+mname+"</b>");
                });

                $(document).on('click', '.action-assign-emails-accounts', function(){
                    var member_id = $(this).attr("data-id");
                    var data_type = $(this).attr("data-type");
                    var url = root_dir + "/ajax_load_sub_account_assign_email.php";
                    var msg = '<div class="alert alert-info" role="alert"><img src="'+root_dir+'/img/spinner.gif" /></div>';

                    $("#modal-assign-email-accounts").modal("show");
                    $(".assign-account-container").html(msg);

                    setTimeout(function () {
                        $.ajax({
                            type: "POST",
                            url: url,
                            data: {"member_id":member_id,"data_type":data_type},
                            success: function(o)
                            {
                                $(".assign-account-container").html(o);
                            }
                        });
                    }, 10);
                });

                $(document).on('click', '.action-add-smtp', function(){
                    var mid = $(this).attr("data-id");
                    $("#mid").val(mid);
                    $("#addSmtp").modal("show");
                });

                $(document).on('click', '.action-change-member-password', function(){
                    var member_id = $(this).attr("data-id");
                    $("#member-change-pass-id").val(member_id);
                    $("#editMemberPass").modal("show");
                });

                $(document).on('click', '.action-view-other-details', function(){
                    var member_id = $(this).attr("data-id");
                    var url = root_dir + "/ajax_get_member_other_details.php";
                    var msg = '<div class="alert alert-info" role="alert"><img src="'+root_dir+'/img/spinner.gif" /></div>';

                    $("#viewMemberOtherDetails").modal("show");
                    $(".modal-member-other-details-body").html(msg);

                    setTimeout(function () {
                        $.ajax({
                            type: "POST",
                            url: url,
                            data: {member_id:member_id},
                            success: function(o)
                            {
                                $(".modal-member-other-details-body").html(o);
                            }
                        });
                    }, 10);
                });

                $(document).on('click', '.action-view-member-details', function(){
                    var mid = $(this).attr('data-id');
                    var url = root_dir + "/_admin_view_member_details";

                    $("#viewMemberDetails").modal('show');
                    $("#view-member-details-id").val(mid);

                    var msg = '<div class="alert alert-info" role="alert"><img src="'+root_dir+'/img/spinner.gif" /></div>';
                    $(".view-member-details-form").html(msg);

                    setTimeout(function () {
                      $.ajax({
                         type: "POST",
                         url: url,      
                         data: {mid:mid},
                         success: function(o)
                         {
                            $(".view-member-details-form").html(o); 
                         },
                         complete: function() {
                           
                        }
                      });
                    }, 1000);
                });

                $(document).on('click', '.action-edit-subaccount', function(){
                    var mid = $(this).attr('data-id');
                    var url = root_dir + "/_admin_edit_sub_account_form";

                    $("#editSubAccount").modal('show');
                    $("#edit-sub-account-id").val(mid);

                    var msg = '<div class="alert alert-info" role="alert"><img src="'+root_dir+'/img/spinner.gif" /></div>';
                    $(".edit-sub-account-form").html(msg);

                    setTimeout(function () {
                      $.ajax({
                         type: "POST",
                         url: url,      
                         data: {mid:mid},
                         success: function(o)
                         {
                            $(".edit-sub-account-form").html(o); 
                         },
                         complete: function() {
                           
                        }
                      });
                    }, 1000);
                });

                $(document).on('click', '.action-edit-member', function(){
                    var mid = $(this).attr('data-id');
                    var url = root_dir + "/_admin_edit_main_account_form";

                    $("#editMember").modal('show');
                    $("#edit-main-account-id").val(mid);
                    
                    var msg = '<div class="alert alert-info" role="alert"><img src="'+root_dir+'/img/spinner.gif" /></div>';
                    $(".edit-main-account-form").html(msg);

                    setTimeout(function () {
                      $.ajax({
                         type: "POST",
                         url: url,      
                         data: {mid:mid},
                         success: function(o)
                         {
                            $(".edit-main-account-form").html(o); 
                         },
                         complete: function() {
                           
                        }
                      });
                    }, 1000);

                });
            });
        </script>

        <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Copyright &copy; <?php echo date('Y'); ?></span>
                </div>
            </div>
        </footer>
        <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>