<?php 

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PhpImap\Mailbox;
use PhpImap\Exceptions\ConnectionException;
require_once dirname(__FILE__) . '/../config.php';
require_once dirname(__FILE__) . '/../functions.php';
require_once dirname(__FILE__) . '/../PHPMailer/autoload.php';
require_once dirname(__FILE__) . '/../Google/autoload.php';
require_once dirname(__FILE__) . '/../swiftmailer/autoload.php';
require_once dirname(__FILE__) . '/../PHPMailer/autoload.php';
require_once dirname(__FILE__) . '/../php-imap/autoload.php';

class CronHelper
{
	//Set Gmail Mailer
	public static function cronGmailMailer($gmail,$email,$campaign,$contact,$identifier,$mail_footer,$googleSecretId,$googleClientId){
		$client = new Google_Client();
		$client->setClientId($googleClientId);
		$client->setClientSecret($googleSecretId);
		$client->setAccessToken($gmail['access_token']);
		$client->refreshToken($gmail['refresh_token']);
		$accessToken = $client->getAccessToken();
		$service = new \Google_Service_Gmail($client);
		$mailer = $service->users_messages;

		if(!empty($campaign['bcc']))
		{
			$message = (new \Swift_Message($email['subject']))
			    ->setFrom($gmail['email'], $gmail['firstName'])
			    ->setTo([$contact['email']])
			    ->setBcc([$campaign['bcc']])
			    ->setContentType('text/html')
			    ->setCharset('utf-8')
			    ->setBody($email['body'].$mail_footer.' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier.'"/>');
		}
		else
		{
			$message = (new \Swift_Message($email['subject']))
			    ->setFrom($gmail['email'], $gmail['firstName'])
			    ->setTo([$contact['email']])
			    ->setContentType('text/html')
			    ->setCharset('utf-8')
			    ->setBody($email['body'].$mail_footer.' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier.'"/>');
		}

		$encoded = base64url_encode($message->toString());

		$message = new \Google_Service_Gmail_Message();
		$message->setRaw($encoded);
		$message = $mailer->send('me', $message);
	}	

	//Set SMTP Mailer
	public static function cronSmtpMailer($smtp,$email,$campaign,$contact,$identifier,$mail_footer){

	    if(!empty($smtp['nylas_account_id'])){


//            $message = $email['body'];
//            $message = $message . $mail_footer . " <img src='" . AUTOMAILER_TRACKER_URL . "/_track.php?id=" . $identifier . "' alt='' />";
//            $message = htmlentities($message);
            $message = "send messsage from nylas";

            $subject = $email['subject'];
            $from_name = $smtp['from_name'];
            $email = $smtp['from_email'];
            $nylas_access_token = $smtp['nylas_access_token'];
            $password = '';

            $curl = curl_init();

            if (!empty($campaign['bcc'])) {
                $bcc = $campaign['bcc'];

                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://api.nylas.com/send",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => "{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n    \"bcc\": \"$bcc\",\n    \"to\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$email\"\n        }\n    ]\n}",
                    CURLOPT_HTTPHEADER => array(
                        "Content-Type: application/json",
                        "Authorization: Bearer ". $nylas_access_token
                    ),
                ));
            }else {

                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://api.nylas.com/send",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => "{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n    \"to\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$email\"\n        }\n    ]\n}",
                    CURLOPT_HTTPHEADER => array(
                        "Content-Type: application/json",
                        "Authorization: Bearer ". $nylas_access_token
                    ),
                ));

            }

            $response = curl_exec($curl);

            curl_close($curl);

            $res = json_decode($response);

            if(isset($res->message)){
                return false;
            }else{
                return true;
            }


        }else {
            $mail = new PHPMailer();
            $mail->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;
            $mail->IsSMTP();
            $mail->Host = $smtp['server'];
            $mail->SMTPAuth = true;
            $mail->Username = $smtp['user'];
            $mail->Password = crypt_jm($smtp['password'], 'd');
            $mail->Port = $smtp['port'];
            if ($smtp['usessltls'] == 1) {
                if ($smtp['port'] == 465) {
                    $mail->SMTPSecure = "ssl";
                }
                if ($smtp['port'] == 587) {
                    $mail->SMTPSecure = "tls";
                }
            }
            $mail->IsHTML(true);
            $mail->setFrom($smtp['from_email']);
            $mail->FromName = $smtp['from_name'];
            $mail->addCustomHeader('In-Reply-To', $identifier);
            $mail->AddAddress($contact['email']);
            if (!empty($campaign['bcc'])) {
                $mail->addBcc($campaign['bcc']);
            }
            $mail->Subject = $email['subject'];
            $message = $email['body'];
            $message = $message . $mail_footer . ' <img src="' . AUTOMAILER_TRACKER_URL . '/_track.php?id=' . $identifier . '" alt="" />';
            $mail->Body = $message;
            $mail->AltBody = strip_tags($message);
            return $mail->Send();
        }
	}

	//Set Outlook Mailer
	public static  function cronOutlookMailer($outlook,$email,$campaign,$contact,$identifier,$mail_footer){
		$mail = new PHPMailer();
		$mail->IsSMTP();
		$mail->Host = $outlook['server'];
		$mail->SMTPAuth = true;
		//$mail->SMTPDebug = 2;
		$mail->Username = $outlook['user'];
		$mail->Password = crypt_jm($outlook['password'], 'd');
		$mail->Port = $outlook['port'];
		if ($outlook['port'] == 465)
		{
			$mail->SMTPSecure = "ssl";
		}
		if ($outlook['port'] == 587)
		{
			$mail->SMTPSecure = "tls";
		}
		$mail->IsHTML(true);
		$mail->setFrom($outlook['from_email']);
		$mail->FromName = $outlook['from_name'];
		$mail->addCustomHeader('In-Reply-To', $identifier);
		$mail->AddAddress($contact['email']);
		if (!empty($campaign['bcc']))
		{
			$mail->addBcc($campaign['bcc']);
		}
		$mail->Subject = $email['subject'];
		$message = $email['body'];
		$message = $message . $mail_footer . ' <img src="' . AUTOMAILER_TRACKER_URL . '/_track.php?id=' . $identifier . '"/>';
		$mail->Body = $message;
		$mail->AltBody = strip_tags($message);
		return $mail->Send();
	}

    public static function cronNylasSmtpMailer($smtp,$email,$campaign,$contact,$identifier='',$mail_footer=''){

        if(!empty($smtp['nylas_account_id'])){

            $message = $email['body'];
            //$message = str_replace("\r\n","",$message); //issue while sending with \r\n with nylas
            $message = sanitize_output($message);
            //$message = addslashes($message);

            $message = $message . $mail_footer . ' <img src="' . AUTOMAILER_TRACKER_URL . '/_track.php?id=' . $identifier . '" />';
            //$message = addcslashes($message, '"');
            //echo '<pre>';print_r($message);exit;
            $message = addslashes($message);

            $subject = $email['subject'];
            $subject = sanitize_output($subject);
            //$subject = addcslashes($subject, '"');

            $from_name = $smtp['name'];
            $from_email = $smtp['email'];
            $to_email = $contact['email'];
            $nylas_access_token = $smtp['nylas_access_token'];
            $password = '';

            //$bcc = isset($campaign['bcc']) && !empty($campaign['bcc'])?$campaign['bcc']:'';
            //$message_id = isset($email['is_thread'])?$email['is_thread']:'';

            $curl = curl_init();

            if(isset($email['is_thread']) && !empty($email['is_thread'])){ //this works while from send lead replies cron

                $message_id = $email['is_thread'];
                if (!empty($campaign['bcc'])) {
                    $bcc = $campaign['bcc'];

                    $post = [
                        'body' => $message,
                        'subject' => $subject,
                        'reply_to_message_id' => $message_id,
                        'bcc'   => [[
                            'name' => 'Automailer BCC',
                            'email' => $bcc
                        ]],
                        'from'   => [[
                            'name' => $from_name,
                            'email' => $from_email
                        ]],
                        'to'   => [[
                            'email' => $to_email
                        ]],
                        'tracking'   => [
                            'opens' => false,
                            'links' => false,
                            'thread_replies' => true,
                            'payload' => $identifier
                        ]
                    ];

                    curl_setopt_array($curl, array(
                        CURLOPT_URL => "https://api.nylas.com/send",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => "POST",
                        //CURLOPT_POSTFIELDS => "{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n  \"reply_to_message_id\": \"$message_id\",\n    \"bcc\": \"$bcc\",\n    \"to\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$to_email\"\n        }\n    ]\n}",
                        //CURLOPT_POSTFIELDS =>"{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n  \"reply_to_message_id\": \"$message_id\",\n    \"bcc\": [\n        {\n            \"name\": \"automailer bcc\",\n            \"email\":\"$bcc\"\n        }\n    ],\n    \"to\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$to_email\"\n        }\n    ],\n    \"tracking\": {\n \"opens\":\"true\", \n \"links\":\"true\", \n \"thread_replies\":\"true\", \n \"payload\":\"$identifier\" \n }\n      \n}",
                        //CURLOPT_POSTFIELDS =>"{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n  \"reply_to_message_id\": \"$message_id\",\n    \"bcc\": [\n        {\n            \"name\": \"Automailer BCC\",\n            \"email\":\"$bcc\"\n        }\n    ],\n  \"from\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$from_email\"\n        }\n    ],\n    \"to\": [\n        {\n           \"email\": \"$to_email\"\n        }\n    ],\n    \"tracking\": {\n \"opens\":\"false\", \n \"links\":\"false\", \n \"thread_replies\":\"true\", \n \"payload\":\"$identifier\" \n }\n      \n}",
                        CURLOPT_POSTFIELDS => json_encode($post),

                        CURLOPT_HTTPHEADER => array(
                            "Content-Type: application/json",
                            "Authorization: Bearer " . $nylas_access_token
                        ),
                    ));

                } else {

                    $post = [
                        'body' => $message,
                        'subject' => $subject,
                        'reply_to_message_id' => $message_id,
                        'from'   => [[
                            'name' => $from_name,
                            'email' => $from_email
                        ]],
                        'to'   => [[
                            'email' => $to_email
                        ]],
                        'tracking'   => [
                            'opens' => false,
                            'links' => false,
                            'thread_replies' => true,
                            'payload' => $identifier
                        ]
                    ];

                    curl_setopt_array($curl, array(
                        CURLOPT_URL => "https://api.nylas.com/send",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => "POST",
                        //CURLOPT_POSTFIELDS => "{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n \"reply_to_message_id\": \"$message_id\",\n    \"to\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$to_email\"\n        }\n    ],\n    \"tracking\":  {\n \"opens\":\"true\", \n \"links\":\"true\", \n \"thread_replies\":\"true\", \n \"payload\":\"$identifier\" \n}\n      \n}",
                        //CURLOPT_POSTFIELDS => "{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n \"reply_to_message_id\": \"$message_id\",\n  \"from\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$from_email\"\n        }\n    ],\n    \"to\": [\n        {\n          \"email\": \"$to_email\"\n        }\n    ],\n    \"tracking\":  {\n \"opens\":\"false\", \n \"links\":\"false\", \n \"thread_replies\":\"true\", \n \"payload\":\"$identifier\" \n}\n      \n}",
                        CURLOPT_POSTFIELDS => json_encode($post),

                        CURLOPT_HTTPHEADER => array(
                            "Content-Type: application/json",
                            "Authorization: Bearer " . $nylas_access_token
                        ),
                    ));

                }

            }else {

                if (!empty($campaign['bcc'])) {
                    $bcc = $campaign['bcc'];

                    $post = [
                        'body' => $message,
                        'subject' => $subject,
                        'bcc'   => [[
                            'name' => 'Automailer BCC',
                            'email' => $bcc
                        ]],
                        'from'   => [[
                            'name' => $from_name,
                            'email' => $from_email
                        ]],
                        'to'   => [[
                            'email' => $to_email
                        ]],
                        'tracking'   => [
                            'opens' => false,
                            'links' => false,
                            'thread_replies' => true,
                            'payload' => $identifier
                        ]
                    ];

                    curl_setopt_array($curl, array(
                        CURLOPT_URL => "https://api.nylas.com/send",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => "POST",
                        //CURLOPT_POSTFIELDS => "{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n    \"bcc\": \"$bcc\",\n    \"to\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$to_email\"\n        }\n    ]\n}",
                        //CURLOPT_POSTFIELDS =>"{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n    \"bcc\": [\n        {\n            \"name\": \"automailer bcc\",\n            \"email\":\"$bcc\"\n        }\n    ],\n    \"to\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$to_email\"\n        }\n    ],\n    \"tracking\":  {\n \"opens\":\"true\", \n \"links\":\"true\", \n \"thread_replies\":\"true\", \n \"payload\":\"$identifier\" \n }\n     \n}",
                        //CURLOPT_POSTFIELDS =>"{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n    \"bcc\": [\n        {\n            \"name\": \"Automailer BCC\",\n            \"email\":\"$bcc\"\n        }\n    ],\n  \"from\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$from_email\"\n        }\n    ],\n    \"to\": [\n        {\n    \"email\": \"$to_email\"\n        }\n    ],\n    \"tracking\":  {\n \"opens\":\"false\", \n \"links\":\"false\", \n \"thread_replies\":\"true\", \n \"payload\":\"$identifier\" \n }\n     \n}",
                        CURLOPT_POSTFIELDS => json_encode($post),

                        CURLOPT_HTTPHEADER => array(
                            "Content-Type: application/json",
                            "Authorization: Bearer " . $nylas_access_token
                        ),
                    ));
                } else {

                    $post = [
                        'body' => $message,
                        'subject' => $subject,
                        'from'   => [[
                            'name' => $from_name,
                            'email' => $from_email
                        ]],
                        'to'   => [[
                            'email' => $to_email
                        ]],
                        'tracking'   => [
                            'opens' => false,
                            'links' => false,
                            'thread_replies' => true,
                            'payload' => $identifier
                        ]
                    ];

                    curl_setopt_array($curl, array(
                        CURLOPT_URL => "https://api.nylas.com/send",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => "POST",
                        //CURLOPT_POSTFIELDS => "{\n    \"body\" : \"$message\",\n    \"subject\": \"$subject\",\n  \"from\": [\n        {\n            \"name\": \"$from_name\",\n            \"email\": \"$from_email\"\n        }\n    ],\n    \"to\": [\n        {\n           \"email\": \"$to_email\"\n        }\n    ],\n    \"tracking\":  {\n \"opens\":\"false\", \n \"links\":\"false\", \n \"thread_replies\":\"true\", \n \"payload\":\"$identifier\" \n }\n       \n}",
                        CURLOPT_POSTFIELDS => json_encode($post),

                        CURLOPT_HTTPHEADER => array(
                            "Content-Type: application/json",
                            "Authorization: Bearer " . $nylas_access_token
                        ),
                    ));

                }
            }

            $response = curl_exec($curl);

            curl_close($curl);

            $res = json_decode($response);
            //echo '<pre>';print_r($res);exit;

            if(isset($res->message)){
                //return false;
                return $res;
            }else{
                return $res;
            }


        }
    }


}

