  <title><?php echo SITE_NAME; ?> - Exclusions</title>
  <style>
  .dataTables_length, .dataTables_wrapper .dataTables_filter{
    display: block !important;
  }
  .img-duplicate, .img-delete{
        margin: 0 auto;
        display: block;
        height: 127px;
  }
  .hdr-duplicate, .hdr-delete{
        width: 100%;
        text-align: center;
        font-size: 25px;
        margin: 29px 0px;
  }

  </style>
</head>

<body id="page-top">

  <!-- Page Wrapper -->
  <div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar Navbar -->
        <?php include_once("nav/right_nav.php"); ?>

        <!-- Begin Page Content -->
        <div class="container-fluid">  


          <!-- Page Heading -->
          <div class="panel-header">
            <div class="float-left">
              <h1 class="panel-title">Exclusions</h1>
              <?php if( in_array("manage", $exclusion_roles) || $member['account_type'] == 0 ){ ?>
              <!-- <h4>Add Exclusions</h4> -->
              <p class="panel-subtitle">This will allow you to add emails and domains that will be excluded on the list that you add on the recipient upon sending of campaign.</p>
              <a href="javascript:void(0);"  class="btn btn-success btn-add-exclusion" data-toggle="tooltip" title="Add Exclusion">Add Exclusions</a>
              <a href="javascript:void(0);" href="'.$root.'/add_exclusions" class="btn btn-link btn-import-exclusion" data-toggle="tooltip" title="Add Exclusion"><i class="fas fa-cloud-upload-alt"></i> Import Exclusions</a>
              <br /><br />
              <?php } ?>
            </div>
            <div class="clearfix"></div>
          </div>

          <?php 
            if( isset($_POST['action-exclusion']) && $_POST['action-exclusion'] == 'add' ){
              if( $_POST['exclusion_type'] == exclusionEmail() ){ 
                $type = exclusionEmail();
                $exclusion = $_POST['exclusion_email'];
              }else{
                $type = exclusionDomain();
                $exclusion = $_POST['exclusion_domain'];
              }
              $data_exclusions = array(
                $member['id'],
                $exclusion,
                $type,
                strtotime(date("Y-m-d H:i:s"))
              );
              $q = $pdo->prepare('INSERT INTO `exclusions` (member_id,exclusion,type,created) VALUES (?,?,?,?)');
              $q->execute($data_exclusions);

              echo '
              <div class="alert alert-success" role="alert">
                Exclusion list was successfully updated!
              </div>
              ';
            }elseif( isset($_POST['action-exclusion']) && $_POST['action-exclusion'] == 'delete' ){
              $exclusion_id = $_POST['exclusion_id'];
              $q = $pdo->prepare('DELETE FROM `exclusions` WHERE `id`=? AND `member_id`=? LIMIT 1');
              $q->execute(array($exclusion_id, $member['id']));

              echo '
              <div class="alert alert-success" role="alert">
                Exclusion list was successfully updated!
              </div>
              ';
            }elseif( isset($_POST['action-exclusion']) && $_POST['action-exclusion'] == 'edit' ){
              if( $_POST['exclusion_type'] == exclusionEmail() ){ 
                $type = exclusionEmail();
                $exclusion = $_POST['exclusion_email'];
              }else{
                $type = exclusionDomain();
                $exclusion = $_POST['exclusion_domain'];
              }
              $data_exclusions = array(
                $exclusion,
                $type,
                $_POST['edit_exclusion_id'],
                $member['id']
              );
              $q = $pdo->prepare('UPDATE `exclusions` SET `exclusion`=?, `type`=? WHERE `id`=? AND `member_id`=? LIMIT 1');
              $q->execute($data_exclusions);

              echo '
              <div class="alert alert-success" role="alert">
                Exclusion list was successfully updated!
              </div>
              ';
            }elseif( isset($_POST['action-exclusion']) && $_POST['action-exclusion'] == 'import' ){

              $file_size       = $_FILES['file']['size'];
              $array = explode('.', $_FILES['file']['name']);
              $extension = end($array);
              if($extension == "csv"){
                if( $file_size <= UPLOAD_MAX_FILE_SIZE ){
                  $csvData = array_map('str_getcsv', file($_FILES['file']['tmp_name']));
                  $keys = array();

                  foreach ($csvData[0] as $key => $value) {
                    if(strpos(strtolower($value), 'email') !== false){
                      $emailKey = $key;
                    }
                    if(strpos(strtolower($value), 'domain') !== false){
                      $domainKey = $key;
                    }

                    if(isset($emailKey) && isset($domainKey)){
                      $keys = array(
                        'emailKey' => $emailKey,
                        'domainKey' => $domainKey
                      );
                    }
                  }

                  $count = 0;
                  foreach ($csvData as $key => $value) {
                    $data = array();

                    if(strtolower($value[$keys['emailKey']]) !== 'email' && strtolower($value[$keys['domainKey']]) !== 'domain'){
                      if( $value[$keys['emailKey']] != '' ){
                        $type = exclusionEmail();
                        $exclusion    = $pdo->prepare('SELECT `id` FROM `exclusions` WHERE `member_id`=? AND `exclusion`=? AND `type`=? LIMIT 1');
                        $exclusion->execute(array($member['id'],$value[$keys['emailKey']],$type));

                        if($exclusion->rowcount()<=0){
                          $data_exclusions = array(
                            $member['id'],
                            $value[$keys['emailKey']],
                            $type,
                            strtotime(date("Y-m-d H:i:s"))
                          );

                          $q = $pdo->prepare('INSERT INTO `exclusions` (member_id,exclusion,type,created) VALUES (?,?,?,?)');
                          $q->execute($data_exclusions);
                        }
                      }

                      if( $value[$keys['domainKey']] != '' ){
                        $type = exclusionDomain();
                        $exclusion    = $pdo->prepare('SELECT `id` FROM `exclusions` WHERE `member_id`=? AND `exclusion`=? AND `type`=? LIMIT 1');
                        $exclusion->execute(array($member['id'],$value[$keys['domainKey']],$type));

                        if($exclusion->rowcount()<=0){
                          $data_exclusions = array(
                            $member['id'],
                            $value[$keys['domainKey']],
                            $type,
                            strtotime(date("Y-m-d H:i:s"))
                          );

                          $q = $pdo->prepare('INSERT INTO `exclusions` (member_id,exclusion,type,created) VALUES (?,?,?,?)');
                          $q->execute($data_exclusions);
                        }                        
                      }
                    }
                    $count++;
                  }

                  echo '
                  <div class="alert alert-success" role="alert">
                    Import successful!
                  </div>
                  ';

                }else{
                    // Remove file
                    if (!empty($_FILES['file']['tmp_name']))
                        @unlink($_FILES['file']['tmp_name']);
                   echo '<div class="alert alert-warning"> Import error: Filesize is limit to ' . format_size(UPLOAD_MAX_FILE_SIZE) . '.</div>';
                }
              }else{

                    // Remove file
                    if (!empty($_FILES['file']['tmp_name']))
                        @unlink($_FILES['file']['tmp_name']);
                echo '<div class="alert alert-warning"> Invalid file format. Click <a href="' .$root_assets.'/sample_exclusion_import.csv" target="_blank">here</a> to download the correct template.  </div>';
              }
            }
          ?>
          <div class="row">

            <div class="col-sm-12">
              <div class="dataTables_wrapper">
                <table class="table datatable" id="exclusion-datatable">
                  <thead>                   
                    <tr>
                      <th scope="col">NAME</th>
                      <th scope="col">DATE CREATED</th>
                      <th scope="col">TYPE</th>
                      <?php if( in_array("manage", $exclusion_roles) || $member['account_type'] == 0 ){ ?>
                      <th scope="col">ACTIONS</th>
                      <?php } ?>
                    </tr>
                  </thead>
                  <tbody></tbody>
                </table>
              </div>
            </div>

          </div>

        </div>
        <!-- /.container-fluid -->

      </div>
      <!-- End of Main Content -->

      <!-- Modal -->
      <div class="modal fade modal-enhanced" id="modalEditExclusion" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
		  <div class="modal-dialog" role="document">
		    <div class="modal-content">                      		      
		      <form action="" method="post">
            <div class="row" style="margin-top:37px;">
                <div class="col-12" style="text-align: center;">
                    <i class="far fa-edit" style="font-size:50px;"></i>
                    <p style="margin-top: 20px; font-size: 30px;margin-bottom: 13px;">Edit Exclusion</p>
                </div>
            </div>
		      	<input type="hidden" name="edit_exclusion_id" id="edit_exclusion_id" value="">
		      <div class="modal-body">
		        <div class="modal-form-body"></div>  

            <div class="modal-footer" style="display: block;text-align: center;">
              <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
              <button type="submit" class="btn btn-success" style="width:200px;font-size: 21px;" name="action-exclusion" value="edit">Update</button>
            </div>                 
		      </div>
		      </form>
		    </div>
		  </div>
		</div>

      <div class="modal fade modal-enhanced" id="modalAddExclusion" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
          <div class="modal-content">                                
            <form action="" method="post" id="">  
              <div class="row" style="margin-top:37px;">
                  <div class="col-12" style="text-align: center;">
                      <i class="far fa-plus-square" style="font-size:50px;"></i>
                      <p style="margin-top: 20px; font-size: 30px;margin-bottom: 13px;">Add Exclusion</p>
                  </div>
              </div>
              <div class="modal-body">        
                <input type="hidden" name="action" value="add">              
                <div class="modal-add-smtp-msg"></div>
                <div class="row">                  
                  <div class="col-md-12">
                    <div class="form-group">
                      <select class="form-control add-exclusion-type" name="exclusion_type" data-toggle="tooltip" title="Name that will show on the sender name">
                        <option value="1">Email</option>
                        <option value="2">Domain</option>
                      </select>
                      <label>Type: *</label>
                    </div>
                  </div>
                  <div class="col-md-12 add-exclusion-email">
                    <div class="form-group">
                      <input type="email" name="exclusion_email" required="" data-toggle="tooltip" title="Email to add in exclusion" placeholder="user@domain.com" class="form-control add-exclusion-email">
                      <label>Email: *</label>
                    </div>
                  </div>
                  <div class="col-md-12 add-exclusion-domain" style="display: none;">
                    <div class="form-group">
                      <input type="text" name="exclusion_domain" placeholder="domain.com" data-toggle="tooltip" title="Domain name to add in exclusion" class="form-control add-exclusion-domain">
                      <label>Domain: *</label>
                    </div>
                  </div>                    
                </div>   
                <div class="modal-footer" style="display: block;text-align: center;">
                  <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                  <button type="submit" class="btn btn-success" style="width:200px;font-size: 21px;" name="action-exclusion" value="add">Save</button>
                </div>        
              </div>
            </form>
          </div>
        </div>
      </div>

      <div class="modal fade" id="modalImportExclusion" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
            <form action="" method="post" enctype="multipart/form-data">      
              <div class="modal-body">
                <!-- <h4 class="modal-heading">Import Exclusion</h4>  -->
                <div class="drop-upload">
                    <a class="float-right btn-sm btn-default btn-download-template" href="<?php echo $root_assets; ?>/sample_exclusion_import.csv">Download Template</a>
                  <div id="dropContainer">

                    <center>
                      <i class="fas fa-cloud-upload-alt"></i>                    
                      <big>Drop a file here or click to upload</big>
                      <label>Upload *.csv file. Maximum filesize: <?php echo format_size(UPLOAD_MAX_FILE_SIZE); ?>.</label>
                      <a class="btn btn-sm btn-secondary btn-select-upload" href="javascript:void();">Select files to upload</a>
                    </center>
                  </div>
                </div>     

                <!-- <div id="dropContainer">Drop a file here or click to upload</div> -->
                <input type="file" id="fileInput" name="file" style="display: none;" />
                <div class="modal-footer" style="display: block;text-align: center;">
                  <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                  <button type="submit" class="btn btn-success" style="width:200px;font-size: 21px;" name="action-exclusion" value="import">Import</button>
                </div>
              </div>              
              </form>
          </div>
        </div>
      </div>

     <!-- <div class="modal fade modal-enhanced modal-danger" id="modalDeleteExclusion" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
          <div class="modal-content">                      
            <div class="modal-header">
              <h5 class="modal-title"><i class="far fa-trash-alt"></i> Delete</h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <form action="" method="post" id="">  
              <input type="hidden" name="exclusion_id" id="delete_exclusion_id" value="">
              <div class="modal-body"> 
                <div class="modal-delete-exclusion-body"></div>
                <div class="modal-footer">            
                  <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>  
                  <button type="submit" class="btn btn-danger" name="action-exclusion" value="delete">Delete</button>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div> -->
 
       <!-- Modal Delete Confirmation -->
        <div class="modal fade modal-enhanced modal-danger" id="modalDeleteExclusion" tabindex="-1" role="dialog" aria-labelledby="modalDeleteExclusion" aria-hidden="true">
            <div class="modal-dialog modal-md" role="document">
                <form action="" method="post">
                    <input type="hidden" value="" name="delete_exclusion_id" class="delete_exclusion_id">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="col-md-12">
                                <img src="<?php echo $root; ?>/img/delete-icon.png" class="img-delete">
                                <h3 class="hdr-delete" style="font-size:29px; font-weight: bold;"></h3>
                                <div class="list-selected-msg" style="text-align:center;font-size: 18px;"><div class="modal-delete-exclusion-body"></div><br />This process cannot be undone</div>
                            </div>
                            <div class="modal-footer" style="display: block;text-align: center;">
                                <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                                <button type="submit" class="btn btn-danger" name="action" value="delete" style="width:200px;font-size: 21px;">Delete</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>


      <!-- Footer -->
      <footer class="sticky-footer bg-white">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; <?php echo date('Y'); ?></span>
          </div>
        </div>
      </footer>
      <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>