  <title><?php echo SITE_NAME; ?> - Add Contact</title>
</head>

<body id="page-top">

  <!-- Page Wrapper -->
  <div id="wrapper">

    <!-- Sidebar -->
    <ul class="navbar-nav sidebar sidebar-dark accordion" id="accordionSidebar">

      <!-- Sidebar - Brand -->
      <a class="sidebar-brand d-flex align-items-center justify-content-center" href="<?php echo $root; ?>/dashboard">
        <div class="sidebar-brand-icon rotate-n-15">
          <i class="fas fa-robot"></i>
        </div>
        <div class="sidebar-brand-text mx-3">AUTOMAILER</div>
      </a>

      <!-- Divider -->
      <hr class="sidebar-divider my-0">

      <!-- Nav Item - Dashboard -->
      <li class="nav-item">
        <a class="nav-link" href="<?php echo $root; ?>/dashboard">
          <i class="fas fa-fw fa-tachometer-alt"></i>
          <span>Dashboard</span></a>
      </li>

      <!-- Divider -->
      <hr class="sidebar-divider">

      <!-- Heading -->
      <div class="sidebar-heading">
        Main Menu
      </div>

      
      <li class="nav-item">
        <a class="nav-link" href="<?php echo $root; ?>/email-accounts">
          <i class="fas fa-envelope-square"></i>
          <span>Email Accounts</span></a>
      </li>
      
      <li class="nav-item">
        <a class="nav-link" href="<?php echo $root; ?>/campaigns">
          <i class="fas fa-clock"></i>
          <span>Campaigns</span></a>
      </li>
      
      <li class="nav-item">
        <a class="nav-link" href="<?php echo $root; ?>/lists">
          <i class="fas fa-list"></i>
          <span>Lists</span></a>
      </li>
      
      <li class="nav-item">
        <a class="nav-link" href="<?php echo $root; ?>/integrations">
          <i class="fas fa-network-wired"></i>
          <span>Integrations</span></a>
      </li>
      
      <li class="nav-item">
        <a class="nav-link" href="<?php echo $root; ?>/templates">
          <i class="fas fa-edit"></i>
          <span>Templates</span></a>
      </li>

      <!-- Divider -->
      <hr class="sidebar-divider">

      <!-- Heading -->
      <div class="sidebar-heading">
        Quick Links
      </div>

      <li class="nav-item">
        <a class="nav-link" href="<?php echo $root; ?>/campaigns/create">
          <span>Create New Campaign</span></a>
      </li>

      <li class="nav-item <?php echo $admin_nav_selected == 'autoreplies' ? 'active' : ''; ?>">
        <a class="nav-link" href="<?php echo $root; ?>/auto-replies">
          <span>Auto Replies</span></a>
      </li>
      

      <!-- Divider -->
      <hr class="sidebar-divider d-none d-md-block">

      <!-- Sidebar Toggler (Sidebar) -->
      <div class="text-center d-none d-md-inline">
        <button class="rounded-circle border-0" id="sidebarToggle"></button>
      </div>

    </ul>
    <!-- End of Sidebar -->

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar -->
        <nav class="navbar navbar-expand navbar-light topbar mb-4 static-top shadow" style="background: <?php echo $colors['sidebar']; ?> !important;">

          <!-- Sidebar Toggle (Topbar) -->
          <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
            <i class="fa fa-bars"></i>
          </button>

          

          <!-- Topbar Navbar -->
          <ul class="navbar-nav ml-auto">

            

            <div class="topbar-divider d-none d-sm-block"></div>

            <!-- Nav Item - User Information -->
            <li class="nav-item dropdown no-arrow">
              <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <span class="mr-2 d-none d-lg-inline text-white small"><?php echo $member['fname'].' '.$member['lname']; ?></span>
              </a>
              <!-- Dropdown - User Information -->
              <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in" aria-labelledby="userDropdown">
                <a class="dropdown-item" href="<?php echo $root; ?>/settings">
                  <i class="fas fa-cogs fa-sm fa-fw mr-2 text-gray-400"></i>
                  Settings
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item" href="<?php echo $root; ?>/?logout=1">
                  <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                  Logout
                </a>
              </div>
            </li>

          </ul>

        </nav>
        <!-- End of Topbar -->

        <!-- Begin Page Content -->
        <div class="container-fluid">

          <?php
          if(isset($_POST['firstName']))
          {
            $email_checker = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? AND `email`=?');
            $email_checker->execute(array($_SEO[2],$_POST['email']));
            if($email_checker->rowcount()<1){
              $q = $pdo->prepare('INSERT INTO `contacts`  (list_id,firstName,lastName,email,data,status)  VALUES (?,?,?,?,?,?)');
              $q->execute(array($_SEO[2], $_POST['firstName'], $_POST['lastName'], $_POST['email'], json_encode($_POST['data']), 0));
              $error = 1;
            }else{
              $error = 2;
            }
          }

          $q = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? ORDER BY `id` DESC');
          $q->execute(array($_SEO[2]));
          $contact = $q->fetch(PDO::FETCH_ASSOC);
          ?>

          <!-- Page Heading -->
          <div class="float-left">
            <h1 class="h3 mb-4 text-gray-800">Add contact</h1>
          </div>
          <div class="float-right" style="margin-right: 10vw;">

          </div>
          <div class="clearfix"></div>
          
          <form action="" method="post" class="p-2 card card-body">
            <?php
            if(isset($_POST['firstName']))
            {
              if($error==1){
                echo '
                <div class="alert alert-success" role="alert">
                  Contact '.$_POST['firstName'].' has been added.
                </div>
                ';
              }elseif($error==2){
                echo '
                <div class="alert alert-warning" role="alert">
                  Contact '.$_POST['email'].' already in the list. Cannot add duplicate email.
                </div>
                ';
              }
            }
            ?>
            <div class="row">
              <div class="col-md-4">
                <label style="display: block; margin-top: 10px;">First name</label>
                <input type="text" name="firstName" class="form-control" value="" autocomplete="off" required>
              </div>
              <div class="col-md-4">
                <label style="display: block; margin-top: 10px;">Last name</label>
                <input type="text" name="lastName" class="form-control" value="" autocomplete="off" required>
              </div>
              <div class="col-md-4">
                <label style="display: block; margin-top: 10px;">Email</label>
                <input type="email" name="email" class="form-control" value="" autocomplete="off" required>
              </div>
              <?php
              $customFields = json_decode($contact['data'], 1);
              foreach ($customFields as $key => $value) {
                echo '
                <div class="col-md-4">
                  <label style="display: block; margin-top: 10px;">'.$key.'</label>
                  <input type="text" name="data['.$key.']" class="form-control" value="" autocomplete="off">
                </div>
                ';
              }
              ?>
              <div class="col-sm-12 mt-4">
                <button type="submit" class="btn btn-primary">Add</button>
                <a href="<?php echo $root.'/list/'.$_SEO['2']; ?>" class="btn btn-default">Back to List</a>
              </div>
            </div>
          </form>

        </div>
        <!-- /.container-fluid -->

      </div>
      <!-- End of Main Content -->

      <!-- Footer -->
      <footer class="sticky-footer bg-white">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; <?php echo date('Y'); ?></span>
          </div>
        </div>
      </footer>
      <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>