<?php
//exit();
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PhpImap\Mailbox;
use PhpImap\Exceptions\ConnectionException;
define("IN_CRONTAB",1);
require_once dirname(__FILE__) . '/config.php';
require_once dirname(__FILE__) . '/functions.php';
require_once dirname(__FILE__) . '/PHPMailer/autoload.php';
require_once dirname(__FILE__) . '/Google/autoload.php';
require_once dirname(__FILE__) . '/swiftmailer/autoload.php';
require_once dirname(__FILE__) . '/php-imap/autoload.php';
require_once dirname(__FILE__) . '/helper/leads_helper.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(900);

echo 'Running Cron Mark Replies';

$leadsHelper = new LeadsHelper();

$script_time_start = microtime(true);
$mail = new PHPMailer();
$mail->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;

//Marked email if replied
$date = date("Y-m-d");
$default_followup_date = defaultFollowupDate($date);

/*$q = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `replied`=? AND `bounced`=?');
$q->execute(array(0,0));*/
$id = 543;
$q = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=?');
$q->execute(array($id));

foreach ($q as $row) {
	$is_updated = false;

	// check every 10 minutes per account
	$nextCheckTime = time() - (10 * 60);

	$gmail = $pdo->prepare('SELECT `id`,`email`,`access_token`,`refresh_token`,`member_id`,`active`,`lastdate_markreplies` FROM `gmail_accounts` WHERE active = 1 AND `email`=?  AND lastdate_markreplies <= ?');
	$gmail->execute(array($row['from_email'],$nextCheckTime));

	if($gmail->rowcount()>0)
	{
		$gmail = $gmail->fetch(PDO::FETCH_ASSOC);

		$updateActive = $pdo->prepare('UPDATE `gmail_accounts` SET lastdate_markreplies = ? WHERE `id`=?');
		$updateActive->execute(array(time(), $gmail['id']));

        try
        {
            $client = new Google_Client();
            $client->setClientId($googleClientId);
            $client->setClientSecret($googleSecretId);
            $client->setAccessToken($gmail['access_token']);
            $client->refreshToken($gmail['refresh_token']);

            $accessToken = $client->getAccessToken();

            if (empty($accessToken['refresh_token']))
                error_log("Mark Replies GMAIL Token: " . $gmail['id'] . " Reason:" .  print_r($accessToken,true));

            $refreshToken = $pdo->prepare('UPDATE `gmail_accounts` SET `access_token`=?, `refresh_token`=? WHERE `id`=?');
            $refreshToken->execute(array($accessToken['access_token'], $accessToken['refresh_token'], $gmail['id']));

            $messages = new Google_Service_Gmail($client);

            $list = $messages->users_messages->listUsersMessages('me',
                [
                	'q' => 'from:'.$row['to_email'].' AND to:'.$row['from_email'].' AND subject:'.$row['subject'],                    
                    'maxResults' => 10
            ]);

            if($row['from_email'] !== $row['to_email'])
            {
                if(count($list->messages)>0)
                {
                	$email_date = date("Y-m-d H:i:s");
                	$lists      = $list->getMessages();
		            $messageId  = $lists[0]->getId();
		            $optParamsGet = [];
			        $optParamsGet['format'] = 'full'; // Display message in payload
			        $message = $messages->users_messages->get('me',$messageId,$optParamsGet);
			        $messagePayload = $message->getPayload();
			        $headers = $message->getPayload()->getHeaders();
			        $parts   = $message->getPayload()->getParts();

			        $body       = $parts[0]['body'];
			        $rawData    = $body->data;
			        $sanitizedData = strtr($rawData,'-_', '+/');
			        $content    = base64_decode($sanitizedData);
			        $is_bounced = 0;
			        if(trim($content) != ''){
			        	$leads = $pdo->prepare('SELECT `id`,`member_id`,`mail_id`,`sent_mail_id` FROM `leads` WHERE `sent_mail_id`=?');				        	
				        $leads->execute(array($row['id']));
				        if($leads->rowcount()<=0){
				        	$status  = $leadsHelper->cronSetLeadStatus($content);
				        	if( $status == 0 ){			        		
				        		$continue_automation = $leadsHelper->continueAutomation();
					    		AddNotification("leads", "New Lead",$row['member_id']);
					    	}else{
					    		$is_bounced = 1;
					    		$continue_automation = $leadsHelper->stopAutomation();
					    		AddNotification("autoreply", "Received new auto reply",$row['member_id']);
					    	}

					    	//$campaign_imap = $pdo->prepare('SELECT `id`,`bounces`,`member_id`,`trigger_date` FROM `campaigns` WHERE `id`=?');
							//$campaign_imap->execute(array($row['campaign_id']));
							//$campaign_imap_id = $campaign_imap->fetch(PDO::FETCH_ASSOC);
		            		//if(strtotime($email->date) >= $campaign_imap_id['trigger_date']){
								$data = array(
					    			$row['id'],
					    			strtotime($default_followup_date),
					    			strtotime($email_date),
					    			$content,
					    			$status,
					    			$row['member_id'],
					    			0,
					    			$continue_automation
					    		);
					    		//$q = $pdo->prepare('INSERT INTO `leads` (sent_mail_id,followup_date,replied_date,content,status,member_id,mail_id,continue_automation) VALUES (?,?,?,?,?,?,?,?)');
							    //$result = $q->execute($data);
							    //$lead_id = $pdo->lastInsertId();

							    //Insert lead reply
						    	$data = array(
						    		$lead_id,
						    		$row['campaign_id'],
						    		$content,
						    		strtotime($email_date),
						    		1,
						    		1,
						    		0
						    	);
						    	//$q = $pdo->prepare('INSERT INTO `lead_replies` (lead_id,campaign_id,msg,replied_date,is_with_reply,is_sent,mail_id)  VALUES (?,?,?,?,?,?,?)');
								//$result = $q->execute($data);

								//AddNotification("leads", "New Lead Reply",$row['member_id']);

							//}				    	
				        }else{
				        	//$leadThread = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `mail_id`=?');
		            		//$leadThread->execute(array($mail_id));
		            		//if($leadThread->rowcount()<=0){	      
		            			$leads = $leads->fetch(PDO::FETCH_ASSOC);		
		            			//Insert lead reply
						    	$data = array(
						    		$leads['id'],
						    		$row['campaign_id'],
						    		$content,
						    		strtotime($email_date),
						    		1,
						    		1,
						    		0
						    	);
						    	/*$q = $pdo->prepare('INSERT INTO `lead_replies` (lead_id,campaign_id,msg,replied_date,is_with_reply,is_sent,mail_id)  VALUES (?,?,?,?,?,?,?)');
								$result = $q->execute($data);

								AddNotification("leads", "New Lead Reply",$row['member_id']);*/
		            		//}
				        }
			            
	                    $replied = $pdo->prepare('UPDATE `sent_mails` SET `replied`=1, `last_activity`=?, `bounced`=? WHERE `id`=?');
	                    $replied->execute(array(time(), $is_bounced, $row['id']));

	                    $is_updated = true;
			        }
                }
            }


		}
		catch (Google_Service_Exception $e)
        {
            // Account no longer active...
            $updateActive = $pdo->prepare('UPDATE `gmail_accounts` SET active = 0 WHERE `id`=?');
            $updateActive->execute(array($gmail['id']));

            error_log("Mark Replies GMAIL ID: " . $gmail['id'] . " Reason:" .  $e->getMessage());
            AddNotification("gmail", "GMAIL Account " . $gmail['gmail'] . " inactive - " . $e->getMessage(),$row['member_id']);
        }
	}

	//IMAP
	if( !$is_updated ){
		/*$imap = $pdo->prepare('SELECT `id`,`active`,`user`,`member_id`,`lastdate_markreplies`,`is_ssl`,`server`,`port`,`password` FROM `imap` WHERE  active = 1 AND `user`=? AND `member_id`=? AND lastdate_markreplies <= ?');
		$imap->execute(array($row['from_email'],$row['member_id'],$nextCheckTime));*/
		$imap = $pdo->prepare('SELECT * FROM `imap` WHERE  `user`=? AND `member_id`=?');
		$imap->execute(array($row['from_email'],$row['member_id']));
		if($imap->rowcount()>0) {		
			$imap = $imap->fetch(PDO::FETCH_ASSOC);

			//$updateActive = $pdo->prepare('UPDATE `imap` SET lastdate_markreplies  =? WHERE `id`=?');
			//$updateActive->execute(array(time(),$imap['id']));

			if( $imap['is_ssl'] == 1 ){
				$mailbox_server = '{'.$imap['server'].':'.$imap['port'].'/imap/ssl}INBOX';
			}else{
				$mailbox_server = '{'.$imap['server'].':'.$imap['port'].'/imap}INBOX';
			}

	        try {
				$mailbox = new Mailbox(
				    $mailbox_server,
				    $imap['user'],
				    crypt_jm($imap['password'],'d'),
				    __DIR__,
				    'US-ASCII'
				);
				$identifier = $row['identifier'];

				$subject = str_replace("@", "", $row['subject']);
				$subject = str_replace("Re :", "", trim($subject));
				$mail_ids = $mailbox->searchMailbox('SUBJECT "'.$subject.'" FROM "' . $row['to_email'] . '"');			

			} catch(ConnectionException $ex) {
	            // Account no longer active...
	            //$updateActive = $pdo->prepare('UPDATE `imap` SET active = 0, inactive_reason =? WHERE `id`=?');
	            //$updateActive->execute(array($ex->getMessage(),$imap['id']));
	            //AddNotification("imap", "IMAP Account " . $imap['user']. " inactive - " . $ex->getMessage(),$imap['member_id']);
			    //error_log("IMAP connection failed: ID: " . $imap['id'] . " Reason: " . $ex->getMessage());
			    continue;
			}

			
			foreach ($mail_ids as $mail_id) {


			    $email = $mailbox->getMail(
			        $mail_id,
			        false
			    );

			    $email_content_raw = htmlentities($email->textHtml);
			    $strpos     = strpos($email_content_raw, $identifier);
			    $is_bounced = 0;
			    echo "<br /> From : " . $row['to_email'] . " / Subject : " . $row['subject'] . "<br />";

			    echo "<pre>";
				print_r($email);
				echo "</pre>";
				$content = $email->textPlain;
			    $status  = $leadsHelper->cronSetLeadStatus($content);
			    $bounceDelete = bounceDeleteChecker($content);

			    echo "<pre>";
			    print_r($bounceDelete);
			    echo "</pre>";

			    echo "<br /> Content: ". $content;
			    echo "<br /> Status: ". $status; 
			    //if($strpos !== false){
			    	$leads = $pdo->prepare('SELECT `id`,`member_id`,`mail_id`,`sent_mail_id` FROM `leads` WHERE `sent_mail_id`=?');
			        $leads->execute(array($row['id']));
			        if($leads->rowcount()<=0){
			        	$content = $email->textPlain;
			        	$status  = $leadsHelper->cronSetLeadStatus($content);

			        	if($content == ""){
			        		$content = $email->textHtml;
			        	}
			        	if( $status == 0 ){
			        		$continue_automation = $leadsHelper->continueAutomation();
				    		AddNotification("leads", "New Lead",$row['member_id']);
				    	}else{
				    		$is_bounced = 1;
				    		$continue_automation = $leadsHelper->stopAutomation();
				    		AddNotification("autoreply", "Received new auto reply",$row['member_id']);
				    	}

				    	echo "<br /> Content: ". $content;
				    	echo "<br /> Status: ". $status; 

				    	$campaign_imap = $pdo->prepare('SELECT * FROM `campaigns` WHERE `id`=?');
						$campaign_imap->execute(array($row['campaign_id']));
						$campaign_imap_id = $campaign_imap->fetch(PDO::FETCH_ASSOC);
						//if(strtotime($email->date) >= $campaign_imap_id['trigger_date']){
							$data = array(
				    			$row['id'],
				    			strtotime($default_followup_date),
				    			strtotime($email->date),
				    			$content,
				    			$status,
				    			$row['member_id'],
				    			$mail_id,
				    			$continue_automation
				    		);
				    		$q = $pdo->prepare('INSERT INTO `leads` (sent_mail_id,followup_date,replied_date,content,status,member_id,mail_id,continue_automation) VALUES (?,?,?,?,?,?,?,?)');
						    $result = $q->execute($data);
						//}

			        }else{
		            	$leadThread = $pdo->prepare('SELECT `id`,`mail_id` FROM `lead_replies` WHERE `mail_id`=?');
	            		$leadThread->execute(array($mail_id));
	            		if($leadThread->rowcount()<=0){	      
	            			$leads = $leads->fetch(PDO::FETCH_ASSOC);		
	            			//Insert lead reply
					    	$data = array(
					    		$leads['id'],
					    		$row['campaign_id'],
					    		$email->textPlain,
					    		strtotime($email->date),
					    		1,
					    		1,
					    		$mail_id
					    	);
					    	$q = $pdo->prepare('INSERT INTO `lead_replies` (lead_id,campaign_id,msg,replied_date,is_with_reply,is_sent,mail_id)  VALUES (?,?,?,?,?,?,?)');
							$result = $q->execute($data);

							//AddNotification("leads", "New Lead Reply",$row['member_id']);
	            		}
		            }

				    // echo ->textHtml; for reply html
				    if(!empty($email->fromAddress)){
				    	$replied = $pdo->prepare('UPDATE `sent_mails` SET `replied`=1, `last_activity`=?, `bounced`=? WHERE `id`=?');
				    	$replied->execute(array(time(), $is_bounced, $row['id']));
				    	$is_updated = true;
				    }
				//}
			}

			$mailbox->disconnect();
		}
	}

	// Outlook
	/*if( !$is_updated ){
		$outlook = $pdo->prepare('SELECT `id`,`user`,`member_id`,`lastdate_markreplies`,`password` FROM `outlook` WHERE  active = 1 AND `user`=? AND `member_id`=? AND lastdate_markreplies <= ?');
		$outlook->execute(array($row['from_email'],$row['member_id'],$nextCheckTime));

		if($outlook->rowcount()>0) {		
			$outlook = $outlook->fetch(PDO::FETCH_ASSOC);

			$mailbox_server = '{'.$outlook_imap_server.':'.$outlook_imap_port.'/imap/ssl}INBOX';

	        try {
				$mailbox = new Mailbox(
				    $mailbox_server,
				    $outlook['user'],
				    crypt_jm($outlook['password'],'d'),
				    __DIR__,
				    'US-ASCII'
				);
				$identifier = $row['identifier'];

				$subject = str_replace("@", "", $row['subject']);
				$subject = str_replace("Re :", "", trim($subject));
				$mail_ids = $mailbox->searchMailbox('SUBJECT "'.$subject.'" FROM "' . $row['to_email'] . '"');

			} catch(ConnectionException $ex) {
	            // Account no longer active...
	            $updateActive = $pdo->prepare('UPDATE `outlook` SET active = 0, inactive_reason =? WHERE `id`=?');
	            $updateActive->execute(array($ex->getMessage(),$outlook['id']));
	            AddNotification("outlook", "Outlook Account " . $outlook['user']. " inactive - " . $ex->getMessage(), $outlook['member_id']);
			    error_log("Outlook connection failed: ID: " . $outlook['id'] . " Reason: " . $ex->getMessage());
			   // continue;
			}
			
			foreach ($mail_ids as $mail_id) {
			    $email = $mailbox->getMail(
			        $mail_id,
			        false
			    );

			    $email_content_raw = htmlentities($email->textHtml);
			    $strpos     = strpos($email_content_raw, $identifier);
			    $is_bounced = 0;
			    //if($strpos !== false){
			    	$leads = $pdo->prepare('SELECT `id`,`member_id`,`mail_id`,`sent_mail_id` FROM `leads` WHERE `sent_mail_id`=?');
			        $leads->execute(array($row['id']));
			        if($leads->rowcount()<=0){
			        	$content = $email->textPlain;
			        	$status  = LeadsHelper::cronSetLeadStatus($content);

			        	if( $status == 0 ){
			        		$continue_automation = $leadsHelper->continueAutomation();
				    		AddNotification("leads", "New Lead",$row['member_id']);
				    	}else{
				    		$continue_automation = $leadsHelper->stopAutomation();
				    		AddNotification("autoreply", "Received new auto reply",$row['member_id']);
				    	}

				    	$campaign_imap = $pdo->prepare('SELECT * FROM `campaigns` WHERE `id`=?');
						$campaign_imap->execute(array($row['campaign_id']));
						$campaign_imap_id = $campaign_imap->fetch(PDO::FETCH_ASSOC);
						//if(strtotime($email->date) >= $campaign_imap_id['trigger_date']){
							$data = array(
				    			$row['id'],
				    			strtotime($default_followup_date),
				    			strtotime($email->date),
				    			$content,
				    			$status,
				    			$row['member_id'],
				    			$mail_id,
				    			$continue_automation
				    		);
				    		$q = $pdo->prepare('INSERT INTO `leads` (sent_mail_id,followup_date,replied_date,content,status,member_id,mail_id,continue_automation) VALUES (?,?,?,?,?,?,?,?)');
						    $result = $q->execute($data);
						//}

			        }else{
		            	$leadThread = $pdo->prepare('SELECT `id`,`mail_id` FROM `lead_replies` WHERE `mail_id`=?');
	            		$leadThread->execute(array($mail_id));
	            		if($leadThread->rowcount()<=0){	      
	            			$leads = $leads->fetch(PDO::FETCH_ASSOC);		
	            			//Insert lead reply
					    	$data = array(
					    		$leads['id'],
					    		$row['campaign_id'],
					    		$email->textPlain,
					    		strtotime($email->date),
					    		1,
					    		1,
					    		$mail_id
					    	);
					    	$q = $pdo->prepare('INSERT INTO `lead_replies` (lead_id,campaign_id,msg,replied_date,is_with_reply,is_sent,mail_id)  VALUES (?,?,?,?,?,?,?)');
							$result = $q->execute($data);

							AddNotification("leads", "New Lead Reply",$row['member_id']);
	            		}
		            }

				    // echo ->textHtml; for reply html
				    if(!empty($email->fromAddress)){
				    	$replied = $pdo->prepare('UPDATE `sent_mails` SET `replied`=1, `last_activity`=?, `bounced`=? WHERE `id`=?');
				    	$replied->execute(array(time(), $is_bounced, $row['id']));
				    	$is_updated = true;
				    }
				//}
			}

			$mailbox->disconnect();
		}
	}*/
}


$time_end = microtime(true);
$time = $time_end - $script_time_start;

echo ' End Cron Mark Replies: - Time Taken: ' . $time . '<br>';