<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PhpImap\Mailbox;
use PhpImap\Exceptions\ConnectionException;
define("IN_CRONTAB",1);
require_once dirname(__FILE__) . '/config.php';
require_once dirname(__FILE__) . '/functions.php';
require_once dirname(__FILE__) . '/PHPMailer/autoload.php';
require_once dirname(__FILE__) . '/Google/autoload.php';
require_once dirname(__FILE__) . '/swiftmailer/autoload.php';
require_once dirname(__FILE__) . '/php-imap/autoload.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(900);

echo 'Running Cron Send Lead Replies';
flush();
$script_time_start = microtime(true);


/*Send Lead Replies*/
/*$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `is_sent`=? AND `is_with_reply`=?');
$q->execute(array(0,0));*/
$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `is_sent`=? LIMIT 10');
$q->execute(array(0));
/*$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `id`=? LIMIT 10');
$q->execute(array(167));*/
foreach( $q as $row ){
	$data = $pdo->prepare('SELECT `id`, `data`, `member_id`, `bcc` FROM `campaigns` WHERE `id`=?');
	$data->execute(array($row['campaign_id']));
	$campaign = $data->fetch(PDO::FETCH_ASSOC);

	$data = $pdo->prepare('SELECT * FROM `leads` WHERE `id`=?');
	$data->execute(array($row['lead_id']));
	$lead = $data->fetch(PDO::FETCH_ASSOC);

	$data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `id`=?');
	$data->execute(array($lead['sent_mail_id']));
	$sent_mail = $data->fetch(PDO::FETCH_ASSOC);
    $identifier_smtp = $sent_mail['identifier'];

	$emails = json_decode($campaign['data'], 1);

	$is_sent = false;	
	foreach ($emails as $email) {		
		if( $email['subject'] == $sent_mail['subject'] ){
			//email sending
			switch ($email['send_server']) {

				case 'gmail':

					$gmail = $pdo->prepare('SELECT * FROM `gmail_accounts` WHERE active = 1 AND `id`=?');
					$gmail->execute(array($email['send_id']));
					$gmail = $gmail->fetch(PDO::FETCH_ASSOC);

					$send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
					$send_limit->execute(array($gmail['email'], time()-86400));

					if($gmail['send_limit'] == 0)
					{
						$gmail['send_limit'] = $send_limit->rowcount()+1;
					}

					if(!empty($gmail['email']) && $send_limit->rowcount()<$gmail['send_limit'])
					{

					    try
                        {
                            $client = new Google_Client();
                            $client->setClientId($googleClientId);
                            $client->setClientSecret($googleSecretId);
                            $client->setAccessToken($gmail['access_token']);
                            $client->refreshToken($gmail['refresh_token']);

                            $accessToken = $client->getAccessToken();

                            $refreshToken = $pdo->prepare('UPDATE `gmail_accounts` SET `access_token`=?, `refresh_token`=? WHERE `id`=?');
                            $refreshToken->execute(array($accessToken['access_token'], $accessToken['refresh_token'], $gmail['id']));

                            $service = new \Google_Service_Gmail($client);
                            $mailer = $service->users_messages;

                            if(!empty($campaign['bcc']))
                            {
                                $message = (new \Swift_Message($email['subject']))
                                    ->setFrom($gmail['email'], $gmail['firstName'])
                                    ->setTo($sent_mail['to_email'])
                                    ->setBcc([$campaign['bcc']])
                                    ->setContentType('text/html')
                                    ->setCharset('utf-8')
                                    ->setBody($row['msg'].$mail_footer.' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier_smtp.'"/>');
                            }
                            else
                            {
                                $message = (new \Swift_Message($email['subject']))
                                    ->setFrom($gmail['email'], $gmail['firstName'])
                                    ->setTo([$sent_mail['to_email']])
                                    ->setContentType('text/html')
                                    ->setCharset('utf-8')
                                    ->setBody($email['body'].$mail_footer.' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier_smtp.'"/>');
                            }

                            $encoded = base64url_encode($message->toString());

                            $message = new \Google_Service_Gmail_Message();
                            $message->setRaw($encoded);
                            $message = $mailer->send('me', $message);

                            $is_sent = true;
                        }
                        catch (Exception $e)
                        {
                            // Account no longer active...
                            $updateActive = $pdo->prepare('UPDATE `gmail_accounts` SET active = 0,inactive_reason =? WHERE `id`=?');
                            $updateActive->execute(array($e->getMessage(),$gmail['id']));

                            error_log("Lead Replies GMAIL: " . $gmail['id'] . " Reason: " .  $e->getMessage());
                             AddNotification("gmail", "GMAIL Account " . $gmail['gmail'] . " inactive - " . $e->getMessage(),$campaign['member_id']);
                        }

					}

					break;

				case 'smtp':
					$smtp = $pdo->prepare('SELECT * FROM `smtp` WHERE active = 1 AND `id`=?');
					$smtp->execute(array($email['send_id']));
					$smtp = $smtp->fetch(PDO::FETCH_ASSOC);

					$send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
					$send_limit->execute(array($smtp['from_email'], time()-86400));

					if($smtp['send_limit'] == 0)
					{
						$smtp['send_limit'] = $send_limit->rowcount()+1;
					}

					if(isset($smtp['from_email']) && $send_limit->rowcount()<$smtp['send_limit'])
					{

						$mail = new PHPMailer();
						$mail->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;

						$mail->IsSMTP();
						$mail->Host = $smtp['server'];
						$mail->SMTPAuth = true;
						//$mail->SMTPDebug = 2;
						$mail->Username = $smtp['user'];
						$mail->Password = crypt_jm($smtp['password'],'d');
						$mail->Port = $smtp['port'];
			            if($smtp['usessltls']==1){
							if ($smtp['port'] == 465)
							{
								$mail->SMTPSecure = "ssl";
							}
							if ($smtp['port'] == 587)
							{
								$mail->SMTPSecure = "tls";
							}
						}

					    //$mail->SMTPDebug  = 2;
						$mail->IsHTML(true);
						$mail->setFrom($smtp['from_email']);
						$mail->FromName = $smtp['from_name'];
						$mail->addCustomHeader('In-Reply-To', $identifier_smtp);
						$mail->AddAddress($sent_mail['to_email']);
						if(!empty($campaign['bcc']))
						{
							$mail->addBcc($campaign['bcc']);
						}
						$mail->Subject = "Re:" . $email['subject'];
						$message = $row['msg'];
						$mail->Body = $message . ' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier_smtp.'"/>';
						$mail->AltBody = strip_tags($message);
						if($mail->Send()){
							$is_sent = true;
						}else{
							AddNotification("smtp", "SMTP Account " . $smtp['from_email']. " send failure - " . $mail->ErrorInfo, $campaign['member_id']);
						}
					}

					break;

				case 'outlook':

					$outlook = $pdo->prepare('SELECT * FROM `outlook` WHERE active = 1 AND `id`=?');
					$outlook->execute(array($email['send_id']));
					$outlook = $outlook->fetch(PDO::FETCH_ASSOC);

					$send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
					$send_limit->execute(array($outlook['from_email'], time()-86400));

					if($outlook['send_limit'] == 0)
					{
						$outlook['send_limit'] = $send_limit->rowcount()+1;
					}

					if(isset($outlook['from_email']) && $send_limit->rowcount()<$outlook['send_limit'])
					{

						$mail = new PHPMailer();
						$mail->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;

						$mail->IsSMTP();
						$mail->Host = $outlook_server;
						$mail->SMTPAuth = true;
						//$mail->SMTPDebug = 2;
						$mail->Username = $outlook['user'];
						$mail->Password = crypt_jm($outlook['password'],'d');
						$mail->Port = $outlook_port;
			            $mail->SMTPSecure = "tsl";
						$mail->IsHTML(true);
						$mail->setFrom($outlook['from_email']);
						$mail->FromName = $outlook['from_name'];
						$mail->addCustomHeader('In-Reply-To', $identifier_smtp);
						$mail->AddAddress($sent_mail['to_email']);
						if(!empty($campaign['bcc']))
						{
							$mail->addBcc($campaign['bcc']);
						}
						$mail->Subject = $email['subject'];
						$message = $row['msg'];
						$mail->Body = $message . ' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier_smtp.'"/>';
						$mail->AltBody = strip_tags($message);
						if($mail->Send()){
							$is_sent = true;
						}else{
							echo $mail->ErrorInfo;
							AddNotification("smtp", "SMTP Account " . $smtp['from_email']. " send failure - " . $mail->ErrorInfo, $campaign['member_id']);
						}
					}

					break;
			}

			if( $is_sent ){
				//Update lead_replies flag is_sent field to 1
				$q = $pdo->prepare('UPDATE `lead_replies` SET `is_sent`=? WHERE `id`=?');
				$q->execute(array(1,$row['id']));
				$is_sent = false;
			}

			break;
		}

	}
}

$time_end = microtime(true);
$time = $time_end - $script_time_start;

echo ' End Cron Send Lead Replies - Time Taken: ' . $time . '<br>';