<?php

define("IN_CRONTAB", 1);
require_once dirname(__FILE__) . '/config.php';
require_once dirname(__FILE__) . '/functions.php';
require_once dirname(__FILE__) . '/helper/cron_helper.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(900);


echo 'Running Cron Send';
flush();

$script_time_start = microtime(true);

$members = $pdo->prepare('SELECT m.id, m.fname, m.lname, m.timezone, m.parent_id FROM (`members` as m) WHERE m.status = 1');
$members->execute();

foreach ($members as $keyMember => $member) {
    //set timzone to the member's timezone

    if( $member['parent_id'] > 0 ){
        $smtp_member_id = $member['parent_id'];
    }else{
        $smtp_member_id = $member['id'];
    }

    echo "<br /><br /> Member: " . $member['fname'] . " " . $member['lname'];
    //echo "<br /> Timezone: " . $member['timezone'] ;
    date_default_timezone_set($member['timezone']);
    $day = date("l");

    $smtp_emails = $pdo->prepare('SELECT * FROM `nylas_smtp` WHERE active = 1 AND  `member_id`=?');
    $smtp_emails->execute(array($smtp_member_id));

    if ($smtp_emails->rowcount() > 0) {
        // get per email settings
        foreach ($smtp_emails as $keySMTP => $smtp_email) {

            //$sending_account = "smtp:" . $smtp_email['id'];
            $sending_account = $smtp_email['smtp_type'] .":". $smtp_email['id'];
            //get today running campaigns
            $campaign_sending_done = true;

            //added by jen for pending campaign stuff
            $campaigns = $pdo->prepare('SELECT * FROM `campaigns` WHERE `status` IN (?) AND `member_id`=? AND `sending_account`=?');
            $campaigns->execute(array(CAMPAIGN_STATUS_RUNNING , $member['id'], $sending_account));
            //end

            $total_campaign = $campaigns->rowcount();

            echo "<br /> Total Campaigns : " . $total_campaign;

            $send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
            $send_limit->execute(array($smtp_email['email'], time() - 86400));

            //$smtp['send_limit'] = 10000;
            echo " <br /> Current Limit: " . $send_limit->rowcount();
            echo " <br /> Email Limit per day :" . $smtp_email['sending_limit_per_day'];

            echo "<pre>";
            //	print_r($smtp_email);
            echo "</pre>";
            flush();

            if($total_campaign > 0 && $smtp_email['sending_limit_per_day'] < 100){

                $limit = $smtp_email['sending_limit_per_day'] + 5;
                echo "<br /> Updated id: - ". $smtp_email['id']. " - limit increase to - ". $limit;
                $q = $pdo->prepare('UPDATE `nylas_smtp` SET `sending_limit_per_day`=? WHERE `id`=?');
                $q->execute(array($limit, $smtp_email['id']));

            }

            //loop through each campaign
            //foreach ($campaigns as $campaign) {
            //}

        } // end of the smtp loop
    } //end check if has smtp


} // end of the member




//exit();
$time_end = microtime(true);
$time = $time_end - $script_time_start;

echo ' <br/>End Cron Send - Time Taken: ' . $time . '<br>';
