<title><?php echo SITE_NAME; ?> - User Settings</title>
</head>
<style>


    #show-password{
        z-index: 9999 !important;
    }

</style>
<body id="page-top">


<!-- Page Wrapper -->
<div id="wrapper">
    <?php include_once("nav_wrapper.php"); ?>
    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>

            <!-- Begin Page Content -->
            <div class="container-fluid">


                <!-- Page Heading -->
                <div class="panel-header">
                    <div class="float-left">
                        <h1 class="panel-title">User Settings</h1>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <?php
                if (isset($_POST['action']) && $_POST['action'] == 'update-user-setting'){
                    $password = $_POST['user_password'];
                    $password = htmlspecialchars($password, ENT_QUOTES);
                    if( $password != '' && password_verify($password, $member['password'])){
                        if( $_POST['password'] != '' ){
                            $_POST['password'] = htmlspecialchars($_POST['password'], ENT_QUOTES);
                            $data_member = array(
                                $_POST['fname'],
                                $_POST['lname'],
                                password_hash($_POST['password'], PASSWORD_BCRYPT),
                                $_POST['email'],
                                $_POST['user_timezone'],
                                $_POST['unsubscribe_link'],
                                $member['id']
                            );
                            $sql = 'UPDATE `members` SET `fname`=?, `lname`=?, `password`=?, `email`=?, `timezone`=?, `unsubscribe_link`=?  WHERE `id`=?';
                        }else{
                            $data_member = array(
                                $_POST['fname'],
                                $_POST['lname'],
                                $_POST['email'],
                                $_POST['user_timezone'],
                                $_POST['unsubscribe_link'],
                                $member['id']
                            );
                            $sql = 'UPDATE `members` SET `fname`=?, `lname`=?, `email`=?, `timezone`=?, `unsubscribe_link`=? WHERE `id`=?';
                        }


                        $q = $pdo->prepare($sql);
                        $q->execute($data_member);

                        $q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
                        $q->execute(array($member['id']));
                        $member = $q->fetch(PDO::FETCH_ASSOC);

                        echo '
                <div class="alert alert-success" role="alert">
                  User setting was successfully updated!
                </div>
                ';
                    }else{
                        echo '
                <div class="alert alert-danger" role="alert">
                  Invalid password!
                </div>
                ';

                    }
                }
                ?>
                <div class="container">
                    <form class="user" action="" method="post" id="user_setting">
                        <input type="hidden" value="monthly" id="billing_type" />
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input type="text" name="fname" value="<?php echo $member['fname']; ?>" class="form-control form-control-user" required>
                                    <label for="">First name</label>
                                    <span class="err-fname alert-danger"></span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input type="text" name="lname" value="<?php echo $member['lname']; ?>" class="form-control form-control-user" required>
                                    <label for="">Last name</label>
                                    <span class="err-lname alert-danger"></span>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input type="text" name="email" value="<?php echo $member['email']; ?>" class="form-control form-control-user" required>
                                    <label for="">Email address</label>
                                    <span class="err-email alert-danger"></span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input type="text" name="uname" readonly="readonly" disabled="disabled" class="form-control form-control-user" value="<?php echo $member['username']; ?>">
                                    <label for="">Username</label>
                                    <div class="err-username"></div>
                                </div>
                            </div>
                        </div>



                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input type="password" name="password" id="password" class="form-control form-control-user">
                                    <label for="">Change Password</label>
                                    <span id="show-password" onclick="showpass();">
                        <svg class="hide-pass" fill="none" height="24" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg">
                          <path d="M17.94 17.94A10.07 10.07 0 0 1 12 20c-7 0-11-8-11-8a18.45 18.45 0 0 1 5.06-5.94M9.9 4.24A9.12 9.12 0 0 1 12 4c7 0 11 8 11 8a18.5 18.5 0 0 1-2.16 3.19m-6.72-1.07a3 3 0 1 1-4.24-4.24"/>
                          <line x1="1" x2="23" y1="1" y2="23"/>
                        </svg>
                        <svg class="show-pass" xmlns="http://www.w3.org/2000/svg">
                          <path id="svg_1" d="m12.500024,5.221397c5.497863,0 8.968661,5.198402 10.137382,7.278493c-1.170795,2.083726 -4.640821,7.278493 -10.137382,7.278493c-5.497081,0 -8.967362,-5.16825 -10.137119,-7.239762c1.168977,-2.092048 4.640038,-7.317224 10.137119,-7.317224m0,-2.079572c-8.318277,0 -12.477416,9.401215 -12.477416,9.401215s4.159139,9.314912 12.477416,9.314912s12.477418,-9.358062 12.477418,-9.358062s-4.15914,-9.358065 -12.477418,-9.358065l0,0z"/>
                          <path id="svg_2" d="m12.500985,10.344938c1.187673,0 2.154023,0.966351 2.154023,2.154022s-0.966351,2.154022 -2.154023,2.154022s-2.154023,-0.966351 -2.154023,-2.154022s0.966351,-2.154022 2.154023,-2.154022m0,-2.154023c-2.379115,0 -4.308045,1.92893 -4.308045,4.308045c0,2.379385 1.92893,4.308046 4.308045,4.308046c2.379385,0 4.308045,-1.928661 4.308045,-4.308046c0,-2.379115 -1.92866,-4.308045 -4.308045,-4.308045l0,0z"/>
                        </svg>
                      </span>

                                    <span class="err-password alert-danger"></span>
                                </div>
                            </div>


                            <div class="col-md-6">
                                <div class="form-group">
                                    <?php
                                    $timezones = $pdo->prepare('SELECT * FROM `timezones`');
                                    $timezones->execute();
                                    ?>
                                    <select class="form form-control timezone-list" name="user_timezone" required="">
                                        <option value="">Select Timezone</option>
                                        <?php foreach($timezones as $value){ ?>
                                            <option <?php echo($member['timezone'] == $value['timezone'] ? 'selected="selected"' : ''); ?> value="<?php echo $value['timezone']; ?>"><?php echo $value['utc_gmt'] . " - " . $value['timezone']; ?></option>
                                        <?php } ?>
                                    </select>
                                    <label for="">Timezone</label>
                                    <div class="err-username"></div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <select class="form form-control" name="unsubscribe_link" required="">
                                        <option <?php echo($member['unsubscribe_link'] == 1 ? 'selected="selected"' : ''); ?> value="1">Active</option>
                                        <option <?php echo($member['unsubscribe_link'] == 2 ? 'selected="selected"' : ''); ?> value="2">Inactive</option>
                                    </select>
                                    <label for="">Unsubscribe link</label>
                                    <div class="err-username"></div>
                                </div>
                            </div>

                        </div>

                        <div>
                            <a class="btn btn-success btn-lg float-right btn-modal-password" href="javascript:void(0);">Update Settings</a>
                            <div class="clearfix"></div>
                        </div>

                        <div class="modal fade" id="modal-update-settings" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <div class="row" style="margin-top:10px;">
                                            <div class="col-12" style="text-align: center;">
                                                <i class="fa fa-cog" style="font-size:50px;"></i>
                                                <p style="margin-top: 20px; font-size: 30px;margin-bottom: 22px;">Update Settings</p>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <input type="password" name="user_password" placeholder="********" required="required" data-toggle="tooltip" title="Your Password" value="" class="form-control">
                                                    <label>Enter your password to update settings: *</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer" style="display: block;text-align: center;margin-top: 16px;">
                                          <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                                          <button type="submit" class="btn btn-success" style="width:200px;font-size: 21px;" name="action" value="update-user-setting">Update</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
            <!-- /.container-fluid -->

        </div>
        <!-- End of Main Content -->

        <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Copyright &copy; <?php echo date('Y'); ?></span>
                </div>
            </div>
        </footer>
        <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>


<script type="text/javascript">
    $(function(){
        $(".btn-modal-password").click(function(){
            //Verify if email is taken
            var url = root_dir + "/validate-email";
            var msg = '<div class="alert alert-warning" role="alert"><img src="'+root_dir+'/img/spinner.gif" /> Checking email if taken...</div>';
            $(".err-email").html(msg);
            setTimeout(function () {
                $.ajax({
                    type: "POST",
                    url: url,
                    dataType: "json",
                    data: {email:$('[name="email"]').val()},
                    success: function(o)
                    {
                        if( o.is_email_taken ){
                            $(".err-email").addClass("inline-error");
                            $(".err-email").html("<div class='alert alert-danger'>Email already in used</div>");
                        }else{
                            var msg = '<div class="alert alert-success alert-validate-email" role="alert">Email Available</div>';
                            $(".err-email").removeClass("inline-error");
                            $(".err-email").html(msg);
                            $("#modal-update-settings").modal("show");
                        }
                    }
                });
            }, 10);
        });
    });

    function showpass() {
        var x = document.getElementById("password");
        var element = document.getElementById("show-password");
        if (x.type === "password") {
            x.type = "text";
            document.getElementById("show-password").className = true;
            element.classList.add("show");
        } else {
            x.type = "password";
            element.classList.remove("show");
        }
    }
</script>

