<?php

include 'config.php';
require(dirname(__file__) . '/PhpExcel/Classes/PHPExcel.php');

$campaigns = $pdo->prepare('SELECT * FROM `campaigns` WHERE `member_id`=? AND `id`=? LIMIT 1');
$campaigns->execute(array($_POST['member_id'],$_POST['report_campaign_id']));
$campaign = $campaigns->fetch(PDO::FETCH_ASSOC);

$sent_mails = $pdo->prepare('SELECT to_contact,subject FROM `sent_mails` WHERE `campaign_id`=? AND `opened`=1');
$sent_mails->execute(array($_POST['report_campaign_id']));

// Create new PHPExcel object
PHPExcel_Settings::setZipClass(PHPExcel_Settings::PCLZIP);
$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator("Automailer");

$BStyle = array(
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);

//HEADER
$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->setCellValue('A1', "CAMPAIGN REPLIES");
$objPHPExcel->getActiveSheet()->mergeCells('A1:D1');
$objPHPExcel->getActiveSheet()->setCellValue('A2', "CAMPAIGN : " . $campaign['name']);
$objPHPExcel->getActiveSheet()->mergeCells('A2:D2');
$objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setSize(20);
$objPHPExcel->getActiveSheet()->getStyle("A2")->getFont()->setSize(16);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getStyle('A2')->getFont()->setBold(true);

$i=4;

$sent_mails = $pdo->prepare('SELECT id,to_contact,subject  FROM `sent_mails` WHERE `campaign_id`=? AND `replied`=1');
$sent_mails->execute(array($_POST['report_campaign_id']));

$objPHPExcel->getActiveSheet()->setCellValue('A'.$i, '#'.$campaign['id'].' - '.$campaign['name']. ' (Replies)');
$objPHPExcel->getActiveSheet()->mergeCells('A'.$i.':E'.$i);
$objPHPExcel->getActiveSheet()->getStyle('A'.$i.':E'.$i)->applyFromArray($BStyle);

$objPHPExcel->getActiveSheet()
    ->getStyle('A'.$i.':E'.$i)
    ->getFill()
    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
    ->getStartColor()
    ->setRGB('a3a3a3')
;

$i++;

$objPHPExcel->getActiveSheet()->setCellValue('A'.$i, 'First name');
$objPHPExcel->getActiveSheet()->setCellValue('B'.$i, 'Last name');
$objPHPExcel->getActiveSheet()->setCellValue('C'.$i, 'Email');
$objPHPExcel->getActiveSheet()->setCellValue('D'.$i, 'Subject');
$objPHPExcel->getActiveSheet()->setCellValue('E'.$i, 'Initial Reply');
$objPHPExcel->getActiveSheet()->getStyle('A'.$i.':E'.$i)->applyFromArray($BStyle);

$objPHPExcel->getActiveSheet()
    ->getStyle('A'.$i.':E'.$i)
    ->getFill()
    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
    ->getStartColor()
    ->setRGB('cccccc')
;
$i++;

foreach ($sent_mails as $sent_mail) {
    $contacts = $pdo->prepare('SELECT firstName,lastName,email FROM `contacts` WHERE `id`=? LIMIT 1');
    $contacts->execute(array($sent_mail['to_contact']));
    $contact = $contacts->fetch(PDO::FETCH_ASSOC);


    $replies = $pdo->prepare('SELECT sent_mail_id, content FROM `leads` WHERE `sent_mail_id`=? LIMIT 1');
    $replies->execute(array($sent_mail['id']));
    $reply = $replies->fetch(PDO::FETCH_ASSOC);


    $reply_content = "";
    $days  = array("On Mon", "On Tue", "On Wed", "On Thu", "On Fri", "On Sat", "On Sun");
    foreach ($days as $day) {
        $reply_msg = strpos($reply['content'], $day);
        if ($reply_msg) {
            $reply_content = strstr($reply['content'], $day, true);
        }
    }

    if($reply_content == ""){
        $reply_content = $reply['content'];
    }

    $objPHPExcel->getActiveSheet()->setCellValue('A'.$i, $contact['firstName']);
    $objPHPExcel->getActiveSheet()->setCellValue('B'.$i, $contact['lastName']);
    $objPHPExcel->getActiveSheet()->setCellValue('C'.$i, $contact['email']);
    $objPHPExcel->getActiveSheet()->setCellValue('D'.$i, $sent_mail['subject']);
    $objPHPExcel->getActiveSheet()->setCellValue('E'.$i, strip_tags($reply_content));
    $objPHPExcel->getActiveSheet()->getStyle('A'.$i.':E'.$i)->applyFromArray($BStyle);

    $i++;

}

$i++;
// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('REPLIES');


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
$filename = "campaign_report-" . $_POST['report_campaign_id'] . ".xlsx";

ob_clean();
//call the function in the controller with $output_type = F and $file with complete path to the file, to generate the file in the server for example attach to email
// Redirect output to a client's web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="'.$filename.'"');
header('Cache-Control: max-age=0');
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
?>