<?php
$q = $pdo->prepare('SELECT * FROM `campaigns` WHERE `id`=? LIMIT 1');
$q->execute(array($campaign_id));
$campaign = $q->fetch(PDO::FETCH_ASSOC);

if($export_type=="Sent_List"){
    $sent_mails = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=?');
} elseif($export_type=="Bounce_List"){
    $sent_mails = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `bounced`=1');
}elseif($export_type=="Clicks_List"){
    $sent_mails = $pdo->prepare('SELECT * FROM `sent_mails` s  JOIN `links_clicked` m on s.identifier = m.identifier WHERE `campaign_id`=? ');
}elseif($export_type=='Replies_List'){
    $sent_mails = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `replied`=1');
}elseif($export_type=="Opened_List"){
    $sent_mails = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `opened`=1');
}
$sent_mails->execute(array($campaign_id));

$excel_data  = "<h2>SENT MESSAGES</h2>";
$excel_data .= "<h3>CAMPAIGN : " . $campaign['name'] . "</h3>";
$excel_data .= "<table style='border: 1px solid black;'>";
$excel_data .= "<tr>";
$excel_data .= "<td style='border: 1px solid black;'><b>First name</b></td>";
$excel_data .= "<td style='border: 1px solid black;'><b>Last name</b></td>";
$excel_data .= "<td style='border: 1px solid black;'><b>Email</b></td>";
$excel_data .= "<td style='border: 1px solid black;'><b>Subject</b></td>";
$excel_data .= "<td style='border: 1px solid black;'><b>Sent Date</b></td>";
$excel_data .= "</tr>";

foreach ($sent_mails as $sent_mail) {
    $contacts = $pdo->prepare('SELECT firstName,lastName,email FROM `contacts` WHERE `id`=? LIMIT 1');
    $contacts->execute(array($sent_mail['to_contact']));
    $contact = $contacts->fetch(PDO::FETCH_ASSOC);

    if($sent_mail['sent_date']<=0){
        $sent_date = "";
    } else {
        $sent_date = date('m/d/Y',$sent_mail['sent_date']);
    }

    $excel_data .= "<tr>";
    $excel_data .= "<td style='border: 1px solid black;'>".ucfirst($contact['firstName'])."</td>";
    $excel_data .= "<td style='border: 1px solid black;'>".ucfirst($contact['lastName'])."</td>";
    $excel_data .= "<td style='border: 1px solid black;'>".$contact['email']."</td>";
    $excel_data .= "<td style='border: 1px solid black;'>".$sent_mail['subject']."</td>";
    $excel_data .= "<td style='border: 1px solid black;'>".$sent_date."</td>";
    $excel_data .= "</tr>";
}
$excel_data .= "</table>";
ob_clean();
header("Content-type: application/vnd.ms-excel; name='excel'");
header("Content-Disposition: attachment; filename=sent_messages.xls");
header("Pragma: no-cache");
header("Expires: 0");

// output data
echo $excel_data;
?>