<?php 
require_once('Hashid/vendor/autoload.php');

$start = (int) $_POST['start'];
$end   = (int) $_POST['length'];
$sort  = htmlspecialchars($_POST['order'][0]['dir'],ENT_QUOTES);
$sort_col = htmlspecialchars($_POST['order'][0]['column'],ENT_QUOTES);
$_POST['search']['value'] = htmlspecialchars($_POST['search']['value'],ENT_QUOTES);

switch ($sort_col) {
    case 1:
        $col_name = 'fname';
        break;
    case 2:
        $col_name = 'lname';
        break;
    case 3:
        $col_name = 'email';
        break;   
    case 4:
        $col_name = 'username';
        break;  
    case 5:
        $col_name = 'plan';
        break; 
    default:
        $col_name = 'fname';
        break;
}

$q = $pdo->prepare('SELECT COUNT(id) FROM `members`');
$q->execute();
$total_records = $q->fetchColumn(); 

if( $_POST['search']['value'] != '' ){
    $q = $pdo->prepare('SELECT * FROM `members` WHERE (username LIKE "%'.$_POST['search']['value'].'%" OR fname LIKE "%'.$_POST['search']['value'].'%" OR lname LIKE "%'.$_POST['search']['value'].'%" OR email LIKE "%'.$_POST['search']['value'].'%") ORDER BY '.$col_name.' ' .$sort. ' LIMIT '.$start.','.$end);
}else{
    $q = $pdo->prepare('SELECT * FROM `members` ORDER BY '.$col_name.' ' .$sort. ' LIMIT '.$start.','.$end);
}

$q->execute();
$members = $q->fetchAll();

$array_key = 0;
$dt_data = array();

$hashids = new Hashids\Hashids();

foreach( $members as $m ){

    $eid = $hashids->encode($m['id']);
    $add_action  = '';
    $member_name = $m['fname'] . ' ' . $m['lname'];

    if($m['plan'] == 1){
        $plan = "Professional";
    }elseif ($m['plan'] == 2) {
        $plan = "Business";
    }elseif ($m['plan'] == 3) {
        $plan = "Enterprise";
    }

    if($m['parent_id'] > 0){
        $account_type = 'SUB ACCOUNT';
        $add_action   .= '<li><a href="javascript:void(0);" class="dropdown-item action-assign-emails-accounts" data-type="admin" data-id='.$m['id'].' title="Assign Email"><i class="fas fa-envelope-open"></i> Assign email</a></li>';
        $add_action   .= '<li><a href="javascript:void(0);" class="dropdown-item action-edit-subaccount" data-id="'.$m['id'].'" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a></li>';
    }else{
        $account_type = 'MAIN ACCOUNT';
        $add_action   .= '<li><a href="javascript:void(0);" class="dropdown-item action-add-smtp" data-id="'.$m['id'].'"><i class="fas fa-envelope"></i> Add SMTP</a></li>';
        $add_action   .= '<li><a href="javascript:void(0);" class="dropdown-item action-edit-member" data-id="'.$m['id'].'" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a></li>';
    }

    
    if($m['status'] == 1 ){
        $add_action .= '<li><a href="javascript:void(0);" class="dropdown-item action-deactivate-member" data-name="'.$member_name.'" data-id="'.$m['id'].'" title="deactivate"><i class="fa fa-window-close"></i> Deactivate Member</a></li>';
    }else{
        $add_action .= '<li><a href="javascript:void(0);" class="dropdown-item action-activate-member" data-name="'.$member_name.'" data-id="'.$m['id'].'" title="activate"><i class="fas fa-check"></i> Activate Member</a></li>';
    }

    $add_action .= '<li><a href="javascript:void(0);" class="dropdown-item action-change-member-password" data-id="'.$m['id'].'" title="Change password"><i class="fas fa-user-lock"></i> Change Password</a></li>';
    $add_action .= '<li><a href="javascript:void(0);" class="dropdown-item action-delete-member" data-name="'.$member_name.'" data-id="'.$m['id'].'" title="delete"><i class="fas fa-trash-alt"></i> Delete</a></li>';
    $add_action .= '<div class="dropdown-divider"></div>';
    $add_action .= '<li><a href="javascript:void(0);" class="dropdown-item action-view-member-details" data-id="'.$m['id'].'"  title="View Info"><i class="fas fa-search"></i> View Info</a></li>';
    $add_action .= '<li><a href="javascript:void(0);" class="dropdown-item action-view-other-details" data-id="'.$m['id'].'" title="View Other Details"><i class="fas fa-search"></i> View Other Details</a></li>';    
    $add_action .= '<div class="dropdown-divider"></div>';
    $add_action .= '<li><a href="'.$root.'/switch-member?cusid='.$m['id'].'" class="dropdown-item" title="Login to account"><i class="fas fa fa-window-restore"></i> Login to Account</a></li>';
    $add_action .= '<li><a href="'.$root.'/member-email-account/'.$eid.'" class="dropdown-item" title="Email Account Logs"><i class="fas fa fa-window-restore"></i> Email Account Logs</a></li>';    

    $action_drop_down      = '<div class="dropdown"><button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown">Action<span class="caret"></span></button>';
    $action_drop_down     .= '<ul class="dropdown-menu">';
        $action_drop_down .= $add_action;
    $action_drop_down .= '</ul>';
    $action_drop_down .= '</div>';

    $dt_data[] = array(
        $m['fname'],
        $m['lname'],
        $m['email'],
        $m['username'],
        $plan,
        $m['timezone'],
        $account_type,
        $action_drop_down
    );

    $array_key++;
}

echo json_encode(array('data' => $dt_data,'recordsTotal' => $total_records, 'recordsFiltered' => $total_records));
?>