<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PhpImap\Mailbox;
use PhpImap\Exceptions\ConnectionException;
define("IN_CRONTAB",1);
require_once dirname(__FILE__) . '/config.php';
require_once dirname(__FILE__) . '/functions.php';
require_once dirname(__FILE__) . '/PHPMailer/autoload.php';
require_once dirname(__FILE__) . '/Google/autoload.php';
require_once dirname(__FILE__) . '/swiftmailer/autoload.php';
require_once dirname(__FILE__) . '/php-imap/autoload.php';
require_once dirname(__FILE__) . '/helper/cron_helper.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(900);

echo 'Running Cron Send';
flush();

$script_time_start = microtime(true);
$mail = new PHPMailer();
$mail->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;

//Load per active Members 
$members 	= $pdo->prepare('SELECT m.id, m.fname, m.lname, m.timezone FROM (`members` as m)
 LEFT JOIN smtp as s ON (s.member_id = m.id) WHERE m.status = 1 AND s.active = 1 group by s.member_id');
$members->execute();

foreach ($members as $keyMember => $member) {
    //set timzone to the member's timezone

    echo "<br /><br /> Member: ".   $member['fname'] . " ". $member['lname'];
	//echo "<br /> Timezone: " . $member['timezone'] ;
	date_default_timezone_set($member['timezone']);
	$day = date("l");
	
	// Load each smtp accounts 
	$smtp_emails 	= $pdo->prepare('SELECT * FROM `smtp` WHERE active = 1 AND  `member_id`=?');
	$smtp_emails->execute(array($member['id']));

	if($smtp_emails->rowcount()>0){
		// get per email settings
		foreach ($smtp_emails as $keySMTP => $smtp_email) {

			$sending_account = "smtp:". $smtp_email['id'];
			//get today running campaigns
			$campaign_sending_done = true;
			$campaigns 	= $pdo->prepare('SELECT * FROM `campaigns` WHERE `status`=? AND `member_id`=? AND `sending_account`=?');
			$campaigns->execute(array(CAMPAIGN_STATUS_RUNNING, $member['id'],$sending_account));
			$total_campaign = $campaigns->rowcount();
			echo "<br /> SMTP";
			echo "<br /> Timezone: " . $member['timezone'] ;
			echo "<br /> Member ID: " . $member['id']; 
			echo "<br /> Total campaigns: " . $total_campaign; 
			echo "<br /> Allowed Sending time From : " . date('h:i A', $smtp_email['allowed_time_send_from'] );
			echo "<br /> Allowed Sending time To : " . date('h:i A', $smtp_email['allowed_time_send_to'] );
			echo "<br /> email sending limit per day : " . $smtp_email['sending_limit_per_day'] ;
			echo "<br /> interval per blast: " . $smtp_email['time_between_email_send'] ;
  			echo "<br /> email sent per blast: " . $smtp_email['max_email_per_time'] ;

  			if($total_campaign == 0){
  				$allowed_per_campaign_email = 0;		
  			}else{	
  			 	$allowed_per_campaign_email = $smtp_email['max_email_per_time']  / $total_campaign;
  			 	if($allowed_per_campaign_email < 1){
  			 		$allowed_per_campaign_email = 1;
  			 	} 
  			}
  			echo "<br /> Per campaign email sent : " . $allowed_per_campaign_email;

  			$time_today   = strtotime(date("h:i A"));
            echo " <br />  Time now: ". date('h:i A', $time_today);

            $time_from =  $smtp_email['allowed_time_send_from'];
	        $time_to   =  $smtp_email['allowed_time_send_to'];
            if($time_from <= $time_today && $time_to >= $time_today  ){
				echo "send now";
			}

			$send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
			$send_limit->execute(array($smtp_email['from_email'], time()-86400));

			
			//$smtp['send_limit'] = 10000;
			echo " <br /> Current Limit: ". $send_limit->rowcount();
			echo " <br /> Email Limit :" . $smtp_email['send_limit'];

			echo "<pre>";
		//	print_r($smtp_email);
			echo "</pre>";
			flush();
			//loop through each campaign
			foreach ($campaigns as $campaign) {
                // This will check the interval per send must be higher than the set time between email 
	  			$last_sents = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? ORDER BY last_activity DESC LIMIT 1');
				$last_sents->execute(array($campaign['id']));
				echo "<br /> Campaign id:".$campaign['id'];	

				if($last_sents->rowcount() >= 1 ) {
					
					foreach ($last_sents as $keyLastSent => $last_sent) {
					  $diff_time=(strtotime(date("Y/m/d H:i:s"))- $last_sent['last_activity'])/60;
					}

					if($diff_time > $smtp_email['time_between_email_send']){
						$batch_send = true;
					}else{
						$batch_send = false;
					}
				}else{
					echo "New Campaign";
					$batch_send = true;
				}

				if($batch_send){

					// this will reset send counts
					$xsend = 0; 

				    //exclusions
					$exclusions = $pdo->prepare('SELECT * FROM `exclusions` WHERE `member_id`=?');
					$exclusions->execute(array($member['id']));

					$exclusion_emails  = array();
					$exclusion_domains = array();
					foreach( $exclusions as $ex ){
						$s_exclusion = strtolower($ex['exclusion']);
						if( $ex['type'] == exclusionEmail() ){
							$exclusion_emails[$s_exclusion] = $s_exclusion;
						}else{
							$exclusion_domains[$s_exclusion] = $s_exclusion; 
						}
					}
					
					$date_today   = strtotime(date("m/d/Y h:i A"));
					$trigger_date = $campaign['trigger_date'];

					echo " <br />Date time today:  " . date('m/d/Y h:i A',$date_today );
					echo " <br /> Trigger date:  " . date('m/d/Y h:i A',	$trigger_date );

					if( $trigger_date <= $date_today ){

						//check if campaign stop has JSON
						if(isJSON($campaign['stop_at']))
						{
							$stop_at = json_decode($campaign['stop_at'], 1);
						}else{
							$stop_at = array();
							$stop_at['type'] = $campaign['stop_at'];
						}


						//select all contacts for this campaign
						$contacts = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? AND (status=? OR status=?)');
						$contacts->execute(array($campaign['list'],1,0));
						$contacts = $contacts->fetchAll();

						//loop through all contacts
						foreach ($contacts as $key => $contact) {

							//remove contact if they replied to an email on this campaign
							if($stop_at['type'] == 'reply')
							{
								$replied = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `campaign_id`=? AND `to_email`=? AND `replied`=1 LIMIT 1');
								$replied->execute(array($campaign['id'], $contact['email']));
								$replies = $replied->fetch(PDO::FETCH_ASSOC);
								if($replied->rowcount()>0)
								{
									//Replies with Stop Automation will be removed on the list
									$reply_data = $pdo->prepare('SELECT * FROM `auto_replies` WHERE `sent_mail_id`=?  LIMIT 1');
				                    $reply_data->execute(array($replies['id']));
				                    $sent_mail = $reply_data->fetch(PDO::FETCH_ASSOC);
				                    if($sent_mail['status']==1){ 
									    unset($contacts[$key]);
								    }// if the status is set to 0 = Continue Automation it will not be unset on the list

								    //if the sent mail has no record on the auto replies it will be unset on the list
								    if($reply_data->rowcount()<=0)
									{
										unset($contacts[$key]);	
									}

									//Opener with Stop status will be removed on the list
									$opener_data = $pdo->prepare('SELECT * FROM `opener_stop_sending` WHERE `campaign_id`=? AND `email`=? LIMIT 1');
				                    $opener_data->execute(array($campaign['id'], $contact['email']));
				                    $opener_data_mail = $opener_data->fetch(PDO::FETCH_ASSOC);
				                    if($opener_data->rowcount()==1){ 
									    unset($contacts[$key]);
								    }
								}
							}
						}

						//get emails for this campaign
						$emails = json_decode($campaign['data'], 1);

						// Old slow
						//$eid 	= crypt_jm($campaign['id']);
						$eid = sha1($campaign['id'] . SITE_ENCRYPTION_KEY);
						 //loop through contacts again
						foreach ($contacts as $contact) {

							//remove spaces from contact email
							$contact['email'] = trim($contact['email']);
							
							$i = 0;


							//loop through email
							foreach ($emails as $email) {
								$email['body'] = linkify($email['body']);
								// set limit the sent per campaign
								echo "<br />  Allowed: " . $allowed_per_campaign_email . " - ". $xsend;
								if( $xsend <= $allowed_per_campaign_email){
									echo " Send counter " .  $xsend;
									unset($send);
									$send = 0;
									$mail_footer = "";
									//generate a unique identifier for this email and contact
									$identifier = base64_encode($email['subject'].'-' . $email['email_number'].'-' . $contact['id'].'-' . $email['trigger'].'-' . $campaign['id']);
									//mail footer unsubscribe

									$link   = AUTOMAILER_TRACKER_URL ."/_unsubscribe.php?email=".$contact['email']."&campaign=" . $campaign['id']  ."&eid=".$eid;
					    			$mail_footer = "<br /><br /><a href='".$link."'>Unsubscribe</a><br />";
									//replace all links with a trackable redirect
									$email['body'] = str_replace(
										array(
											'href="http://',
											'href="https://'
										),
										array(
											'target="_blank" href="'.AUTOMAILER_TRACKER_URL.'/_track_link.php?identifier='.$identifier.'&link=http://',
											'target="_blank" href="'.AUTOMAILER_TRACKER_URL.'/_track_link.php?identifier='.$identifier.'&link=https://'
										),
										$email['body']
									);

									//replace all default tags with contact values in body of email
									$email['body'] = str_replace('{FirstName}', $contact['firstName'], $email['body']);
									$email['body'] = str_replace('{LastName}', $contact['lastName'], $email['body']);
									$email['body'] = str_replace('{Email}', $contact['email'], $email['body']);

									$email['body'] = str_replace('{firstName}', $contact['firstName'], $email['body']);
									$email['body'] = str_replace('{lastName}', $contact['lastName'], $email['body']);
									$email['body'] = str_replace('{email}', $contact['email'], $email['body']);
					 
									//replace all default tags with contact values in subject of email
									$email['subject'] = str_replace('{FirstName}', $contact['firstName'], $email['subject']);
									$email['subject'] = str_replace('{LastName}', $contact['lastName'], $email['subject']);
									$email['subject'] = str_replace('{Email}', $contact['email'], $email['subject']);

									$email['subject'] = str_replace('{firstName}', $contact['firstName'], $email['subject']);
									$email['subject'] = str_replace('{lastName}', $contact['lastName'], $email['subject']);
									$email['subject'] = str_replace('{email}', $contact['email'], $email['subject']);

									//get custom tag names
									$tagData = json_decode($contact['data'], 1);

									//replace all custom tags with contact values in subject and body
									if(is_array($tagData)){
										foreach ($tagData as $key => $value) {
											$email['body'] = str_replace('{'.$key.'}', $value, $email['body']);
											$email['subject'] = str_replace('{'.$key.'}', $value, $email['subject']);
										}
								    }
									$is_first_email = false;

									if($i == 0)
									{
									   //if first email, no trigger necessary				   
									   $day = date("l");
									   $sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
									   $sent->execute(array($identifier));
									   if($sent->rowcount()<1)
									   {
									   		$time_from = strtotime(date('h:i A', $smtp_email['allowed_time_send_from']));
				                            $time_to   = strtotime(date('h:i A', $smtp_email['allowed_time_send_to']));
				                            $time_today   = strtotime(date("h:i A"));

									   	  	if($day == "Monday" && $email['is_mon']==1){
												//unset($send);
												if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													$send = 1;
												}	
											}
											if($day == "Tuesday" && $email['is_tues']==1){
												//unset($send);	
												if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													$send = 1;
												}	
											}
											if($day == "Wednesday" && $email['is_wed']==1){
												//unset($send);
												if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													$send = 1;
												}	
											}
											if($day == "Thursday" && $email['is_thur']==1){
												//unset($send);
												if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													$send = 1;
												}	
											}
											if($day == "Friday" && $email['is_fri']==1){
												//unset($send);
												if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													$send = 1;
												}	
											}
											if($day == "Saturday" && $email['is_sat']==1){
												//unset($send);
												if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													$send = 1;
												}	
											}
											if($day == "Sunday" && $email['is_sun']==1){
												//unset($send);
												if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													$send = 1;
												}	
											}

										  if( $send == 1 ){
										  	$is_first_email = true;
										  }				   	  
									   }
									}
									else
									{
										//minus 1 from email number to match the email array
										$email_number = $email['email_number'] - 2;

										//get the trigger email identifier
										$trigger_identifier = base64_encode($emails[$email_number]['subject'].'-' . $emails[$email_number]['email_number'].'-' . $contact['id'].'-' . $emails[$email_number]['trigger'].'-' . $campaign['id']);
										/*echo "Trigger identifier : " . $trigger_identifier . "/" . $emails[$email_number]['subject'] . "/Campaign ID : " . $campaign['id'] . "/" . $emails[$email_number]['email_number'] . "/" . $emails[$email_number]['trigger'] . "/Current Subject : " . $email['subject'] . " / Identifier B : " . $identifier . "<br />";*/
										/*echo "<pre>";
										print_r($emails[$email_number]);*/
										//get the trigger email if it was sent
										$trigger_email = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
										$trigger_email->execute(array($trigger_identifier));
										if($trigger_email->rowcount()>0)
										{

											//get trigger email data
											$trigger_email = $trigger_email->fetch(PDO::FETCH_ASSOC);

											//check if email is based on days after
											if(!empty($email['days_after']) && $email['days_after']>0)
											{
												$time_passed = strtotime('+'.$email['days_after'].' days', $trigger_email['last_activity'])<time();

												/* Validation for no send on the day */
												$is_days_after_lapse = true;
												$day = date("l");
												if( $email['days_after'] > 0 ){
													//Base start date in last_activity date
													$add_days   = $email['days_after'];
													$last_activity  = date("Y-m-d",$trigger_email['last_activity']);
													$expected_start = date("Y-m-d", strtotime($last_activity . " + {$add_days} days"));
													if( strtotime($expected_start) > strtotime(date("Y-m-d")) ){ //Validate if start date lapse the days after
														$is_days_after_lapse = false;
													}
												}

												if( $is_days_after_lapse ){
													$debug_con = "Yes";
												}else{
													$debug_con = "False";
												}				

												$time_from = strtotime(date('h:i A', $smtp_email['allowed_time_send_from']));
				                                $time_to   = strtotime(date('h:i A', $smtp_email['allowed_time_send_to']));

				                                $time_today   = strtotime(date("h:i A"));

				                                if(($time_today >= $time_from) && ($time_today <= $time_to) ){
													echo "send now";
												}

												if($day == "Monday" && $email['is_mon']==1 && $is_days_after_lapse==true){
													//unset($send);
													if(($time_today >= $time_from) && ($time_today <= $time_to) ){
														$send = 1;
													}
												}
												if($day == "Tuesday" && $email['is_tues']==1 && $is_days_after_lapse==true){
													//unset($send);	
													if(($time_today >= $time_from) && ($time_today <= $time_to) ){
														$send = 1;
													}
												}
												if($day == "Wednesday" && $email['is_wed']==1 && $is_days_after_lapse==true){
													//unset($send);
													if(($time_today >= $time_from) && ($time_today <= $time_to) ){
														$send = 1;
													}
												}
												if($day == "Thursday" && $email['is_thur']==1 && $is_days_after_lapse==true){
													//unset($send);
													if(($time_today >= $time_from) && ($time_today <= $time_to) ){
														$send = 1;
													}
												}
												if($day == "Friday" && $email['is_fri']==1 && $is_days_after_lapse==true){
													//unset($send);
													if(($time_today >= $time_from) && ($time_today <= $time_to) ){
														$send = 1;
													}
												}
												if($day == "Saturday" && $email['is_sat']==1 && $is_days_after_lapse==true){
													//unset($send);
													if(($time_today >= $time_from) && ($time_today <= $time_to) ){
														$send = 1;
													}
												}
												if($day == "Sunday" && $email['is_sun']==1 && $is_days_after_lapse==true){
													//unset($send);
													if(($time_today >= $time_from) && ($time_today <= $time_to) ){
														$send = 1;
													}
												}

											
												$trigger_identifier = base64_encode($emails[$email_number]['subject'].'-' . $emails[$email_number]['email_number'].'-' . $contact['id'].'-' . $emails[$email_number]['trigger'].'-' . $campaign['id']);
												switch ($email['trigger']) {
													case 'no_condition':
													    //check if trigger email no condition
													    //if($time_passed)
													    //{
													    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
													    	$sent->execute(array($identifier));
													    	/*if($sent->rowcount()<1){
													    		$send = 1;
													    	}*/
													    	if($sent->rowcount()>0){
													    		$send = 0;
													    	}
													    //}
														break;	
													case 'opened':
													    //check if trigger email was opened
													    //if($time_passed && $trigger_email['opened'] == 1)
														if($trigger_email['opened'] == 1)
													    {
													    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
													    	$sent->execute(array($identifier));
													    	if($sent->rowcount()>0)
													    	{
													    		 $send = 0;
													    	}
													    }
														break;
													case 'unopened':
													    //check if trigger email was not opened
													    if($trigger_email['opened'] == 0)
													    {
													    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
													    	$sent->execute(array($identifier));
													    	if($sent->rowcount()>0)
													    	{
													    		$send = 0;
		
													    	}
													    }
														break;
													case 'has_click':
													    $links = $pdo->prepare('SELECT * FROM `links_clicked` WHERE `identifier`=? AND `link`=?');
													    $links->execute(array($trigger_identifier, $email['link']));
													    //if($links->rowcount()>0 && $time_passed)
													    if($links->rowcount()>0)
													    {
													    	$send = 1;
													    }
														break;
												}
											}
											else
											{
												//email is based on a date and time
												switch ($email['trigger']) {
													case 'no_condition':
													    //check if trigger email no condition
													    if($email['time']<time())
													    {
													    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
													    	$sent->execute(array($identifier));
													    	if($sent->rowcount()<1)
													    	{
													    		$send = 1;
													    	}
													    }
														break;	
													case 'opened':
													    //check if trigger email was opened
													    if($email['time']<time() && $trigger_email['opened'] == 1)
													    {
													    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
													    	$sent->execute(array($identifier));
													    	if($sent->rowcount()<1)
													    	{
													    		 $send = 1;
													    	}
													    }
														break;
													case 'unopened':
													    //check if trigger email was not opened
													    if($email['time']<time() && $trigger_email['opened'] == 0)
													    {
													    	$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
													    	$sent->execute(array($identifier));
													    	if($sent->rowcount()<1)
													    	{
													    		$send = 1;
													    	}
													    }
														break;
													case 'has_click':
													    $links = $pdo->prepare('SELECT * FROM `links_clicked` WHERE `identifier`=? AND `link`=?');
													    $links->execute(array($trigger_identifier, $email['link']));
													    if($links->rowcount()>0 && $email['time']<time())
													    {
													    	$send = 1;
													    }
														break;								
												}
											}
										}
									}

									// Sending of Email
									if( $is_first_email ){
										$send = 1;
										//echo "This is First Email Subject : " . $email['subject'] . "/" . $send . "<br />";
									}
									//echo "First Email Subject : " . $email['subject'] . "/" . $send . "<br />";
									if($send > 0)
									{
										echo "";

                                        $resultUnsubscribe = $pdo->prepare('SELECT email FROM `unsubscribed_emails` WHERE member_id = ? AND `email`=?');
                                        $resultUnsubscribe->execute(array($campaign['member_id'], trim($contact['email'])));


										 if ($resultUnsubscribe->rowcount() == 0) { //Must not send or create if in unsubscribed list
											
													//Must not send if in exclusion list
													$email_domain_name = substr(strrchr($contact['email'], "@"), 1);
													if( !in_array(strtolower($contact['email']), $exclusion_emails) && !in_array(strtolower($email_domain_name), $exclusion_domains) ){
														//email sending
														$smtp = $pdo->prepare('SELECT * FROM `smtp` WHERE active = 1 AND `id`=?');
														$smtp->execute(array($email['send_id']));
														$smtp = $smtp->fetch(PDO::FETCH_ASSOC);

														$send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>? AND `is_verified`=?');
														$send_limit->execute(array($smtp['from_email'], time()-86400,0));

														if($smtp['sending_limit_per_day'] == 0)
														{
															$smtp['sending_limit_per_day'] = $send_limit->rowcount()+1;
														}
														//$smtp['send_limit'] = 10000;
														echo " <br /> Current Limit: ". $send_limit->rowcount();
														echo " <br /> Email Limit :" . $smtp['sending_limit_per_day'];


														if(!empty($smtp['from_email']) && $send_limit->rowcount()<$smtp['sending_limit_per_day'])
														{

															if (empty($email['body']))
															{
																echo 'Message not sent! Body empty: Identifier: ' . $identifier . " Subject: " . $email['subject'];

															}
															else
															{
																$sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
														    	$sent->execute(array($identifier));
														    	if($sent->rowcount()<1)
														    	{

														    		$pause_campaign =  $pdo->prepare('SELECT * FROM `excluded_campaign_recipients` WHERE `campaign_id`=? AND `contact_id`=? ');
														    	    $pause_campaign->execute(array($campaign['id'],$contact['id'])); 
														    	    if($pause_campaign->rowcount()<1){

																		$sender = CronHelper::cronSmtpMailer($smtp,$email,$campaign,$contact,$identifier,$mail_footer);
																		if (!$sender)
																		{
																			echo 'Mail Not sent Identifier: ' . $identifier . " " . $mail->ErrorInfo . "<br>";
																			$smtp_word = "smtp";

																			$error_string = "SMTP Account " . $smtp['user']. " Email Authentication failed - Please check your email SMTP settings or password - " . $mail->ErrorInfo;

																			$check_error_send =  $pdo->prepare('SELECT * FROM `notifications` WHERE `member_id`=? AND `module`=? AND `description`=? ');
																			$check_error_send->execute(array($campaign['member_id'],$smtp_word,$error_string)); 

																			if($check_error_send->rowcount()<1){
																				// TODO TRAP SMTP Connect errors mark account as in-active and add notification to system
																				 AddNotification("smtp", "SMTP Account " . $smtp['user']. " Email Authentication failed - Please check your email SMTP settings or password - " . $mail->ErrorInfo,$campaign['member_id']);
																			}
																		}else{
																			// Mark as sent...
																			$sent = $pdo->prepare('INSERT INTO `sent_mails` (`campaign_id`, `subject`, `from_email`, `to_contact`, `to_email`, `opened`, `replied`, `last_activity`, `identifier`, `member_id`, `id`, `sent_date`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)');
																			$mail->ClearAllRecipients();
																			$sent->execute(array($campaign['id'], $email['subject'], $smtp['from_email'], $contact['id'], $contact['email'], 0, 0, time(), $identifier, $campaign['member_id'], NULL, time()));
																			$xsend++;
																		}
																	}
																}	

															}

															

														}else{
															$campaign_sending_done = false;
														}
													}
										}
									}
									echo "<br /> campaign id ". $campaign['id'];
									
								} // limit the sent per campaign	
								$i++;
							} //end of email 
						} // end of loop through contacts again 
					} // end of trigger date
				} // checker if the last send is Time between email sends 	

			} // end of the campaign loop

		} // end of the smtp loop
	} //end check if has smtp


} // end of the member


//Check if the email has been sent to the campaign to complate the campaign
$campaigns_details = $pdo->prepare('SELECT * FROM `campaigns` WHERE status=?');
$campaigns_details->execute(array(1));
if( $campaigns_details->rowcount()>1){ 
	foreach ($campaigns_details as $key => $campaigns_detail) {
		$campaign_count = 0;
		$emails = json_decode($campaigns_detail['data'], 1);
		if(isset($emails)){
		    foreach ($emails as $email) {
		   		$campaign_count++;
		    } 
		}    
	    if( $campaign_count == 1 ){
	    	$contacts_verify = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? AND (status=?)');
			$contacts_verify->execute(array($campaigns_detail['list'],1));
	    	$campaign_sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=?');
			$campaign_sent->execute(array($campaigns_detail['id']));
			if($campaign_sent->rowcount() >= $contacts_verify->rowcount()){
		    	$sql = "UPDATE campaigns SET status=? WHERE id=?";
				$q = $pdo->prepare($sql);
				$q->execute(array(4, $campaigns_detail['id']));
				echo " <br /> single campaign id: " .  $campaigns_detail['id'];
			}	
	    }elseif($campaign_count > 1){
	 		$contacts_verify = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? AND (status=?)');
			$contacts_verify->execute(array($campaigns_detail['list'],1));
			$contact_count = $contacts_verify->rowcount();	
			$total_contact_to_send = $campaign_count * $contact_count;
	    	$campaign_sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=?');
			$campaign_sent->execute(array($campaigns_detail['id']));
			if($campaign_sent->rowcount() >= $total_contact_to_send){
		        $sql = "UPDATE campaigns SET status=? WHERE id=?";
				$q = $pdo->prepare($sql);
				$q->execute(array(4, $campaigns_detail['id']));
				echo " <br /> multi drip campaign id: " .  $campaigns_detail['id'];
			}	
	    }
	}
}


//exit();
$time_end = microtime(true);
$time = $time_end - $script_time_start;

echo ' End Cron Send - Time Taken: ' . $time . '<br>';
?>