<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PhpImap\Mailbox;
use PhpImap\Exceptions\ConnectionException;

define("IN_CRONTAB", 1);
require_once dirname(__FILE__) . '/config.php';
require_once dirname(__FILE__) . '/functions.php';
require_once dirname(__FILE__) . '/nylas_helper.php';
require_once dirname(__FILE__) . '/PHPMailer/autoload.php';
require_once dirname(__FILE__) . '/Google/autoload.php';
require_once dirname(__FILE__) . '/swiftmailer/autoload.php';
require_once dirname(__FILE__) . '/php-imap/autoload.php';
require_once dirname(__FILE__) . '/helper/cron_helper.php';
require_once dirname(__FILE__) . '/vendor/autoload.php'; //added for raabitmq

use PhpAmqpLib\Connection\AMQPStreamConnection; //added for raabitmq
use PhpAmqpLib\Exchange\AMQPExchangeType; //added for raabitmq
use PhpAmqpLib\Message\AMQPMessage; //added for raabitmq

error_reporting(E_ALL);
ini_set('display_errors', 1);
//set_time_limit(900);
set_time_limit(0);
error_log(date("m-d-Y, g:i:s a") . 'Start Cron Send' .  "\n" ,3,'logs/smtp_cron.txt');
echo 'Running Cron Send';
flush();

$script_time_start = microtime(true);
$mail = new PHPMailer();
$mail->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;

/*$data = $pdo->prepare('SELECT `id`, `cron_module`,`last_id_checked`,`last_activity` FROM `cron_last_activities` WHERE `cron_module`="send_mail"');
$data->execute();
$cron = $data->fetch(PDO::FETCH_ASSOC);
$last_id_checked = $cron['last_id_checked'];*/

//Load per active Members
//$members = $pdo->prepare('SELECT m.id, m.fname, m.lname, m.timezone FROM (`members` as m)
// LEFT JOIN nylas_smtp as s ON (s.member_id = m.id) WHERE m.status = 1 AND s.active = 1 group by s.member_id');
//$members->execute();

//$members = $pdo->prepare('SELECT m.id, m.fname, m.lname, m.timezone, m.parent_id, m.unsubscribe_link, m.text_to_display FROM (`members` as m) WHERE m.status = 1 AND m.stripe_status = "active" AND `id` >= ? LIMIT 1000');
$members = $pdo->prepare('SELECT m.id, m.fname, m.lname, m.timezone, m.parent_id, m.unsubscribe_link, m.text_to_display FROM (`members` as m) WHERE m.status = 1');
//$members = $pdo->prepare('SELECT m.id, m.fname, m.lname, m.timezone, m.parent_id, m.unsubscribe_link, m.text_to_display FROM (`members` as m) WHERE m.status = 1 AND `id` >= ? LIMIT 1000');
//$members->execute(array($last_id_checked));
$members->execute();

foreach ($members as $keyMember => $member) {
    //set timzone to the member's timezone

    /*added later on*/
    /*$last_id_checked = $member['id'];

    if($last_id_checked == $cron['last_id_checked']){
        $q = $pdo->prepare('UPDATE `cron_last_activities` SET `last_id_checked`=?, `last_activity`=? WHERE `cron_module`="send_mail"');
        $result = $q->execute(array(0,time()));
    }else{
        if($last_id_checked > 0){
            $q = $pdo->prepare('UPDATE `cron_last_activities` SET `last_id_checked`=?, `last_activity`=? WHERE `cron_module`="send_mail"');
            $result = $q->execute(array($last_id_checked,time()));
        }
    }*/
    /*end*/

    if( $member['parent_id'] > 0 ){
        $smtp_member_id = $member['parent_id'];
    }else{
        $smtp_member_id = $member['id'];
    }

    echo "<br /><br /> Member: " . $member['fname'] . " " . $member['lname'];
    //echo "<br /> Timezone: " . $member['timezone'] ;
    date_default_timezone_set($member['timezone']);
    $day = date("l");

    // Load each smtp accounts
    /*$smtp_emails = $pdo->prepare('SELECT * FROM `nylas_smtp` WHERE active = 1 AND  `member_id`=?');
    $smtp_emails->execute(array($member['id']));*/

    $smtp_emails = $pdo->prepare('SELECT * FROM `nylas_smtp` WHERE active = 1 AND  `member_id`=?');
    $smtp_emails->execute(array($smtp_member_id));

    if ($smtp_emails->rowcount() > 0) {
        // get per email settings
        foreach ($smtp_emails as $keySMTP => $smtp_email) {

            //$sending_account = "smtp:" . $smtp_email['id'];
            $sending_account = $smtp_email['smtp_type'] .":". $smtp_email['id'];
            //get today running campaigns
            $campaign_sending_done = true;
            /*$campaigns = $pdo->prepare('SELECT * FROM `campaigns` WHERE `status`=? AND `member_id`=? AND `sending_account`=?');
            $campaigns->execute(array(CAMPAIGN_STATUS_RUNNING, $member['id'], $sending_account));*/
            //added by jen for pending campaign stuff
            $campaigns = $pdo->prepare('SELECT * FROM `campaigns` WHERE `status` IN (?,?) AND `member_id`=? AND `sending_account`=?');
            $campaigns->execute(array(CAMPAIGN_STATUS_RUNNING,CAMPAIGN_STATUS_PENDING , $member['id'], $sending_account));
            //end

            $total_campaign = $campaigns->rowcount();
            echo "<br /> Sending Account: " . $sending_account;
            echo "<br /> SMTP";
            echo "<br /> Timezone: " . $member['timezone'];
            echo "<br /> Member ID: " . $member['id'];
            echo "<br /> Total campaigns: " . $total_campaign;
            echo "<br /> Allowed Sending time From : " . date('h:i A', $smtp_email['allowed_time_send_from']);
            echo "<br /> Allowed Sending time To : " . date('h:i A', $smtp_email['allowed_time_send_to']);
            echo "<br /> email sending limit per day : " . $smtp_email['sending_limit_per_day'];
            echo "<br /> interval per blast: " . $smtp_email['time_between_email_send'];
            echo "<br /> email sent per blast: " . $smtp_email['max_email_per_time'];

            if ($total_campaign == 0) {
                $allowed_per_campaign_email = 0;
            } else {
                $allowed_per_campaign_email = $smtp_email['max_email_per_time'] / $total_campaign;
                if ($allowed_per_campaign_email < 1) {
                    $allowed_per_campaign_email = 1;
                }
            }
            echo "<br /> Per campaign email sent : " . $allowed_per_campaign_email;

            $time_today = strtotime(date("h:i A"));
            echo " <br />  Time now: " . date('h:i A', $time_today);

            $time_from = $smtp_email['allowed_time_send_from'];
            $time_to = $smtp_email['allowed_time_send_to'];
            if ($time_from <= $time_today && $time_to >= $time_today) {
                echo "send now";
            }

            $send_limit = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
            $send_limit->execute(array($smtp_email['email'], time() - 86400));


            //$smtp['send_limit'] = 10000;
            echo " <br /> Current Limit: " . $send_limit->rowcount();
            echo " <br /> Email Limit :" . $smtp_email['send_limit'];

            echo "<pre>";
            //  print_r($smtp_email);
            echo "</pre>";
            flush();

            //loop through each campaign
            foreach ($campaigns as $campaign) {

                //if ($campaign['id'] == 572) { //need to change by vishal
                //if (in_array($campaign['id'], $allow_campaign_ids)){ //need to change by vishal
                if ($campaign['id'] >= START_CAMPAIGN_ID) { //need to change by vishal also need to change on live

                    // This will check the interval per send must be higher than the set time between email
                    $last_sents = $pdo->prepare('SELECT id,last_activity FROM `sent_mails` WHERE `campaign_id`=? ORDER BY last_activity DESC LIMIT 1');
                    $last_sents->execute(array($campaign['id']));
                    echo "<br /> Campaign id:" . $campaign['id'];

                    if ($last_sents->rowcount() >= 1) {

                        foreach ($last_sents as $keyLastSent => $last_sent) {
                            $diff_time = (strtotime(date("Y/m/d H:i:s")) - $last_sent['last_activity']) / 60;
                        }

                        echo '-->'.$diff_time*60;echo '-->'.($smtp_email['time_between_email_send']/$allowed_per_campaign_email) * 60;echo '--><br>';

                        //if ($diff_time > $smtp_email['time_between_email_send']) { //change due to send limit issue on 23-jan-2021 by vishal
                        if (($diff_time * 60) >= ( ($smtp_email['time_between_email_send']/$allowed_per_campaign_email) * 60)) { //compare in seconds
                            $batch_send = true;
                        } else {
                            $batch_send = false;
                        }
                    } else {
                        echo "New Campaign";
                        $batch_send = true;
                    }

                    if ($batch_send) {

                        // this will reset send counts
                        //$xsend = 0; //change due to send limit issue on 23-jan-2021 by vishal
                        $xsend = 1;

                        //exclusions
                        $exclusions = $pdo->prepare('SELECT * FROM `exclusions` WHERE `member_id`=?');
                        $exclusions->execute(array($member['id']));

                        $exclusion_emails = array();
                        $exclusion_domains = array();
                        foreach ($exclusions as $ex) {
                            $s_exclusion = strtolower($ex['exclusion']);
                            if ($ex['type'] == exclusionEmail()) {
                                $exclusion_emails[$s_exclusion] = $s_exclusion;
                            } else {
                                $exclusion_domains[$s_exclusion] = $s_exclusion;
                            }
                        }

                        $date_today = strtotime(date("m/d/Y h:i A"));
                        $trigger_date = $campaign['trigger_date'];

                        echo " <br />Date time today:  " . date('m/d/Y h:i A', $date_today);
                        echo " <br /> Trigger date:  " . date('m/d/Y h:i A', $trigger_date);

                        if ($trigger_date <= $date_today) {

                            //check if campaign stop has JSON
                            if (isJSON($campaign['stop_at'])) {
                                $stop_at = json_decode($campaign['stop_at'], 1);
                            } else {
                                $stop_at = array();
                                $stop_at['type'] = $campaign['stop_at'];
                            }


                            //select all contacts for this campaign
                            $contacts = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? AND (status=? OR status=?)');
                            $contacts->execute(array($campaign['list'], 1, 0));
                            $contacts = $contacts->fetchAll();

                            //loop through all contacts
                            foreach ($contacts as $key => $contact) {

                                //bounce list if mail already sent drip 1 so will not need to send it to drip 2..added on 29-apr-21
                                $consider_bounce = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `campaign_id`=? AND `to_email`=? AND `bounced`=1 LIMIT 1');
                                $consider_bounce->execute(array($campaign['id'], $contact['email']));
                                //$consider_bounce_data = $consider_bounce->fetch(PDO::FETCH_ASSOC);
                                if ($consider_bounce->rowcount() > 0) {
                                    unset($contacts[$key]);
                                }
                                //end

                                //remove contact if they replied to an email on this campaign
                                if ($stop_at['type'] == 'reply') {
                                    $replied = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `campaign_id`=? AND `to_email`=? AND `replied`=1 LIMIT 1');
                                    $replied->execute(array($campaign['id'], $contact['email']));
                                    $replies = $replied->fetch(PDO::FETCH_ASSOC);
                                    if ($replied->rowcount() > 0) {
                                        //Replies with Stop Automation will be removed on the list
                                        $reply_data = $pdo->prepare('SELECT * FROM `auto_replies` WHERE `sent_mail_id`=?  LIMIT 1');
                                        $reply_data->execute(array($replies['id']));
                                        $sent_mail = $reply_data->fetch(PDO::FETCH_ASSOC);
                                        if ($sent_mail['status'] == 1) {
                                            unset($contacts[$key]);
                                        }// if the status is set to 0 = Continue Automation it will not be unset on the list

                                        //if the sent mail has no record on the auto replies it will be unset on the list
                                        if ($reply_data->rowcount() <= 0) {
                                            unset($contacts[$key]);
                                        }

                                        //Opener with Stop status will be removed on the list
                                        $opener_data = $pdo->prepare('SELECT * FROM `opener_stop_sending` WHERE `campaign_id`=? AND `email`=? LIMIT 1');
                                        $opener_data->execute(array($campaign['id'], $contact['email']));
                                        $opener_data_mail = $opener_data->fetch(PDO::FETCH_ASSOC);
                                        if ($opener_data->rowcount() == 1) {
                                            unset($contacts[$key]);
                                        }

                                    }
                                }
                            }

                            //get emails for this campaign
                            $emails = json_decode($campaign['data'], 1);

                            // Old slow
                            //$eid  = crypt_jm($campaign['id']);
                            $eid = sha1($campaign['id'] . SITE_ENCRYPTION_KEY);
                            //loop through contacts again
                            foreach ($contacts as $contact) {

                                //remove spaces from contact email
                                $contact['email'] = trim($contact['email']);

                                $i = 0;


                                //loop through email
                                foreach ($emails as $email) {
                                    $email['body'] = linkify($email['body']);
                                    // set limit the sent per campaign
                                    echo "<br />  Allowed: " . $allowed_per_campaign_email . " - " . $xsend;
                                    //if ($xsend <= $allowed_per_campaign_email) { //change due to send limit issue on 23-jan-2021 by vishal
                                    if ($xsend <= 1) { //this is due to mail send not at a time. we need to send mail one by one interval.
                                        echo " Send counter " . $xsend;
                                        unset($send);
                                        $send = 0;
                                        $mail_footer = "";
                                        //generate a unique identifier for this email and contact
                                        $identifier = base64_encode($email['subject'] . '-' . $email['email_number'] . '-' . $contact['id'] . '-' . $email['trigger'] . '-' . $campaign['id']);
                                        //mail footer unsubscribe

                                        $link = AUTOMAILER_TRACKER_URL . "/_unsubscribe.php?email=" . $contact['email'] . "&campaign=" . $campaign['id'] . "&eid=" . $eid;
                                        //$mail_footer = "<br /><br /><a href='" . $link . "'>Unsubscribe</a><br />";

                                        /*if($member['unsubscribe_link'] == 1){
                                            $mail_footer = "<br /><br /><a href='" . $link . "'>Unsubscribe</a><br />";
                                        }*/

                                        if($member['unsubscribe_link'] == 1){
                                            if($campaign['unsubscribe_link'] == 1){
                                                if($member['text_to_display'] == NULL){
                                                    if($campaign['text_to_display'] != NULL){
                                                        $mail_footer = "<br /><br /><a href='" . $link . "'>". $campaign['text_to_display'] . "</a><br />";
                                                    }else{
                                                        $mail_footer = "<br /><br /><a href='" . $link . "'>Unsubscribe</a><br />";
                                                    }
                                                }else{
                                                    if($member['text_to_display'] !=""){
                                                        if($campaign['text_to_display'] != NULL){
                                                            $mail_footer = "<br /><br /><a href='" . $link . "'>". $campaign['text_to_display'] . "</a><br />";
                                                        }else{
                                                            $mail_footer = "<br /><br /><a href='" . $link . "'>". $member['text_to_display'] . "</a><br />";
                                                        }
                                                    }else{
                                                        if($campaign['text_to_display'] != NULL){
                                                            $mail_footer = "<br /><br /><a href='" . $link . "'>". $campaign['text_to_display'] . "</a><br />";
                                                        }else{
                                                            $mail_footer = "<br /><br /><a href='" . $link . "'>Unsubscribe</a><br />";
                                                        }
                                                    }
                                                }
                                            }
                                        }

                                        if($member['unsubscribe_link'] == 2){
                                            if($campaign['unsubscribe_link'] == 1){
                                                if($member['text_to_display'] == NULL){
                                                    if($campaign['text_to_display'] != NULL){
                                                        $mail_footer = "<br /><br /><a href='" . $link . "'>". $campaign['text_to_display'] . "</a><br />";
                                                    }else{
                                                        $mail_footer = "<br /><br /><a href='" . $link . "'>Unsubscribe</a><br />";
                                                    }
                                                }else{
                                                    if($member['text_to_display'] != ""){
                                                        if($campaign['text_to_display'] != NULL){
                                                            $mail_footer = "<br /><br /><a href='" . $link . "'>". $campaign['text_to_display'] . "</a><br />";
                                                        }else{
                                                            $mail_footer = "<br /><br /><a href='" . $link . "'>". $member['text_to_display'] . "</a><br />";
                                                        }
                                                    }else{
                                                        if($campaign['text_to_display'] != NULL){
                                                            $mail_footer = "<br /><br /><a href='" . $link . "'>". $campaign['text_to_display'] . "</a><br />";
                                                        }else{
                                                            $mail_footer = "<br /><br /><a href='" . $link . "'>Unsubscribe</a><br />";
                                                        }
                                                    }
                                                }
                                            }
                                        }

                                        //replace all links with a trackable redirect
                                        $email['body'] = str_replace(
                                            array(
                                                'href="http://',
                                                'href="https://'
                                            ),
                                            array(
                                                'target="_blank" href="' . AUTOMAILER_TRACKER_URL . '/_track_link.php?identifier=' . $identifier . '&link=http://',
                                                'target="_blank" href="' . AUTOMAILER_TRACKER_URL . '/_track_link.php?identifier=' . $identifier . '&link=https://'
                                            ),
                                            $email['body']
                                        );

                                        $email['body'] = str_replace(
                                            array(
                                                "href='http://",
                                                "href='https://"
                                            ),
                                            array(
                                                "target='_blank' href='" . AUTOMAILER_TRACKER_URL . "/_track_link.php?identifier=" . $identifier . "&link=http://",
                                                "target='_blank' href='" . AUTOMAILER_TRACKER_URL . "/_track_link.php?identifier=" . $identifier . "&link=https://"
                                            ),
                                            $email['body']
                                        );

                                        //replace all default tags with contact values in body of email
                                        $email['body'] = str_replace('{FirstName}', $contact['firstName'], $email['body']);
                                        $email['body'] = str_replace('{LastName}', $contact['lastName'], $email['body']);
                                        $email['body'] = str_replace('{Email}', $contact['email'], $email['body']);

                                        $email['body'] = str_replace('{firstName}', $contact['firstName'], $email['body']);
                                        $email['body'] = str_replace('{lastName}', $contact['lastName'], $email['body']);
                                        $email['body'] = str_replace('{email}', $contact['email'], $email['body']);

                                        if($member['unsubscribe_link'] == 1){
                                            if($campaign['unsubscribe_link'] == 1){
                                                if($member['text_to_display'] == NULL){
                                                    $unsubscribe_footer = "<br /><br /><a href='" . $link . "'>Unsubscribe</a><br />";
                                                }else{
                                                    if($member['text_to_display'] != ""){
                                                        $unsubscribe_footer = "<br /><br /><a href='" . $link . "'>". $member['text_to_display'] . "</a><br />";
                                                    }else{
                                                        $unsubscribe_footer = "<br /><br /><a href='" . $link . "'>Unsubscribe</a><br />";
                                                    }
                                                }
                                                $email['body'] = str_replace('{Unsubscribe}', $unsubscribe_footer, $email['body']);
                                            }
                                        }
                                        if($member['unsubscribe_link'] == 2){
                                            if($campaign['unsubscribe_link'] == 1){
                                                if($member['text_to_display'] == NULL){
                                                    $unsubscribe_footer = "<br /><br /><a href='" . $link . "'>Unsubscribe</a><br />";
                                                }else{
                                                    if($member['text_to_display'] != ""){
                                                        $unsubscribe_footer = "<br /><br /><a href='" . $link . "'>". $member['text_to_display'] . "</a><br />";
                                                    }else{
                                                        $unsubscribe_footer = "<br /><br /><a href='" . $link . "'>Unsubscribe</a><br />";
                                                    }
                                                }
                                                $email['body'] = str_replace('{Unsubscribe}', $unsubscribe_footer, $email['body']);
                                            }
                                        }

                                        //replace all default tags with contact values in subject of email
                                        $email['subject'] = str_replace('{FirstName}', $contact['firstName'], $email['subject']);
                                        $email['subject'] = str_replace('{LastName}', $contact['lastName'], $email['subject']);
                                        $email['subject'] = str_replace('{Email}', $contact['email'], $email['subject']);

                                        $email['subject'] = str_replace('{firstName}', $contact['firstName'], $email['subject']);
                                        $email['subject'] = str_replace('{lastName}', $contact['lastName'], $email['subject']);
                                        $email['subject'] = str_replace('{email}', $contact['email'], $email['subject']);

                                        //get custom tag names
                                        $tagData = json_decode($contact['data'], 1);

                                        //replace all custom tags with contact values in subject and body
                                        if (is_array($tagData)) {
                                            foreach ($tagData as $key => $value) {
                                                $email['body'] = str_replace('{' . $key . '}', $value, $email['body']);
                                                $email['subject'] = str_replace('{' . $key . '}', $value, $email['subject']);
                                            }
                                        }
                                        $is_first_email = false;
                                        echo '<br>'.'I value-->'.$i.'<br>';

                                        if ($i == 0) {
                                            //if first email, no trigger necessary
                                            $day = date("l");
                                            $sent = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `identifier`=?');
                                            $sent->execute(array($identifier));
                                            echo '<br>'.'identifier-->'.$identifier.'<br>';
                                            if ($sent->rowcount() < 1) {
                                                $time_from = strtotime(date('h:i A', $smtp_email['allowed_time_send_from']));
                                                $time_to = strtotime(date('h:i A', $smtp_email['allowed_time_send_to']));
                                                $time_today = strtotime(date("h:i A"));

                                                if ($day == "Monday" && $email['is_mon'] == 1) {
                                                    //unset($send);
                                                    if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                        $send = 1;
                                                    }
                                                }
                                                if ($day == "Tuesday" && $email['is_tues'] == 1) {
                                                    //unset($send);
                                                    if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                        $send = 1;
                                                    }
                                                }
                                                if ($day == "Wednesday" && $email['is_wed'] == 1) {
                                                    //unset($send);
                                                    if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                        $send = 1;
                                                    }
                                                }
                                                if ($day == "Thursday" && $email['is_thur'] == 1) {
                                                    //unset($send);
                                                    if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                        $send = 1;
                                                    }
                                                }
                                                if ($day == "Friday" && $email['is_fri'] == 1) {
                                                    //unset($send);
                                                    if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                        $send = 1;
                                                    }
                                                }
                                                if ($day == "Saturday" && $email['is_sat'] == 1) {
                                                    //unset($send);
                                                    if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                        $send = 1;
                                                    }
                                                }
                                                if ($day == "Sunday" && $email['is_sun'] == 1) {
                                                    //unset($send);
                                                    if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                        $send = 1;
                                                    }
                                                }

                                                if ($send == 1) {
                                                    $is_first_email = true;
                                                }
                                            }
                                        } else {
                                            //minus 1 from email number to match the email array
                                            $email_number = $email['email_number'] - 2;

                                            //get the trigger email identifier
                                            $trigger_identifier = base64_encode($emails[$email_number]['subject'] . '-' . $emails[$email_number]['email_number'] . '-' . $contact['id'] . '-' . $emails[$email_number]['trigger'] . '-' . $campaign['id']);
                                            /*echo "Trigger identifier : " . $trigger_identifier . "/" . $emails[$email_number]['subject'] . "/Campaign ID : " . $campaign['id'] . "/" . $emails[$email_number]['email_number'] . "/" . $emails[$email_number]['trigger'] . "/Current Subject : " . $email['subject'] . " / Identifier B : " . $identifier . "<br />";*/
                                            /*echo "<pre>";
                                            print_r($emails[$email_number]);*/
                                            //get the trigger email if it was sent
                                            $trigger_email = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
                                            $trigger_email->execute(array($trigger_identifier));
                                            if ($trigger_email->rowcount() > 0) {

                                                //get trigger email data
                                                $trigger_email = $trigger_email->fetch(PDO::FETCH_ASSOC);

                                                //added later for resume date or automation logic from lead tab & added for automation by vish
                                                $check_automation_email = $pdo->prepare('SELECT id,continue_automation,status,resume_date FROM `leads` WHERE `sent_mail_id`=?');
                                                $check_automation_email->execute(array($trigger_email['id']));

                                                $automation = 1;

                                                if ($check_automation_email->rowcount() > 0) {

                                                    $check_automation_email = $check_automation_email->fetch(PDO::FETCH_ASSOC);

                                                    if($check_automation_email['continue_automation'] == 0 && $check_automation_email['status'] == 3){
                                                        echo "<br />".'Goes to automation'. "<br />";
                                                        $automation = 0;
                                                    }else if($check_automation_email['continue_automation'] == 1 && $check_automation_email['status'] == 3 && $check_automation_email['resume_date'] >= time()){
                                                        echo "<br />".'Goes to automation'. "<br />";
                                                        $automation = 0;
                                                    }
                                                    //echo '-----'.$check_automation_email['resume_date'] .'-----'.time(). '--==='.$automation.'--->';
                                                    //echo '-->'.$automation.'-->'.$contact['email'];
                                                }
                                                //end

                                                if($automation) { //added for automation by vish
                                                    //check if email is based on days after
                                                    if (!empty($email['days_after']) && $email['days_after'] > 0) {
                                                        $time_passed = strtotime('+' . $email['days_after'] . ' days', $trigger_email['last_activity']) < time();

                                                        /* Validation for no send on the day */
                                                        $is_days_after_lapse = true;
                                                        $day = date("l");
                                                        if ($email['days_after'] > 0) {
                                                            //Base start date in last_activity date
                                                            $add_days = $email['days_after'];
                                                            $last_activity = date("Y-m-d", $trigger_email['last_activity']);
                                                            $expected_start = date("Y-m-d", strtotime($last_activity . " + {$add_days} days"));
                                                            if (strtotime($expected_start) > strtotime(date("Y-m-d"))) { //Validate if start date lapse the days after
                                                                $is_days_after_lapse = false;
                                                            }
                                                        }

                                                        if ($is_days_after_lapse) {
                                                            $debug_con = "Yes";
                                                        } else {
                                                            $debug_con = "False";
                                                        }

                                                        $time_from = strtotime(date('h:i A', $smtp_email['allowed_time_send_from']));
                                                        $time_to = strtotime(date('h:i A', $smtp_email['allowed_time_send_to']));

                                                        $time_today = strtotime(date("h:i A"));

                                                        if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                            echo "send now";
                                                        }

                                                        if ($day == "Monday" && $email['is_mon'] == 1 && $is_days_after_lapse == true) {
                                                            //unset($send);
                                                            if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                                $send = 1;
                                                            }
                                                        }
                                                        if ($day == "Tuesday" && $email['is_tues'] == 1 && $is_days_after_lapse == true) {
                                                            //unset($send);
                                                            if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                                $send = 1;
                                                            }
                                                        }
                                                        if ($day == "Wednesday" && $email['is_wed'] == 1 && $is_days_after_lapse == true) {
                                                            //unset($send);
                                                            if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                                $send = 1;
                                                            }
                                                        }
                                                        if ($day == "Thursday" && $email['is_thur'] == 1 && $is_days_after_lapse == true) {
                                                            //unset($send);
                                                            if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                                $send = 1;
                                                            }
                                                        }
                                                        if ($day == "Friday" && $email['is_fri'] == 1 && $is_days_after_lapse == true) {
                                                            //unset($send);
                                                            if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                                $send = 1;
                                                            }
                                                        }
                                                        if ($day == "Saturday" && $email['is_sat'] == 1 && $is_days_after_lapse == true) {
                                                            //unset($send);
                                                            if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                                $send = 1;
                                                            }
                                                        }
                                                        if ($day == "Sunday" && $email['is_sun'] == 1 && $is_days_after_lapse == true) {
                                                            //unset($send);
                                                            if (($time_today >= $time_from) && ($time_today <= $time_to)) {
                                                                $send = 1;
                                                            }
                                                        }


                                                        $trigger_identifier = base64_encode($emails[$email_number]['subject'] . '-' . $emails[$email_number]['email_number'] . '-' . $contact['id'] . '-' . $emails[$email_number]['trigger'] . '-' . $campaign['id']);
                                                        switch ($email['trigger']) {
                                                            case 'no_condition':
                                                                //check if trigger email no condition
                                                                //if($time_passed)
                                                                //{
                                                                $sent = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `identifier`=?');
                                                                $sent->execute(array($identifier));
                                                                /*if($sent->rowcount()<1){
                                                                    $send = 1;
                                                                }*/
                                                                if ($sent->rowcount() > 0) {
                                                                    $send = 0;
                                                                }
                                                                //}
                                                                break;
                                                            case 'opened':
                                                                //check if trigger email was opened
                                                                //if($time_passed && $trigger_email['opened'] == 1)
                                                                if ($trigger_email['opened'] == 1) {
                                                                    $sent = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `identifier`=?');
                                                                    $sent->execute(array($identifier));
                                                                    if ($sent->rowcount() > 0) {
                                                                        $send = 0;
                                                                    }
                                                                }
                                                                break;
                                                            case 'unopened':
                                                                //check if trigger email was not opened
                                                                if ($trigger_email['opened'] == 0) {
                                                                    $sent = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `identifier`=?');
                                                                    $sent->execute(array($identifier));
                                                                    if ($sent->rowcount() > 0) {
                                                                        $send = 0;

                                                                    }
                                                                }
                                                                break;
                                                            case 'has_click':
                                                                $links = $pdo->prepare('SELECT id FROM `links_clicked` WHERE `identifier`=? AND `link`=?');
                                                                $links->execute(array($trigger_identifier, $email['link']));
                                                                //if($links->rowcount()>0 && $time_passed)
                                                                if ($links->rowcount() > 0) {
                                                                    $send = 1;
                                                                }
                                                                break;
                                                        }
                                                    } else {
                                                        //email is based on a date and time
                                                        switch ($email['trigger']) {
                                                            case 'no_condition':
                                                                //check if trigger email no condition
                                                                if ($email['time'] < time()) {
                                                                    $sent = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `identifier`=?');
                                                                    $sent->execute(array($identifier));
                                                                    if ($sent->rowcount() < 1) {
                                                                        $send = 1;
                                                                    }
                                                                }
                                                                break;
                                                            case 'opened':
                                                                //check if trigger email was opened
                                                                if ($email['time'] < time() && $trigger_email['opened'] == 1) {
                                                                    $sent = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `identifier`=?');
                                                                    $sent->execute(array($identifier));
                                                                    if ($sent->rowcount() < 1) {
                                                                        $send = 1;
                                                                    }
                                                                }
                                                                break;
                                                            case 'unopened':
                                                                //check if trigger email was not opened
                                                                if ($email['time'] < time() && $trigger_email['opened'] == 0) {
                                                                    $sent = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `identifier`=?');
                                                                    $sent->execute(array($identifier));
                                                                    if ($sent->rowcount() < 1) {
                                                                        $send = 1;
                                                                    }
                                                                }
                                                                break;
                                                            case 'has_click':
                                                                $links = $pdo->prepare('SELECT id FROM `links_clicked` WHERE `identifier`=? AND `link`=?');
                                                                $links->execute(array($trigger_identifier, $email['link']));
                                                                if ($links->rowcount() > 0 && $email['time'] < time()) {
                                                                    $send = 1;
                                                                }
                                                                break;
                                                        }
                                                    }
                                                } //end and added for automation by vish
                                            }
                                        }

                                        // Sending of Email
                                        if ($is_first_email) {
                                            $send = 1;
                                            //echo "This is First Email Subject : " . $email['subject'] . "/" . $send . "<br />";
                                        }

                                        echo "<br />First Email Subject : " . $email['subject'] . "/" . $send . "<br />";
                                        if ($send > 0) {
                                            $resultUnsubscribe = $pdo->prepare('SELECT email FROM `unsubscribed_emails` WHERE member_id = ? AND `email`=?');
                                            $resultUnsubscribe->execute(array($campaign['member_id'], trim($contact['email'])));


                                            if ($resultUnsubscribe->rowcount() == 0) { //Must not send or create if in unsubscribed list

                                                //This will check/remove email if in the global bounce list
                                                $global_bounce_list = $pdo->prepare('SELECT id FROM `global_bounce_list` WHERE `bounce_email`=? LIMIT 1');
                                                $global_bounce_list->execute(array($contact['email']));

                                                if ($global_bounce_list->rowcount() == 0) {

                                                    //Must not send if in exclusion list
                                                    $email_domain_name = substr(strrchr($contact['email'], "@"), 1);
                                                    if (!in_array(strtolower($contact['email']), $exclusion_emails) && !in_array(strtolower($email_domain_name), $exclusion_domains)) {
                                                        //email sending
                                                        $smtp = $pdo->prepare('SELECT * FROM `nylas_smtp` WHERE active = 1 AND `id`=?');
                                                        // list($send_type, $send_id) = explode(':', $email['send_id']); //added by vishal on 12-nov-2020
                                                        if (strpos($email['send_id'], ':') !== false) {
                                                            $exp_str = explode(':',$email['send_id']);
                                                            $smtp->execute(array($exp_str[1]));
                                                        }else {
                                                            $smtp->execute(array($email['send_id']));
                                                        }
                                                        $smtp = $smtp->fetch(PDO::FETCH_ASSOC);

                                                        $send_limit = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>? AND `is_verified`=?');
                                                        $send_limit->execute(array($smtp['email'], time() - 86400, 0));

                                                        if ($smtp['sending_limit_per_day'] == 0) {
                                                            $smtp['sending_limit_per_day'] = $send_limit->rowcount() + 1;
                                                        }
                                                        //$smtp['send_limit'] = 10000;
                                                        echo " <br /> Current Limit: " . $send_limit->rowcount();
                                                        echo " <br /> Email Limit :" . $smtp['sending_limit_per_day'];


                                                        if (!empty($smtp['email']) && $send_limit->rowcount() < $smtp['sending_limit_per_day']) {

                                                            if (empty($email['body'])) {
                                                                echo 'Message not sent! Body empty: Identifier: ' . $identifier . " Subject: " . $email['subject'];

                                                            } else {

                                                                echo "<br /> Message going start sending now";


                                                                $sent = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `identifier`=?');
                                                                $sent->execute(array($identifier));
                                                                if ($sent->rowcount() < 1) {


                                                                    echo "<pre>";
                                                                    print_r($smtp);
                                                                    echo $contact['email'];
                                                                    echo "</pre>";
                                                                    
                                                                  //  exit();
                                                                   
                                                                //  $sender = CronHelper::cronSmtpMailer($smtp, $email, $campaign, $contact, $identifier, $mail_footer);
                                                                 //  $sender = CronHelper::cronSmtpMailer($smtp, $email, $campaign, $contact, $identifier, $mail_footer);
                                                                    /*$mail = new PHPMailer();
                                                                    $mail->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;
                                                                    $mail->IsSMTP();
                                                                    $mail->Host = $smtp['server'];
                                                                    $mail->SMTPAuth = true;
                                                                    $mail->Username = $smtp['username'];
                                                                    $mail->Password = crypt_jm($smtp['password'], 'd');
                                                                    $mail->Port = $smtp['port'];
                                                                    if ($smtp['usessltls'] == 1) {
                                                                        if ($smtp['port'] == 465) {
                                                                            $mail->SMTPSecure = "ssl";
                                                                        }
                                                                        if ($smtp['port'] == 587) {
                                                                            $mail->SMTPSecure = "tls";
                                                                        }
                                                                    }
                                                                    $mail->IsHTML(true);
                                                                    $mail->setFrom($smtp['email']);
                                                                    $mail->FromName = $smtp['name'];
                                                                    $mail->addCustomHeader('In-Reply-To', $identifier);
                                                                    $mail->AddAddress($contact['email']);
                                                                    if (!empty($campaign['bcc'])) {
                                                                        $mail->addBcc($campaign['bcc']);
                                                                    }
                                                                    $mail->Subject = $email['subject'];
                                                                    $message = $email['body'];
                                                                    $message = $message . $mail_footer . ' <img src="' . AUTOMAILER_TRACKER_URL . '/_track.php?id=' . $identifier . '" alt="" />';
                                                                    $mail->Body = $message;
                                                                    $mail->AltBody = strip_tags($message);
                                                                    $sender = $mail->Send();*/
                                                                    $message = $email['body'];
                                                                    $message = $message . $mail_footer . ' <img src="' . AUTOMAILER_TRACKER_URL . '/_track.php?id=' . $identifier . '" alt="" />';
                                                                    $subject = $email['subject'];
                                                                    $message = $message;
                                                                    $to   = array();
                                                                    $bcc  = array();
                                                                    $to[] = ['email' => $contact['email'], 'name' => $contact['email']];
                                                                    if (!empty($campaign['bcc'])) {
                                                                        $bcc[] = ['email' => $campaign['bcc'], 'name' => $campaign['bcc']];
                                                                        $mail->addBcc($campaign['bcc']);
                                                                    }
                                                                    $nylasResult = nylasSendA($subject, $message, $to);

                                                                    if ($nylasResult['is_sent'] == 1) {
                                                                        echo  "<br /> Email sent";
                                                                         // Mark as sent...
                                                                        $sent = $pdo->prepare('INSERT INTO `sent_mails` (`campaign_id`, `subject`, `from_email`, `to_contact`, `to_email`, `opened`, `replied`, `last_activity`, `identifier`, `member_id`, `id`, `sent_date`, `nylas_response`, `email_number`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
                                                                        $mail->ClearAllRecipients();
                                                                        $sent->execute(array($campaign['id'], $email['subject'], $smtp['email'], $contact['id'], $contact['email'], 0, 0, time(), $identifier, $campaign['member_id'], NULL, time(), "", $email['email_number']));
                                                                        $xsend++;

                                                                        //Update campaign total sent
                                                                        $total_sent = $campaign['emails'] + 1;
                                                                        $q = $pdo->prepare('UPDATE `campaigns` SET `emails`=? WHERE `id`=? LIMIT 1');
                                                                        $q->execute(array($total_sent, $campaign['id']));
                                                                       
                                                                    } else {
                                                                         echo 'Mail Not sent Identifier: ' . $identifier . "<br>";

                                                                        $smtp_word = "smtp";

                                                                        $error_string = "SMTP Account " . $smtp['email']. " Email Authentication failed - Please check your email SMTP settings or password - ";

                                                                        $check_error_send =  $pdo->prepare('SELECT * FROM `notifications` WHERE `member_id`=? AND `module`=? AND `description`=? ');
                                                                        $check_error_send->execute(array($campaign['member_id'],$smtp_word,$error_string));

                                                                        if($check_error_send->rowcount()<1){
                                                                            // TODO TRAP SMTP Connect errors mark account as in-active and add notification to system
                                                                            AddNotification("smtp", "SMTP Account " . $smtp['email']. " Email Authentication failed - Please check your email SMTP settings or password - " . $mail->message,$campaign['member_id']);
                                                                        }

                                                                        // TODO TRAP SMTP Connect errors mark account as in-active and add notification to system
                                                                        //AddNotification("smtp", "SMTP Account " . $smtp['email'] . " Email Authentication failed - Please check your email SMTP settings or password - " . $sender->message, $campaign['member_id']);
                                                                       
                                                                    }
                                                                }

                                                            }


                                                        } else {
                                                            echo "<br /> Not going to send email for this campaign " . $campaign['id'];
                                                            $campaign_sending_done = false;
                                                        }
                                                    }
                                                } // End of global bounce list
                                            }
                                        }
                                        echo "<br /> campaign id " . $campaign['id'];

                                    } // limit the sent per campaign
                                    $i++;
                                } //end of email
                            } // end of loop through contacts again
                        } // end of trigger date
                    } // checker if the last send is Time between email sends

                } // end of the campaign loop
            }

        } // end of the smtp loop
    } //end check if has smtp


} // end of the member

//Check if the email has been sent to the campaign to complate the campaign
$campaigns_details = $pdo->prepare('SELECT id,list,data FROM `campaigns` WHERE status=?');
$campaigns_details->execute(array(1));
if ($campaigns_details->rowcount() > 1) {
    foreach ($campaigns_details as $key => $campaigns_detail) {
        $campaign_count = 0;
        $emails = json_decode($campaigns_detail['data'], 1);
        if (isset($emails)) {
            foreach ($emails as $email) {
                $campaign_count++;
            }
        }
        if ($campaign_count == 1) {
            $contacts_verify = $pdo->prepare('SELECT count(*) as total  FROM `contacts` WHERE `list_id`=? AND (status=?)');
            $contacts_verify->execute(array($campaigns_detail['list'], 1));
            $contacts_verifyTotal =  $contacts_verify->fetch(PDO::FETCH_ASSOC);

            $campaign_sent = $pdo->prepare('SELECT count(*) as total  FROM `sent_mails` WHERE `campaign_id`=?');
            $campaign_sent->execute(array($campaigns_detail['id']));
            $campaign_sentTotal =  $campaign_sent->fetch(PDO::FETCH_ASSOC);

            if ($campaign_sentTotal['total'] >= $contacts_verifyTotal['total']) {
                $sql = "UPDATE campaigns SET status=? WHERE id=?";
                $q = $pdo->prepare($sql);
                $q->execute(array(4, $campaigns_detail['id']));
            }
        } elseif ($campaign_count > 1) {
            $contacts_verify = $pdo->prepare('SELECT count(*) as total FROM `contacts` WHERE `list_id`=? AND (status=?)');
            $contacts_verify->execute(array($campaigns_detail['list'], 1));
            $contacts_verifyTotal =  $contacts_verify->fetch(PDO::FETCH_ASSOC);

            $contact_count = $contacts_verifyTotal['total'];
            $total_contact_to_send = $campaign_count * $contact_count;
            $campaign_sent = $pdo->prepare('SELECT count(*) as total FROM `sent_mails` WHERE `campaign_id`=?');
            $campaign_sent->execute(array($campaigns_detail['id']));
            $campaign_sentTotal =  $campaign_sent->fetch(PDO::FETCH_ASSOC);

            if ($campaign_sentTotal['total'] >= $total_contact_to_send) {
                $sql = "UPDATE campaigns SET status=? WHERE id=?";
                $q = $pdo->prepare($sql);
                $q->execute(array(4, $campaigns_detail['id']));
            }
        }
    }
}


//exit();
$time_end = microtime(true);
$time = $time_end - $script_time_start;

echo ' End Cron Send - Time Taken: ' . $time . '<br>';

error_log(date("m-d-Y, g:i:s a") . 'End Cron Send - Time Taken: ' . $time .  "\n" ,3,'logs/smtp_cron.txt');