<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PhpImap\Mailbox;
use PhpImap\Exceptions\ConnectionException;
define("IN_CRONTAB",1);
require_once dirname(__FILE__) . '/config.php';
require_once dirname(__FILE__) . '/functions.php';
require_once dirname(__FILE__) . '/PHPMailer/autoload.php';
require_once dirname(__FILE__) . '/Google/autoload.php';
require_once dirname(__FILE__) . '/swiftmailer/autoload.php';
require_once dirname(__FILE__) . '/php-imap/autoload.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(900);

echo 'Running Cron Lead Replies';
flush();
$script_time_start = microtime(true);


/*Lead Replies*/
/*$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `is_sent`=? AND `is_with_reply`=?');
$q->execute(array(0,0));*/
$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `is_sent`=? ');
$q->execute(array(0));
foreach( $q as $row ){
	$data = $pdo->prepare('SELECT `id`, `data`, `member_id`, `bcc` FROM `campaigns` WHERE `id`=?');
	$data->execute(array($row['campaign_id']));
	$campaign = $data->fetch(PDO::FETCH_ASSOC);

	$data = $pdo->prepare('SELECT * FROM `leads` WHERE `id`=?');
	$data->execute(array($row['lead_id']));
	$lead = $data->fetch(PDO::FETCH_ASSOC);

	$data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `id`=?');
	$data->execute(array($lead['sent_mail_id']));
	$sent_mail = $data->fetch(PDO::FETCH_ASSOC);
    $identifier_smtp = $sent_mail['identifier'];

	$emails = json_decode($campaign['data'], 1);

	$is_sent = false;	
	foreach ($emails as $email) {		
		if( $email['subject'] == $sent_mail['subject'] ){
			//email sending
			switch ($email['send_server']) {

				case 'gmail':

					$gmail = $pdo->prepare('SELECT * FROM `gmail_accounts` WHERE active = 1 AND `id`=?');
					$gmail->execute(array($email['send_id']));
					$gmail = $gmail->fetch(PDO::FETCH_ASSOC);

					$send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
					$send_limit->execute(array($gmail['email'], time()-86400));

					if($gmail['send_limit'] == 0)
					{
						$gmail['send_limit'] = $send_limit->rowcount()+1;
					}

					if(!empty($gmail['email']) && $send_limit->rowcount()<$gmail['send_limit'])
					{

					    try
                        {
                            $client = new Google_Client();
                            $client->setClientId($googleClientId);
                            $client->setClientSecret($googleSecretId);
                            $client->setAccessToken($gmail['access_token']);
                            $client->refreshToken($gmail['refresh_token']);

                            $accessToken = $client->getAccessToken();

                            $refreshToken = $pdo->prepare('UPDATE `gmail_accounts` SET `access_token`=?, `refresh_token`=? WHERE `id`=?');
                            $refreshToken->execute(array($accessToken['access_token'], $accessToken['refresh_token'], $gmail['id']));

                            $service = new \Google_Service_Gmail($client);
                            $mailer = $service->users_messages;

                            if(!empty($campaign['bcc']))
                            {
                                $message = (new \Swift_Message($email['subject']))
                                    ->setFrom($gmail['email'], $gmail['firstName'])
                                    ->setTo($sent_mail['to_email'])
                                    ->setBcc([$campaign['bcc']])
                                    ->setContentType('text/html')
                                    ->setCharset('utf-8')
                                    ->setBody($row['msg'].$mail_footer.' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier_smtp.'"/>');
                            }
                            else
                            {
                                $message = (new \Swift_Message($email['subject']))
                                    ->setFrom($gmail['email'], $gmail['firstName'])
                                    ->setTo([$sent_mail['to_email']])
                                    ->setContentType('text/html')
                                    ->setCharset('utf-8')
                                    ->setBody($email['body'].$mail_footer.' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier_smtp.'"/>');
                            }

                            $encoded = base64url_encode($message->toString());

                            $message = new \Google_Service_Gmail_Message();
                            $message->setRaw($encoded);
                            $message = $mailer->send('me', $message);

                            $is_sent = true;
                        }
                        catch (Exception $e)
                        {
                            // Account no longer active...
                            $updateActive = $pdo->prepare('UPDATE `gmail_accounts` SET active = 0,inactive_reason =? WHERE `id`=?');
                            $updateActive->execute(array($e->getMessage(),$gmail['id']));

                            error_log("Lead Replies GMAIL: " . $gmail['id'] . " Reason: " .  $e->getMessage());
                             AddNotification("gmail", "GMAIL Account " . $gmail['gmail'] . " inactive - " . $e->getMessage(),$campaign['member_id']);
                        }

					}

					break;

				case 'smtp':

					$smtp = $pdo->prepare('SELECT * FROM `smtp` WHERE active = 1 AND `id`=?');
					$smtp->execute(array($email['send_id']));
					$smtp = $smtp->fetch(PDO::FETCH_ASSOC);

					$send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
					$send_limit->execute(array($smtp['from_email'], time()-86400));

					if($smtp['send_limit'] == 0)
					{
						$smtp['send_limit'] = $send_limit->rowcount()+1;
					}

					if(isset($smtp['from_email']) && $send_limit->rowcount()<$smtp['send_limit'])
					{

						$mail = new PHPMailer();
						$mail->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;

						$mail->IsSMTP();
						$mail->Host = $smtp['server'];
						$mail->SMTPAuth = true;
						//$mail->SMTPDebug = 2;
						$mail->Username = $smtp['user'];
						$mail->Password = crypt_jm($smtp['password'],'d');
						$mail->Port = $smtp['port'];
			            if($smtp['port'] == 465)
                        {
                            $mail->SMTPSecure = "ssl";
                        }
						if($smtp['port'] == 587)
						{
							$mail->SMTPSecure = "tls";
					    }


						$mail->IsHTML(true);
						$mail->setFrom($smtp['from_email']);
						$mail->FromName = $smtp['from_name'];
						$mail->addCustomHeader('In-Reply-To', $identifier_smtp);
						$mail->AddAddress($sent_mail['to_email']);
						if(!empty($campaign['bcc']))
						{
							$mail->addBcc($campaign['bcc']);
						}
						$mail->Subject = $email['subject'];
						$message = $row['msg'];
						$mail->Body = $message . ' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier_smtp.'"/>';
						$mail->AltBody = strip_tags($message);
						$mail->Send();

						$is_sent = true;

					}

					break;

				case 'outlook':

					$outlook = $pdo->prepare('SELECT * FROM `outlook` WHERE active = 1 AND `id`=?');
					$outlook->execute(array($email['send_id']));
					$outlook = $outlook->fetch(PDO::FETCH_ASSOC);

					$send_limit = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `from_email`=? AND `last_activity`>?');
					$send_limit->execute(array($outlook['from_email'], time()-86400));

					if($outlook['send_limit'] == 0)
					{
						$outlook['send_limit'] = $send_limit->rowcount()+1;
					}

					if(isset($outlook['from_email']) && $send_limit->rowcount()<$outlook['send_limit'])
					{

						$mail = new PHPMailer();
						$mail->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;

						$mail->IsSMTP();
						$mail->Host = $outlook_server;
						$mail->SMTPAuth = true;
						//$mail->SMTPDebug = 2;
						$mail->Username = $outlook['user'];
						$mail->Password = crypt_jm($outlook['password'],'d');
						$mail->Port = $outlook_port;
			            $mail->SMTPSecure = "tsl";
						$mail->IsHTML(true);
						$mail->setFrom($outlook['from_email']);
						$mail->FromName = $outlook['from_name'];
						$mail->addCustomHeader('In-Reply-To', $identifier_smtp);
						$mail->AddAddress($sent_mail['to_email']);
						if(!empty($campaign['bcc']))
						{
							$mail->addBcc($campaign['bcc']);
						}
						$mail->Subject = $email['subject'];
						$message = $row['msg'];
						$mail->Body = $message . ' <img src="'.AUTOMAILER_TRACKER_URL.'/_track.php?id='.$identifier_smtp.'"/>';
						$mail->AltBody = strip_tags($message);
						$mail->Send();

						$is_sent = true;

					}

					break;
			}

			if( $is_sent ){
				//Update lead_replies flag is_sent field to 1
				$q = $pdo->prepare('UPDATE `lead_replies` SET `is_sent`=? WHERE `id`=?');
				$q->execute(array(1,$row['id']));
				$is_sent = false;
			}

			break;
		}

	}
}

/*$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `is_sent`=? AND `is_with_reply`=?');
$q->execute(array(0,0));*/
$q = $pdo->prepare('SELECT id,lead_id FROM `lead_replies` WHERE `is_sent`=? AND `is_with_reply`=?');
$q->execute(array(1,0));
foreach( $q as $row ){
	$is_checked = false;
	$data = $pdo->prepare('SELECT sent_mail_id FROM `leads` WHERE `id`=?');
	$data->execute(array($row['lead_id']));
	$lead = $data->fetch(PDO::FETCH_ASSOC);

	$data = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `id`=?');
	$data->execute(array($lead['sent_mail_id']));
	$sent_mail = $data->fetch(PDO::FETCH_ASSOC);
	$identifier = $sent_mail['identifier'];

	$data = $pdo->prepare('SELECT * FROM `campaigns` WHERE `id`=?');
	$data->execute(array($sent_mail['campaign_id']));
	$campaign = $data->fetch(PDO::FETCH_ASSOC);

	$nextCheckTime = time() - (10 * 60);
	// IMAP non ssl
	$imap = $pdo->prepare('SELECT * FROM `imap` WHERE active = 1 AND `user`=? AND lastdate_leadreplies <= ?');
	$imap->execute(array($sent_mail['from_email'],$nextCheckTime));
	if($imap->rowcount()>0) {

		$imap = $imap->fetch(PDO::FETCH_ASSOC);

		$updateActive = $pdo->prepare('UPDATE `imap` SET lastdate_leadreplies  =? WHERE `id`=?');
		$updateActive->execute(array(time(),$imap['id']));

		if( $imap['is_ssl'] == 1 ){
			$mailbox_server = '{'.$imap['server'].':'.$imap['port'].'/imap/ssl}INBOX';
		}else{
			$mailbox_server = '{'.$imap['server'].':'.$imap['port'].'/imap}INBOX';
		}
        try {
		$mailbox = new Mailbox(
		    $mailbox_server,
		    $imap['user'],
		    crypt_jm($imap['password'],'d'),
		    __DIR__,
		    'US-ASCII'
		);


		$subject = str_replace("@", "", $sent_mail['subject']);
		$mail_ids = $mailbox->searchMailbox('SUBJECT "'.$subject.'" FROM "' . $sent_mail['to_email'] . '"');	
		
		} catch(ConnectionException $ex) {

            // Account no longer active...
            $updateActive = $pdo->prepare('UPDATE `imap` SET active = 0,inactive_reason =? WHERE `id`=?');
            $updateActive->execute(array($ex->getMessage(),$imap['id']));
		    error_log("IMAP Check Lead Relies failed: " . $imap['id'] . " Reason: " . $ex->getMessage());
		    AddNotification("imap", "IMAP Account " . $imap['user']. " inactive - " . $e->getMessage(),$campaign['member_id']);
		    continue;
		}
		foreach ($mail_ids as $mail_id) {
		    $email = $mailbox->getMail(
		        $mail_id,
		        false
		    );

		    if(!empty($email->fromAddress)){

		    	$email_content_raw = htmlentities($email->textHtml);
			    $strpos = strpos($email_content_raw, $identifier);
			    if($strpos !== false){

			    	$count_replies = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `mail_id`=?');
					$count_replies->execute(array($mail_id));
					$count_replies = $count_replies->fetch(PDO::FETCH_ASSOC);

					if( !$count_replies ){
						if( strtotime($email->date) >= $campaign['trigger_date'] ){ //To prevent fetching old msg with same subject
							//Insert lead reply
					    	$data = array(
					    		$row['lead_id'],
					    		$sent_mail['campaign_id'],
					    		$email->textHtml,
					    		strtotime($email->date),
					    		1,
					    		1,
					    		$mail_id
					    	);
					    	$q = $pdo->prepare('INSERT INTO `lead_replies` (lead_id,campaign_id,msg,replied_date,is_with_reply,is_sent,mail_id)  VALUES (?,?,?,?,?,?,?)');
							$result = $q->execute($data);

							$q = $pdo->prepare('UPDATE `lead_replies` SET `is_with_reply`=? WHERE `id`=?');
							$result = $q->execute(array(1,$row['id']));

							AddNotification("leads", "New Lead Reply",$campaign['member_id']);
						}
					}
		    		$is_checked = true;
		    	}
		    }
		}

		$mailbox->disconnect();
	}

	//Pop3
    /*
	if( !$is_checked ){
		$pop3 = $pdo->prepare('SELECT * FROM `pop3` WHERE active = 1 AND `user`=?');
		$pop3->execute(array($sent_mail['from_email']));

		if($pop3->rowcount()>0){
			$pop3 = $pop3->fetch(PDO::FETCH_ASSOC);

			if( $pop3['is_ssl'] == 1 ){
				$mailbox_server = '{'.$pop3['server'].':'.$pop3['port'].'/pop3/ssl}INBOX';
			}else{
				$mailbox_server = '{'.$pop3['server'].':'.$pop3['port'].'/pop3}INBOX';
			}

            try {
			$mailbox = new Mailbox(
			    $mailbox_server,
			    $pop3['user'],
			    crypt_jm($pop3['password'],'d'),
			    __DIR__,
			    'US-ASCII'
			);


			    $subject = str_replace("@", "", $sent_mail['subject']);
			    $mail_ids = $mailbox->searchMailbox('SUBJECT "'.$subject.'"');
			} catch(ConnectionException $ex) {

                // Account no longer active...
                $updateActive = $pdo->prepare('UPDATE `pop3` SET active = 0 WHERE `id`=?');
                $updateActive->execute(array($pop3['id']));



			    error_log("POP3 Lead Replies failed: " . $pop3['id'] . " Reason: " . $ex->getMessage());
			    continue;
			}
			foreach ($mail_ids as $mail_id) {
			    $email = $mailbox->getMail(
			        $mail_id,
			        false
			    );

			    // echo ->textHtml; for reply html
			    if(!empty($email->fromAddress)){

					$email_content_raw = htmlentities($email->textHtml);
				    $strpos = strpos($email_content_raw, $identifier);
				    if($strpos !== false){

				    	$count_replies = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `mail_id`=?');
						$count_replies->execute(array($mail_id));
						$count_replies = $count_replies->fetch(PDO::FETCH_ASSOC);

						if( !$count_replies ){

							if( strtotime($email->date) >= $campaign['trigger_date'] ){ //To prevent fetching old msg with same subject
								//Insert lead reply
						    	$data = array(
						    		$row['lead_id'],
						    		$sent_mail['campaign_id'],
						    		$email->textHtml,
						    		strtotime($email->date),
						    		1,
						    		1,
						    		$mail_id
						    	);
						    	$q = $pdo->prepare('INSERT INTO `lead_replies` (lead_id,campaign_id,msg,replied_date,is_with_reply,is_sent,mail_id)  VALUES (?,?,?,?,?,?,?)');
								$result = $q->execute($data);

								$q = $pdo->prepare('UPDATE `lead_replies` SET `is_with_reply`=? WHERE `id`=?');
								$result = $q->execute(array(1,$row['id']));
							}
						}

				    	$is_checked = true;
				    }
			    }
			}

			$mailbox->disconnect();
		}
	} /// end pop3
    */
}

/* this will set is_with_reply to 0 to check if the lead have new reply on email */
/*$datas = $pdo->prepare('SELECT * FROM `leads`');
$datas->execute(array());
foreach ($datas as $data) {
	$q = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `lead_id`=? LIMIT 1');
    $q->execute(array($data['id']));
    $lead = $q->fetch(PDO::FETCH_ASSOC);

    $l = $pdo->prepare('UPDATE `lead_replies` SET `is_with_reply`=? WHERE `id`=?');
	$l->execute(array(0,$lead['id']));
}*/


$time_end = microtime(true);
$time = $time_end - $script_time_start;

echo ' End Cron Lead Replies - Time Taken: ' . $time . '<br>';