<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once dirname(__FILE__) . '/PHPMailer/autoload.php';
include 'config.php';
require_once 'functions.php';


$q = $pdo->prepare('SELECT * FROM `prospect` WHERE `status`="pending"');
$q->execute();
$prospects = $q->fetchAll();


foreach($prospects as $value){

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => GETPROSPECT_URL."/insights/search/".$value['getprospect_id'],
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => array(
            "Content-Type: application/json",
            "Authorization: Bearer ". GETPROSPECT_API_KEY
        )
    ));

    $response = curl_exec($curl);
    $check_status = json_decode($response, true);
    if($check_status['status'] == "in_progress")
    {
        echo "List is in progress";
        continue;
    }
    //  $insight_search = json_decode($value['insight_search']);
    //  print_r($insight_search->limits->total);die;
    //  $curl = curl_init();
    //  //echo '<br>'.$value['getprospect_id'].'<br>';
    //  curl_setopt_array($curl, array(
    //      CURLOPT_URL => GETPROSPECT_URL."/insights/search/".$value['getprospect_id'],
    //      CURLOPT_RETURNTRANSFER => true,
    //      CURLOPT_HTTPHEADER => array(
    //          "Content-Type: application/json",
    //          "Authorization: Bearer ". GETPROSPECT_API_KEY
    //      )
    //  ));

    //  $response_check = curl_exec($curl);
    //  $decode_check_res = json_decode($response_check, true);

    //  if(isset($decode_check_res['statusCode'])){
    //     if($decode_check_res['statusCode']==401)
    //     {
    //       include 'get_prospect_email.php';
    //     }
    //   }

    //if($decode_check_res['data']['found'] > 0) {
    //if($decode_check_res['data']['statusId'] == 33){
    // if(isset($decode_check_res['processingComplete']) && $decode_check_res['processingComplete'] && $decode_check_res['saved'] > 0){
    $curl = curl_init();
    //echo '<br>' . $value['getprospect_list_id'] . '<br>';
    /*curl_setopt_array($curl, array(
        CURLOPT_URL => GETPROSPECT_URL."/lists/" . $value['getprospect_list_id'] . "/leads",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => array(
            "Content-Type: application/json",
            "Authorization: Bearer ". GETPROSPECT_API_KEY
        )
    ));*/
    curl_setopt_array($curl, array(
        CURLOPT_URL => GETPROSPECT_URL."/contacts/lists/" . $value['getprospect_list_id'] . "/contacts/search?pageSize=500",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => array(
            "Content-Type: application/json",
            "Authorization: Bearer ". GETPROSPECT_API_KEY
        )
    ));

    $response = curl_exec($curl);
    $decode_res = json_decode($response, true);
    if(isset($decode_res['statusCode'])){
        if($decode_res['statusCode']==401)
        {
            //include 'get_prospect_email.php';
            PhpMailerSendEmail('support@automailer.io','Prospect Key Expiration','Your Given Key for Get Prospect Has Been Expired','Automailer.io',true);
        }
    }
    $email_missing_count = 0;
    $added_contacts = 0;

    foreach ($decode_res['data'] as $key=>$user_data){
        // echo $key. "net";
        if(!isset($user_data['companyRelations'][0]['email']['value']))
        {
            continue;
        }
        $check_email_record = $pdo->prepare('SELECT * FROM `contacts` WHERE `email`=? LIMIT 1');
        $check_email_record->execute(array($user_data['companyRelations'][0]['email']['value']));
        $email_record = $check_email_record->fetch(PDO::FETCH_ASSOC);

        if($check_email_record->rowCount()>0)
        {
            $check_contact_by_list = $pdo->prepare('SELECT * FROM `contacts` WHERE `email`=? AND `list_id`=? LIMIT 1');
            $check_contact_by_list->execute(array($user_data['companyRelations'][0]['email']['value'], $value['list_id']));
            $contact_by_list = $check_contact_by_list->fetch(PDO::FETCH_ASSOC);

            if($check_contact_by_list->rowCount() == 0)
            {
                $q = $pdo->prepare('INSERT INTO `contacts`  (list_id,firstName,lastName,email,data,all_data,status, country,city,position,industry,hq_location)  VALUES (?,?,?,?,?,?,?,?,?,?,?,?)');
                $q->execute(array($value['list_id'], $email_record['firstName'], $email_record['lastName'], $email_record['email'], $email_record['data'], $email_record['all_data'], 0, $email_record['country'], $email_record['city'], $email_record['position'], $email_record['industry'], $email_record['hq_location']));
            }

            continue;
        }
        $arr = array ();
        //$arr['firstName'] = $user_data['firstName'];
        //$arr['lastName'] = $user_data['lastName'];
        //$arr['email'] = $user_data['email'];
        $arr['Job title'] = $user_data['companyRelations'][0]['position'];

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => GETPROSPECT_URL."/companies/company/" . $user_data['companyRelations'][0]['company'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json",
                "Authorization: Bearer ". GETPROSPECT_API_KEY
            )
        ));
        $response_company = curl_exec($curl);
        $decode_res_company = json_decode($response_company, true);

        if(isset($decode_res_company['statusCode'])){
            if($decode_res_company['statusCode']==401)
            {
                //include 'get_prospect_email.php';
                PhpMailerSendEmail('support@automailer.io','Prospect Key Expiration','Your Given Key for Get Prospect Has Been Expired','Automailer.io',true);
            }
        }
        // print_r($decode_res_company);die;
        $arr['Company Name'] = $decode_res_company['properties']['name']['value'];
        $arr['Company Size'] = $decode_res_company['properties']['size']['value'];
        $arr['Company Industry'] = $decode_res_company['properties']['industry']['value'];
        $arr['Location'] = $user_data['properties']['location']['value'];
        //$arr['contactInfo'] = $user_data['contactInfo'];
        $display_field = json_encode($arr);
        $country_code = !empty($allArr['Location']) ? $allArr['Location'] :NULL;

        $allArr = array ();
        $allArr['firstName'] = $user_data['properties']['firstName']['value'];
        $allArr['lastName'] = $user_data['properties']['lastName']['value'];
        $allArr['linkedinUrl'] = $user_data['properties']['linkedinUrl']['value'];
        $allArr['contactInfo'] = $user_data['properties']['contactInfo']['value'];
        $allArr['Location'] = $user_data['properties']['location']['value'];
        $allArr['postalCode'] = $user_data['properties']['postalCode']['value'];
        $allArr['summary'] = $user_data['properties']['summary']['value'];
        $allArr['notes'] = $user_data['properties']['notes']['value'];

        $allArr['email'] = $user_data['companyRelations'][0]['email']['value'];
        $allArr['Job title'] = $user_data['companyRelations'][0]['position'];

        $allArr['Company Name'] = $decode_res_company['properties']['name']['value'];
        $allArr['Company Size'] = $decode_res_company['properties']['size']['value'];
        $allArr['Company Industry'] = $decode_res_company['properties']['industry']['value'];
        $allArr['Company Domain'] = $decode_res_company['properties']['domain']['value'];
        $allArr['Company Headquarters'] = isset($decode_res_company['properties']['headquarters']['value']) ? $decode_res_company['properties']['headquarters']['value'] : '';
        $allArr['ompanyCountryCode'] = isset($decode_res_company['properties']['countryCode']['value']) ? $decode_res_company['properties']['countryCode']['value']:'';
        $allArr['companyPostalCode'] = isset($decode_res_company['properties']['postalCode']['value']) ? $decode_res_company['properties']['postalCode']['value'] : '' ;
        $allArr['Company Description'] = isset($decode_res_company['properties']['description']['value']) ? :'' ;

        if(!empty($allArr['position']))
        {
            $check_position_record = $pdo->prepare('SELECT * FROM `prospect_positions` WHERE `position`=? LIMIT 1');
            $check_position_record->execute(array($allArr['position']));
            $position_record = $check_position_record->fetch(PDO::FETCH_ASSOC);
            if($check_position_record->rowcount()==0){
                $q = $pdo->prepare('INSERT INTO `prospect_positions` (position) VALUES (?)');
                $result = $q->execute(array($allArr['position']));
                $user_data['position'] = $pdo->lastInsertId();
            }else{
                $user_data['position'] = $position_record['id'];
            }
        }else{
            $user_data['position'] = NULL;
        }

        // insert country id
        if(!empty($allArr['Location']))
        {
            $location_arr = explode(',', $allArr['Location']);

            if(count($location_arr)>=2){
                $city = $location_arr[0];
                $country = str_replace(" ","",$location_arr[1]);
                $check_city_record = $pdo->prepare('SELECT * FROM `prospect_cities` WHERE `city`=? LIMIT 1');
                $check_city_record->execute(array($city));
                $city_record = $check_city_record->fetch(PDO::FETCH_ASSOC);
                if($check_city_record->rowcount()==0){
                    $q = $pdo->prepare('INSERT INTO `prospect_cities` (city) VALUES (?)');
                    $result = $q->execute(array($city));
                    $user_data['city'] = $pdo->lastInsertId();
                }else{
                    $user_data['city'] = $city_record['id'];
                }
            }else{

                $city = "";
                $country = str_replace(" ","",$location_arr[0]);
                $user_data['city'] = NULL;
            }
            echo $user_data['city'];
            $check_country_record = $pdo->prepare('SELECT * FROM `prospect_countries` WHERE `country`=? LIMIT 1');
            $check_country_record->execute(array($country));
            $country_record = $check_country_record->fetch(PDO::FETCH_ASSOC);

            if($check_country_record->rowcount()==0){
                //  echo "if";
                $q = $pdo->prepare('INSERT INTO `prospect_countries` (country) VALUES (?)');
                $result = $q->execute(array($country));
                $user_data['country'] = $pdo->lastInsertId();
            }else{
                $user_data['country'] = $country_record['id'];
            }
        }

        $user_data['hq_location'] = $allArr['Company Headquarters'];


        // insert industry id
        if(!empty($allArr['Company Industry']))
        {
            $check_industry_record = $pdo->prepare('SELECT * FROM `prospect_industries` WHERE `industry`=? LIMIT 1');
            $check_industry_record->execute(array($allArr['Company Industry']));
            $industry_record = $check_industry_record->fetch(PDO::FETCH_ASSOC);
            if($check_industry_record->rowcount()==0){
                $q = $pdo->prepare('INSERT INTO `prospect_industries` (industry) VALUES (?)');
                $result = $q->execute(array($allArr['Company Industry']));
                $user_data['industry'] = $pdo->lastInsertId();
            }else{
                $user_data['industry'] = $industry_record['id'];
            }
        }else{
            $user_data['industry'] = NULL;
        }


        if(isset($user_data['companyRelations'][0]['email']['value']) != '') {
            // $q = $pdo->prepare('INSERT INTO `contacts`  (list_id,firstName,lastName,email,data,all_data,status, country,city,position,industry,hq_location,country_code)  VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)');
            // $q->execute(array($value['list_id'], $user_data['properties']['firstName']['value'], $user_data['properties']['lastName']['value'], $user_data['companyRelations'][0]['email']['value'], $display_field, json_encode($allArr), 0, $user_data['country'], $user_data['city'], $user_data['position'], $user_data['industry'], $user_data['hq_location'], $country_code));
            // $contact_id = $pdo->lastInsertId();
            echo 'position'.$user_data['position'];
            $q = $pdo->prepare('INSERT INTO `contacts`  (list_id,firstName,lastName,email,data,all_data,status,position,industry,country_code)  VALUES (?,?,?,?,?,?,?,?,?,?)');
            $q->execute(array($value['list_id'],$user_data['properties']['firstName']['value'], $user_data['properties']['lastName']['value'], $user_data['companyRelations'][0]['email']['value'], $display_field, json_encode($allArr), 0,$user_data['position'],$user_data['industry'], $country_code));
            $contact_id = $pdo->lastInsertId();
            // echo 'id'.$contact_id;die;
            $q = $pdo->prepare('INSERT INTO `member_has_contacts`  (contact_id,email,member_id)  VALUES (?,?,?)');
            $q->execute(array($contact_id,$user_data['companyRelations'][0]['email']['value'],$value['user_id']));
            if($contact_id!="" && $contact_id>0){
                $added_contacts++;
            }

        }else{
            $email_missing_count++;
        }
        print_r($q->errorInfo());
    }
    //  if($decode_check_res['data']['statusId'] == 33){ //check if list processed then need to change status in out database

    //  deduct credit from account
    // echo $added_contacts;
    $q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
    $q->execute(array($value['user_id']));
    $member = $q->fetch(PDO::FETCH_ASSOC);

    $remaining_balance = $member['search_credit'] - $added_contacts + $email_missing_count;
    $q = $pdo->prepare('UPDATE `members` SET `search_credit`=? WHERE `id`=?');
    $q->execute(array($remaining_balance,  $value['user_id']));
    //end

    $q = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=?');
    $q->execute(array($value['list_id']));
    $contacts = $q->fetchAll();

    $q = $pdo->prepare('UPDATE `lists` SET `total_contacts`=? WHERE `id`=?');
    $q->execute(array(count($contacts),  $value['list_id']));
    // echo "addes contacts ". $added_contacts;
    // echo "total wanted contacts".$insight_search->limits->total;
    //  $insight_search->limits->total = $value['limit_amount'] - count($contacts);
    //  $insight_search->selected = $value['limit_amount'] - count($contacts);
    //  $q = $pdo->prepare('UPDATE `prospect` SET `insight_search`=? WHERE `id`=?');
    //  $q->execute(array(json_encode($insight_search),  $value['id']));


    // if($value['limit_amount'] >= count($contacts))
    // {
    $q = $pdo->prepare('UPDATE `prospect` SET `status`=? WHERE `id`=?');
    $q->execute(array('completed',  $value['id']));
    //}

    //}


    AddNotification("prospect", "LeadFinder has completed your data search and has successfully loaded your list in your contact section.",$value['user_id']);

    //send mail
    $mail = new PHPMailer();
    $mail->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;

    $mail->IsSMTP();
    $mail->Host = SMTP_HOST;
    $mail->SMTPAuth = false;
    //$mail->SMTPDebug = 2;
    // $mail->Username = SMTP_USERNAME;
    //$mail->Password = SMTP_PASSWORD;
    $mail->Port = SMTP_PORT;
    $mail->IsHTML(true);
    $mail->setFrom(SMTP_FROM_EMAIL);
    $mail->FromName = SMTP_FROM_NAME;

    $mail->AddAddress($member['email']);

    $mail->Subject = 'Automailer: LeadFinder';
    $message = ' <span>Dear client,</span><br>';
    if(count($decode_res['data']) > 0) {
        $message .= '
                      <p>LeadFinder has completed your data search and has successfully loaded your list in your contact section.</p>
                      <br>';
    } else {
        $message .= '
                        <p>Based on your data filters, LeadFinder was unsuccessful in finding you the contacts you requested. A client success manager will be intouch with you shortly to discuss how we can fulfill your request.</p>
                        <br>';
    }
    $message .= '<span>Thank you,</span>
                        <br>
                        <span>Automailer</span>';
    $mail->Body = $message;
    $mail->AltBody = $message;
    $mail->Send();
    //  end
}

//  function insight_search($search_data)
//  {
//    echo json_encode($search_data);
//     $curl = curl_init();

//         curl_setopt_array($curl, array(
//         CURLOPT_URL => GETPROSPECT_URL."/insights/search",
//         CURLOPT_RETURNTRANSFER => true,
//         CURLOPT_ENCODING => "",
//         CURLOPT_MAXREDIRS => 10,
//         CURLOPT_TIMEOUT => 0,
//         CURLOPT_FOLLOWLOCATION => true,
//         CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//         CURLOPT_CUSTOMREQUEST => "POST",
//         //CURLOPT_POSTFIELDS => "{\n    \"positions\" : \"$positions\",\n    \"inSummary\": \"true\",\n    \"countryCodes\": \"US\",\n    \"leadCities\": \"$lead_cities\",\n \"companyIndustries\": \"$industries\",\n \"companySizeMin\": \"$company_min\",\n \"companySizeMax\": \"$company_max\" \n}",
//         CURLOPT_POSTFIELDS => json_encode($search_data),
//         CURLOPT_HTTPHEADER => array(
//             "Content-Type: application/json",
//             "Authorization: Bearer ". GETPROSPECT_API_KEY
//         ),
//     ));
//     $response_ls = curl_exec($curl);
//     $decode_response = json_decode($response_ls, true);
//     // print_r($decode_response);
//  }

//}

?>